/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.security.domain;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.lib.security.PermissionStorageConnector;
import com.sap.engine.lib.security.ProtectedPermissionCollection;
import com.sap.engine.lib.security.domain.LockPermissionCollectionAction;
import com.sap.engine.lib.security.domain.ProtectedProtectionDomain;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.PropertyPermission;
import java.util.Vector;

public class ProtectionDomainFactory {
    private int anonymousDomainCounter;
    private Vector protectionDomains;
    private static Policy policy = null;
    private static ProtectionDomainFactory factory = null;
    private static PermissionStorageConnector storageConnector = null;
    private static String rootDirFile = null;
    private static String appsDirFile = null;
    public static final String SDA_SECURITY_SERVICE_NAME = "services/security/security.jar";
    public static final String FS_SECURITY_SERVICE_NAME = "services/security.jar";
    private static final Permission LOAD_LIBRARY = new RuntimePermission("loadLibrary", null);
    private static final Permission QUEUE_PRINT_JOB = new RuntimePermission("queuePrintJob", null);
    private static final Permission SOCKET_CONNECT = new SocketPermission("*", "connect");
    private static final Permission ACCESS_CURRENT_DIR = new FilePermission("*", "read,write");
    private static final Permission READ_ALL_PROPERTIES = new PropertyPermission("*", "read");
    private static Field field = null;

    public static void setAppsDir(String rootAppsDir) throws IOException {
        appsDirFile = new File(rootAppsDir).getCanonicalPath();
        if (storageConnector != null) {
            storageConnector.setApplicationsDir(appsDirFile);
        }
    }

    public static String getAppsDir() {
        return appsDirFile;
    }

    public static void setPermissionCollectionOperator(PermissionStorageConnector operator) throws Exception {
        storageConnector = operator;
        if (appsDirFile != null) {
            storageConnector.setApplicationsDir(appsDirFile);
        }
    }

    private ProtectionDomainFactory() {
        block2: {
            this.anonymousDomainCounter = 0;
            this.protectionDomains = new Vector();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    policy = Policy.getPolicy();
                    return null;
                }
            });
            try {
                rootDirFile = new File(SystemProperties.getProperty("user.dir") + File.separator + "bin").getCanonicalPath();
            }
            catch (IOException e) {
                if (storageConnector == null) break block2;
                storageConnector.logNotice("[protection domain factory] unable to get root directory:\n" + ProtectionDomainFactory.getStackTrace(e));
            }
        }
    }

    public static synchronized ProtectionDomainFactory getFactory() {
        if (factory == null) {
            factory = new ProtectionDomainFactory();
        }
        return factory;
    }

    public static String encodeDomainName(String domain) {
        String result;
        block8: {
            result = domain;
            try {
                if (appsDirFile != null) {
                    if (domain.startsWith(appsDirFile)) {
                        result = domain.substring(appsDirFile.length() + 1);
                    } else if (domain.startsWith(rootDirFile)) {
                        result = domain.substring(rootDirFile.length() + 1);
                    }
                } else if (domain.startsWith(rootDirFile)) {
                    result = domain.substring(rootDirFile.length() + 1);
                }
            }
            catch (Exception ioe) {
                if (storageConnector == null) break block8;
                storageConnector.logNotice("cutDomainName[" + domain + "]:\n" + ProtectionDomainFactory.getStackTrace(ioe));
            }
        }
        return result.replace('\\', '/');
    }

    public synchronized ProtectionDomain getProtectionDomain(CodeSource code) {
        ProtectedProtectionDomain domain = null;
        code = this.getCanonical(code);
        this.optimize();
        int i = 0;
        while (i < this.protectionDomains.size()) {
            domain = this.getProtectionDomainAt(i);
            if (domain instanceof ProtectedProtectionDomain && code.equals(domain.getCodeSource())) {
                return domain;
            }
            ++i;
        }
        return null;
    }

    public synchronized ProtectionDomain getProtectionDomain(String name) {
        name = ProtectionDomainFactory.encodeDomainName(name);
        ProtectedProtectionDomain domain = null;
        this.optimize();
        int i = 0;
        while (i < this.protectionDomains.size()) {
            domain = this.getProtectionDomainAt(i);
            if (domain instanceof ProtectedProtectionDomain && name.equals(domain.getName())) {
                return domain;
            }
            ++i;
        }
        return null;
    }

    public ProtectionDomain registerApplicationProtectionDomain(String name, CodeSource codeSource) throws SecurityException {
        if (name == null) {
            try {
                name = new File(codeSource.getLocation().getFile()).getCanonicalPath();
            }
            catch (IOException e) {
                throw new SecurityException(e.toString());
            }
        }
        return this.registerProtectionDomain(name, codeSource, true);
    }

    public ProtectionDomain registerProtectionDomain(String name, CodeSource codeSource) throws SecurityException {
        return this.registerProtectionDomain(name, codeSource, false);
    }

    private ProtectionDomain registerProtectionDomain(String name, CodeSource codeSource, boolean isApplicationDomain) throws SecurityException {
        ProtectionDomain domain = null;
        codeSource = this.getCanonical(codeSource);
        this.optimize();
        if (name == null) {
            ++this.anonymousDomainCounter;
            name = "#anonymous" + this.anonymousDomainCounter;
        }
        if ((domain = this.getProtectionDomain(name = ProtectionDomainFactory.encodeDomainName(name))) != null && domain.getCodeSource() != null && !codeSource.equals(domain.getCodeSource())) {
            domain = null;
        }
        if (domain != null) {
            return domain;
        }
        try {
            Exception result;
            PermissionCollection permissions = null;
            if (storageConnector != null) {
                permissions = storageConnector.getPermissionCollection(name, codeSource);
                if (permissions == null) {
                    permissions = policy.getPermissions(codeSource);
                }
            } else {
                permissions = policy.getPermissions(codeSource);
            }
            if (isApplicationDomain) {
                permissions.add(LOAD_LIBRARY);
                permissions.add(QUEUE_PRINT_JOB);
                permissions.add(SOCKET_CONNECT);
                permissions.add(ACCESS_CURRENT_DIR);
                permissions.add(READ_ALL_PROPERTIES);
            }
            domain = new ProtectedProtectionDomain(this, name, codeSource, permissions, isApplicationDomain);
            this.protectionDomains.add(new WeakReference<ProtectionDomain>(domain));
            if (storageConnector != null && (result = (Exception)AccessController.doPrivileged(new LockPermissionCollectionAction((ProtectedPermissionCollection)domain.getPermissions()))) != null) {
                throw result;
            }
            return domain;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage());
        }
    }

    public synchronized ProtectionDomain[] getProtectionDomains() {
        this.optimize();
        ProtectionDomain[] result = new ProtectionDomain[this.protectionDomains.size()];
        int i = 0;
        while (i < this.protectionDomains.size()) {
            result[i] = this.getProtectionDomainAt(i);
            ++i;
        }
        return result;
    }

    public synchronized String[] getProtectionDomainsNames() {
        this.optimize();
        String[] result = new String[this.protectionDomains.size()];
        int i = 0;
        while (i < this.protectionDomains.size()) {
            result[i] = this.getProtectionDomainAt(i).getName();
            ++i;
        }
        return result;
    }

    public synchronized CodeSource[] getProtectionDomainsCodeSources() {
        this.optimize();
        CodeSource[] result = new CodeSource[this.protectionDomains.size()];
        int i = 0;
        while (i < this.protectionDomains.size()) {
            result[i] = this.getProtectionDomainAt(i).getCodeSource();
            ++i;
        }
        return result;
    }

    public ProtectionDomain[] getProtectionDomainStack() {
        return ProtectionDomainFactory.getProtectionDomainStack1();
    }

    public static ProtectionDomain[] getNativeProtectionDomainStack() {
        final AccessControlContext context = AccessController.getContext();
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return field.get(context);
                }
                catch (Throwable e) {
                    return e;
                }
            }
        });
        if (result instanceof Throwable) {
            return new ProtectionDomain[0];
        }
        return (ProtectionDomain[])result;
    }

    public static ProtectionDomain[] getProtectionDomainStack1() {
        ProtectionDomain[] nativeStack = ProtectionDomainFactory.getNativeProtectionDomainStack();
        int n = 0;
        int i = 0;
        while (i < nativeStack.length) {
            if (!(nativeStack[i].getPermissions() instanceof ProtectedPermissionCollection)) {
                nativeStack[i] = null;
            } else {
                ++n;
            }
            ++i;
        }
        ProtectionDomain[] result = new ProtectionDomain[n];
        int counter = 0;
        int i2 = 0;
        while (i2 < nativeStack.length) {
            if (nativeStack[i2] != null) {
                result[counter++] = ProtectionDomainFactory.getFactory().getProtectionDomain(nativeStack[i2].getCodeSource());
            }
            ++i2;
        }
        return result;
    }

    public void removeStoredProtectionDomain(String domainName) {
        if (storageConnector != null) {
            storageConnector.logNotice("removed stored domain[" + domainName + "]");
            storageConnector.unregisterProtectionDomain(ProtectionDomainFactory.encodeDomainName(domainName));
        }
        this.removeProtectionDomain(domainName);
    }

    public synchronized void removeProtectionDomain(String nameDomain) {
        nameDomain = ProtectionDomainFactory.encodeDomainName(nameDomain);
        ProtectedProtectionDomain domain = null;
        this.optimize();
        int i = 0;
        while (i < this.protectionDomains.size()) {
            block4: {
                try {
                    domain = this.getProtectionDomainAt(i);
                    if (domain.getName().equals(nameDomain)) {
                        this.protectionDomains.remove(i);
                        return;
                    }
                }
                catch (Exception e) {
                    if (storageConnector == null) break block4;
                    storageConnector.logNotice("removeDomain[" + nameDomain + "]:\n" + ProtectionDomainFactory.getStackTrace(e));
                }
            }
            ++i;
        }
    }

    private final CodeSource getCanonical(CodeSource code) {
        try {
            URL url = code.getLocation();
            String file = url.getFile();
            file = new File(file).isAbsolute() ? new File(file).getCanonicalPath() : new File(".", file).getCanonicalPath();
            URL canonical = new URL("file:" + file);
            return new CodeSource(canonical, code.getCertificates());
        }
        catch (Exception e) {
            return code;
        }
    }

    private final void optimize() {
        int i = 0;
        while (i < this.protectionDomains.size()) {
            if (this.getProtectionDomainAt(i) == null) {
                this.protectionDomains.remove(i);
                --i;
            }
            ++i;
        }
    }

    private final ProtectedProtectionDomain getProtectionDomainAt(int position) {
        return (ProtectedProtectionDomain)((WeakReference)this.protectionDomains.elementAt(position)).get();
    }

    private static final String getStackTrace(Throwable t) {
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(ostr));
        return ostr.toString();
    }

    static {
        field = (Field)AccessController.doPrivileged(new PrivilegedAction(){
            static /* synthetic */ Class class$java$security$AccessControlContext;

            public Object run() {
                try {
                    Field field = (class$java$security$AccessControlContext == null ? (class$java$security$AccessControlContext = 1.class$("java.security.AccessControlContext")) : class$java$security$AccessControlContext).getDeclaredField("context");
                    ((AccessibleObject)field).setAccessible(true);
                    return field;
                }
                catch (Throwable e) {
                    return null;
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
    }
}

