/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.security;

import java.security.Permission;
import java.util.StringTokenizer;

public class EnginePermission
extends Permission {
    public static final String TARGET_KEYSTORE = "keystore";
    public static final String KEYSTORE_VIEW_FLAG = "view";
    public static final String KEYSTORE_ENTRY_FLAG = "entry";
    public static final String KEYSTORE_PROPERTY_FLAG = "property";
    public static final String ALL_ACTIONS = "*";
    public static final String TARGET_SECURITY = "security";
    public static final char[] INVALID_ACTIONS_CHARACTERS = new char[]{'\"', '$', '{', '}', ' ', '.'};
    public static final String KEYSTORE_TOKEN_SEPARATOR = ":";
    private int instance_hash_value = 0;
    private String impliesFailedDomain = null;
    private String actions = null;
    private String[] thisActions = null;
    public static final String NULL_TOKEN = " ";

    public String getImpliesFailedDomain() {
        return this.impliesFailedDomain;
    }

    public void setImpliesFailedDomain(String impliesFailedDomain) {
        this.impliesFailedDomain = impliesFailedDomain;
    }

    public EnginePermission(String target, String actions) throws IllegalArgumentException {
        super(target);
        EnginePermission.checkForIllegalCharacters(actions);
        this.actions = actions;
        this.thisActions = EnginePermission.parseKeystoreActions(actions);
        this.instance_hash_value = 0;
        if (target != null) {
            this.instance_hash_value += target.hashCode();
        }
        if (actions != null) {
            this.instance_hash_value += actions.hashCode();
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof EnginePermission)) {
            return false;
        }
        if (!this.getName().equals(permission.getName())) {
            return false;
        }
        if (this.getName().equals(TARGET_KEYSTORE)) {
            return this.impliesKeystorePermission(permission.getActions(), ((EnginePermission)permission).thisActions);
        }
        return this.getName().equals(TARGET_SECURITY) && permission.getActions().equals(this.actions);
    }

    private boolean impliesKeystorePermission(String actions, String[] thatActions) {
        if (actions.equals(this.actions)) {
            return true;
        }
        if (this.actions.equals(ALL_ACTIONS)) {
            return true;
        }
        int i = 0;
        while (i < 4) {
            if (!this.thisActions[i].equals(thatActions[i]) && !this.thisActions[i].equals(ALL_ACTIONS)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.instance_hash_value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnginePermission)) {
            return false;
        }
        EnginePermission castedObj = (EnginePermission)obj;
        if (!castedObj.getName().equals(this.getName())) {
            return false;
        }
        return castedObj.getActions().equals(this.getActions());
    }

    public String getActions() {
        return this.actions;
    }

    public String toString() {
        return "{EnginePermission: [" + this.getName() + "][" + this.actions + "]}";
    }

    private static final void checkForIllegalCharacters(String actions) throws IllegalArgumentException {
        char[] actionsAsChars = actions.toCharArray();
        String result = "";
        int i = 0;
        while (i < actionsAsChars.length) {
            int j = 0;
            while (j < INVALID_ACTIONS_CHARACTERS.length) {
                if (INVALID_ACTIONS_CHARACTERS[j] == actionsAsChars[i]) {
                    result = result + "pos: " + i + ", char: '" + actionsAsChars[i] + "'\n";
                }
                ++j;
            }
            ++i;
        }
        if (result.length() > 0) {
            throw new IllegalArgumentException("Invalid characters found: " + result);
        }
    }

    private static final String[] parseKeystoreActions(String actions) {
        String[] result = new String[]{NULL_TOKEN, NULL_TOKEN, NULL_TOKEN, NULL_TOKEN};
        StringTokenizer t = new StringTokenizer(actions, KEYSTORE_TOKEN_SEPARATOR, false);
        int i = 0;
        while (t.hasMoreTokens()) {
            result[i++] = t.nextToken();
        }
        return result;
    }
}

