/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.logging.descriptors;

import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.lib.logging.descriptors.LogFormatterDescriptor;
import com.sap.engine.lib.logging.descriptors.PersistenceAdapter;
import com.sap.engine.lib.util.DeepCloneable;
import com.sap.engine.lib.util.HashMapObjectByte;
import com.sap.engine.lib.util.HashMapObjectInt;
import com.sap.tc.logging.Severity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class LogControllerDescriptor
implements Serializable,
Cloneable,
DeepCloneable,
Comparable {
    public static final byte ASSOCIATION_TYPE_PUBLIC = 0;
    public static final byte ASSOCIATION_TYPE_PRIVATE = 1;
    public static final byte ASSOCIATION_TYPE_LOCAL = 2;
    public static final byte STATE_DISABLED = -1;
    public static final byte STATE_NORMAL = 0;
    public static final byte STATE_DEBUG = 1;
    private String name = null;
    private String bundleName = null;
    private int minSeverity = 0;
    private int maxSeverity = 701;
    private HashSet filters = null;
    private HashMapObjectByte associatedDestinations = null;
    private HashMapObjectInt minRelativeSeverities = null;
    private HashMapObjectInt maxRelativeSeverities = null;
    private transient PersistenceAdapter source = null;
    private boolean hasDBLog = true;
    private boolean acceptsDBLog = true;
    private byte state = 0;
    private String stateOwner = null;

    public static InputStream writeDescriptors(LogControllerDescriptor[] source) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        try {
            oos.writeObject(source);
            oos.flush();
            oos.close();
        }
        catch (IOException ioe) {
            oos.close();
            throw ioe;
        }
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public static LogControllerDescriptor[] readDescriptors(InputStream source) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(source);
        return (LogControllerDescriptor[])ois.readObject();
    }

    public LogControllerDescriptor() {
        this.filters = new HashSet();
        this.associatedDestinations = new HashMapObjectByte();
        this.minRelativeSeverities = new HashMapObjectInt();
        this.maxRelativeSeverities = new HashMapObjectInt();
    }

    public LogControllerDescriptor(PersistenceAdapter source) {
        this();
        this.source = source;
    }

    public LogControllerDescriptor(PersistenceAdapter source, LogDestinationDescriptor[] associatedDestinations, byte[] associationTypes) throws IllegalArgumentException {
        if (associationTypes.length != associatedDestinations.length) {
            throw new IllegalArgumentException("Each associated destination must have a corresponding association type!");
        }
        this.associatedDestinations = new HashMapObjectByte(associatedDestinations.length);
        int i = associatedDestinations.length;
        while (--i >= 0) {
            this.associatedDestinations.put(associatedDestinations[i], associationTypes[i]);
        }
        this.source = source;
        this.filters = new HashSet();
        this.minRelativeSeverities = new HashMapObjectInt();
        this.maxRelativeSeverities = new HashMapObjectInt();
    }

    public HashMapObjectByte getAssociatedDestinations() {
        return this.associatedDestinations;
    }

    public void setAssociatedDestinations(HashMapObjectByte associatedDestinations) {
        if (associatedDestinations == null) {
            this.associatedDestinations.clear();
        } else {
            this.associatedDestinations = associatedDestinations;
        }
    }

    public void addDestination(LogDestinationDescriptor destination, byte associationType) throws IllegalArgumentException {
        if (associationType != 0 && associationType != 1 && associationType != 2) {
            throw new IllegalArgumentException("Invalid Association Type!");
        }
        this.associatedDestinations.put(destination, associationType);
    }

    public boolean removeDestination(LogDestinationDescriptor destination) {
        return this.associatedDestinations.remove(destination);
    }

    public void removeDestinations() {
        this.associatedDestinations.clear();
    }

    public boolean containsDestination(LogDestinationDescriptor destination) {
        return this.associatedDestinations.containsKey(destination);
    }

    public LogDestinationDescriptor[] getDestinations() {
        return (LogDestinationDescriptor[])this.associatedDestinations.getAllKeys(new LogDestinationDescriptor[this.associatedDestinations.size()], 0);
    }

    public byte getAssociationType(LogDestinationDescriptor destination) throws NoSuchElementException {
        return this.associatedDestinations.get(destination);
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return LogControllerDescriptor.getParentName(this.name);
    }

    public static String getParentName(String name) {
        if (name.startsWith("/")) {
            int position = name.lastIndexOf(47);
            if (position == 0) {
                if (name.length() == 1) {
                    return null;
                }
                return "/";
            }
            return name.substring(0, position);
        }
        int position = name.lastIndexOf(46);
        if (position < 0) {
            if (name.length() == 0) {
                return null;
            }
            return "";
        }
        return name.substring(0, position);
    }

    public void setName(String name) {
        if (name.startsWith("com.sap.engine.core.configuration") || name.startsWith("com.sap.sql") || name.equals("SQLTraceLogger")) {
            this.acceptsDBLog = false;
            this.hasDBLog = false;
        } else {
            this.acceptsDBLog = true;
        }
        this.name = name;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public String getMinSeverity() {
        return Severity.toString((int)this.minSeverity);
    }

    public int getMinSeverityInt() {
        return this.minSeverity;
    }

    public void setMinSeverity(String minSeverity) {
        this.minSeverity = Severity.parse((String)minSeverity);
    }

    public void setMinSeverity(int minSeverity) {
        this.minSeverity = minSeverity;
    }

    public String getMaxSeverity() {
        return Severity.toString((int)this.maxSeverity);
    }

    public int getMaxSeverityInt() {
        return this.maxSeverity;
    }

    public void setMaxSeverity(String maxSeverity) {
        this.maxSeverity = Severity.parse((String)maxSeverity);
    }

    public void setMaxSeverity(int maxSeverity) {
        this.maxSeverity = maxSeverity;
    }

    public void setEffectiveSeverity(String severity) {
        this.setMinSeverity(severity);
        this.setMaxSeverity(severity);
    }

    public void setEffectiveSeverity(int severity) {
        this.setMinSeverity(severity);
        this.setMaxSeverity(severity);
    }

    public HashMapObjectInt getMinRelativeSeverities() {
        return this.minRelativeSeverities;
    }

    public void setMinRelativeSeverities(HashMapObjectInt minRelativeSeverities) {
        if (minRelativeSeverities != null) {
            this.minRelativeSeverities = minRelativeSeverities;
        } else {
            this.minRelativeSeverities.clear();
        }
    }

    public HashMapObjectInt getMaxRelativeSeverities() {
        return this.maxRelativeSeverities;
    }

    public void setMaxRelativeSeverities(HashMapObjectInt maxRelativeSeverities) {
        if (maxRelativeSeverities != null) {
            this.maxRelativeSeverities = maxRelativeSeverities;
        } else {
            this.maxRelativeSeverities.clear();
        }
    }

    public void setRelativeSeverities(HashMapObjectInt relativeSeverities) {
        this.setMinRelativeSeverities(relativeSeverities);
        this.setMaxRelativeSeverities(relativeSeverities);
    }

    public void removeRelativeSeverities() {
        this.minRelativeSeverities.clear();
        this.maxRelativeSeverities.clear();
    }

    public void setMinRelativeSeverity(String relativeControllerName, int severity) {
        this.minRelativeSeverities.put(relativeControllerName, severity);
    }

    public void setMinRelativeSeverity(String relativeControllerName, String severity) {
        this.setMinRelativeSeverity(relativeControllerName, Severity.parse((String)severity));
    }

    public void setMaxRelativeSeverity(String relativeControllerName, int severity) {
        this.maxRelativeSeverities.put(relativeControllerName, severity);
    }

    public void setMaxRelativeSeverity(String relativeControllerName, String severity) {
        this.setMaxRelativeSeverity(relativeControllerName, Severity.parse((String)severity));
    }

    public int getMinRelativeSeverity(String relativeControllerName) throws NoSuchElementException {
        if (this.minRelativeSeverities.containsKey(relativeControllerName)) {
            return this.minRelativeSeverities.get(relativeControllerName);
        }
        return 0;
    }

    public int getMaxRelativeSeverity(String relativeControllerName) throws NoSuchElementException {
        if (this.maxRelativeSeverities.containsKey(relativeControllerName)) {
            return this.maxRelativeSeverities.get(relativeControllerName);
        }
        return 701;
    }

    public boolean hasMinRelativeSeverity(String relativeControllerName) {
        return this.minRelativeSeverities.containsKey(relativeControllerName);
    }

    public boolean hasMaxRelativeSeverity(String relativeControllerName) {
        return this.maxRelativeSeverities.containsKey(relativeControllerName);
    }

    public void setRelativeSeverity(String relativeControllerName, int severity) {
        this.setMinRelativeSeverity(relativeControllerName, severity);
        this.setMaxRelativeSeverity(relativeControllerName, severity);
    }

    public void setRelativeSeverity(String relativeControllerName, String severity) {
        this.setMinRelativeSeverity(relativeControllerName, severity);
        this.setMaxRelativeSeverity(relativeControllerName, severity);
    }

    public String[] getRelativeControllersNames() {
        String[] maxRelatives = (String[])this.maxRelativeSeverities.getAllKeys(new String[this.maxRelativeSeverities.size()], 0);
        TreeSet<String> resultSet = new TreeSet<String>(Arrays.asList(maxRelatives));
        Enumeration minRelatives = this.minRelativeSeverities.keys();
        while (minRelatives.hasMoreElements()) {
            resultSet.add((String)minRelatives.nextElement());
        }
        return resultSet.toArray(maxRelatives);
    }

    public String[] getFilters() {
        return ((AbstractCollection)this.filters).toArray(new String[this.filters.size()]);
    }

    public void setFilters(String[] filters) {
        this.removeFilters();
        if (filters != null) {
            this.addFilters(filters);
        }
    }

    public void addFilters(String[] filters) {
        int i = filters.length;
        while (--i >= 0) {
            this.filters.add(filters[i]);
        }
    }

    public void addFilter(String filter) {
        this.filters.add(filter);
    }

    public void removeFilter(String filter) {
        this.filters.remove(filter);
    }

    public void removeFilters() {
        this.filters.clear();
    }

    public boolean containsFilter(String filter) {
        return this.filters.contains(filter);
    }

    public PersistenceAdapter getPersistenceAdapter() {
        return this.source;
    }

    public void setPersistenceAdapter(PersistenceAdapter source) {
        this.source = source;
    }

    public boolean hasDBLog() {
        return this.hasDBLog;
    }

    public void setDBLog(boolean enabled) {
        if (this.acceptsDBLog) {
            this.hasDBLog = enabled;
        }
    }

    public byte getState() {
        return this.state;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public String getStateOwner() {
        return this.stateOwner;
    }

    public void setStateOwner(String stateOwner) {
        this.stateOwner = stateOwner;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LogControllerDescriptor)) {
            return false;
        }
        LogControllerDescriptor descr = (LogControllerDescriptor)obj;
        if (!LogFormatterDescriptor.equals(this.name, descr.name)) {
            return false;
        }
        if (!LogFormatterDescriptor.equals(this.bundleName, descr.bundleName)) {
            return false;
        }
        if (this.minSeverity != descr.minSeverity) {
            return false;
        }
        if (this.maxSeverity != descr.maxSeverity) {
            return false;
        }
        if (!this.associatedDestinations.equals(descr.associatedDestinations)) {
            return false;
        }
        if (!this.minRelativeSeverities.equals(descr.minRelativeSeverities)) {
            return false;
        }
        if (!this.maxRelativeSeverities.equals(descr.maxRelativeSeverities)) {
            return false;
        }
        if (!this.filters.equals(descr.filters)) {
            return false;
        }
        if (this.hasDBLog != descr.hasDBLog) {
            return false;
        }
        if (this.state != descr.state) {
            return false;
        }
        return LogFormatterDescriptor.equals(this.stateOwner, descr.stateOwner);
    }

    public Object deepClone() {
        try {
            LogControllerDescriptor descr = (LogControllerDescriptor)super.clone();
            descr.filters = (HashSet)this.filters.clone();
            descr.associatedDestinations = (HashMapObjectByte)this.associatedDestinations.clone();
            descr.minRelativeSeverities = (HashMapObjectInt)this.minRelativeSeverities.clone();
            descr.maxRelativeSeverities = (HashMapObjectInt)this.maxRelativeSeverities.clone();
            return descr;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Object clone() {
        return this.deepClone();
    }

    public int compareTo(LogControllerDescriptor descr) {
        return this.getName().compareTo(descr.getName());
    }

    public int compareTo(Object o) {
        return this.compareTo((LogControllerDescriptor)o);
    }

    public String toString() {
        if ("".equals(this.name)) {
            return "ROOT LOCATION";
        }
        if ("/".equals(this.name)) {
            return "ROOT CATEGORY";
        }
        return this.name;
    }
}

