/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

public class SWMRG {
    protected int activeReaders = 0;
    protected int activeWriters = 0;
    protected int waitingReaders = 0;
    protected int waitingWriters = 0;
    protected int consecutiveWrites = 0;
    protected int consecutiveReads = 0;
    public int maxConsecutiveWrites = 4;
    public int maxConsecutiveReads = 32;

    public int getActiveReaders() {
        return this.activeReaders;
    }

    public void setActiveReaders(int activeReaders) {
        this.activeReaders = activeReaders;
    }

    public int getActiveWriters() {
        return this.activeWriters;
    }

    public void setActiveWriters(int activeWriters) {
        this.activeWriters = activeWriters;
    }

    public int getWaitingReaders() {
        return this.waitingReaders;
    }

    public void setWaitingReaders(int waitingReaders) {
        this.waitingReaders = waitingReaders;
    }

    public int getWaitingWriters() {
        return this.waitingWriters;
    }

    public void setWaitingWriters(int waitingWriters) {
        this.waitingWriters = waitingWriters;
    }

    public int getConsecutiveWrites() {
        return this.consecutiveWrites;
    }

    public void setConsecutiveWrites(int consecutiveWrites) {
        this.consecutiveWrites = consecutiveWrites;
    }

    public int getConsecutiveReads() {
        return this.consecutiveReads;
    }

    public void setConsecutiveReads(int consecutiveReads) {
        this.consecutiveReads = consecutiveReads;
    }

    public int getMaxConsecutiveWrites() {
        return this.maxConsecutiveWrites;
    }

    public void setMaxConsecutiveWrites(int maxConsecutiveWrites) {
        this.maxConsecutiveWrites = maxConsecutiveWrites;
    }

    public int getMaxConsecutiveReads() {
        return this.maxConsecutiveReads;
    }

    public void setMaxConsecutiveReads(int maxConsecutiveReads) {
        this.maxConsecutiveReads = maxConsecutiveReads;
    }

    protected boolean allowReader() {
        if (this.activeWriters == 0) {
            if (this.waitingWriters == 0) {
                return true;
            }
            return this.consecutiveReads < this.maxConsecutiveReads;
        }
        return false;
    }

    protected boolean allowWriter() {
        if (this.activeReaders == 0 && this.activeWriters == 0) {
            if (this.waitingReaders == 0) {
                return true;
            }
            return this.consecutiveWrites < this.maxConsecutiveWrites;
        }
        return false;
    }

    public synchronized void startRead() {
        ++this.waitingReaders;
        while (!this.allowReader()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        --this.waitingReaders;
        ++this.activeReaders;
        this.consecutiveWrites = 0;
        if (this.waitingWriters > 0) {
            ++this.consecutiveReads;
        }
    }

    public synchronized void endRead() {
        --this.activeReaders;
        this.notifyAll();
    }

    public synchronized void startWrite() {
        ++this.waitingWriters;
        while (!this.allowWriter()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        --this.waitingWriters;
        ++this.activeWriters;
        this.consecutiveReads = 0;
        if (this.waitingReaders > 0) {
            ++this.consecutiveWrites;
        }
    }

    public synchronized void endWrite() {
        --this.activeWriters;
        this.notifyAll();
    }
}

