/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

import com.sap.engine.lib.lang.ReadStream;
import java.io.IOException;
import java.io.OutputStream;

public class RunExec {
    private String[] command;
    private String simpleCommand;
    private int returnValue = 0;
    private Process process;
    protected ReadStream readInput;
    protected ReadStream readError;
    public static final byte NO_READ = 0;
    public static final byte READ_INPUT = 1;
    public static final byte READ_ERROR = 2;
    public static final byte READ_INPUT_ERROR = 3;

    public RunExec(String simpleCommand) {
        this.simpleCommand = simpleCommand;
    }

    public RunExec(String[] command) {
        this.command = command;
    }

    public void exec() throws IOException {
        this.exec((byte)3);
    }

    public void exec(byte type) throws IOException {
        this.process = this.command != null ? Runtime.getRuntime().exec(this.command) : Runtime.getRuntime().exec(this.simpleCommand);
        this.readInput = new ReadStream(this.process.getInputStream());
        this.readError = new ReadStream(this.process.getErrorStream());
        if (type == 1 || type == 3) {
            this.readInput.setWriting(true);
        } else {
            this.readInput.setWriting(false);
        }
        if (type == 2 || type == 3) {
            this.readError.setWriting(true);
        } else {
            this.readError.setWriting(false);
        }
        this.readInput.start();
        this.readError.start();
    }

    public int waitFor() throws Exception {
        if (this.process != null) {
            this.returnValue = this.process.waitFor();
            this.readInput.waitFor();
            this.readError.waitFor();
            return this.returnValue;
        }
        throw new Exception("Process is not executed!");
    }

    public int execAndWaitFor() throws Exception {
        return this.execAndWaitFor((byte)3);
    }

    public int execAndWaitFor(byte type) throws Exception {
        this.exec(type);
        return this.waitFor();
    }

    public void destroy() throws Exception {
        if (this.process == null) {
            throw new Exception("Process is not executed!");
        }
        this.process.destroy();
    }

    public String getOutput() throws IOException {
        return this.readInput.getInputString();
    }

    public String getError() throws IOException {
        return this.readError.getInputString();
    }

    public OutputStream getInputStream() {
        return this.process.getOutputStream();
    }
}

