/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io.version;

import com.sap.engine.lib.io.hash.CorruptedHashException;
import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.engine.lib.io.hash.Hasher;
import com.sap.engine.lib.io.hash.Index;
import com.sap.engine.lib.io.hash.MD5Hash;
import com.sap.engine.lib.io.version.Version;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.lib.util.HashMapObjectIntPositive;
import com.sap.engine.lib.util.HashMapObjectObject;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;

public class VersionFile
implements Version {
    private File versionFile = null;
    HashMapObjectIntPositive versions = new HashMapObjectIntPositive();
    HashMapObjectObject indexes = new HashMapObjectObject();
    private Hasher hasher = new MD5Hash();
    private boolean changed = false;

    public VersionFile(String filename) {
        this.versionFile = new File(filename);
        try {
            this.readData();
        }
        catch (IOException e) {
            this.versionFile.delete();
        }
        this.changed = false;
    }

    public VersionFile() throws IOException {
    }

    public int getVersion(String name) {
        int ver = this.versions.get(name);
        return ver;
    }

    public Index getIndex(String name) {
        Index ind = (Index)this.indexes.get(name);
        return ind;
    }

    public void writeData() throws IOException {
        String name;
        if (this.versionFile.exists()) {
            this.versionFile.delete();
        }
        byte[] intBuffer = new byte[4];
        this.hasher.clear();
        RandomAccessFile dataFile = new RandomAccessFile(this.versionFile, "rw");
        byte[] writeBuff = new byte[(this.versions.size() + 5) * 1024];
        int dataFileIndex = 0;
        Convert.writeIntToByteArr(writeBuff, 0, this.versions.size());
        dataFileIndex += 4;
        Enumeration enumeration = this.versions.keys();
        while (enumeration.hasMoreElements()) {
            name = (String)enumeration.nextElement();
            Convert.writeIntToByteArr(writeBuff, dataFileIndex, name.length());
            Convert.writeAStringToByteArr(writeBuff, dataFileIndex += 4, name);
            Convert.writeIntToByteArr(writeBuff, dataFileIndex += name.length(), this.versions.get(name));
            dataFileIndex += 4;
        }
        dataFile.write(writeBuff, 0, dataFileIndex);
        this.hasher.updateHash(writeBuff, 0, dataFileIndex);
        enumeration = this.indexes.keys();
        Convert.writeIntToByteArr(intBuffer, 0, this.indexes.size());
        dataFile.write(intBuffer);
        this.hasher.updateHash(intBuffer);
        while (enumeration.hasMoreElements()) {
            name = (String)enumeration.nextElement();
            Index ind = (Index)this.indexes.get(name);
            writeBuff = ind.toByteArr();
            Convert.writeIntToByteArr(intBuffer, 0, writeBuff.length);
            dataFile.write(intBuffer);
            this.hasher.updateHash(intBuffer);
            dataFile.write(writeBuff);
            this.hasher.updateHash(writeBuff);
        }
        writeBuff = this.hasher.getHash();
        dataFile.write(writeBuff);
        dataFile.close();
        this.changed = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readData() throws IOException, CorruptedHashException {
        byte[] readBuffer;
        block8: {
            if (!this.versionFile.exists() || this.changed) {
                return;
            }
            RandomAccessFile dataFile = null;
            try {
                dataFile = new RandomAccessFile(this.versionFile, "rw");
                readBuffer = new byte[(int)dataFile.length()];
                dataFile.readFully(readBuffer);
                Object var4_3 = null;
                if (dataFile == null) break block8;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (dataFile != null) {
                    dataFile.close();
                }
                throw throwable;
            }
            dataFile.close();
        }
        if (this.checkCRC(readBuffer)) {
            int i;
            int readIndex = 0;
            int work = Convert.byteArrToInt(readBuffer, readIndex);
            readIndex += 4;
            int i2 = work;
            while (true) {
                if (i2 <= 0) {
                    work = Convert.byteArrToInt(readBuffer, readIndex);
                    readIndex += 4;
                    i = work;
                    break;
                }
                work = Convert.byteArrToInt(readBuffer, readIndex);
                String name = Convert.byteArrToAString(readBuffer, readIndex += 4, work);
                readIndex += work;
                work = Convert.byteArrToInt(readBuffer, readIndex);
                readIndex += 4;
                this.versions.put(name, work);
                --i2;
            }
            while (i > 0) {
                work = Convert.byteArrToInt(readBuffer, readIndex);
                Index ind = HashUtils.getIndex(readBuffer, readIndex += 4);
                readIndex += work;
                this.indexes.put(ind.getName(), ind);
                --i;
            }
        }
    }

    public void setVersion(String name, int ver) {
        int k = this.versions.get(name);
        if (k != ver) {
            this.versions.put(name, ver);
            this.changed = true;
        }
    }

    public void setIndex(Index ind) {
        if (ind == null) {
            return;
        }
        Index oldIndex = (Index)this.indexes.get(ind.getName());
        if (oldIndex == null || oldIndex != null && !ind.equals(oldIndex)) {
            this.indexes.put(ind.getName(), ind);
            this.changed = true;
        }
    }

    private boolean checkCRC(byte[] inData) {
        this.hasher.clear();
        try {
            this.hasher.updateHash(inData, 0, inData.length - 16);
        }
        catch (Exception e) {
            return false;
        }
        byte[] buff = this.hasher.getHash();
        return VersionFile.compareByteArrays(buff, 0, 16, inData, inData.length - 16, 16);
    }

    public static boolean compareByteArrays(byte[] array1, int from1, int len1, byte[] array2, int from2, int len2) {
        if (len1 != len2) {
            return false;
        }
        int i = 0;
        while (i < len1) {
            if (array1[from1 + i] != array2[from2 + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean exists() {
        return this.versionFile.exists();
    }

    public boolean delete() {
        return this.versionFile.delete();
    }

    public boolean checkConsistency() {
        try {
            if (!this.changed) {
                this.readData();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        block3: {
            block2: {
                sb = new StringBuffer();
                sb.append("-[VersionFile: " + this.versionFile.getAbsolutePath() + "]----" + "\n");
                enum = this.indexes.keys();
                sb.append("[[[[[[ Index section ]]]]]]\n");
                if (enum.hasMoreElements()) ** GOTO lbl18
                sb.append("<EMPTY!>\n");
                break block2;
lbl-1000:
                // 1 sources

                {
                    key = (String)enum.nextElement();
                    sb.append("-=[" + key + "]=-" + "\n");
                    sb.append(this.getIndex(key) + "\n");
                    sb.append("-------------------------------------------------------------------\n");
lbl18:
                    // 2 sources

                    ** while (enum.hasMoreElements())
                }
            }
            enum = this.versions.keys();
            sb.append("[[[[[[ Version section ]]]]]]\n");
            if (enum.hasMoreElements()) ** GOTO lbl30
            sb.append("<EMPTY!>\n");
            break block3;
lbl-1000:
            // 1 sources

            {
                key = (String)enum.nextElement();
                sb.append("[" + key + "] ---> " + this.getVersion(key) + "\n");
lbl30:
                // 2 sources

                ** while (enum.hasMoreElements())
            }
        }
        sb.append("-------------------------------------------------------------------\n");
        return sb.toString();
    }
}

