/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io;

import com.sap.engine.lib.util.HashMapObjectObject;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class GZIPMultiOutputStream {
    private static final boolean DEBUG = false;
    private HashMapObjectObject hash = new HashMapObjectObject();
    static /* synthetic */ Class array$B;

    public void addStream(OutputStream _out, Constructor def, Constructor crc) throws IOException {
        OutputStream outputStream = _out;
        synchronized (outputStream) {
            StreamTool tool = null;
            if (def == null || crc == null) {
                tool = new StreamTool(new Deflater(-1, true), new CRC32());
            } else {
                try {
                    tool = new StreamTool(def.newInstance(new Integer(-1), new Boolean(true)), crc.newInstance(new Object[0]));
                }
                catch (Exception e) {
                    throw new IOException("Error constructing StreamTool : " + e.getMessage());
                }
            }
            this.hash.put(_out, tool);
            tool.writeHeader(_out);
            if (tool.externalLib) {
                try {
                    tool.crc32.getClass().getMethod("reset", new Class[0]).invoke(tool.crc32, new Object[0]);
                }
                catch (Exception e) {
                    throw new IOException("Error executing CRC32.reset() : [" + e.getMessage() + "] !");
                }
            } else {
                tool.crc.reset();
            }
        }
    }

    public void write(OutputStream out, int b) throws IOException {
        if (this.hash.containsKey(out)) {
            byte[] buf = new byte[]{(byte)(b & 0xFF)};
            this.write(out, buf, 0, 1);
        }
    }

    public synchronized void write(OutputStream _out, byte[] b) throws IOException {
        if (this.hash.containsKey(_out)) {
            this.write(_out, b, 0, b.length);
        }
    }

    public void write(OutputStream _out, byte[] buf, int off, int len) throws IOException {
        OutputStream outputStream = _out;
        synchronized (outputStream) {
            if (this.hash.containsKey(_out)) {
                StreamTool tool = (StreamTool)this.hash.get(_out);
                if (tool.externalLib) {
                    boolean finished;
                    Object obj = ((StreamTool)this.hash.get((Object)_out)).deflater;
                    try {
                        finished = (Boolean)obj.getClass().getMethod("finished", new Class[0]).invoke(obj, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IOException("Error executing Deflater.finished() : [" + e.getMessage() + "] !");
                    }
                    if (finished) {
                        throw new IOException("write beyond end of stream");
                    }
                    if ((off | len | off + len | buf.length - (off + len)) < 0) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (len == 0) {
                        return;
                    }
                    try {
                        finished = (Boolean)obj.getClass().getMethod("finished", new Class[0]).invoke(obj, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IOException("Error executing Deflater.finished() : [" + e.getMessage() + "] !");
                    }
                    if (!finished) {
                        try {
                            obj.getClass().getMethod("setInput", array$B == null ? (array$B = GZIPMultiOutputStream.class$("[B")) : array$B, Integer.TYPE, Integer.TYPE).invoke(obj, buf, new Integer(off), new Integer(len));
                        }
                        catch (Exception e) {
                            throw new IOException("Error executing Deflater.setInput(byte[], int,int) : [" + e.getMessage() + "] !");
                        }
                        try {
                            while (!((Boolean)obj.getClass().getMethod("needsInput", new Class[0]).invoke(obj, new Object[0])).booleanValue()) {
                                tool.deflate(_out);
                            }
                        }
                        catch (Exception e) {
                            throw new IOException("Error executing Deflater.needsInput() : [" + e.getMessage() + "] !");
                        }
                        try {
                            tool.crc32.getClass().getMethod("update", array$B == null ? (array$B = GZIPMultiOutputStream.class$("[B")) : array$B, Integer.TYPE, Integer.TYPE).invoke(tool.crc32, buf, new Integer(off), new Integer(len));
                        }
                        catch (Exception e) {
                            throw new IOException("Error executing CRC32.update(byte[], int, int) : [" + e.getMessage() + "] !");
                        }
                    }
                } else {
                    Deflater def = ((StreamTool)this.hash.get((Object)_out)).def;
                    if (def.finished()) {
                        throw new IOException("write beyond end of stream");
                    }
                    if ((off | len | off + len | buf.length - (off + len)) < 0) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (len == 0) {
                        return;
                    }
                    if (!def.finished()) {
                        def.setInput(buf, off, len);
                        while (!def.needsInput()) {
                            tool.deflate(_out);
                        }
                    }
                    tool.crc.update(buf, off, len);
                }
            }
        }
    }

    public void flush(OutputStream _out) throws IOException {
        OutputStream outputStream = _out;
        synchronized (outputStream) {
            if (this.hash.containsKey(_out)) {
                ((StreamTool)this.hash.get(_out)).deflate(_out);
                _out.flush();
            }
        }
    }

    public void finish(OutputStream _out) throws IOException {
        if (this.hash.containsKey(_out)) {
            StreamTool tool = (StreamTool)this.hash.get(_out);
            if (tool.externalLib) {
                boolean finished;
                try {
                    finished = (Boolean)tool.deflater.getClass().getMethod("finished", new Class[0]).invoke(tool.deflater, new Object[0]);
                }
                catch (Exception e) {
                    throw new IOException("Error executing Deflater.finished() : [" + e.getMessage() + "] !");
                }
                if (!finished) {
                    try {
                        tool.deflater.getClass().getMethod("finish", new Class[0]).invoke(tool.deflater, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IOException("Error executing Deflater.finish() : [" + e.getMessage() + "] !");
                    }
                    try {
                        while (!((Boolean)tool.deflater.getClass().getMethod("finished", new Class[0]).invoke(tool.deflater, new Object[0])).booleanValue()) {
                            tool.deflate(_out);
                        }
                    }
                    catch (Exception e) {
                        throw new IOException("Error executing Deflater.finished() : [" + e.getMessage() + "] !");
                    }
                    tool.writeTrailer(_out);
                }
            } else {
                Deflater def = tool.def;
                if (!def.finished()) {
                    def.finish();
                    while (!def.finished()) {
                        tool.deflate(_out);
                    }
                    tool.writeTrailer(_out);
                }
            }
        }
    }

    public void close(OutputStream _out) throws IOException {
        OutputStream outputStream = _out;
        synchronized (outputStream) {
            if (this.hash.containsKey(_out)) {
                StreamTool tool = (StreamTool)this.hash.get(_out);
                this.finish(_out);
                if (tool.externalLib) {
                    try {
                        tool.deflater.getClass().getMethod("end", new Class[0]).invoke(tool.deflater, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IOException("Error executing Deflater.end() : [" + e.getMessage() + "] !");
                    }
                } else {
                    tool.def.end();
                }
                this.hash.remove(_out);
                _out.close();
            }
        }
    }

    protected void finalize() throws Throwable {
        Object[] streams = this.hash.getAllKeys();
        int i = 0;
        while (i < streams.length) {
            this.close((OutputStream)streams[i]);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class StreamTool {
        private static final int GZIP_MAGIC = 35615;
        protected Deflater def = null;
        protected CRC32 crc = null;
        protected byte[] buf = new byte[512];
        protected Object deflater = null;
        protected Object crc32 = null;
        protected boolean externalLib = false;
        static /* synthetic */ Class array$B;

        public StreamTool(Deflater _def, CRC32 _crc) {
            this.def = _def;
            this.crc = _crc;
        }

        public StreamTool(Object _def, Object _crc) {
            this.deflater = _def;
            this.crc32 = _crc;
            this.externalLib = true;
        }

        public void writeInt(OutputStream out, int i) throws IOException {
            this.writeShort(out, i & 0xFFFF);
            this.writeShort(out, i >> 16 & 0xFFFF);
        }

        public void writeShort(OutputStream out, int s) throws IOException {
            out.write(s & 0xFF);
            out.write(s >> 8 & 0xFF);
        }

        public void writeHeader(OutputStream out) throws IOException {
            this.writeShort(out, 35615);
            if (this.externalLib) {
                try {
                    out.write(this.deflater.getClass().getField("DEFLATED").getInt(this.deflater));
                }
                catch (Exception e) {
                    throw new IOException("Error obtaining Deflater.DEFLATED : [" + e.getMessage() + "] !");
                }
            } else {
                out.write(8);
            }
            out.write(0);
            this.writeInt(out, 0);
            out.write(0);
            out.write(0);
        }

        protected void deflate(OutputStream out) throws IOException {
            int len;
            if (this.externalLib) {
                try {
                    len = (Integer)this.deflater.getClass().getMethod("deflate", array$B == null ? (array$B = StreamTool.class$("[B")) : array$B, Integer.TYPE, Integer.TYPE).invoke(this.deflater, this.buf, new Integer(0), new Integer(this.buf.length));
                }
                catch (Exception e) {
                    throw new IOException("Error executing Deflater.deflate(byte[], int, int) : [" + e.getMessage() + "] !");
                }
            } else {
                len = this.def.deflate(this.buf, 0, this.buf.length);
            }
            if (len > 0) {
                out.write(this.buf, 0, len);
            }
        }

        protected void writeTrailer(OutputStream out) throws IOException {
            if (this.externalLib) {
                try {
                    this.writeInt(out, ((Long)this.crc32.getClass().getMethod("getValue", new Class[0]).invoke(this.crc32, new Object[0])).intValue());
                }
                catch (Exception e) {
                    throw new IOException("Error executing CRC32.getValue() : [" + e.getMessage() + "] !");
                }
                try {
                    this.writeInt(out, (Integer)this.deflater.getClass().getMethod("getTotalIn", new Class[0]).invoke(this.deflater, new Object[0]));
                }
                catch (Exception e) {
                    throw new IOException("Error executing Deflater.getTotalIn() : [" + e.getMessage() + "] !");
                }
            }
            this.writeInt(out, (int)this.crc.getValue());
            this.writeInt(out, this.def.getTotalIn());
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

