/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.interfaces.security.auth;

import com.sap.engine.interfaces.security.auth.LoginModuleHelper;
import com.sap.engine.interfaces.security.userstore.context.UserContext;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import java.lang.ref.WeakReference;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public abstract class AbstractLoginModule
implements LoginModule {
    public static final String PRINCIPAL = "javax.security.auth.login.principal";
    protected static final String NAME = "javax.security.auth.login.name";
    private static WeakReference helper = null;
    private Map sharedState = null;

    public static void setLoginModuleHelper(LoginModuleHelper helper) {
        if (helper != null) {
            LoginModuleHelper moduleHelper;
            if (AbstractLoginModule.helper != null && (moduleHelper = (LoginModuleHelper)AbstractLoginModule.helper.get()) != null) {
                moduleHelper.checkPermission();
            }
            AbstractLoginModule.helper = new WeakReference<LoginModuleHelper>(helper);
        } else {
            AbstractLoginModule.helper = null;
        }
    }

    protected void checkUserLockStatus(String userName) throws LoginException {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            moduleHelper.checkUserLockStatus(userName, this.sharedState);
        }
    }

    protected void checkUserLockStatus(X509Certificate certificate) throws LoginException {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            moduleHelper.checkUserLockStatus(certificate, this.sharedState);
        }
    }

    protected void checkUserLockStatus(UserContext userContext, UserInfo userInfo) throws LoginException {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            moduleHelper.checkUserLockStatus(userContext, userInfo, this.sharedState);
        }
    }

    public boolean changePasswordIfNeeded(String userName, CallbackHandler callbackHandler) throws LoginException {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            return moduleHelper.changePasswordIfNeeded(userName, callbackHandler);
        }
        return false;
    }

    public boolean changePasswordIfNeeded(X509Certificate certificate, CallbackHandler callbackHandler) throws LoginException {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            return moduleHelper.changePasswordIfNeeded(certificate, callbackHandler);
        }
        return false;
    }

    public boolean changePasswordIfNeeded(UserContext userContext, UserInfo userInfo, CallbackHandler callbackHandler) throws LoginException {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            return moduleHelper.changePasswordIfNeeded(userContext, userInfo, callbackHandler);
        }
        return false;
    }

    public boolean isUserAccountExpired(String userName) throws LoginException {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            return moduleHelper.isUserAccountExpired(userName, this.sharedState);
        }
        return false;
    }

    public boolean isUserAccountExpired(UserInfo userInfo, UserContext userContext) throws LoginException {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            return moduleHelper.isUserAccountExpired(userInfo, userContext, this.sharedState);
        }
        return false;
    }

    public void refreshUserInfo(String userName) throws LoginException {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            moduleHelper.refreshUserInfo(userName, this.sharedState);
        }
    }

    protected void writeLogonStatistics(boolean successful, String userName, long timeStamp, Map sharedState) {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            moduleHelper.writeLogonStatistics(successful, userName, timeStamp, sharedState);
        }
    }

    public void writeLogonStatistics(boolean successful, UserInfo userInfo, long timeStamp, Map sharedState) {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            moduleHelper.writeLogonStatistics(successful, userInfo, timeStamp, sharedState);
        }
    }

    protected void logMessage(byte severity, String message) {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            moduleHelper.logMessage(severity, message);
        }
    }

    protected void logThrowable(byte severity, Throwable throwable) {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            moduleHelper.logThrowable(severity, throwable);
        }
    }

    protected void throwNewLoginException(String message) throws LoginException {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            moduleHelper.throwNewLoginException(message);
        }
    }

    protected void throwNewLoginException(String message, byte cause) throws LoginException {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            moduleHelper.throwNewLoginException(message, cause);
        }
    }

    protected void throwUserLoginException(Exception exception) throws LoginException {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            moduleHelper.throwUserLoginException(exception);
        }
    }

    protected void throwUserLoginException(Exception exception, byte cause) throws LoginException {
        LoginModuleHelper moduleHelper;
        if (helper != null && (moduleHelper = (LoginModuleHelper)helper.get()) != null) {
            moduleHelper.throwUserLoginException(exception, cause);
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.sharedState = sharedState;
    }

    public abstract boolean login() throws LoginException;

    public abstract boolean commit() throws LoginException;

    public abstract boolean abort() throws LoginException;

    public abstract boolean logout() throws LoginException;
}

