/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.load.res;

import com.sap.engine.frame.core.load.res.JarResource;

final class JarThread
extends Thread {
    private static final long SLEEP_TIME = 2000L;
    private static final long JAR_TIME_OPENED = 2000L;
    private Entry head;
    private Entry tail;

    JarThread() {
        super("SAPJarResourceCloseTimeoutThread");
        this.setDaemon(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            JarThread jarThread = this;
            synchronized (jarThread) {
                while (this.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Entry entry = this.getFirst();
            while (entry != null) {
                JarResource jarResource = entry.jarResource;
                synchronized (jarResource) {
                    if (System.currentTimeMillis() - entry.openTime > 2000L) {
                        entry.jarResource.closeTimeout(entry.openTime);
                        entry = entry.nextEntry;
                        continue;
                    }
                    break;
                }
            }
            this.setFirst(entry);
        }
    }

    void register(JarResource jarResource, long openTime) {
        this.addLast(new Entry(jarResource, openTime));
        JarThread jarThread = this;
        synchronized (jarThread) {
            this.notify();
        }
    }

    private synchronized boolean isEmpty() {
        return this.head == null;
    }

    private synchronized void addLast(Entry entry) {
        if (this.tail == null) {
            this.head = this.tail = entry;
        } else {
            this.tail.nextEntry = entry;
            this.tail = entry;
        }
    }

    private synchronized Entry getFirst() {
        return this.head;
    }

    private synchronized void setFirst(Entry entry) {
        this.head = entry;
        if (entry == null) {
            this.tail = null;
        }
    }

    private static class Entry {
        private Entry nextEntry = null;
        private JarResource jarResource;
        private long openTime;

        public Entry(JarResource jarResource, long openTime) {
            this.jarResource = jarResource;
            this.openTime = openTime;
        }
    }
}

