/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.load.res;

import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.frame.core.load.res.ClassInfo;
import com.sap.engine.frame.core.load.res.DirResource;
import com.sap.engine.frame.core.load.res.Resource;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.PermissionCollection;
import java.util.HashSet;
import java.util.Vector;
import java.util.jar.Attributes;

public class DirsResource
implements Resource {
    protected DirResource[] dirs = new DirResource[0];
    protected PermissionCollection permissionCollection;

    public DirsResource() {
    }

    public DirsResource(String fileName) {
        this.addDir(fileName);
    }

    public DirsResource(String[] fileNames) {
        this.addDirs(fileNames);
    }

    public DirsResource(File[] dirFiles) {
        this.addDirs(dirFiles);
    }

    public ClassInfo getClassInfo(String className, String fileName) {
        ClassInfo result = null;
        int i = 0;
        while (i < this.dirs.length) {
            result = this.dirs[i].getClassInfo(className, fileName);
            if (result != null) break;
            ++i;
        }
        return result;
    }

    public URL getURL(String fileName) {
        URL result = null;
        int i = 0;
        while (i < this.dirs.length) {
            result = this.dirs[i].getURL(fileName);
            if (result != null) break;
            ++i;
        }
        return result;
    }

    public URL[] getURLs(String fileName) {
        Vector<URL> array = new Vector<URL>();
        URL next = null;
        int i = 0;
        while (i < this.dirs.length) {
            next = this.dirs[i].getURL(fileName);
            if (next != null) {
                array.add(next);
            }
            ++i;
        }
        return array.toArray(new URL[array.size()]);
    }

    public InputStream getInputStream(String fileName) {
        InputStream result = null;
        int i = 0;
        while (i < this.dirs.length) {
            result = this.dirs[i].getInputStream(fileName);
            if (result != null) break;
            ++i;
        }
        return result;
    }

    public String[] getResourceNames() {
        String[] names = new String[this.dirs.length];
        int i = 0;
        while (i < names.length) {
            names[i] = this.dirs[i].getName();
            ++i;
        }
        return names;
    }

    public Attributes getAttributes(String packageName, boolean filterCheck) {
        Attributes result = null;
        int i = 0;
        while (i < this.dirs.length) {
            result = this.dirs[i].getAttributes(packageName, filterCheck);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public Resource[] getSimpleResources() {
        Resource[] result = new Resource[this.dirs.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.dirs[i];
            ++i;
        }
        return result;
    }

    public void addDir(String dir) {
        if (dir != null) {
            this.addResources(new DirResource[]{new DirResource(dir)});
        }
    }

    public void addDirs(String[] dirNames) {
        if (dirNames != null) {
            DirResource[] newResources = new DirResource[dirNames.length];
            int i = 0;
            while (i < dirNames.length) {
                newResources[i] = new DirResource(dirNames[i]);
                ++i;
            }
            this.addResources(newResources);
        }
    }

    public void addDirs(File[] dirFiles) {
        if (dirFiles != null) {
            DirResource[] newResources = new DirResource[dirFiles.length];
            int i = 0;
            while (i < dirFiles.length) {
                newResources[i] = new DirResource(dirFiles[i].getAbsolutePath());
                ++i;
            }
            this.addResources(newResources);
        }
    }

    public void addResource(DirResource dirResource) {
        this.addResources(new DirResource[]{dirResource});
    }

    public synchronized void addResources(DirResource[] dirResources) {
        if (!ReferencedLoader.isStrictResourceOrder()) {
            if (dirResources != null) {
                HashSet<DirResource> set = new HashSet<DirResource>();
                int i = 0;
                while (i < this.dirs.length) {
                    set.add(this.dirs[i]);
                    ++i;
                }
                int i2 = 0;
                while (i2 < dirResources.length) {
                    set.add(dirResources[i2]);
                    ++i2;
                }
                DirResource[] tempResources = new DirResource[set.size()];
                set.toArray(tempResources);
                this.dirs = tempResources;
            }
        } else if (dirResources != null) {
            Vector<DirResource> set = new Vector<DirResource>();
            int i = 0;
            while (i < this.dirs.length) {
                set.add(this.dirs[i]);
                ++i;
            }
            int i3 = 0;
            while (i3 < dirResources.length) {
                set.add(dirResources[i3]);
                ++i3;
            }
            DirResource[] tempResources = new DirResource[set.size()];
            set.toArray(tempResources);
            this.dirs = tempResources;
        }
    }
}

