/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.configuration.admin;

import com.sap.engine.frame.core.configuration.admin.BlockingLock;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class BlockingLockImpl
implements BlockingLock,
Serializable {
    private String m_path;
    private int m_accessMode;
    private int m_clusterNode;
    private int m_blockingTime;
    private String m_lockOwnerID;
    private int m_lockOwnerClusterID;
    private int m_waiters;

    public BlockingLockImpl(String path, int accessMode, int clusterNode, int blockTime, int waiters, String lockOwnerId, int lockOwnerClusterID) {
        this.m_path = path;
        this.m_accessMode = accessMode;
        this.m_clusterNode = clusterNode;
        this.m_blockingTime = blockTime;
        this.m_waiters = waiters;
        this.m_lockOwnerID = lockOwnerId;
        this.m_lockOwnerClusterID = lockOwnerClusterID;
    }

    public String getBlockedConfigurationPath() {
        return this.m_path;
    }

    public int getAccessMode() {
        return this.m_accessMode;
    }

    public int getClusterNodeID() {
        return this.m_clusterNode;
    }

    public int getBlockingTime() {
        return this.m_blockingTime;
    }

    public int getNumberOfWaiters() {
        return this.m_waiters;
    }

    public String getLockOwnerTransactionID() {
        return this.m_lockOwnerID;
    }

    public int getLockOwnerClusterID() {
        return this.m_lockOwnerClusterID;
    }

    public String toString() {
        return "Locked path:" + this.m_path + ", lock owner:" + this.m_lockOwnerID + ", owner cluster ID:" + this.m_lockOwnerClusterID;
    }

    public static BlockingLockImpl[] readAllFromStream(ObjectInputStream in) throws Exception {
        boolean eof = false;
        Vector<BlockingLockImpl> v = new Vector<BlockingLockImpl>();
        while (!eof) {
            try {
                String path = (String)in.readObject();
                int accessMode = in.readInt();
                int clusterNode = in.readInt();
                int blockTime = in.readInt();
                int waiters = in.readInt();
                String ownerid = (String)in.readObject();
                int ownerhost = in.readInt();
                v.addElement(new BlockingLockImpl(path, accessMode, clusterNode, blockTime, waiters, ownerid, ownerhost));
            }
            catch (EOFException e) {
                eof = true;
            }
        }
        return v.toArray(new BlockingLockImpl[0]);
    }

    public void writeToStream(ObjectOutputStream out) throws IOException {
        out.writeObject(this.m_path);
        out.writeInt(this.m_accessMode);
        out.writeInt(this.m_clusterNode);
        out.writeInt(this.m_blockingTime);
        out.writeInt(this.m_waiters);
        out.writeObject(this.m_lockOwnerID);
        out.writeInt(this.m_lockOwnerClusterID);
    }
}

