/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.core.configuration;

import com.sap.engine.frame.core.configuration.ConfigMetaData;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.InvalidValueException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.NoWriteAccessException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import java.io.File;
import java.io.InputStream;
import java.rmi.Remote;
import java.util.Map;

public interface Configuration
extends Remote {
    public static final int CLOSED = 1;
    public static final int INCONSISTENT = 2;
    public static final int DELETED = 3;
    public static final int NOTEXIST = 4;
    public static final int ACCESSABLE = 0;
    public static final int READ_ALL = 2;
    public static final int READ_ENTRY = 4;
    public static final int CACHE_ON = 8;
    public static final int CACHE_OFF = 16;
    public static final int CONFIG_TYPE_STANDARD = 0;
    public static final int CONFIG_TYPE_PROPERTYSHEET = 1;

    public boolean isValid();

    public long getId();

    public String getPath();

    public Configuration getOpenRoot();

    public void close() throws ConfigurationException;

    public void setCacheMode(int var1) throws ConfigurationException, NoWriteAccessException;

    public int getConfigurationType() throws ConfigurationException;

    public int getCacheMode() throws ConfigurationException;

    public ConfigMetaData getMetaData() throws ConfigurationException;

    public Configuration createSubConfiguration(String var1) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public Map createSubConfigurations(String[] var1) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public Configuration createSubConfiguration(String var1, int var2) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public Map createSubConfigurations(String[] var1, int var2) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public Configuration createSubConfigurationHierachy(String var1) throws ConfigurationException, NoWriteAccessException;

    public boolean existsSubConfiguration(String var1) throws ConfigurationException, InconsistentReadException;

    public Configuration getSubConfiguration(String var1) throws ConfigurationException, NameNotFoundException, InconsistentReadException;

    public Map getSubConfigurations(String[] var1) throws ConfigurationException, NameNotFoundException, InconsistentReadException;

    public Map getAllSubConfigurations() throws ConfigurationException, InconsistentReadException;

    public String[] getAllSubConfigurationNames() throws ConfigurationException, InconsistentReadException;

    public ConfigMetaData[] getAllSubConfigurationMetaData() throws ConfigurationException, InconsistentReadException;

    public void deleteConfiguration(String var1) throws ConfigurationException, NameNotFoundException, NoWriteAccessException;

    public void deleteConfiguration() throws ConfigurationException, NoWriteAccessException;

    public void deleteSubConfigurations(String[] var1) throws ConfigurationException, NoWriteAccessException;

    public void deleteAllSubConfigurations() throws ConfigurationException, NoWriteAccessException;

    public void addConfigEntry(String var1, Object var2) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException, InvalidValueException;

    public void addConfigEntries(Map var1) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException, InvalidValueException;

    public boolean existsConfigEntry(String var1) throws ConfigurationException, InconsistentReadException;

    public void modifyConfigEntry(String var1, Object var2) throws ConfigurationException, NameNotFoundException, NoWriteAccessException, InvalidValueException;

    public void modifyConfigEntry(String var1, Object var2, boolean var3) throws ConfigurationException, NameNotFoundException, NoWriteAccessException, InvalidValueException;

    public void modifyConfigEntries(Map var1) throws ConfigurationException, NoWriteAccessException, InvalidValueException;

    public Object getConfigEntry(String var1) throws ConfigurationException, NameNotFoundException, InconsistentReadException;

    public Map getConfigEntries(String[] var1) throws ConfigurationException, InconsistentReadException;

    public Map getAllConfigEntries() throws ConfigurationException, InconsistentReadException;

    public String[] getAllConfigEntryNames() throws ConfigurationException, InconsistentReadException;

    public void deleteConfigEntry(String var1) throws ConfigurationException, NameNotFoundException, NoWriteAccessException;

    public void deleteConfigEntries(String[] var1) throws ConfigurationException, NoWriteAccessException;

    public void deleteAllConfigEntries() throws ConfigurationException, NoWriteAccessException;

    public void addFileAsStream(String var1, InputStream var2) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public void addFileEntryByKey(String var1, File var2) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public void addFileEntry(File var1) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public void addFileEntries(File[] var1) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public void addFileEntriesByKey(Map var1) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public void updateFile(File var1) throws ConfigurationException, NameNotFoundException, NoWriteAccessException;

    public void updateFile(File var1, boolean var2) throws ConfigurationException, NameNotFoundException, NoWriteAccessException;

    public void updateFileByKey(String var1, File var2) throws ConfigurationException, NameNotFoundException, NoWriteAccessException;

    public void updateFileByKey(String var1, File var2, boolean var3) throws ConfigurationException, NoWriteAccessException;

    public boolean existsFile(String var1) throws ConfigurationException, InconsistentReadException;

    public void updateFileAsStream(String var1, InputStream var2) throws ConfigurationException, NameNotFoundException, NoWriteAccessException;

    public void updateFileAsStream(String var1, InputStream var2, boolean var3) throws ConfigurationException, NameNotFoundException, NoWriteAccessException;

    public void updateFiles(File[] var1) throws ConfigurationException, NoWriteAccessException;

    public void updateFilesByKey(Map var1) throws ConfigurationException, NoWriteAccessException;

    public InputStream getFile(String var1) throws ConfigurationException, NameNotFoundException, InconsistentReadException;

    public Map getFileEntries(String[] var1) throws ConfigurationException, NameNotFoundException, InconsistentReadException;

    public String[] getAllFileEntryNames() throws ConfigurationException, InconsistentReadException;

    public Map getAllFileEntries() throws ConfigurationException, InconsistentReadException;

    public void deleteFile(String var1) throws ConfigurationException, NameNotFoundException, NoWriteAccessException;

    public void deleteFiles(String[] var1) throws ConfigurationException, NoWriteAccessException;

    public void deleteAllFiles() throws ConfigurationException, NoWriteAccessException;

    public PropertySheet getPropertySheetInterface() throws ConfigurationException, InconsistentReadException;

    public void export(String var1) throws InconsistentReadException, ConfigurationException;

    public void importAsSubConfiguration(String var1) throws NoWriteAccessException, NameAlreadyExistsException, ConfigurationException;

    public void importContent(String var1) throws NoWriteAccessException, NameAlreadyExistsException, ConfigurationException;
}

