/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.frame.cluster.message;

import com.sap.engine.frame.core.load.LoadContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;

public class ClassloaderNameInputStream
extends ObjectInputStream {
    protected static final String OTHER_LOADER = "other_loader";
    protected LoadContext loadContext;

    public ClassloaderNameInputStream(InputStream in, LoadContext loadContext) throws IOException, StreamCorruptedException {
        super(in);
        this.loadContext = loadContext;
    }

    protected Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        String loaderName = (String)this.readObject();
        String className = osc.getName();
        ClassLoader loader = null;
        try {
            if (OTHER_LOADER.equals(loaderName)) {
                try {
                    return super.resolveClass(osc);
                }
                catch (ClassNotFoundException e) {
                    return Class.forName(className);
                }
            }
            if (!loaderName.startsWith("common:")) {
                loader = this.loadContext.getClassLoader(loaderName);
                if (loader != null) {
                    return Class.forName(className, false, loader);
                }
            } else {
                int begin;
                int end = begin = "common".length();
                do {
                    if ((loader = (end = loaderName.indexOf(59, begin = end + 1)) == -1 ? this.loadContext.getClassLoader(loaderName.substring(begin)) : this.loadContext.getClassLoader(loaderName.substring(begin, end))) == null) continue;
                    try {
                        return Class.forName(className, false, loader);
                    }
                    catch (ClassNotFoundException e3) {
                        // empty catch block
                    }
                } while (end != -1);
            }
        }
        catch (ClassNotFoundException e2) {
            // empty catch block
        }
        return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
    }
}

