/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.server.common;

import com.sap.engine.deploy.server.provider.ServiceProviderDocument;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.deploy.tool.server.common.ServiceSecurity;
import com.sap.engine.deploy.tool.server.common.ServiceSecurityPanel;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.TreeUtils;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import com.sap.engine.services.deploy.gui.common.additional.SecurityTreeNode;
import com.sap.engine.services.deploy.gui.common.additional.SecurityTreeRenderer;
import com.sap.engine.services.deploy.gui.common.additional.SecurityUserObject;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;

public class ServiceSecurityPanelLogical
extends ServiceSecurityPanel {
    protected SecurityTreeNode root = null;
    protected SecurityTreeNode jarNode = null;
    protected SecurityTreeNode classNode = null;
    protected SecurityTreeNode methodNode = null;
    private DynamicClassLoader loader = null;
    private int madeFrom = 0;
    private ApplicationInformationProvider appProvider;
    private Frame frame;
    private ServiceSecurity security = null;
    private String[] jars = null;
    private static final Icon rootIcon = new ImageIcon((class$com$sap$engine$deploy$tool$ToolTabPanel == null ? (class$com$sap$engine$deploy$tool$ToolTabPanel = ServiceSecurityPanelLogical.class$("com.sap.engine.deploy.tool.ToolTabPanel")) : class$com$sap$engine$deploy$tool$ToolTabPanel).getResource("tree/images/service.gif"));
    private int classType;
    private int methodType;
    private Hashtable resources = null;
    private ServiceProviderDocument document;
    static /* synthetic */ Class class$com$sap$engine$deploy$tool$ToolTabPanel;

    public ServiceSecurityPanelLogical(Frame mainFrame, ClassLoader loader) {
        LookAndFeelHandler.add((Component)this);
        this.frame = mainFrame;
        this.loader = (DynamicClassLoader)loader;
        this.methodTree.setCellRenderer(new SecurityTreeRenderer(rootIcon));
        this.methodTree.setRootVisible(false);
        this.root = new SecurityTreeNode("root", 0);
        ((DefaultTreeModel)this.methodTree.getModel()).setRoot(this.root);
        this.initButtons();
    }

    public void setPanelInfo(ServiceProviderDocument _doc, String[] serviceJarsPaths) {
        this.document = _doc;
        this.security = this.document.getSecurity();
        this.jars = serviceJarsPaths;
        this.selectedList.removeAll();
        this.root.removeAllChildren();
        ((DefaultTreeModel)this.methodTree.getModel()).reload();
        this.initButtons();
        this.initTree();
        ((DefaultTreeModel)this.methodTree.getModel()).reload();
        TreeUtils.expandTree((JTree)this.methodTree, (int)3);
    }

    private void initButtons() {
        if (this.methodTree.isSelectionEmpty() || this.availableList.isSelectionEmpty()) {
            this.addButton.setEnabled(false);
        } else if (this.selectedList.getModel().getSize() == 0) {
            this.addButton.setEnabled(true);
        } else if (!this.availableList.getSelectedValue().toString().equals(this.selectedList.getModel().getElementAt(0).toString())) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
        if (this.methodTree.isSelectionEmpty() || this.selectedList.isSelectionEmpty()) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.initButtons();
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.initButtons();
        SecurityTreeNode selectedNode = null;
        if (!this.methodTree.isSelectionEmpty()) {
            selectedNode = (SecurityTreeNode)this.methodTree.getLastSelectedPathComponent();
            if (((SecurityUserObject)selectedNode.getUserObject()).getType() == 0 || ((SecurityUserObject)selectedNode.getUserObject()).getType() == 4 || ((SecurityUserObject)selectedNode.getUserObject()).getType() == 3) {
                this.mainSplitPane.add((Component)this.infoPanel, "right");
                this.mainSplitPane.setDividerLocation(200);
                return;
            }
            this.mainSplitPane.add((Component)this.rolesPanel, "right");
            this.mainSplitPane.setDividerLocation(200);
            if (this.methodNode != null) {
                this.setSecurity(this.methodNode);
            }
            this.methodNode = selectedNode;
            this.clear();
            if ((((SecurityUserObject)selectedNode.getUserObject()).getType() == 2 || ((SecurityUserObject)selectedNode.getUserObject()).getType() == 1) && this.methodNode != null) {
                this.showSecurity(this.methodNode);
            }
        } else {
            this.selectedModel.removeAllElements();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("REMOVE_CMD")) {
            this.removeBtnAction();
        } else if (cmd.equals("ADD_CMD")) {
            this.addBtnAction();
        }
    }

    private void initTree() {
        if (this.jars == null || this.jars.length == 0) {
            return;
        }
        JarFile jarFile = null;
        Enumeration<JarEntry> jarEntries = null;
        String entryName = null;
        JarEntry theEntry = null;
        Class temp = null;
        String classEntryName = null;
        int i = 0;
        while (i < this.jars.length) {
            this.jarNode = new SecurityTreeNode(this.jars[i].substring(this.jars[i].lastIndexOf(File.separatorChar) + 1), 0);
            this.root.add(this.jarNode);
            try {
                jarFile = new JarFile(this.jars[i]);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.frame, "Error while opening " + this.jars[i] + " file.\n " + ioe.toString(), "Error", 0);
            }
            jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                theEntry = jarEntries.nextElement();
                entryName = theEntry.getName();
                if (!entryName.endsWith("class")) continue;
                try {
                    classEntryName = entryName.substring(0, entryName.lastIndexOf(46));
                    classEntryName = classEntryName.replace('/', '.');
                    temp = this.loader.loadClass(classEntryName);
                    if (temp == null || !this.isInterfaceImplementsRemote(temp)) continue;
                    this.initTreeNode(temp);
                }
                catch (ClassNotFoundException cnfe) {
                    JOptionPane.showMessageDialog(this.frame, "Could not find class file " + entryName + ".\n " + cnfe.toString(), "Error", 0);
                }
            }
            ++i;
        }
        this.methodNode = null;
    }

    private boolean isInterfaceImplementsRemote(Class baseClass) {
        Class<?>[] classes = baseClass.getInterfaces();
        if (classes != null && classes.length > 0) {
            int i = 0;
            while (i < classes.length) {
                if (classes[i] != null) {
                    if (classes[i].getName().equals("java.rmi.Remote")) {
                        if (baseClass.getName().endsWith("EJBObject")) {
                            this.classType = 4;
                        } else if (baseClass.getName().endsWith("EJBHome")) {
                            this.classType = 3;
                        }
                        return true;
                    }
                    if (this.isInterfaceImplementsRemote(classes[i])) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return baseClass.getSuperclass() != null && this.isInterfaceImplementsRemote(baseClass.getSuperclass());
    }

    private void initTreeNode(Class baseClass) {
        this.classNode = new SecurityTreeNode(baseClass.getName().substring(baseClass.getName().lastIndexOf(46) + 1), this.classType);
        this.jarNode.add(this.classNode);
        TreeUtils.expandTree((JTree)this.methodTree, (int)3);
        ((DefaultTreeModel)this.methodTree.getModel()).reload();
        Method[] methods = baseClass.getDeclaredMethods();
        switch (this.classType) {
            case 4: {
                this.methodType = 2;
                break;
            }
            case 3: {
                this.methodType = 1;
            }
        }
        int i = 0;
        while (i < methods.length) {
            if (Modifier.isPublic(methods[i].getModifiers())) {
                this.methodNode = new SecurityTreeNode(methods[i].getName(), this.methodType);
                this.classNode.add(this.methodNode);
            }
            ++i;
        }
    }

    public void removeBtnAction() {
        if (!this.selectedList.isSelectionEmpty()) {
            this.selectedModel.removeElement(this.selectedList.getSelectedValue());
        }
        this.availableList.clearSelection();
        this.selectedModel.removeAllElements();
    }

    public void addBtnAction() {
        if (!this.availableList.isSelectionEmpty()) {
            int result = -1;
            if (!this.selectedModel.isEmpty()) {
                if (!this.availableList.getSelectedValue().toString().equals(this.selectedList.getModel().getElementAt(0).toString())) {
                    result = JOptionPane.showConfirmDialog(this.frame, "Every method can have only one security role.\nWould you like to replace '" + this.selectedModel.getElementAt(0) + "' with '" + this.availableList.getSelectedValue() + "'?", "Warning", 2, 2);
                }
                if (this.selectedModel.isEmpty() || result == 0) {
                    this.selectedModel.removeAllElements();
                    this.selectedModel.addElement(this.availableList.getSelectedValue());
                }
            } else {
                this.selectedModel.addElement(this.availableList.getSelectedValue());
            }
            this.availableList.clearSelection();
            this.selectedList.clearSelection();
        }
    }

    public void setSecurity(SecurityTreeNode node) {
        if (this.security == null) {
            this.security = new ServiceSecurity(new Hashtable());
        }
        Hashtable actions = null;
        boolean isClassFound = false;
        boolean isMethodFound = false;
        this.resources = this.security.getResources();
        if (this.resources != null && this.resources.size() > 0) {
            String className = null;
            String methodName = null;
            Enumeration e = this.resources.keys();
            while (e.hasMoreElements()) {
                className = (String)e.nextElement();
                if (className == null || !className.equals(((SecurityTreeNode)node.getParent()).getName())) continue;
                isClassFound = true;
                actions = (Hashtable)this.resources.get(className);
                if (actions == null) continue;
                Enumeration enumeration = actions.keys();
                while (enumeration.hasMoreElements()) {
                    methodName = (String)enumeration.nextElement();
                    if (methodName == null || !methodName.equals(node.getName())) continue;
                    isMethodFound = true;
                    if (!this.selectedModel.isEmpty()) {
                        actions.put(methodName, this.selectedModel.getElementAt(0).toString());
                        continue;
                    }
                    actions.remove(methodName);
                }
                if (isMethodFound || this.selectedModel.isEmpty()) continue;
                actions.put(node.getName(), this.selectedModel.getElementAt(0).toString());
            }
            if (!isClassFound) {
                actions = new Hashtable();
                if (!this.selectedModel.isEmpty()) {
                    actions.put(node.getName(), this.selectedModel.getElementAt(0).toString());
                }
            }
        } else {
            if (this.resources == null) {
                this.resources = new Hashtable();
            }
            actions = new Hashtable();
            if (!this.selectedModel.isEmpty()) {
                actions.put(node.getName(), this.selectedModel.getElementAt(0).toString());
            }
        }
        this.resources.put(((SecurityTreeNode)node.getParent()).getName(), actions);
        this.security.setResources(this.resources);
    }

    public void commitChange() {
        if (this.document != null) {
            this.document.setSecurity(this.security);
        }
    }

    public void showSecurity(SecurityTreeNode node) {
        if (this.security != null && node.getName() != null) {
            this.resources = this.security.getResources();
            String className = null;
            Hashtable actions = null;
            String methodName = null;
            if (this.resources != null && this.resources.size() > 0) {
                Enumeration e = this.resources.keys();
                while (e.hasMoreElements()) {
                    className = (String)e.nextElement();
                    if (!className.equals(((SecurityTreeNode)node.getParent()).getName())) continue;
                    actions = (Hashtable)this.resources.get(className);
                    Enumeration en = actions.keys();
                    while (en.hasMoreElements()) {
                        methodName = (String)en.nextElement();
                        if (node.getName() == null || !node.getName().equals(methodName)) continue;
                        this.selectedModel.addElement(new ListValues(new SecurityRoles((String)actions.get(methodName)), 0));
                    }
                }
            }
        }
        this.availableList.clearSelection();
        this.availableList.setEnabled(true);
        this.selectedList.setEnabled(true);
    }

    public void setLoader(ClassLoader classLoader) {
        this.loader = (DynamicClassLoader)classLoader;
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
    }

    public void clear() {
        this.selectedModel.removeAllElements();
    }

    public int isCorrect() {
        return 0;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

