/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.server.common;

import com.sap.engine.deploy.ejb.gui.additional.BeanSettings;
import com.sap.engine.deploy.server.CPropertyObject;
import com.sap.engine.deploy.server.provider.ServiceProviderDocument;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.deploy.tool.server.common.RuntimePropertyEditor;
import com.sap.engine.deploy.tool.server.common.ServiceProviderDescriptorPanel;
import com.sap.engine.deploy.tool.server.common.ServiceSecurityPanelLogical;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.editorproperties.PropertyEditor;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.services.deploy.gui.SFileChooser;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ServicePropPanel
extends BasicPanelView
implements ChangeListener,
ActionListener {
    private Frame mainFrame;
    private String displayName;
    private String componentName;
    private JTabbedPane tabPane = new JTabbedPane();
    private BorderLayout borderLayout = new BorderLayout();
    private BorderLayout propertiesBorderLayout = new BorderLayout();
    private ServiceProviderDescriptorPanel providerXMLPanel;
    private ServiceSecurityPanelLogical securityPanel;
    private RuntimePropertyEditor runtimePropPanel;
    private PropertyEditor propPanel;
    private Properties props = new Properties();
    private Properties runtimeProps = new Properties();
    private ServiceProviderDocument document;
    private Vector propertyFiles;
    private ErrorReportObject error;
    private ApplicationInformationProvider appInfo;
    private JPanel directoryPanel = new JPanel();
    private JPanel propertiesPanel = new JPanel();
    private JLabel dirLabel;
    private JTextField dirTextField = new JTextField();
    private JButton browseDirButton = new JButton("...");
    private SFileChooser chooser = null;
    private int madeFromConstant = -1;
    private ClassLoader loader;

    public ServicePropPanel() {
        try {
            this.init();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Visualization of panels cannot be initialized properly\nReason: " + e.toString() + "\nRestart of the tool is recommended.\n We are sorry for the inconvenience.", "Error in visualization", 0);
        }
    }

    public ServicePropPanel(Frame frame, ClassLoader _loader) {
        this.mainFrame = frame;
        this.loader = _loader;
        this.init();
    }

    public void init() {
        LookAndFeelHandler.add((Component)this);
        this.setLayout(this.borderLayout);
        this.tabPane.setTabPlacement(1);
        this.providerXMLPanel = new ServiceProviderDescriptorPanel(this.mainFrame);
        this.securityPanel = new ServiceSecurityPanelLogical(this.mainFrame, this.loader);
        this.runtimePropPanel = new RuntimePropertyEditor();
        this.runtimePropPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Runtime Properties"));
        this.propPanel = new PropertyEditor();
        this.propPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Additional Properties"));
        this.propertiesPanel.setLayout(this.propertiesBorderLayout);
        this.propertiesPanel.add((Component)this.runtimePropPanel, "North");
        this.propertiesPanel.add((Component)this.propPanel, "Center");
        this.tabPane.addTab(BeanSettings.getResourceString("ProviderXMLPanel", "Provider"), this.providerXMLPanel);
        this.tabPane.addTab(BeanSettings.getResourceString("ServiceSecurity", "Security"), this.securityPanel);
        this.tabPane.addTab(BeanSettings.getResourceString("Properties", "Properties"), this.propertiesPanel);
        this.add((Component)this.tabPane, "Center");
        this.tabPane.addChangeListener(this);
        this.tabPane.setSelectedIndex(0);
        this.browseDirButton.addActionListener(this);
        this.browseDirButton.setActionCommand("browse");
        this.browseDirButton.setEnabled(true);
        this.dirLabel = new JLabel("Directory: ");
        this.directoryPanel.setLayout(new GridBagLayout());
        this.directoryPanel.add((Component)this.dirLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.directoryPanel.add((Component)this.dirTextField, new GridBagConstraints(1, 0, 2, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.directoryPanel.add((Component)this.browseDirButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.directoryPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Service Persistent Directory"));
        this.add((Component)this.directoryPanel, "South");
        this.repaint();
        this.validate();
    }

    public void setDocument(ServiceProviderDocument doc, InfoObject[] jars) {
        this.document = doc;
        this.providerXMLPanel.setLeaf(this.document);
        this.providerXMLPanel.setSpecificInfo();
        if (jars != null) {
            String[] serviceJars = new String[jars.length];
            int i = 0;
            while (i < jars.length) {
                serviceJars[i] = jars[i].getFilePath();
                ++i;
            }
            this.securityPanel.setPanelInfo(this.document, serviceJars);
        }
    }

    public void setPropertyFiles(Vector prop) {
        this.clear();
        this.propertyFiles = prop;
        this.props = new Properties();
        this.runtimeProps = new Properties();
        if (this.propertyFiles != null && this.propertyFiles.size() > 0) {
            String propFileName = null;
            FileInputStream fis = null;
            int i = 0;
            while (i < this.propertyFiles.size()) {
                propFileName = ((CPropertyObject)this.propertyFiles.elementAt(i)).getFilePath();
                if (propFileName.endsWith("runtime.properties")) {
                    try {
                        if (new File(propFileName).exists()) {
                            fis = new FileInputStream(propFileName);
                            this.runtimeProps.load(fis);
                            fis.close();
                            this.runtimePropPanel.initProperties(this.runtimeProps);
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Could not find runtime property file " + propFileName + ".\n " + fnfe.toString(), "Error", 0);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Could not read runtime property file " + propFileName + ".\n " + ioe.toString(), "Error", 0);
                    }
                } else if (propFileName.endsWith("properties")) {
                    try {
                        if (new File(propFileName).exists()) {
                            fis = new FileInputStream(propFileName);
                            this.props.load(fis);
                            fis.close();
                            this.propPanel.initProperties(this.props);
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Could not find property file " + propFileName + ".\n " + fnfe.toString(), "Error", 0);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Could not read property file " + propFileName + ".\n " + ioe.toString(), "Error", 0);
                    }
                }
                ++i;
            }
        }
    }

    public void savePropertyFiles() {
        String propFileName = null;
        File dirPath = null;
        File propFile = null;
        FileOutputStream fos = null;
        int i = 0;
        while (i < this.propertyFiles.size()) {
            try {
                propFileName = ((CPropertyObject)this.propertyFiles.elementAt(i)).getFilePath();
                if (propFileName.endsWith("runtime.properties")) {
                    this.runtimeProps = this.runtimePropPanel.getProperties();
                    if (((Hashtable)this.runtimeProps).keys().hasMoreElements()) {
                        dirPath = new File(propFileName.substring(0, propFileName.lastIndexOf(File.separatorChar)));
                        dirPath.mkdirs();
                        propFile = new File(propFileName);
                        if (propFile.exists()) {
                            propFile.delete();
                        }
                        propFile.createNewFile();
                        fos = new FileOutputStream(propFile);
                        this.runtimeProps.store(fos, null);
                        fos.flush();
                        fos.close();
                    } else {
                        propFile = new File(propFileName);
                        if (propFile.exists()) {
                            propFile.delete();
                        }
                    }
                } else if (propFileName.endsWith("properties")) {
                    this.props = this.propPanel.getProps();
                    if (((Hashtable)this.props).keys().hasMoreElements()) {
                        dirPath = new File(propFileName.substring(0, propFileName.lastIndexOf(File.separatorChar)));
                        dirPath.mkdirs();
                        propFile = new File(propFileName);
                        if (propFile.exists()) {
                            propFile.delete();
                        }
                        propFile.createNewFile();
                        fos = new FileOutputStream(propFile);
                        this.props.store(fos, null);
                        fos.flush();
                        fos.close();
                    } else {
                        propFile = new File(propFileName);
                        if (propFile.exists()) {
                            propFile.delete();
                        }
                    }
                }
            }
            catch (FileNotFoundException fnfe) {
                JOptionPane.showMessageDialog(this.mainFrame, "Could not find property file " + propFileName + ".\n " + fnfe.toString(), "Error", 0);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.mainFrame, "Could not read property file " + propFileName + ".\n " + ioe.toString(), "Error", 0);
            }
            ++i;
        }
    }

    public void setDisplayName(String name) {
        this.displayName = name;
        this.providerXMLPanel.setDisplayName(this.displayName);
    }

    public void setComponentName(String name) {
        this.componentName = name;
        this.providerXMLPanel.setComponentName(this.componentName);
    }

    public void stateChanged(ChangeEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        this.chooser = SFileChooser.getInstance((JFrame)this.mainFrame);
        LookAndFeelHandler.add((Component)((Object)this.chooser));
        String[] dirName = this.chooser.showDirDialog("Select Persistent Directory", false, false, false);
        if (dirName != null) {
            this.dirTextField.setText(dirName[0]);
        }
        this.repaint();
    }

    public void init(int madeFromConstant) {
        this.madeFromConstant = madeFromConstant;
        this.providerXMLPanel.init(madeFromConstant);
        this.securityPanel.init(madeFromConstant);
    }

    public void clear() {
        this.propPanel.initProperties(null);
        this.runtimePropPanel.initProperties(null);
    }

    public int isCorrect() {
        return 4;
    }

    public void commitChange() {
        this.providerXMLPanel.commitChange();
        this.securityPanel.commitChange();
        this.savePropertyFiles();
    }

    public String getPersistentDirectory() {
        return this.dirTextField.getText().trim();
    }

    public void setPersistentDirectory(String dirName) {
        this.dirTextField.setText(dirName);
    }

    public void setFrame(Frame frame) {
        this.mainFrame = frame;
    }

    public void setLoader(ClassLoader loader) {
    }

    public ErrorReportObject getErrorObject() {
        return this.error;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appInfo = appProvider;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appInfo;
    }
}

