/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.server.common;

import com.sap.engine.deploy.tool.server.common.SComponentsReference;
import javax.swing.table.AbstractTableModel;

public class SComponentsReferenceTableModel
extends AbstractTableModel {
    protected String[] colnames = new String[]{"Name", "Type", "Strength"};
    protected SComponentsReference[] refs = new SComponentsReference[0];
    static /* synthetic */ Class class$java$lang$String;

    public SComponentsReferenceTableModel() {
    }

    public SComponentsReferenceTableModel(String[] colnames, SComponentsReference[] refs) {
        this.colnames = colnames;
        this.refs = refs;
    }

    public int getColumnCount() {
        return this.colnames.length;
    }

    public int getRowCount() {
        return this.refs.length;
    }

    public Object getValueAt(int row, int col) {
        if (row >= 0 && row < this.refs.length) {
            switch (col) {
                case 0: {
                    return this.refs[row].getName();
                }
                case 1: {
                    switch (this.refs[row].getReferenceType()) {
                        case 12: {
                            return "library";
                        }
                        case 13: {
                            return "interface";
                        }
                        case 1: {
                            return "service";
                        }
                    }
                }
                case 2: {
                    switch (this.refs[row].getStrength()) {
                        case 0: {
                            return "weak";
                        }
                        case 1: {
                            return "hard";
                        }
                        case 2: {
                            return "notify";
                        }
                    }
                }
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        return this.colnames[column];
    }

    public Class getColumnClass(int columnIndex) {
        return class$java$lang$String == null ? (class$java$lang$String = SComponentsReferenceTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void addRow(SComponentsReference sRef) {
        String name = sRef.getName();
        if (name == null || name.trim().length() == 0) {
            return;
        }
        int i = 0;
        while (i < this.refs.length) {
            if (this.refs[i].getName().trim().equals(name)) {
                return;
            }
            ++i;
        }
        SComponentsReference[] temp = new SComponentsReference[this.refs.length + 1];
        System.arraycopy(this.refs, 0, temp, 0, this.refs.length);
        temp[this.refs.length] = sRef;
        this.refs = temp;
        this.fireTableDataChanged();
    }

    public void removeRow(int row) {
        if (row < 0 || row >= this.refs.length) {
            return;
        }
        SComponentsReference[] temp = new SComponentsReference[this.refs.length - 1];
        int index = this.refs.length - row - 1;
        if (index > 0) {
            System.arraycopy(this.refs, row + 1, this.refs, row, index);
        }
        System.arraycopy(this.refs, 0, temp, 0, this.refs.length - 1);
        this.refs = temp;
        this.fireTableDataChanged();
    }

    public void addRows(SComponentsReference[] ref) {
        this.refs = ref == null ? new SComponentsReference[0] : ref;
        this.fireTableDataChanged();
    }

    public SComponentsReference[] getAllRows() {
        return this.refs;
    }

    public SComponentsReference getRow(int index) {
        if (index < 0 || index >= this.refs.length) {
            return null;
        }
        return this.refs[index];
    }

    public void updateReference(SComponentsReference ref, int index) {
        if (index < 0 || index >= this.refs.length) {
            return;
        }
        this.refs[index] = ref;
        this.fireTableDataChanged();
    }

    public void clearAll() {
        this.refs = new SComponentsReference[0];
        this.fireTableDataChanged();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

