/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.server.common;

import com.sap.engine.deploy.server.SComponentObject;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.editorproperties.PropertiesTableModel;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.services.deploy.gui.SFileChooser;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class SComponentJarsPanel
extends BasicPanelView
implements ChangeListener,
ActionListener,
ListSelectionListener,
DocumentListener {
    private JButton browseButton = new JButton("...");
    private JLabel keyLabel;
    private JTextField keyTextField;
    private JLabel valueLabel;
    private JTextField valueTextField;
    private JButton addButton;
    private JButton removeButton;
    private JTable jarTable;
    private PropertiesTableModel model;
    private Frame mainFrame;
    private JPanel buttonPanel = new JPanel();
    private JPanel libNamePanel = new JPanel();
    private ErrorReportObject error;
    private ApplicationInformationProvider appInfo;
    private JPanel jarPanel = new JPanel();
    private SComponentObject scObj;
    private String title = null;
    private SFileChooser chooser = null;
    private DynamicClassLoader loader = null;
    private JCheckBox jarsDefault = new JCheckBox();
    private boolean hasComboBox = false;
    private Color backgroundColor = new Color(255, 255, 255);
    private Color disabledBackgroundColor = new Color(186, 194, 223);

    public SComponentJarsPanel(ClassLoader _loader) {
        this.loader = (DynamicClassLoader)_loader;
        this.visualInit(12);
    }

    public SComponentJarsPanel(int type) {
        this.visualInit(type);
    }

    private void visualInit(int _type) {
        LookAndFeelHandler.add((Component)this);
        LookAndFeelHandler.add((Component)this.jarsDefault);
        this.setLayout(new BorderLayout());
        this.jarTable = new JTable();
        this.model = new PropertiesTableModel("JAR Path", "Mapping");
        this.jarTable.setModel((TableModel)this.model);
        this.jarTable.getSelectionModel().addListSelectionListener(this);
        this.jarTable.setSelectionMode(0);
        switch (_type) {
            case 12: {
                this.title = "Library";
                break;
            }
            case 13: {
                this.title = "Interface";
                break;
            }
            case 1: {
                this.title = "Service";
            }
        }
        this.jarsDefault.setText("Use Default JAR Files");
        this.jarsDefault.addChangeListener(this);
        this.jarPanel = this.initPanel(this.jarPanel);
        this.jarPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), this.title + " Jars"));
        this.buttonPanel.setLayout(new FlowLayout());
        this.browseButton.addActionListener(this);
        this.browseButton.setActionCommand("browse");
        this.browseButton.setEnabled(true);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.add((Component)this.libNamePanel, "North");
        this.add((Component)this.jarPanel, "Center");
        this.add((Component)this.buttonPanel, "South");
    }

    private JPanel initPanel(JPanel tablePanel) {
        tablePanel.setLayout(new GridBagLayout());
        tablePanel.add((Component)new JScrollPane(this.jarTable), new GridBagConstraints(0, 1, 4, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.keyLabel = new JLabel("JAR:");
        tablePanel.add((Component)this.keyLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.keyTextField = new JTextField();
        this.keyTextField.getDocument().addDocumentListener(this);
        tablePanel.add((Component)this.keyTextField, new GridBagConstraints(1, 2, 2, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        tablePanel.add((Component)this.browseButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.valueLabel = new JLabel("Mapping:");
        tablePanel.add((Component)this.valueLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.valueTextField = new JTextField();
        this.valueTextField.getDocument().addDocumentListener(this);
        tablePanel.add((Component)this.valueTextField, new GridBagConstraints(1, 3, 2, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.keyTextField.setEnabled(true);
        this.valueTextField.setEnabled(true);
        this.addButton = new JButton("Add");
        this.addButton.setActionCommand("addJar");
        this.addButton.addActionListener(this);
        this.buttonPanel.add(this.addButton);
        this.removeButton = new JButton("Remove");
        this.removeButton.setActionCommand("remJar");
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        this.buttonPanel.add(this.removeButton);
        this.libNamePanel.setLayout(new GridBagLayout());
        return tablePanel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("addJar")) {
            this.addJarFile();
        } else if (e.getActionCommand().equals("remJar")) {
            this.removeJarFile();
        } else if (e.getActionCommand().equals("browse")) {
            this.browseAction();
        }
    }

    private void browseAction() {
        this.jarTable.getSelectionModel().clearSelection();
        this.removeButton.setEnabled(false);
        this.chooser = SFileChooser.getInstance((JFrame)this.mainFrame);
        LookAndFeelHandler.add((Component)((Object)this.chooser));
        this.chooser.setFilters(new String[]{".jar"});
        String[] fileName = this.chooser.showFileDialog("Select Archive", false, false, false);
        if (fileName != null) {
            this.keyTextField.setText(fileName[0]);
            this.valueTextField.setText(fileName[0].substring(fileName[0].lastIndexOf(File.separatorChar) + 1, fileName[0].length()));
        }
        this.repaint();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e == null || e.getValueIsAdjusting()) {
            return;
        }
        this.table_valueChanged();
    }

    private void table_valueChanged() {
        int row = this.jarTable.getSelectedRow();
        if (row >= this.jarTable.getRowCount() || row < 0) {
            this.removeButton.setEnabled(false);
            return;
        }
        this.removeButton.setEnabled(true);
        this.keyTextField.setText((String)this.model.getValueAt(row, 0));
        this.valueTextField.setText((String)this.model.getValueAt(row, 1));
    }

    public void setDescriptor(SComponentObject _scObj) {
        this.clear();
        this.scObj = _scObj;
        if (this.scObj != null) {
            InfoObject[] infoObjs = this.scObj.getJars();
            this.jarTable.setBackground(this.backgroundColor);
            if (this.scObj.getCompType().equalsIgnoreCase("interface")) {
                if (this.scObj.isJarsAreDefaultJars()) {
                    this.jarsDefault.setSelected(true);
                } else {
                    this.jarsDefault.setSelected(false);
                }
                if (!this.hasComboBox) {
                    this.jarPanel.add((Component)this.jarsDefault, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
                    this.hasComboBox = true;
                    if (this.jarsDefault.isSelected()) {
                        this.jarTable.setBackground(this.disabledBackgroundColor);
                    }
                }
            } else {
                if (this.hasComboBox) {
                    this.jarPanel.remove(this.jarsDefault);
                    this.hasComboBox = false;
                }
                this.jarTable.setEnabled(true);
                this.jarTable.setBackground(this.backgroundColor);
                this.keyTextField.setEnabled(true);
                this.valueTextField.setEnabled(true);
                this.browseButton.setEnabled(true);
                this.buttonPanel.setEnabled(true);
            }
            if (infoObjs != null && infoObjs.length > 0) {
                int i = 0;
                while (i < infoObjs.length) {
                    if (infoObjs[i].getFilePath().trim().length() == 0) {
                        return;
                    }
                    if (!new File(infoObjs[i].getFilePath()).exists()) {
                        JOptionPane.showMessageDialog(this, "JAR '" + infoObjs[i].getFilePath() + "' does not exists!");
                        return;
                    }
                    this.model.addRow(infoObjs[i].getFilePath(), infoObjs[i].getEntryName());
                    ++i;
                }
            }
        }
    }

    public void setTitle(String titleName) {
        ((TitledBorder)this.jarPanel.getBorder()).setTitle(titleName);
    }

    public void setTitle(int _type) {
        String title = null;
        switch (_type) {
            case 12: {
                title = "Library";
                break;
            }
            case 13: {
                title = "Interface";
                break;
            }
            case 1: {
                title = "Service";
            }
        }
        ((TitledBorder)this.jarPanel.getBorder()).setTitle(title + " Jars");
    }

    private void addJarFile() {
        String jarPath = this.keyTextField.getText();
        String mapping = this.valueTextField.getText();
        if (jarPath.trim().length() == 0) {
            return;
        }
        if (!new File(jarPath).exists()) {
            JOptionPane.showMessageDialog(this, "JAR " + jarPath + " doesn't exists!");
            this.keyTextField.requestFocus();
            return;
        }
        int i = 0;
        while (i < this.model.getRowCount()) {
            if (this.model.getValueAt(i, 1).equals(mapping)) {
                JOptionPane.showMessageDialog(this, "Mapping " + mapping + " already exists!");
                this.valueTextField.requestFocus();
                return;
            }
            ++i;
        }
        if (mapping.trim().equals("")) {
            this.model.addRow(jarPath, jarPath.substring(jarPath.lastIndexOf(File.separator) + 1));
        } else {
            this.model.addRow(jarPath, mapping);
        }
        this.loader.addClasspath(jarPath);
        this.keyTextField.setText("");
        this.valueTextField.setText("");
        this.keyTextField.requestFocus();
    }

    private void removeJarFile() {
        int selRow = this.jarTable.getSelectedRow();
        this.jarTable.editingStopped(new ChangeEvent(this.jarTable));
        this.model.removeRow(selRow);
        if (selRow >= this.jarTable.getRowCount() && this.jarTable.getRowCount() > 0) {
            this.jarTable.setRowSelectionInterval(this.jarTable.getRowCount() - 1, this.jarTable.getRowCount() - 1);
        } else {
            this.jarTable.getSelectionModel().clearSelection();
        }
        this.keyTextField.setText("");
        this.valueTextField.setText("");
        this.table_valueChanged();
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.keyTextField.getText().trim().equals("")) {
            this.addButton.setEnabled(true);
            int i = 0;
            while (i < this.jarTable.getRowCount()) {
                if (this.valueTextField.getText().trim().equals("") && this.valueTextField.getText().trim().equals(((String)this.jarTable.getModel().getValueAt(i, 1)).trim())) {
                    this.addButton.setEnabled(false);
                }
                ++i;
            }
        } else {
            this.addButton.setEnabled(false);
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.keyTextField.getText().trim().equals("")) {
            this.addButton.setEnabled(true);
            int i = 0;
            while (i < this.jarTable.getRowCount()) {
                if (this.valueTextField.getText().trim().equals("") && this.valueTextField.getText().trim().equals(((String)this.jarTable.getModel().getValueAt(i, 1)).trim())) {
                    this.addButton.setEnabled(false);
                }
                ++i;
            }
        } else {
            this.addButton.setEnabled(false);
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void stateChanged(ChangeEvent ce) {
        if (this.hasComboBox && ce.getSource() == this.jarsDefault) {
            if (this.jarsDefault.isSelected()) {
                this.jarTable.setEnabled(false);
                this.jarTable.setBackground(this.disabledBackgroundColor);
                this.keyTextField.setEnabled(false);
                this.valueTextField.setEnabled(false);
                this.browseButton.setEnabled(false);
                this.buttonPanel.setEnabled(false);
            } else {
                this.jarTable.setEnabled(true);
                this.jarTable.setBackground(this.backgroundColor);
                this.keyTextField.setEnabled(true);
                this.valueTextField.setEnabled(true);
                this.browseButton.setEnabled(true);
                this.buttonPanel.setEnabled(true);
            }
        }
    }

    public void init(int madeFromConstant) {
    }

    public void clear() {
        this.keyTextField.setText("");
        this.valueTextField.setText("");
        this.model.clearAll();
        this.jarTable.removeAll();
        this.jarTable.repaint();
    }

    public int isCorrect() {
        return 4;
    }

    public void commitChange() {
        InfoObject info = null;
        Vector<InfoObject> infoVec = new Vector<InfoObject>();
        int i = 0;
        while (i < this.model.getRowCount()) {
            info = new InfoObject((String)this.model.getValueAt(i, 1), (String)this.model.getValueAt(i, 0));
            infoVec.add(info);
            ++i;
        }
        Object[] infos = new InfoObject[infoVec.size()];
        infoVec.copyInto(infos);
        if (this.hasComboBox) {
            if (this.jarsDefault.isSelected()) {
                this.scObj.setJarsAreDefaultJars(true);
                this.scObj.setJars(new String[0]);
            } else {
                this.scObj.setJarsAreDefaultJars(false);
                this.scObj.setJars((InfoObject[])infos);
            }
        } else {
            this.scObj.setJars((InfoObject[])infos);
        }
    }

    public void setFrame(Frame frame) {
        this.mainFrame = frame;
    }

    public void setLoader(ClassLoader loader) {
    }

    public ErrorReportObject getErrorObject() {
        return this.error;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appInfo = appProvider;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appInfo;
    }

    public boolean isDefaultJars() {
        return this.jarsDefault.isSelected();
    }
}

