/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.server.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RuntimePropertyEditor
extends JPanel
implements ActionListener {
    public static final String CORE = "core-service";
    public static final String MODE = "startup-mode";
    public static final String STATE = "startup-state";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String ALWAYS = "always";
    public static final String MANUAL = "manual";
    public static final String AUTOMATIC = "automatic";
    public static final String STARTED = "started";
    public static final String STOPED = "stopped";
    public static final String CORE_CHECK = "CORE_CHECK";
    public static final String MODE_CHECK = "MODE_CHECK";
    public static final String STATE_CHECK = "STATE_CHECK";
    private JCheckBox coreCheckBox = new JCheckBox();
    private JCheckBox modeCheckBox = new JCheckBox();
    private JCheckBox stateCheckBox = new JCheckBox();
    private JLabel coreLabel = new JLabel("core-service");
    private JLabel modeLabel = new JLabel("startup-mode");
    private JLabel stateLabel = new JLabel("startup-state");
    private JComboBox coreComboBox = new JComboBox<Object>(new Object[]{"false", "true"});
    private JComboBox modeComboBox = new JComboBox<Object>(new Object[]{"always", "manual", "automatic"});
    private JComboBox stateComboBox = new JComboBox<Object>(new Object[]{"started", "stopped"});

    public RuntimePropertyEditor() {
        this.initPanel();
    }

    private void initPanel() {
        JPanel inner = new JPanel();
        this.setLayout(new BorderLayout());
        inner.setLayout(new GridBagLayout());
        this.coreComboBox.setSelectedItem(FALSE);
        this.modeComboBox.setSelectedItem(ALWAYS);
        this.stateComboBox.setEnabled(false);
        this.coreComboBox.setEnabled(false);
        this.modeComboBox.setEnabled(false);
        this.stateComboBox.setSelectedItem(STARTED);
        inner.add((Component)this.coreCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        inner.add((Component)this.coreLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        inner.add((Component)this.coreComboBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        inner.add((Component)this.modeCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        inner.add((Component)this.modeLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        inner.add((Component)this.modeComboBox, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        inner.add((Component)this.stateCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        inner.add((Component)this.stateLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        inner.add((Component)this.stateComboBox, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        inner.setPreferredSize(new Dimension(210, 120));
        inner.setMaximumSize(new Dimension(210, 120));
        this.add((Component)inner, "West");
        this.coreCheckBox.addActionListener(this);
        this.modeCheckBox.addActionListener(this);
        this.stateCheckBox.addActionListener(this);
        this.coreCheckBox.setActionCommand(CORE_CHECK);
        this.modeCheckBox.setActionCommand(MODE_CHECK);
        this.stateCheckBox.setActionCommand(STATE_CHECK);
    }

    public void initProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        if (properties.getProperty(CORE) != null) {
            this.coreComboBox.setSelectedItem(properties.getProperty(CORE));
            this.coreCheckBox.setSelected(true);
            this.coreComboBox.setEnabled(true);
        }
        if (properties.getProperty(MODE) != null) {
            this.coreComboBox.setSelectedItem(properties.getProperty(MODE));
            this.modeCheckBox.setSelected(true);
            this.modeComboBox.setEnabled(true);
        }
        if (properties.getProperty(STATE) != null) {
            this.coreComboBox.setSelectedItem(properties.getProperty(STATE));
            this.stateCheckBox.setSelected(true);
            this.stateComboBox.setEnabled(true);
        }
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        if (this.coreCheckBox.isSelected()) {
            ((Hashtable)properties).put(CORE, (String)this.coreComboBox.getSelectedItem());
        }
        if (this.modeCheckBox.isSelected()) {
            ((Hashtable)properties).put(MODE, (String)this.modeComboBox.getSelectedItem());
        }
        if (this.stateCheckBox.isSelected()) {
            ((Hashtable)properties).put(STATE, (String)this.stateComboBox.getSelectedItem());
        }
        return properties;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(CORE_CHECK)) {
            if (this.coreCheckBox.isSelected()) {
                this.coreComboBox.setEnabled(true);
            } else {
                this.coreComboBox.setEnabled(false);
            }
        }
        if (e.getActionCommand().equals(MODE_CHECK)) {
            if (this.modeCheckBox.isSelected()) {
                this.modeComboBox.setEnabled(true);
            } else {
                this.modeComboBox.setEnabled(false);
            }
        }
        if (e.getActionCommand().equals(STATE_CHECK)) {
            if (this.stateCheckBox.isSelected()) {
                this.stateComboBox.setEnabled(true);
            } else {
                this.stateComboBox.setEnabled(false);
            }
        }
    }
}

