/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.server.common;

import com.sap.engine.deploy.server.provider.MainProviderDocument;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.deploy.tool.server.common.SComponentsReference;
import com.sap.engine.deploy.tool.server.common.SComponentsReferencePanel;
import com.sap.engine.gui.CScrollField;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.DescriptionPanel;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ProviderDescriptorPanel
extends BasicPanelView {
    JPanel versionPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    SComponentsReferencePanel refPanel = null;
    JLabel majorLabel = new JLabel();
    JLabel minorLabel = new JLabel();
    JLabel microLabel = new JLabel();
    JLabel componentNameLabel = new JLabel();
    JTextField componentNameTextField = new JTextField();
    JLabel providerLabel = new JLabel();
    JTextField providerTextField = new JTextField();
    JLabel displayNameLabel = new JLabel();
    JTextField displayNameTextField = new JTextField();
    JLabel groupNameLabel = new JLabel();
    JTextField groupNameTextField = new JTextField();
    JScrollPane jScrollPane1 = new JScrollPane();
    CScrollField majorField = new CScrollField();
    CScrollField minorField = new CScrollField();
    CScrollField microField = new CScrollField();
    Border border1;
    Border border2;
    TitledBorder titledBorder1;
    DescriptionPanel descrPanel = new DescriptionPanel();
    MainProviderDocument mainDoc;
    ErrorReportObject error;
    ApplicationInformationProvider appInfo;
    int compType = 1;

    public ProviderDescriptorPanel(Frame _frame) {
        this.mainFrame = _frame;
        try {
            this.init();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.mainFrame, "Could not initialize provider descriptor panel.\n " + ex.toString(), "Error", 0);
        }
    }

    public ProviderDescriptorPanel(Frame _frame, int _type) {
        this.compType = _type;
        this.mainFrame = _frame;
        try {
            this.init();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.mainFrame, "Could not initialize provider descriptor panel.\n " + ex.toString(), "Error", 0);
        }
    }

    private void init() throws Exception {
        LookAndFeelHandler.add((Component)this);
        this.refPanel = new SComponentsReferencePanel(this.mainFrame, this.compType);
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.border2 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border1, "Service Version");
        this.setLayout(this.gridBagLayout1);
        this.displayNameLabel.setText("Display Name:");
        this.componentNameLabel.setText("Component Name:");
        this.groupNameLabel.setText("Group Name:");
        this.majorLabel.setText("Major:");
        this.minorLabel.setText("Minor:");
        this.microLabel.setText("Micro:");
        this.providerLabel.setText("Provider Name:");
        this.versionPanel.setLayout(this.gridBagLayout2);
        this.versionPanel.setBorder(this.titledBorder1);
        this.versionPanel.add((Component)this.minorLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.versionPanel.add((Component)this.microLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.versionPanel.add((Component)this.majorLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.versionPanel.add((Component)this.majorField, new GridBagConstraints(1, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.versionPanel.add((Component)this.minorField, new GridBagConstraints(3, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.versionPanel.add((Component)this.microField, new GridBagConstraints(5, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.providerLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.providerTextField, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.componentNameLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.componentNameTextField, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.displayNameLabel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.displayNameTextField, new GridBagConstraints(2, 2, 1, 1, 0.1, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.groupNameLabel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.groupNameTextField, new GridBagConstraints(2, 3, 1, 1, 0.1, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.versionPanel, new GridBagConstraints(0, 7, 3, 1, 0.1, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.refPanel, new GridBagConstraints(0, 8, 3, 1, 0.0, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.descrPanel, new GridBagConstraints(0, 9, 3, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setLeaf(MainProviderDocument _doc) {
        this.mainDoc = _doc;
        this.displayNameTextField.setText(_doc.getDisplayName());
        this.groupNameTextField.setText(_doc.getGroupName());
        this.componentNameTextField.setText(_doc.getComponentName());
        this.majorField.setValue(Integer.parseInt(_doc.getMajorVersion().indexOf(46) != -1 ? _doc.getMajorVersion().substring(0, _doc.getMajorVersion().indexOf(46)) : _doc.getMajorVersion()));
        this.minorField.setValue(Integer.parseInt(_doc.getMinorVersion().indexOf(46) != -1 ? _doc.getMinorVersion().substring(0, _doc.getMinorVersion().indexOf(46)) : _doc.getMinorVersion()));
        this.microField.setValue(Integer.parseInt(_doc.getMicroVersion().indexOf(46) != -1 ? _doc.getMicroVersion().substring(0, _doc.getMicroVersion().indexOf(46)) : _doc.getMicroVersion()));
        this.providerTextField.setText(_doc.getProviderName());
        this.descrPanel.setText(_doc.getDescription());
        Vector<SComponentsReference> refVec = new Vector<SComponentsReference>();
        Hashtable refHash = this.mainDoc.getReferences();
        Hashtable refStrength = this.mainDoc.getRefStrength();
        SComponentsReference ref = null;
        String key = null;
        String compType = null;
        String strength = null;
        int type = 0;
        Enumeration e = refHash.keys();
        while (e.hasMoreElements()) {
            ref = new SComponentsReference();
            key = (String)e.nextElement();
            compType = (String)refHash.get(key);
            strength = (String)refStrength.get(key);
            ref.setName(key);
            if (compType.trim().toLowerCase().equals("library")) {
                type = 12;
            } else if (compType.trim().toLowerCase().equals("interface")) {
                type = 13;
            } else if (compType.trim().toLowerCase().equals("service")) {
                type = 1;
            }
            ref.setReferenceType(type);
            if (strength.trim().toLowerCase().equals("weak")) {
                ref.setStrength(0);
            } else if (strength.trim().toLowerCase().equals("hard")) {
                ref.setStrength(1);
            } else if (strength.trim().toLowerCase().equals("notify")) {
                ref.setStrength(2);
            }
            refVec.add(ref);
        }
        Object[] refs = new SComponentsReference[refVec.size()];
        refVec.copyInto(refs);
        this.refPanel.initReferences((SComponentsReference[])refs);
    }

    public void setDisplayName(String _name) {
        this.displayNameTextField.setText(_name);
    }

    public void setComponentName(String _componentName) {
        this.componentNameTextField.setText(_componentName);
    }

    public int getCompType() {
        return this.compType;
    }

    public void setCompType(int _type) {
        this.compType = _type;
        if (this.refPanel != null) {
            this.refPanel.setType(_type);
        }
    }

    public void init(int madeFromConstant) {
    }

    public void clear() {
        this.descrPanel.setText("");
    }

    public int isCorrect() {
        return 4;
    }

    public void commitChange() {
        this.mainDoc.setDisplayName(this.displayNameTextField.getText());
        this.mainDoc.setComponentName(this.componentNameTextField.getText());
        this.mainDoc.setGroupName(this.groupNameTextField.getText());
        this.mainDoc.setMajorVersion(this.majorField.getValue() + "");
        this.mainDoc.setMinorVersion(this.minorField.getValue() + "");
        this.mainDoc.setMicroVersion(this.microField.getValue() + "");
        this.mainDoc.setProviderName(this.providerTextField.getText());
        this.mainDoc.setDescription(this.descrPanel.getText());
        SComponentsReference[] refs = this.refPanel.getReferences();
        Hashtable<String, String> refHash = new Hashtable<String, String>();
        Hashtable<String, String> refStrength = new Hashtable<String, String>();
        String refType = null;
        String strength = null;
        if (refs != null) {
            int i = 0;
            while (i < refs.length) {
                switch (refs[i].getReferenceType()) {
                    case 12: {
                        refType = "library";
                        break;
                    }
                    case 13: {
                        refType = "interface";
                        break;
                    }
                    case 1: {
                        refType = "service";
                    }
                }
                refHash.put(refs[i].getName(), refType);
                switch (refs[i].getStrength()) {
                    case 0: {
                        strength = "weak";
                        break;
                    }
                    case 1: {
                        strength = "hard";
                        break;
                    }
                    case 2: {
                        strength = "notify";
                    }
                }
                refStrength.put(refs[i].getName(), strength);
                ++i;
            }
        }
        this.mainDoc.setReferences(refHash);
        this.mainDoc.setRefStrength(refStrength);
    }

    public void setFrame(Frame frame) {
        this.mainFrame = frame;
    }

    public void setLoader(ClassLoader loader) {
    }

    public ErrorReportObject getErrorObject() {
        return this.error;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appInfo = appProvider;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appInfo;
    }
}

