/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.server;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.deploy.manager.DeployManagerException;
import com.sap.engine.deploy.manager.LoginInfo;
import com.sap.engine.deploy.manager.component.ServerComponentsManager;
import com.sap.engine.deploy.server.CPropertyObject;
import com.sap.engine.deploy.server.SComponentGenerator;
import com.sap.engine.deploy.server.SComponentObject;
import com.sap.engine.deploy.server.ServerComponentDocument;
import com.sap.engine.deploy.server.provider.EntityResolverImpl;
import com.sap.engine.deploy.server.provider.InterfaceProviderDocument;
import com.sap.engine.deploy.server.provider.LibProviderDocument;
import com.sap.engine.deploy.server.provider.MainProviderDocument;
import com.sap.engine.deploy.server.provider.ServiceProviderDocument;
import com.sap.engine.deploy.tool.JarHelper;
import com.sap.engine.deploy.tool.server.ServerComponentsTab;
import com.sap.engine.deploy.tool.server.common.SComponentsDialog;
import com.sap.engine.deploy.tool.server.common.SComponentsRemoveDialog;
import com.sap.engine.deploy.tool.tree.BasicDescriptorNode;
import com.sap.engine.deploy.tool.tree.InterfaceDescriptorNode;
import com.sap.engine.deploy.tool.tree.LibraryDescriptorNode;
import com.sap.engine.deploy.tool.tree.ServerComponentsDescriptorNode;
import com.sap.engine.deploy.tool.tree.ServerComponentsLeafNode;
import com.sap.engine.deploy.tool.tree.ServiceDescriptorNode;
import com.sap.engine.gui.CFileChooser;
import com.sap.engine.gui.CMessageDialog;
import com.sap.engine.gui.LogMessageDialog;
import com.sap.engine.gui.LogViewerDialog;
import com.sap.engine.gui.TreeUtils;
import com.sap.engine.gui.connect.LoginDialog;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.jar.JarExtractor;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.deploy.ear.common.StringCutter;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class ServerComponentsActionManager
implements ActionListener {
    public static final String ADD_LIBRARY_CMD = "ADD_LIBRARY_CMD";
    public static final String ADD_INTERFACE_CMD = "ADD_INTERFACE_CMD";
    public static final String ADD_SERVICE_CMD = "ADD_SERVICE_CMD";
    public static final String CREATE_DISPATCHER_CMD = "CREATE_DISPATCHER_CMD";
    public static final String CREATE_SERVER_CMD = "CREATE_SERVER_CMD";
    public static final String REMOVE_CMD = "REMOVE_CMD";
    public static final String MAKE_LIB_SDA_CMD = "MAKE_LIB_SDA_CMD";
    public static final String MAKE_ARCHIVE_CMD = "MAKE_ARCHIVE_CMD";
    public static final String MAKE_FULL_ARCHIVE_CMD = "MAKE_FULL_ARCHIVE_CMD";
    public static final String RENAME_CMD = "RENAME_CMD";
    public static final String DEPLOY_CMD = "DEPLOY_CMD";
    public static final String UNDEPLOY_CMD = "UNDEPLOY_CMD";
    public static final String VIEW_LOG_FILE_CMD = "VIEW_LOG_FILE_CMD";
    protected BasicDescriptorNode root;
    protected CFileChooser chooser;
    protected SComponentsDialog addDialog;
    protected LogMessageDialog error;
    protected Frame mainFrame;
    protected DefaultTreeModel treeModel;
    protected JTree tree;
    protected JarHelper generator = new JarHelper();
    protected ServerComponentsTab tabPanel;
    protected File projectDir = null;
    protected Vector prjExtractedComponents = new Vector();
    protected String xmlLocation = null;
    protected String logFile = "./server_components_log.txt";
    protected String classPath = SystemProperties.getProperty("java.class.path");
    private boolean madeArchive = false;
    private LoginInfo loginInfo = new LoginInfo();
    private LoginDialog loginDialog = null;
    private ServerComponentDocument document = new ServerComponentDocument();
    private CMessageDialog cMessage = null;
    private boolean logStarted = false;
    private RandomAccessFile out = null;
    static final String logSeparator = "***********************************************************";
    private boolean hasLogFile = true;
    static final SimpleDateFormat logfileDateFormat = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
    private StandardDOMParser parser;
    private String DTD_BASE = "./dtd";

    public ServerComponentsActionManager(Frame frame, ServerComponentsTab tab) {
        this.mainFrame = frame;
        this.loginInfo.setTransportProtocol(new String[]{"None"});
        this.tabPanel = tab;
        DynamicClassLoader loader = new DynamicClassLoader(this.classPath);
        this.tabPanel.setLoader(loader);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        this.tabPanel.status.setText("");
        this.tabPanel.status.repaint();
        this.tabPanel.status.validate();
        if (cmd.equalsIgnoreCase(ADD_LIBRARY_CMD)) {
            this.tabPanel.needSaveing = this.addArchiveAction((byte)0);
        } else if (cmd.equalsIgnoreCase(ADD_INTERFACE_CMD)) {
            this.tabPanel.needSaveing = this.addArchiveAction((byte)1);
        } else if (cmd.equalsIgnoreCase(ADD_SERVICE_CMD)) {
            this.tabPanel.needSaveing = this.addArchiveAction((byte)2);
        } else if (cmd.equalsIgnoreCase(CREATE_DISPATCHER_CMD)) {
            this.tabPanel.needSaveing = this.createLeafAction(16);
        } else if (cmd.equalsIgnoreCase(CREATE_SERVER_CMD)) {
            this.tabPanel.needSaveing = this.createLeafAction(15);
        } else if (cmd.equalsIgnoreCase(REMOVE_CMD)) {
            this.removeAction();
            this.tabPanel.needSaveing = true;
        } else if (cmd.equalsIgnoreCase(MAKE_LIB_SDA_CMD)) {
            this.makeArchive((ServerComponentsDescriptorNode)this.tree.getSelectionPath().getLastPathComponent(), true);
        } else if (cmd.equalsIgnoreCase(MAKE_ARCHIVE_CMD)) {
            this.makeArchive((ServerComponentsDescriptorNode)this.tree.getSelectionPath().getLastPathComponent(), false);
        } else if (cmd.equalsIgnoreCase(MAKE_FULL_ARCHIVE_CMD)) {
            this.makeFullArchive();
        } else if (cmd.equalsIgnoreCase(DEPLOY_CMD)) {
            this.deployArchiveAction();
        } else if (cmd.equalsIgnoreCase(UNDEPLOY_CMD)) {
            this.undeployArchiveAction();
        } else if (cmd.equalsIgnoreCase(RENAME_CMD)) {
            if (!this.tree.getSelectionModel().isSelectionEmpty()) {
                this.renameAction();
            }
        } else if (cmd.equalsIgnoreCase(VIEW_LOG_FILE_CMD)) {
            File logF;
            if (this.tabPanel.getLogViewerDialog() == null) {
                this.tabPanel.logViewerDialog = new LogViewerDialog(this.mainFrame, "Log");
            }
            if (!(logF = new File(this.logFile)).exists()) {
                JOptionPane.showMessageDialog(this.mainFrame, "There is no log file.", "Warning", 2);
            } else {
                this.tabPanel.getLogViewerDialog().show(this.mainFrame, logF);
            }
            this.tabPanel.logViewerDialog = null;
        }
    }

    public boolean createLeafAction(int leafType) {
        BasicDescriptorNode baseNode = null;
        if (!this.tree.isSelectionEmpty()) {
            baseNode = (ServerComponentsDescriptorNode)this.tree.getSelectionModel().getSelectionPath().getLastPathComponent();
        }
        if (baseNode != null) {
            ServerComponentsLeafNode child = null;
            switch (baseNode.getType()) {
                case 12: {
                    child = new ServerComponentsLeafNode(new LibProviderDocument());
                    break;
                }
                case 13: {
                    child = new ServerComponentsLeafNode(new InterfaceProviderDocument());
                    break;
                }
                case 1: {
                    child = new ServerComponentsLeafNode(new ServiceProviderDocument());
                }
            }
            if (baseNode.getType() == 1) {
                CPropertyObject[] propFiles = new CPropertyObject[2];
                SComponentObject compObj = ((ServiceDescriptorNode)baseNode).getCompObj();
                String targetEntry = null;
                switch (leafType) {
                    case 15: {
                        targetEntry = "server";
                        break;
                    }
                    case 16: {
                        targetEntry = "dispatcher";
                    }
                }
                String outputPath = this.projectDir.getAbsolutePath() + File.separator + "ServerComponents" + File.separator + "service_" + compObj.getName() + File.separator + targetEntry + File.separator;
                propFiles[0] = new CPropertyObject(targetEntry, outputPath + "properties");
                compObj.addPropertyFile(outputPath + "properties", targetEntry);
                propFiles[1] = new CPropertyObject(targetEntry, outputPath + "runtime.properties");
                compObj.addPropertyFile(outputPath + "runtime.properties", targetEntry);
                ((ServiceDescriptorNode)baseNode).setCompObj(compObj);
            }
            child.setType(leafType);
            child.setName();
            baseNode.add(child);
            this.treeModel.reload();
            TreeUtils.expandTree((JTree)this.tree, (int)2);
            this.tree.setSelectionPath(new TreePath(this.treeModel.getPathToRoot(child)));
            return true;
        }
        return false;
    }

    private void removeAction() {
        BasicDescriptorNode sellNode = null;
        String nodeName = null;
        if (!this.tree.isSelectionEmpty()) {
            sellNode = (BasicDescriptorNode)this.tree.getSelectionModel().getSelectionPath().getLastPathComponent();
            if (sellNode instanceof ServerComponentsLeafNode && ((ServerComponentsDescriptorNode)sellNode.getParent()).getType() == 1) {
                CPropertyObject[] propFiles = new CPropertyObject[2];
                SComponentObject compObj = ((ServerComponentsDescriptorNode)sellNode.getParent()).getCompObj();
                String targetEntry = null;
                switch (sellNode.getType()) {
                    case 15: {
                        targetEntry = "server";
                        break;
                    }
                    case 16: {
                        targetEntry = "dispatcher";
                    }
                }
                String outputPath = this.projectDir.getAbsolutePath() + File.separator + "ServerComponents" + File.separator + "service_" + compObj.getName() + File.separator + targetEntry + File.separator;
                propFiles[0] = new CPropertyObject(targetEntry, outputPath + "properties");
                compObj.removePropertyFile(outputPath + "properties", targetEntry);
                propFiles[1] = new CPropertyObject(targetEntry, outputPath + "runtime.properties");
                compObj.removePropertyFile(outputPath + "runtime.properties", targetEntry);
                ((ServerComponentsDescriptorNode)sellNode.getParent()).setCompObj(compObj);
            }
            if (sellNode.getXMLFileName() != null) {
                File forDeletion = new File(sellNode.getXMLFileName());
                forDeletion.delete();
            }
            SComponentObject compObj = null;
            String dirForDeletion = null;
            String logText = null;
            if (sellNode.isLeaf()) {
                compObj = ((ServerComponentsDescriptorNode)sellNode.getParent()).getCompObj();
                dirForDeletion = this.projectDir.getAbsolutePath() + File.separator + "ServerComponents" + File.separator + compObj.getCompType() + "_" + compObj.getName() + File.separator + nodeName;
                logText = "Node '" + ((BasicDescriptorNode)sellNode.getParent()).getName() + " / " + nodeName + "' was removed successfully.";
            } else {
                compObj = ((ServerComponentsDescriptorNode)sellNode).getCompObj();
                dirForDeletion = this.projectDir.getAbsolutePath() + File.separator + "ServerComponents" + File.separator + compObj.getCompType() + "_" + compObj.getName();
                String jarForDeletion = this.projectDir.getAbsolutePath() + File.separator + "ServerComponents" + File.separator + compObj.getName() + ".jar";
                File jarFileForDeletion = new File(jarForDeletion);
                if (jarFileForDeletion.exists()) {
                    jarFileForDeletion.delete();
                }
                logText = "Node '" + nodeName + "' was removed successfuly.";
            }
            File dirFileForDeletion = new File(dirForDeletion);
            if (dirFileForDeletion.exists()) {
                this.delDir(dirFileForDeletion);
            }
            this.toLog(logText);
            this.treeModel.removeNodeFromParent(sellNode);
            this.tabPanel.getPropertiesPanel().removeAll();
            this.tabPanel.getPropertiesPanel().repaint();
            this.tabPanel.lastSelectedNode = null;
            this.tabPanel.checkEnable(null);
            this.saveXMLFile();
            this.tabPanel.status.setText("Node '" + nodeName + "' was removed successfully.");
        } else {
            JOptionPane.showMessageDialog(this.mainFrame, "There is no selected node.", "Warning", 2);
        }
    }

    private void delDir(File dir) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.delDir(files[i]);
            } else {
                files[i].delete();
            }
            ++i;
        }
        dir.delete();
    }

    public boolean addArchiveAction(byte _type) {
        if (this.tree.isRootVisible()) {
            this.tree.setRootVisible(false);
        }
        if (this.addDialog == null) {
            switch (_type) {
                case 0: {
                    this.addDialog = new SComponentsDialog(this.mainFrame, "Add Library", true, _type);
                    break;
                }
                case 1: {
                    this.addDialog = new SComponentsDialog(this.mainFrame, "Add Interface", true, _type);
                    break;
                }
                case 2: {
                    this.addDialog = new SComponentsDialog(this.mainFrame, "Add Service", true, _type);
                }
            }
        } else {
            this.addDialog.setType(_type);
            String compName = null;
            switch (_type) {
                case 0: {
                    compName = "Library";
                    break;
                }
                case 1: {
                    compName = "Interface";
                    break;
                }
                case 2: {
                    compName = "Service";
                }
            }
            ((Dialog)((Object)this.addDialog)).setTitle("Add " + compName);
            this.addDialog.setarchLabelText(compName + " Name: ");
            this.addDialog.initFields();
        }
        ((Window)((Object)this.addDialog)).setLocationRelativeTo(this.mainFrame);
        ((Component)((Object)this.addDialog)).setVisible(true);
        if (this.addDialog.isOkAction()) {
            String archiveDisplayName = this.addDialog.getComponentName().trim();
            String jarName = null;
            if (!this.addDialog.isNew()) {
                jarName = this.addDialog.getJarName().trim();
            }
            return this.addArchiveAction(archiveDisplayName, jarName, _type);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addArchiveAction(String name, String jar, byte compType) {
        if (name == null) {
            JOptionPane.showMessageDialog(this.mainFrame, "Archive Name is missing.", "Error", 0);
            this.toLog("Archive Name is missing.");
            return false;
        }
        boolean isNameHasBeenUsed = false;
        String tempName = null;
        Enumeration<TreeNode> e = ((BasicDescriptorNode)this.treeModel.getRoot()).children();
        while (e.hasMoreElements()) {
            tempName = ((ServerComponentsDescriptorNode)e.nextElement()).getName();
            if (!name.equalsIgnoreCase(tempName.substring(0, tempName.length() - 4))) continue;
            isNameHasBeenUsed = true;
        }
        if (isNameHasBeenUsed) {
            JOptionPane.showMessageDialog(this.mainFrame, "Duplicated tree entries names.", "Warning", 2);
            this.toLog("Duplicated tree entry names ware found during add of: " + name);
            return false;
        }
        SComponentObject compObj = new SComponentObject();
        CPropertyObject propObject = null;
        String target = null;
        Vector<ServerComponentsLeafNode> leafs = new Vector<ServerComponentsLeafNode>();
        Vector<CPropertyObject> props = new Vector<CPropertyObject>();
        MainProviderDocument compDoc = null;
        switch (compType) {
            case 0: {
                compDoc = new LibProviderDocument();
                break;
            }
            case 1: {
                compDoc = new InterfaceProviderDocument();
                break;
            }
            case 2: {
                compDoc = new ServiceProviderDocument();
                break;
            }
        }
        int providerType = 15;
        String outputPath = this.projectDir.getAbsolutePath() + File.separator + "ServerComponents";
        if (!new File(outputPath).exists()) {
            new File(outputPath).mkdirs();
        }
        switch (compType) {
            case 0: {
                outputPath = outputPath + File.separator + "library_" + name + File.separator;
                break;
            }
            case 1: {
                outputPath = outputPath + File.separator + "interface_" + name + File.separator;
                break;
            }
            case 2: {
                outputPath = outputPath + File.separator + "service_" + name + File.separator;
                break;
            }
        }
        if (jar != null && new File(jar).exists()) {
            this.prjExtractedComponents.add(new InfoObject(name, outputPath));
            JarExtractor jarEx = new JarExtractor(jar, outputPath);
            try {
                jarEx.extractJar();
            }
            catch (IOException ioe) {
                this.tabPanel.status.setText("Errors occurred during extracting archive.");
                this.toLog("Errors occurred during extracting archive: " + ioe.toString() + "\n" + ioe.getMessage());
                this.toLog("STACK TRACE : \n " + this.loadStackTrace(ioe));
                this.tabPanel.getFrame().setCursor(new Cursor(0));
                return false;
            }
            compObj = new SComponentObject(jar, compType);
            JarFile jarFile = null;
            Vector<String> jars = new Vector<String>();
            try {
                try {
                    jarFile = new JarFile(jar);
                    Enumeration<JarEntry> jarEntries = jarFile.entries();
                    String entryName222 = null;
                    JarEntry theEntry = null;
                    while (jarEntries.hasMoreElements()) {
                        theEntry = jarEntries.nextElement();
                        entryName222 = theEntry.getName();
                        if (entryName222.endsWith("provider.xml")) {
                            this.initParser();
                            if (compType == 0) {
                                compDoc = this.parseLibXML((outputPath + entryName222).replace('/', File.separatorChar).replace('\\', File.separatorChar));
                            } else if (compType == 1) {
                                compDoc = this.parseInterfaceXML((outputPath + entryName222).replace('/', File.separatorChar).replace('\\', File.separatorChar));
                            } else if (compType == 2) {
                                compDoc = this.parseServiceXML((outputPath + entryName222).replace('/', File.separatorChar).replace('\\', File.separatorChar));
                            }
                            if (entryName222.toLowerCase().startsWith("server")) {
                                providerType = 15;
                            } else if (entryName222.toLowerCase().startsWith("dispatcher")) {
                                providerType = 16;
                            }
                            leafs.add(new ServerComponentsLeafNode(providerType, compDoc));
                            continue;
                        }
                        if (entryName222.endsWith(".jar")) {
                            jars.add(outputPath + entryName222);
                            continue;
                        }
                        if (compType != 2) continue;
                        if (entryName222.endsWith("properties")) {
                            if (entryName222.toLowerCase().startsWith("server")) {
                                target = "server";
                            } else if (entryName222.toLowerCase().startsWith("dispatcher")) {
                                target = "dispatcher";
                            }
                            propObject = new CPropertyObject(target, (outputPath + entryName222).replace('/', File.separatorChar).replace('\\', File.separatorChar));
                            props.add(propObject);
                            continue;
                        }
                        if (entryName222.lastIndexOf("persistent") == -1) continue;
                        if (entryName222.toLowerCase().startsWith("server")) {
                            target = "server";
                        } else if (entryName222.toLowerCase().startsWith("dispatcher")) {
                            target = "dispatcher";
                        }
                        if (compObj.getServiceDir(target) != null) continue;
                        compObj.addServiceDir(outputPath + target + File.separator + "persistent", target);
                    }
                }
                catch (IOException ioe) {
                    this.tabPanel.status.setText("Errors occurred during reading archive entries.");
                    this.toLog("Errors occurred during reading archive entries: " + ioe.toString() + "\n" + ioe.getMessage());
                    this.toLog("STACK TRACE : \n " + this.loadStackTrace(ioe));
                    this.tabPanel.getFrame().setCursor(new Cursor(0));
                    boolean entryName222 = false;
                    Object var22_26 = null;
                    try {}
                    catch (IOException ioe2) {
                        this.tabPanel.status.setText("Errors occurred during closeing archive file.");
                        this.toLog("Errors occurred during closeing archive file: " + ioe2.toString() + "\n" + ioe2.getMessage());
                        this.toLog("STACK TRACE : \n " + this.loadStackTrace(ioe2));
                        this.tabPanel.getFrame().setCursor(new Cursor(0));
                        return false;
                    }
                    jarFile.close();
                    return entryName222;
                }
                Object var22_25 = null;
                try {
                    jarFile.close();
                }
                catch (IOException ioe2) {
                    this.tabPanel.status.setText("Errors occurred during closeing archive file.");
                    this.toLog("Errors occurred during closeing archive file: " + ioe2.toString() + "\n" + ioe2.getMessage());
                    this.toLog("STACK TRACE : \n " + this.loadStackTrace(ioe2));
                    this.tabPanel.getFrame().setCursor(new Cursor(0));
                    return false;
                }
            }
            catch (Throwable throwable) {
                Object var22_27 = null;
                try {}
                catch (IOException ioe2) {
                    this.tabPanel.status.setText("Errors occurred during closeing archive file.");
                    this.toLog("Errors occurred during closeing archive file: " + ioe2.toString() + "\n" + ioe2.getMessage());
                    this.toLog("STACK TRACE : \n " + this.loadStackTrace(ioe2));
                    this.tabPanel.getFrame().setCursor(new Cursor(0));
                    return false;
                }
                jarFile.close();
                throw throwable;
            }
            String temp = null;
            if (jars.size() == 0) {
                if (compType != 1) {
                    switch (compType) {
                        case 0: {
                            temp = "library";
                            break;
                        }
                        case 2: {
                            temp = "service";
                            break;
                        }
                    }
                    if (compDoc.getComponentName() == null) {
                        JOptionPane.showMessageDialog(this.mainFrame, "This archive is not correct " + temp + " archive. \nIt does not contain any JAR files.", "Warning", 2);
                        return false;
                    }
                    JOptionPane.showMessageDialog(this.mainFrame, compDoc.getComponentName() + " archive is not correct " + temp + " archive. \nIt does not contain any JAR files.", "Warning", 2);
                    return false;
                }
                if (!((InterfaceProviderDocument)compDoc).isDefaultJars()) {
                    JOptionPane.showMessageDialog(this.mainFrame, compDoc.getComponentName() + " archive is not correct interface archive. \nIt does not contain any JAR files.", "Warning", 2);
                }
            }
            Object[] sJars = new String[jars.size()];
            jars.copyInto(sJars);
            compObj.setJars((String[])sJars);
            Object[] properties = new CPropertyObject[props.size()];
            props.copyInto(properties);
            compObj.setPropertyFiles((CPropertyObject[])properties);
        } else {
            compObj = new SComponentObject(this.projectDir.getAbsolutePath() + File.separator + "ServerComponents" + File.separator + name, compType);
            if (compType == 2) {
                CPropertyObject[] propFiles = new CPropertyObject[2];
                outputPath = this.projectDir.getAbsolutePath() + File.separator + "ServerComponents" + File.separator + "service_" + name + File.separator + "server" + File.separator;
                propFiles[0] = new CPropertyObject("server", outputPath + "properties");
                propFiles[1] = new CPropertyObject("server", outputPath + "runtime.properties");
                compObj.setPropertyFiles(propFiles);
                leafs.add(new ServerComponentsLeafNode(15, compDoc));
            } else {
                leafs.add(new ServerComponentsLeafNode(15, compDoc));
            }
        }
        compObj.setName(name);
        compObj.setHasChanged(true);
        ServerComponentsDescriptorNode compNode = null;
        switch (compType) {
            case 0: {
                compNode = new LibraryDescriptorNode(name + ".jar", compObj);
                break;
            }
            case 1: {
                compObj.setJarsAreDefaultJars(((InterfaceProviderDocument)compDoc).isDefaultJars());
                compNode = new InterfaceDescriptorNode(name + ".jar", compObj);
                break;
            }
            case 2: {
                compNode = new ServiceDescriptorNode(name + ".jar", compObj);
                break;
            }
        }
        int i = 0;
        while (i < leafs.size()) {
            compNode.add((MutableTreeNode)leafs.elementAt(i));
            ++i;
        }
        this.treeModel.insertNodeInto(compNode, this.root, this.root.getChildCount());
        this.treeModel.reload();
        TreeUtils.expandTree((JTree)this.tree, (int)2);
        ((DynamicClassLoader)this.tabPanel.getLoader()).addClasspath(jar);
        return true;
    }

    public boolean readArchive(SComponentObject compObj, byte compType) {
        Vector<ServerComponentsLeafNode> leafs = new Vector<ServerComponentsLeafNode>();
        MainProviderDocument compDoc = null;
        CPropertyObject[] providerXMLs = null;
        switch (compType) {
            case 0: {
                compDoc = new LibProviderDocument();
                break;
            }
            case 1: {
                compDoc = new InterfaceProviderDocument();
                break;
            }
            case 2: {
                compDoc = new ServiceProviderDocument();
            }
        }
        providerXMLs = compObj.getProviderXMLs();
        if (providerXMLs != null && providerXMLs.length > 0) {
            String target = null;
            String providerXML = null;
            int i = 0;
            while (i < providerXMLs.length) {
                target = providerXMLs[i].getTargetEntry();
                providerXML = providerXMLs[i].getFilePath();
                try {
                    this.initParser();
                    switch (compType) {
                        case 0: {
                            compDoc = this.parseLibXML(providerXML);
                            break;
                        }
                        case 1: {
                            compDoc = this.parseInterfaceXML(providerXML);
                            break;
                        }
                        case 2: {
                            compDoc = this.parseServiceXML(providerXML);
                        }
                    }
                }
                catch (IOException ioe) {
                    this.tabPanel.status.setText("Errors occurred during parseing provider.xml.");
                    this.toLog("Errors occurred during parseing provider.xml: " + ioe.toString() + "\n" + ioe.getMessage());
                    this.toLog("STACK TRACE : \n " + this.loadStackTrace(ioe));
                    this.tabPanel.getFrame().setCursor(new Cursor(0));
                    return false;
                }
                int providerType = 15;
                if (target.equals("server")) {
                    providerType = 15;
                } else if (target.equals("dispatcher")) {
                    providerType = 16;
                }
                leafs.add(new ServerComponentsLeafNode(providerType, compDoc));
                ++i;
            }
        }
        DefaultMutableTreeNode compNode = null;
        switch (compType) {
            case 0: {
                compNode = new LibraryDescriptorNode(compObj.getName() + ".jar", compObj);
                break;
            }
            case 1: {
                compObj.setJarsAreDefaultJars(((InterfaceProviderDocument)compDoc).isDefaultJars());
                compNode = new InterfaceDescriptorNode(compObj.getName() + ".jar", compObj);
                break;
            }
            case 2: {
                compNode = new ServiceDescriptorNode(compObj.getName() + ".jar", compObj);
            }
        }
        int i = 0;
        while (i < leafs.size()) {
            compNode.add((MutableTreeNode)leafs.elementAt(i));
            ++i;
        }
        this.treeModel.insertNodeInto(compNode, this.root, this.root.getChildCount());
        this.treeModel.reload();
        TreeUtils.expandTree((JTree)this.tree, (int)2);
        return true;
    }

    private void initParser() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            EntityResolverImpl er = new EntityResolverImpl(this.DTD_BASE);
            this.parser = new StandardDOMParser();
            this.parser.setEntityResolver((EntityResolver)er);
            this.parser.setValidation(false);
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this.mainFrame, "ERROR: Can't initialize XML parser.\n " + exc.toString(), "Error", 0);
        }
        Thread.currentThread().setContextClassLoader(cl);
    }

    public LibProviderDocument parseLibXML(String xmlFile) throws IOException {
        try {
            if (this.parser == null) {
                this.initParser();
            }
            Document doc = this.parser.parse(xmlFile);
            LibProviderDocument document = new LibProviderDocument();
            document.setMainDocument(doc);
            return (LibProviderDocument)document.loadFieldsFromDocument();
        }
        catch (Exception e) {
            this.tabPanel.status.setText("Cannot parse xml file: " + xmlFile + ".");
            this.toLog("Cannot parse xml file: " + xmlFile + ". Reason: \n" + e.toString());
            this.toLog("STACK TRACE : \n " + this.loadStackTrace(e));
            return null;
        }
    }

    public InterfaceProviderDocument parseInterfaceXML(String xmlFile) throws IOException {
        try {
            if (this.parser == null) {
                this.initParser();
            }
            Document doc = this.parser.parse(xmlFile);
            InterfaceProviderDocument document = new InterfaceProviderDocument();
            document.setMainDocument(doc);
            return (InterfaceProviderDocument)document.loadFieldsFromDocument();
        }
        catch (Exception e) {
            this.tabPanel.status.setText("Cannot parse xml file: " + xmlFile + ". Reason: " + e.toString());
            this.error.showErrorDialog(e.toString(), this.logFile);
            this.toLog("Cannot parse xml file: " + xmlFile + ". Reason: \n" + e.toString());
            this.toLog("STACK TRACE : \n " + this.loadStackTrace(e));
            return null;
        }
    }

    public ServiceProviderDocument parseServiceXML(String xmlFile) throws IOException {
        try {
            if (this.parser == null) {
                this.initParser();
            }
            Document doc = this.parser.parse(xmlFile);
            ServiceProviderDocument document = new ServiceProviderDocument();
            document.setMainDocument(doc);
            return (ServiceProviderDocument)document.loadFieldsFromDocument();
        }
        catch (Exception e) {
            this.tabPanel.status.setText("Cannot parse xml file: " + xmlFile + ". Reason: " + e.toString());
            this.error.showErrorDialog(e.toString(), this.logFile);
            this.toLog("Cannot parse xml file: " + xmlFile + ". Reason: \n" + e.toString());
            this.toLog("STACK TRACE : \n " + this.loadStackTrace(e));
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean makeArchive(ServerComponentsDescriptorNode _archNode, boolean isSDA) {
        block8: {
            block9: {
                extention = ".jar";
                if (isSDA) {
                    extention = ".sda";
                }
                this.tabPanel.status.setText("Making Archive ...");
                this.toLog("Making Archive ...");
                this.xmlLocation = this.projectDir.getAbsolutePath() + File.separator + "ServerComponents.xml";
                gen = new SComponentGenerator(this.xmlLocation);
                gen.setServerComponentsActionManager(this);
                compObj = _archNode.getCompObj();
                newJarFileName = compObj.getFileName();
                if (newJarFileName != null) {
                    existing = new File(newJarFileName);
                    if (existing.getParent().indexOf(this.projectDir.getAbsolutePath() + File.separator + "ServerComponents") == -1) {
                        newJarFileName = this.projectDir.getAbsolutePath() + File.separator + "ServerComponents" + File.separator + existing.getName();
                    }
                    if (!newJarFileName.endsWith(extention)) {
                        newJarFileName = newJarFileName + extention;
                    }
                } else {
                    newJarFileName = this.projectDir.getAbsolutePath() + File.separator + "ServerComponents" + File.separator + _archNode.getCompObj().getName() + extention;
                }
                compObj.setFileName(newJarFileName);
                compObj.setHasChanged(false);
                _archNode.setCompObj(compObj);
                this.saveXMLFile();
                try {
                    gen.parseXML();
                    gen.makeJarByFileName(newJarFileName, isSDA);
                    break block8;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this.mainFrame, StringCutter.stringFrameCut("Cannot make archive " + _archNode.getCompObj().getName() + ".\n" + e.toString(), this.mainFrame), "Error", 0);
                    msg = e.getMessage();
                    if (msg == null || msg.indexOf(SComponentGenerator.NO_JARS) == -1) break block9;
                    compName = msg.substring(msg.indexOf(" Name: ") + 7, msg.indexOf(".", msg.indexOf(" Name: ") + 6));
                    tmp = null;
                    nodes = ((BasicDescriptorNode)this.tabPanel.getTree().getModel().getRoot()).children();
                    ** while (nodes.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    tmp = (ServerComponentsDescriptorNode)nodes.nextElement();
                    if (tmp.getName() == null || !tmp.getName().equalsIgnoreCase(compName + ".jar")) continue;
                    this.tree.setSelectionPath(new TreePath(tmp));
                    this.tree.repaint();
                    continue;
                }
            }
            this.tabPanel.status.setText("Errors occurred during making archive.");
            this.toLog("Errors occurred during making archive: " + e.toString());
            this.toLog("STACK TRACE : \n " + this.loadStackTrace(e));
            return false;
        }
        this.madeArchive = true;
        this.tabPanel.status.setText("Archive " + newJarFileName + " was made successfully.");
        this.toLog("Archive " + newJarFileName + " was made successfully.");
        return true;
    }

    public void makeFullArchive() {
        this.tabPanel.status.setText("Making All Archives ...");
        this.toLog("Making All Archives ...");
        BasicDescriptorNode baseNode = (BasicDescriptorNode)this.treeModel.getRoot();
        boolean isDone = true;
        int i = 0;
        while (i < baseNode.getChildCount()) {
            isDone = this.makeArchive((ServerComponentsDescriptorNode)baseNode.getChildAt(i), false);
            if (!isDone) {
                return;
            }
            ++i;
        }
        this.madeArchive = true;
        this.tabPanel.status.setText("All Archives were made successfully.");
        this.toLog("All Archives were made successfully.");
    }

    public boolean deployArchiveAction() {
        this.tabPanel.commitSelected();
        ServerComponentsDescriptorNode baseNode = (ServerComponentsDescriptorNode)this.tree.getSelectionPath().getLastPathComponent();
        ServerComponentsManager scManager = new ServerComponentsManager();
        LoginInfo deployLoginInfo = this.getLoginInfo();
        if (deployLoginInfo == null) {
            return false;
        }
        scManager.setLoginInfo(deployLoginInfo);
        this.tabPanel.status.setText("Start Deploying...");
        this.toLog("Start Deploying...");
        this.makeArchive(baseNode, false);
        SComponentObject depSCObj = baseNode.getCompObj();
        try {
            if (!depSCObj.getCompType().equalsIgnoreCase("library")) {
                throw new DeployManagerException("dm_err_msg_0027");
            }
            scManager.makeComponent(null, depSCObj.getName(), depSCObj.getFileName(), "deploy", depSCObj.getCompType());
        }
        catch (DeployManagerException dme) {
            if (this.cMessage == null) {
                this.cMessage = CMessageDialog.getInstance((Frame)this.mainFrame);
            }
            this.cMessage.showErrorDialog("Cannot deploy component " + depSCObj.getName() + ". Reason: ", dme.toString());
            this.tabPanel.status.setText("Deploy Failed.");
            this.toLog("Cannot deploy component " + depSCObj.getName() + ". Reason: " + dme.toString());
            this.toLog("STACK TRACE : \n " + this.loadStackTrace(dme));
            return false;
        }
        this.tabPanel.status.setText("Deployed Successfully.");
        this.toLog("Component " + depSCObj.getName() + "was deployed successfully");
        return true;
    }

    public boolean undeployArchiveAction() {
        this.tabPanel.commitSelected();
        SComponentsRemoveDialog removeDialog = new SComponentsRemoveDialog(this.mainFrame, "Remove Server Component", true);
        ServerComponentsManager scManager = new ServerComponentsManager();
        LoginInfo deployLoginInfo = this.getLoginInfo();
        if (deployLoginInfo == null) {
            return false;
        }
        scManager.setLoginInfo(deployLoginInfo);
        ((Window)((Object)removeDialog)).setLocationRelativeTo(this.mainFrame);
        ((Component)((Object)removeDialog)).setVisible(true);
        if (removeDialog.isOkAction()) {
            this.tabPanel.status.setText("Start Undeploying...");
            this.toLog("Start Undeploying...");
            String removeName = removeDialog.getComponentName();
            String removeType = removeDialog.getTypeString();
            try {
                if (removeType.equals("library")) {
                    scManager.removeLibrary(removeName);
                }
            }
            catch (DeployManagerException dme) {
                if (this.cMessage == null) {
                    this.cMessage = CMessageDialog.getInstance((Frame)this.mainFrame);
                }
                this.cMessage.showErrorDialog("Cannot undeploy component " + removeName + ". ", dme.toString());
                this.tabPanel.status.setText("Undeploy Failed.");
                this.toLog("Cannot undeploy component " + removeName + ". " + dme.toString());
                this.toLog("STACK TRACE : \n " + this.loadStackTrace(dme));
                return false;
            }
            this.tabPanel.status.setText("Undeployed Successfully.");
            this.toLog("Undeployed Successfully.");
            return true;
        }
        this.tabPanel.status.setText("");
        return false;
    }

    public LoginInfo getLoginInfo() {
        int p4_port = 0;
        int http_port = 0;
        int ssl_port = 0;
        int https_port = 0;
        try {
            p4_port = new Integer(this.tabPanel.tabProperties.getProperty(ServerComponentsTab.REMOTE_P4_PORT));
            http_port = new Integer(this.tabPanel.tabProperties.getProperty(ServerComponentsTab.HTTP_TUNNELING_PORT));
            ssl_port = new Integer(this.tabPanel.tabProperties.getProperty(ServerComponentsTab.SSL_PORT));
            https_port = new Integer(this.tabPanel.tabProperties.getProperty(ServerComponentsTab.HTTPS_PORT));
        }
        catch (Exception e) {
            p4_port = 50004;
            http_port = 50005;
            ssl_port = 50006;
            https_port = 50001;
        }
        int layer = 0;
        String transProtocol = this.loginInfo.getTransportProtocol()[0];
        if (transProtocol.equals("httptunneling")) {
            layer = 1;
        }
        if (transProtocol.equals("ssl")) {
            layer = 2;
        }
        if (transProtocol.equals("https")) {
            layer = 3;
        }
        this.loginDialog = new LoginDialog((JFrame)this.tabPanel.getFrame(), this.document.getLoginInfo().getUserName(), this.document.getLoginInfo().getRemoteHost(), p4_port, "", http_port, ssl_port, https_port, layer);
        this.loginDialog.setLocationRelativeTo(this.tabPanel.getFrame());
        this.loginDialog.setVisible(true);
        if (this.loginDialog.isCanceled()) {
            this.loginDialog.setVisible(false);
            return null;
        }
        this.document.getLoginInfo().setUserName(this.loginDialog.getUserName());
        this.document.getLoginInfo().setUserPassword(this.loginDialog.getPassword());
        this.document.getLoginInfo().setRemotePort(this.loginDialog.getPort());
        this.document.getLoginInfo().setRemoteHost(this.loginDialog.getHost());
        this.document.getLoginInfo().setTransportProtocol(new String[]{this.loginDialog.getLayer()});
        return this.document.getLoginInfo();
    }

    public void setRoot(BasicDescriptorNode _root) {
        this.root = _root;
    }

    public void setTree(JTree _tree) {
        this.tree = _tree;
        this.treeModel = (DefaultTreeModel)_tree.getModel();
    }

    public void saveXMLFile() {
        if (!this.tree.isSelectionEmpty() && !this.tabPanel.updateNodeProperties()) {
            return;
        }
        if (((BasicDescriptorNode)this.treeModel.getRoot()).getChildCount() == 0) {
            this.xmlLocation = null;
            File forDeletion = new File(this.projectDir.getAbsolutePath() + File.separator + "ServerComponents.xml");
            if (forDeletion.exists()) {
                forDeletion.delete();
            }
            return;
        }
        StandardDOMWriter writer = new StandardDOMWriter();
        if (this.xmlLocation == null) {
            if (this.projectDir == null) {
                this.projectDir = new File(".");
            }
            this.xmlLocation = this.projectDir.getAbsolutePath() + File.separator + "ServerComponents.xml";
        }
        String dtd = null;
        SComponentObject cObj = null;
        CPropertyObject cpObj = null;
        Object[] cpObjs = null;
        Vector<SComponentObject> components = new Vector<SComponentObject>();
        ServerComponentsDescriptorNode mainNode = null;
        ServerComponentsLeafNode childNode = null;
        String temp = null;
        String xmlsDir = this.projectDir.getAbsolutePath() + File.separator + "ServerComponents" + File.separator;
        MainProviderDocument providerDoc = null;
        Vector<CPropertyObject> leafComponents = new Vector<CPropertyObject>();
        int i = 0;
        while (i < this.root.getChildCount()) {
            mainNode = (ServerComponentsDescriptorNode)this.root.getChildAt(i);
            cObj = mainNode.getCompObj();
            leafComponents.removeAllElements();
            if ("library".equals(cObj.getCompType())) {
                dtd = "<!DOCTYPE provider-descriptor SYSTEM \"library.provider.dtd\">";
            } else if ("interface".equals(cObj.getCompType())) {
                dtd = "<!DOCTYPE provider-descriptor SYSTEM \"interface.provider.dtd\">";
            } else if ("service".equals(cObj.getCompType())) {
                dtd = "<!DOCTYPE provider-descriptor SYSTEM \"service.provider.dtd\">";
            }
            int j = 0;
            while (j < mainNode.getChildCount()) {
                childNode = (ServerComponentsLeafNode)mainNode.getChildAt(j);
                cpObj = new CPropertyObject();
                switch (childNode.getType()) {
                    case 15: {
                        temp = "server";
                        break;
                    }
                    case 16: {
                        temp = "dispatcher";
                    }
                }
                cpObj.setTargetEntry(temp);
                temp = xmlsDir + cObj.getCompType() + "_" + cObj.getName() + File.separator + temp;
                if (!new File(temp).exists()) {
                    new File(temp).mkdirs();
                }
                temp = temp + File.separator + "provider.xml";
                providerDoc = childNode.getDoc();
                try {
                    writer.write(providerDoc.loadDocumentFromFields(), temp, dtd, "UTF-8");
                }
                catch (Exception xmlex) {
                    this.tabPanel.status.setText("Errors occurred during saving \"" + temp + "\" file.");
                    this.toLog("Errors occurred during saving \"" + temp + "\" file: " + xmlex.toString());
                    this.toLog("STACK TRACE : \n " + this.loadStackTrace(xmlex));
                    xmlex.printStackTrace();
                    return;
                }
                cpObj.setFilePath(temp);
                leafComponents.add(cpObj);
                ++j;
            }
            cpObjs = new CPropertyObject[leafComponents.size()];
            leafComponents.copyInto(cpObjs);
            cObj.setProviderXMLs((CPropertyObject[])cpObjs);
            components.add(cObj);
            ++i;
        }
        Object[] compObjs = new SComponentObject[components.size()];
        components.copyInto(compObjs);
        ServerComponentDocument scDoc = new ServerComponentDocument();
        scDoc.setSComponents((SComponentObject[])compObjs);
        scDoc.setLoginInfo(this.loginInfo);
        scDoc.setProjectDir(this.projectDir.getAbsolutePath());
        Document doc = scDoc.loadDocumentFromFields();
        try {
            writer.write(doc, this.xmlLocation, "<!DOCTYPE server-components-generator [ \n<!ELEMENT server-components-generator (project-dir?, components, login-info?)>\n<!ELEMENT components (component+)>\n<!ELEMENT component (name?, file-name,  jars, components-properties)>\n<!ATTLIST component component-type (service|library|interfase) #REQUIRED>\n<!ELEMENT name (#PCDATA)>\n<!ELEMENT file-name (#PCDATA)>\n<!ELEMENT jars (jar+)>\n<!ELEMENT jar (file-path, entry-name)>\n<!ELEMENT entry-name (#PCDATA)>\n<!ELEMENT file-path (#PCDATA)>\n<!ELEMENT components-properties (provider-xml+, property-file*, service-dir?)>\n<!ELEMENT property-file (#PCDATA)>\n<!ATTLIST property-file target (alone|server|dispatcher) #REQUIRED>\n<!ELEMENT provider-xml (#PCDATA)>\n<!ATTLIST provider-xml target (alone|server|dispatcher) #REQUIRED>\n<!ELEMENT login-info (host, port, transport-protocol*, user-name, user-password)>\n<!ELEMENT host (#PCDATA)>\n<!ELEMENT port (#PCDATA)>\n<!ELEMENT transport-protocol (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT user-password (#PCDATA)>\n]>", "UTF-8");
        }
        catch (Exception e) {
            this.tabPanel.status.setText("Errors occurred during saving \"" + this.xmlLocation + "\" file.");
            this.toLog("Errors occurred during saving \"" + this.xmlLocation + "\" file: " + e.toString());
            this.toLog("STACK TRACE : \n " + this.loadStackTrace(e));
            e.printStackTrace();
            return;
        }
    }

    public String getXMLFileLocation() {
        return this.xmlLocation;
    }

    public void initOnProjectOpen(String xmlFile, String[] paths) throws IOException {
        this.tabPanel.clearOnProjectClose();
        this.classPath = "";
        this.setClassPath(paths);
        this.tree.setRootVisible(false);
        this.xmlLocation = xmlFile;
        File file = this.getLogFile();
        if (file != null && file.exists()) {
            file.delete();
        }
        StandardDOMParser parser = new StandardDOMParser();
        Document doc = null;
        try {
            doc = parser.parse(xmlFile);
        }
        catch (SAXException saxe) {
            saxe.printStackTrace();
            this.toLog(xmlFile + "...  Wrong DTD structure or xml implementation: " + saxe.toString());
            this.toLog("STACK TRACE : \n " + this.loadStackTrace(saxe));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.toLog(xmlFile + "...  " + ioe.toString());
            this.toLog("STACK TRACE : \n " + this.loadStackTrace(ioe));
        }
        ServerComponentDocument scDoc = new ServerComponentDocument();
        scDoc.loadFieldsFromDocument(doc);
        this.loginInfo = scDoc.getLoginInfo();
        this.projectDir = new File(scDoc.getProjectDir());
        ((DynamicClassLoader)this.tabPanel.getLoader()).addClasspath(this.projectDir.getAbsolutePath() + File.separator + "ServerComponents" + File.separator);
        SComponentObject[] scObjs = scDoc.getSComponent();
        byte type = -1;
        if (scObjs != null) {
            String jarPath = null;
            int i = 0;
            while (i < scObjs.length) {
                if (scObjs[i].getCompType().equals("library")) {
                    type = 0;
                } else if (scObjs[i].getCompType().equals("interface")) {
                    type = 1;
                } else if (scObjs[i].getCompType().equals("service")) {
                    type = 2;
                }
                if (scObjs[i].getJars() != null) {
                    int j = 0;
                    while (j < scObjs[i].getJars().length) {
                        jarPath = scObjs[i].getJars()[j].filePath;
                        ((DynamicClassLoader)this.tabPanel.getLoader()).addClasspath(jarPath);
                        ++j;
                    }
                }
                if (scObjs[i].getFileName() == null || scObjs[i].getFileName().equals("")) {
                    this.readArchive(scObjs[i], type);
                } else {
                    this.addArchiveAction(scObjs[i].getName(), scObjs[i].getFileName(), type);
                }
                ++i;
            }
        }
        this.toLog("ServerComponentsTab is loaded successfully.");
    }

    public void setProjectDir(File dir) {
        this.projectDir = dir;
        if (dir != null) {
            this.logFile = dir.getAbsolutePath() + File.separator + "server_components_log.txt";
        }
    }

    public boolean hasMadeArchive() {
        return this.madeArchive;
    }

    public void setMadeArchive(boolean hasMade) {
        this.madeArchive = hasMade;
    }

    private void renameAction() {
        String result = JOptionPane.showInputDialog(this.mainFrame, "Enter new name.", "Rename", 1);
        if (result != null && !result.trim().equals("") && FileUtils.isCorrectFileName(result)) {
            BasicDescriptorNode parental = (BasicDescriptorNode)this.tree.getSelectionModel().getSelectionPath().getLastPathComponent();
            if (!result.toLowerCase().endsWith(".jar")) {
                result = result + ".jar";
            }
            boolean isNameHasBeenUsed = false;
            String tempName = null;
            Enumeration<TreeNode> e = ((BasicDescriptorNode)this.treeModel.getRoot()).children();
            while (e.hasMoreElements()) {
                tempName = ((ServerComponentsDescriptorNode)e.nextElement()).getName();
                if (!result.equals(tempName)) continue;
                isNameHasBeenUsed = true;
            }
            if (!isNameHasBeenUsed) {
                this.toLog("Rename action: node \"" + parental.getName() + "\" was renamed to \"" + result + "\"");
                parental.setName(result);
                String tempFileName = parental.getArchiveFileName();
                if (tempFileName != null && !tempFileName.trim().equals("") && tempFileName.lastIndexOf(File.separator) != -1) {
                    if (tempFileName.substring(0, tempFileName.lastIndexOf(File.separator)).endsWith(File.separator)) {
                        parental.setArchiveFileName(tempFileName.substring(0, tempFileName.lastIndexOf(File.separator)) + result);
                    } else {
                        parental.setArchiveFileName(tempFileName.substring(0, tempFileName.lastIndexOf(File.separator)) + File.separator + result);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this.mainFrame, "Duplicated tree entries names.", "Warning", 2);
                this.toLog("Duplicated tree entry names ware found during rename of: " + result);
            }
        }
    }

    public File getLogFile() {
        if (this.logFile != null) {
            return new File(this.logFile);
        }
        return null;
    }

    public void startLog() {
        System.out.println("Starting log to:   " + new File(this.logFile));
        this.startLog(this.logFile);
    }

    public void startLog(String s) {
        if (s == null) {
            this.logStarted = true;
            this.toLog(logSeparator);
        } else {
            try {
                new File(s).delete();
                this.out = new RandomAccessFile(s, "rw");
                this.logStarted = true;
                this.toLog("***********************************************************\n");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.mainFrame, "ERROR :\n Couldnot start logging. Exception occurred:", "Error", 0);
            }
        }
    }

    public void toLog(String str) {
        try {
            if (!this.logStarted) {
                this.startLog();
            }
            String dateString = logfileDateFormat.format(new Date()) + " -  ";
            StringBuffer emptyStringBuffer = new StringBuffer(dateString.length());
            int i = 0;
            while (i < dateString.length()) {
                emptyStringBuffer.append(' ');
                ++i;
            }
            String emptyString = emptyStringBuffer.toString();
            StringTokenizer st = new StringTokenizer(str, "\n\r");
            String s = "";
            if (st.hasMoreTokens()) {
                if (this.hasLogFile) {
                    s = dateString + st.nextToken() + "\n";
                    this.out.write(s.getBytes());
                } else {
                    s = dateString + st.nextToken();
                    System.out.println(s);
                }
            }
            while (st.hasMoreTokens()) {
                if (this.hasLogFile) {
                    s = emptyString + st.nextToken() + "\n";
                    this.out.write(s.getBytes());
                    continue;
                }
                s = emptyString + st.nextToken();
                System.out.println(s);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mainFrame, "ERROR :\n Couldnot start logging. Exception occurred:", "Error", 0);
        }
    }

    public void setLog(RandomAccessFile out) {
        this.out = out;
        this.logStarted = true;
    }

    public String loadStackTrace(Exception ex) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(out);
        ex.printStackTrace(stream);
        String result = out.toString();
        stream.close();
        try {
            out.close();
        }
        catch (IOException ioe) {
            this.toLog("Cannot close ByteArrayOutputStream for Exception message:\n" + result + "\nReason: " + ioe.toString());
        }
        return result;
    }

    public void setClassPath(String[] path) {
        if (path == null) {
            this.classPath = "";
        }
        StringTokenizer classPathOldTokenizer = new StringTokenizer(this.classPath, File.pathSeparator);
        Vector<String> oldClassPathVector = new Vector<String>();
        while (classPathOldTokenizer.hasMoreTokens()) {
            oldClassPathVector.add(classPathOldTokenizer.nextToken());
        }
        if (path != null) {
            int i = 0;
            while (i < path.length) {
                if (!(path[i] == null || path[i].equals("") || path[i].equals("null") || oldClassPathVector.contains(path[i]))) {
                    this.classPath = this.classPath.endsWith(File.pathSeparator) ? this.classPath + path[i] + File.pathSeparator : this.classPath + File.pathSeparator + path[i] + File.pathSeparator;
                }
                ++i;
            }
        }
        ((DynamicClassLoader)this.tabPanel.getLoader()).addClasspath(this.classPath);
        this.tabPanel.getAppInfoProvider().setClassPath(this.classPath);
    }
}

