/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.gui;

import com.sap.engine.deploy.QuickDeploy;
import com.sap.engine.gui.ProgressBarThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class MakeAllStatusWindow
extends JDialog
implements Runnable,
ActionListener,
KeyListener {
    private Frame frame;
    private int currentPhase = 0;
    private JProgressBar progressBar = new JProgressBar(0, 100);
    private Label statusBar;
    private Label currentStatus;
    private boolean forever = false;
    private QuickDeploy qD;
    private String xml;
    private ProgressBarThread pbT;
    private int maxMultiplayer;

    public MakeAllStatusWindow(Frame frame, QuickDeploy qD) {
        super(frame, "Make All", true);
        this.qD = qD;
        this.frame = frame;
        this.initView();
        this.initActions();
    }

    protected void initView() {
        this.pbT = new ProgressBarThread(this.progressBar);
        this.statusBar = new Label("Begining Make All process...");
        this.currentStatus = new Label("Active...");
        this.update(((Component)this).getGraphics());
        this.getContentPane().setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        buttonPanel.add((Component)cancel, null);
        cancel.setRequestFocusEnabled(true);
        cancel.requestFocus();
        cancel.addKeyListener(this);
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.add((Component)this.statusBar, new GridBagConstraints(0, 0, 3, 1, 0.1, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)this.currentStatus, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)this.progressBar, new GridBagConstraints(0, 2, 5, 1, 0.1, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)buttonPanel, new GridBagConstraints(0, 3, 5, 1, 0.1, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.progressBar.setPreferredSize(new Dimension((int)this.getSize().getWidth(), 20));
        this.pack();
        this.setLocationRelativeTo(this.frame);
        this.update(((Component)this).getGraphics());
    }

    public void run() {
        this.update(((Component)this).getGraphics());
        this.qD.setMakeAllStatusWindow(this);
        this.qD.start();
        this.maxMultiplayer = -1;
        while (this.maxMultiplayer == -1) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.maxMultiplayer = this.qD.getNumberOfTabs();
        }
        this.pbT.setMAXMultiplayer(this.maxMultiplayer);
        this.pbT.startProgress();
        this.pbT.start();
        ((Component)this).setVisible(true);
    }

    public void setXML(String xml) {
        this.xml = xml;
    }

    protected void initActions() {
    }

    public int nextPhase(int phase) {
        this.currentPhase = phase;
        if (this.currentPhase == 9) {
            this.statusBar.setText("The project is empty.");
            this.currentStatus.setText("Error!");
            try {
                this.pbT.kill();
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            this.exitAction();
        }
        if (this.currentPhase == 1) {
            this.statusBar.setText("Generating Archives...");
            this.currentStatus.setText("Working...");
            phase = 1;
        }
        if (this.currentPhase == 2) {
            if (this.maxMultiplayer > 1) {
                this.pbT.setMultiplayer(--this.maxMultiplayer);
            }
            this.statusBar.setText("Genrating EAR file...");
            this.currentStatus.setText("Working...");
        }
        if (this.currentPhase == 3) {
            if (this.maxMultiplayer > 1) {
                this.pbT.setMultiplayer(--this.maxMultiplayer);
            }
            this.statusBar.setText("Deploying...");
            this.currentStatus.setText("Working...");
        }
        if (this.currentPhase > 3) {
            if (this.currentPhase == 4) {
                this.currentStatus.setText("Finished.");
                this.pbT.forcedKill();
                this.pbT.stopProgress();
                this.pbT.setProgress(100);
                this.update(((Component)this).getGraphics());
            }
            if (this.currentPhase == 5) {
                this.currentStatus.setText("Canceled.");
                this.pbT.forcedKill();
                this.kill();
                return 5;
            }
            if (this.currentPhase == 10) {
                this.currentStatus.setText("Error!");
                this.exitAction();
            }
            if (this.currentPhase == 11) {
                this.currentStatus.setText("Error!");
                this.exitAction();
                if (!this.qD.errMessage.equals("")) {
                    JOptionPane.showMessageDialog(this, this.qD.errMessage, "Error", 0);
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.pbT.forcedKill();
            this.exitAction();
        }
        this.update(((Component)this).getGraphics());
        return this.currentPhase;
    }

    public void initPhase() {
        this.currentPhase = 0;
    }

    protected void exitAction() {
        ((Component)this).setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel") && this.currentPhase < 3) {
            this.currentStatus.setText("Working...    Will cancel before next step.");
            this.currentPhase = 5;
            this.pack();
            this.qD.setCancel(true);
        }
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void setThread(Thread thread) {
    }

    public void keyPressed(KeyEvent ke) {
        if ((ke.getKeyCode() == 10 || ke.getKeyCode() == 32) && this.currentPhase < 3) {
            this.currentStatus.setText("Working...    Will cancel before next step.");
            this.currentPhase = 5;
            this.pack();
            this.qD.setCancel(true);
        }
    }

    public void kill() {
        this.pbT.kill();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ((Component)this).setVisible(false);
    }
}

