/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.deployer;

import javax.swing.JProgressBar;

public class ProgressThread
extends Thread {
    public static final int FINISHED = 0;
    public static final int RUNNING = 1;
    public static final int ERROR = 2;
    protected JProgressBar progressBar;
    protected boolean toBeKilled;
    protected double progress;
    protected int status;

    public ProgressThread(JProgressBar progressBar) {
        this.progressBar = progressBar;
        this.toBeKilled = false;
        this.status = 1;
    }

    public void kill() {
        this.toBeKilled = true;
    }

    public void run() {
        while (!this.toBeKilled) {
            int progress = this.getProgress();
            this.progressBar.setValue(progress);
            this.progressBar.setString(progress + "%");
            this.progressBar.setStringPainted(true);
            this.progressBar.repaint();
            this.progressBar.validate();
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.progressBar.setValue(100);
        this.progressBar.setString("100%");
        this.progressBar.repaint();
        this.progressBar.validate();
    }

    public int getProgress() {
        if (this.progress >= 100.0) {
            this.status = 0;
        } else {
            this.calculate();
        }
        return (int)this.progress;
    }

    protected void calculate() {
        double step = (100.0 - this.progress) / 100.0;
        this.progress += step;
    }
}

