/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.deployer;

import com.sap.engine.deploy.SimpleEARClassLoader;
import com.sap.engine.deploy.ejb.descriptors.jar.ReadEjbJar;
import com.sap.engine.lib.jar.JarHandler;
import com.sap.engine.lib.xml.WrongStructureException;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.appclient.descriptor.ClientJar;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.jar.ReadRar;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.extended.ear.EARDescriptor;
import com.sap.engine.services.deploy.extended.ear.ExtendedEARReader;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.jar.WebWar;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ExtendedEarReader
extends ExtendedEARReader {
    private String applicationName;
    private Vector errors = new Vector();
    private String errorMessages;

    public ExtendedEarReader(String fileName) {
        try {
            this.setJarName(fileName);
        }
        catch (IOException e) {
            this.errorMessages = "Error while initializing Extended Ear Reader using file: " + fileName;
        }
    }

    public ExtendedEarReader(String fileName, File tempDir) throws IOException {
        super(fileName, tempDir);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EARDescriptor getFullEarDescriptor() throws WrongStructureException, IOException {
        Hashtable<String, ArchiveDescriptor> earTable = new Hashtable<String, ArchiveDescriptor>();
        Hashtable<String, String> descrTable = new Hashtable<String, String>();
        Hashtable compTable = new Hashtable();
        boolean needClear = false;
        EARDescriptor descr = this.getEARDescriptor();
        this.applicationName = descr.getDisplayName();
        String entry = null;
        try {
            File[] other;
            File[] connector;
            File[] client;
            File[] web;
            File[] ejb;
            if (this.loader == null) {
                this.loader = new SimpleEARClassLoader(null, this.filename);
                needClear = true;
            }
            if ((ejb = this.getEJBJars()) != null) {
                int i = 0;
                while (i < ejb.length) {
                    entry = this.getJ2EEModulAltDDEntry(descr.getModules(), new File(ejb[i].getAbsolutePath()).getName());
                    ArchiveDescriptor ejbJar = this.loadDescriptorFromFile(ejb[i].getAbsolutePath(), entry, 1);
                    if (ejbJar != null) {
                        earTable.put(ejb[i].getAbsolutePath(), ejbJar);
                        descrTable.put(ejb[i].getName(), ejb[i].getAbsolutePath());
                        this.loadBeanTable(ejbJar, ejb[i].getName(), compTable);
                    }
                    ++i;
                }
            }
            if ((web = this.getWarFiles()) != null) {
                int i = 0;
                while (i < web.length) {
                    entry = this.getJ2EEModulAltDDEntry(descr.getModules(), new File(web[i].getAbsolutePath()).getName());
                    ArchiveDescriptor war = this.loadDescriptorFromFile(web[i].getAbsolutePath(), entry, 4);
                    if (war != null) {
                        earTable.put(web[i].getAbsolutePath(), war);
                        descrTable.put(web[i].getName(), web[i].getAbsolutePath());
                        this.loadBeanTable(war, web[i].getName(), compTable);
                    }
                    ++i;
                }
            }
            if ((client = this.getClientJarFiles()) != null) {
                int i = 0;
                while (i < client.length) {
                    entry = this.getJ2EEModulAltDDEntry(descr.getModules(), new File(client[i].getAbsolutePath()).getName());
                    ArchiveDescriptor clientJar = this.loadDescriptorFromFile(client[i].getAbsolutePath(), entry, 3);
                    if (clientJar != null) {
                        earTable.put(client[i].getAbsolutePath(), clientJar);
                        descrTable.put(client[i].getName(), client[i].getAbsolutePath());
                        this.loadBeanTable(clientJar, client[i].getName(), compTable);
                    }
                    ++i;
                }
            }
            if ((connector = this.getConnectorRarFiles()) != null) {
                int i = 0;
                while (i < connector.length) {
                    entry = this.getJ2EEModulAltDDEntry(descr.getModules(), new File(connector[i].getAbsolutePath()).getName());
                    ArchiveDescriptor connectorRar = this.loadDescriptorFromFile(connector[i].getAbsolutePath(), entry, 5);
                    if (connectorRar != null) {
                        earTable.put(connector[i].getAbsolutePath(), connectorRar);
                        descrTable.put(connector[i].getName(), connector[i].getAbsolutePath());
                        this.loadBeanTable(connectorRar, connector[i].getName(), compTable);
                    }
                    ++i;
                }
            }
            if ((other = this.getOtherJarFiles()) != null) {
                int i = 0;
                while (i < other.length) {
                    entry = this.getJ2EEModulAltDDEntry(descr.getModules(), new File(other[i].getAbsolutePath()).getName());
                    ArchiveDescriptor otherJar = this.loadDescriptorFromFile(other[i].getAbsolutePath(), entry, 3);
                    if (otherJar != null) {
                        earTable.put(other[i].getAbsolutePath(), otherJar);
                        descrTable.put(other[i].getName(), other[i].getAbsolutePath());
                    }
                    ++i;
                }
            }
            descr.setArchiveTable(earTable);
            descr.setDescrTable(descrTable);
            descr.setCompTable(compTable);
            Object var15_19 = null;
            if (!needClear) return descr;
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            if (!needClear) throw throwable;
            if (this.loader instanceof SimpleEARClassLoader) {
                ((SimpleEARClassLoader)this.loader).clear();
            }
            this.loader = null;
            throw throwable;
        }
        if (this.loader instanceof SimpleEARClassLoader) {
            ((SimpleEARClassLoader)this.loader).clear();
        }
        this.loader = null;
        return descr;
    }

    private String getJ2EEModulAltDDEntry(J2EEModule[] moduls, String modulUri) {
        String entry = null;
        if (moduls != null && modulUri != null && !modulUri.trim().equals("")) {
            int i = 0;
            while (i < moduls.length) {
                if (moduls[i] != null && modulUri.equals(moduls[i].getUri())) {
                    entry = moduls[i].getAlt_dd();
                    break;
                }
                ++i;
            }
        }
        return entry;
    }

    public ArchiveDescriptor loadDescriptorFromFile(String name, String xmlEntry, int type) throws WrongStructureException, IOException {
        switch (type) {
            case 1: {
                String providerName = this.descr.getProviderName() == null ? "sap.com" : this.descr.getProviderName();
                providerName = providerName + "/";
                ReadEjbJar readEjb = new ReadEjbJar(name, providerName + this.applicationName, true);
                readEjb.setLoader(this.loader);
                EJBJarDescriptor descr = null;
                descr = xmlEntry != null && !xmlEntry.trim().equals("") ? readEjb.getEjbJarDescriptor(this.getZipEntry(xmlEntry)) : readEjb.getEjbJarDescriptor();
                this.errors = readEjb.getErrors();
                return descr;
            }
            case 4: {
                WebWar war = new WebWar(name);
                war.setLoader(this.loader);
                WebDeploymentDescriptor webDescr = war.getWebDescriptor();
                webDescr = xmlEntry != null && !xmlEntry.trim().equals("") ? war.getWebDescriptor(this.getZipEntry(xmlEntry), xmlEntry) : war.getWebDescriptor();
                return webDescr;
            }
            case 3: {
                ClientJar cJar = new ClientJar(name);
                ApplicationClientDescriptor clientDescr = cJar.getClientJarDescriptor();
                clientDescr = xmlEntry != null && !xmlEntry.trim().equals("") ? cJar.getClientJarDescriptor(this.getZipEntry(xmlEntry)) : cJar.getClientJarDescriptor();
                return clientDescr;
            }
            case 5: {
                ReadRar rarReader = new ReadRar(name);
                JCDescriptor connectorDescriptor = rarReader.getDescriptor();
                connectorDescriptor = xmlEntry != null && !xmlEntry.trim().equals("") ? rarReader.getDescriptor(this.getZipEntry(xmlEntry)) : rarReader.getDescriptor();
                return connectorDescriptor;
            }
        }
        return null;
    }

    private BufferedInputStream getZipEntry(String xmlEntry) throws IOException {
        ZipFile jar = new ZipFile(this.filename);
        ZipEntry entry = JarHandler.findEntryIgnoreCase(jar, xmlEntry);
        if (entry == null) {
            entry = JarHandler.findEntryIgnoreCase(jar, xmlEntry);
        }
        if (entry == null) {
            throw new IOException("Can't find the alt_dd xml entry " + xmlEntry + " in the ear file.");
        }
        return new BufferedInputStream(jar.getInputStream(entry));
    }

    public void loadBeanTable(ArchiveDescriptor archDescr, String archName, Hashtable beanTable) {
        DeploymentDescriptor[] deplDescr = null;
        String beanName = null;
        if (archDescr != null && archName != null) {
            if (archDescr instanceof EJBJarDescriptor) {
                deplDescr = (DeploymentDescriptor[])archDescr.getDescriptors();
                if (deplDescr != null) {
                    int i = 0;
                    while (i < deplDescr.length) {
                        beanName = deplDescr[i].getEjbName().toString();
                        if (beanName != null) {
                            beanTable.put(beanName, archName);
                        }
                        ++i;
                    }
                }
            } else if (archDescr instanceof WebDeploymentDescriptor) {
                if (archDescr.getDisplayName() != null) {
                    beanTable.put(archDescr.getDisplayName(), archName);
                } else {
                    beanTable.put(archName, archName);
                }
            } else if (archDescr instanceof ApplicationClientDescriptor) {
                if (archDescr.getDisplayName() != null) {
                    beanTable.put(archDescr.getDisplayName(), archName);
                } else {
                    beanTable.put(archName, archName);
                }
            } else if (archDescr instanceof JCDescriptor) {
                if (archDescr.getDisplayName() != null) {
                    beanTable.put(archDescr.getDisplayName(), archName);
                } else {
                    beanTable.put(archName, archName);
                }
            }
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public Vector getErrors() {
        return this.errors;
    }

    public boolean isJ2EE() {
        J2EEModule[] modules = this.descr.getModules();
        return modules != null && modules.length > 0;
    }
}

