/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.deployer;

import com.sap.engine.deploy.manager.DeployManagerImpl;
import com.sap.engine.deploy.tool.deployer.DeployerActionManager;
import com.sap.engine.lib.io.FileUtils;
import java.io.File;

public class DeployThread
implements Runnable {
    public String xmlFileName;
    public String appName = null;
    public String deployerLogFile;
    DeployerActionManager acManager;
    protected boolean toBeKilled;
    private byte option = 0;
    private String tempEarName = null;
    private String xmlsDir = null;
    private DeployManagerImpl manager = null;
    private File workDir = null;

    public DeployThread(DeployerActionManager acManager, String xmlFileName, byte option, String tempEarName) {
        this.acManager = acManager;
        this.xmlFileName = xmlFileName;
        this.toBeKilled = false;
        this.option = option;
        this.tempEarName = tempEarName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void kill() {
        this.toBeKilled = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.workDir = null;
        try {
            try {
                switch (this.option) {
                    case 0: {
                        this.initDeployManager();
                        this.manager.deploy();
                        break;
                    }
                    case 1: {
                        this.initDeployManager();
                        this.manager.update();
                        break;
                    }
                    case 2: {
                        this.initDeployManager();
                        this.manager.makeTempEar(this.tempEarName);
                        break;
                    }
                    case 3: {
                        this.workDir = new File(this.acManager.getTempDir(), "DeployManager");
                        this.manager = new DeployManagerImpl(this.xmlFileName, this.acManager.getClassPath(), this.workDir.getAbsolutePath());
                        this.manager.setLog(this.deployerLogFile);
                        this.manager.startApplication(this.appName);
                        break;
                    }
                }
                this.acManager.deployFinished(null, null);
            }
            catch (Exception e) {
                this.acManager.deployFinished(e, this.deployerLogFile);
                Object var3_2 = null;
                FileUtils.deleteDirectory(this.workDir);
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            FileUtils.deleteDirectory(this.workDir);
            throw throwable;
        }
        FileUtils.deleteDirectory(this.workDir);
    }

    public void initDeployManager() throws Exception {
        this.workDir = new File(this.acManager.getTempDir(), "DeployManager");
        this.manager = new DeployManagerImpl(this.xmlFileName, this.acManager.getClassPath(), this.workDir.getAbsolutePath());
        this.xmlsDir = this.acManager.getAdditionalXMLsDir().getAbsolutePath();
        this.manager.setXmlsDir(this.xmlsDir);
        this.manager.setLog(this.deployerLogFile);
        this.manager.setTempEarDir(this.acManager.getTempDir().getAbsolutePath());
        this.manager.setDeployProperties(this.acManager.document.getDeployProperties());
    }
}

