/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.deployer;

import com.sap.engine.deploy.manager.DeployConfigDocument;
import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.editorproperties.PropertyEditor;
import com.sap.engine.services.deploy.gui.common.additional.RemoteSupportTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;

public class ClusterPropDialog
extends CEscapeDialog
implements ActionListener,
KeyListener {
    public static final String OK_CMD = "OK_CMD";
    public static final String CANCEL_CMD = "CANCEL_CMD";
    protected final int INITIAL_PROPDLG_WIDTH = 450;
    protected final int INITIAL_PROPDLG_HEIGHT = 225;
    protected JTabbedPane theTabbedPane = new JTabbedPane();
    protected JPanel loginPanel = new JPanel();
    protected JPanel mainPanel;
    protected JPanel buttonsPanel = new JPanel();
    protected JPanel clusterPanel;
    protected JButton okBtn = new JButton("OK");
    protected JButton cancelBtn = new JButton("Cancel");
    protected JScrollPane jScrollPane1 = new JScrollPane();
    protected JScrollPane jScrollPane2 = new JScrollPane();
    protected JLabel userLabel;
    protected JTextField userField;
    protected JLabel passwordLabel;
    protected JPasswordField passwordField;
    protected JLabel hostLabel;
    protected JTextField hostField;
    protected JLabel portLabel;
    protected JTextField portField;
    protected RemoteSupportTableModel supportModel = new RemoteSupportTableModel();
    protected JTable supportTable = new JTable(this.supportModel);
    protected Border eatchedBorder1 = BorderFactory.createEtchedBorder();
    protected TitledBorder titledBorder2 = BorderFactory.createTitledBorder(this.eatchedBorder1, "Supports");
    protected Frame frame;
    DeployConfigDocument document = new DeployConfigDocument();
    private PropertyEditor propEditor = new PropertyEditor("Key", "Value");
    private JComboBox layerCombo = new JComboBox();
    private String[] layers = new String[]{"None", "httptunneling", "ssl", "https"};
    private JLabel layerLabel = null;

    public ClusterPropDialog(Frame frame, String name, boolean modal) {
        super(frame, name, modal);
        this.init();
    }

    public void init() {
        this.mainPanel = new JPanel(new GridBagLayout());
        ((Component)((Object)this)).addKeyListener(this);
        this.clusterPanel = new JPanel(new GridBagLayout());
        this.clusterPanel.add((Component)this.jScrollPane2, new GridBagConstraints(0, 2, 3, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        ((JDialog)((Object)this)).getContentPane().add(this.mainPanel);
        this.loginPanel = new JPanel(new GridBagLayout());
        this.loginPanel.setPreferredSize(new Dimension(450, 225));
        this.userLabel = new JLabel("User Name:");
        this.loginPanel.add((Component)this.userLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.userField = new JTextField();
        this.loginPanel.add((Component)this.userField, new GridBagConstraints(1, 1, 3, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.passwordLabel = new JLabel("Password:");
        this.loginPanel.add((Component)this.passwordLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.passwordField = new JPasswordField();
        this.loginPanel.add((Component)this.passwordField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.hostLabel = new JLabel("Host:");
        this.loginPanel.add((Component)this.hostLabel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.hostField = new JTextField();
        this.loginPanel.add((Component)this.hostField, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.portLabel = new JLabel("Port:");
        this.loginPanel.add((Component)this.portLabel, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.portField = new JTextField();
        this.loginPanel.add((Component)this.portField, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.layerLabel = new JLabel("Layer:");
        this.loginPanel.add((Component)this.layerLabel, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.layerCombo = new JComboBox<String>(this.layers);
        this.loginPanel.add((Component)this.layerCombo, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.theTabbedPane.addTab("Login Info", this.loginPanel);
        this.theTabbedPane.addTab("Cluster Info", this.clusterPanel);
        this.theTabbedPane.addTab("Deployment Properties", (Component)this.propEditor);
        this.mainPanel.add((Component)this.theTabbedPane, new GridBagConstraints(0, 0, 2, 2, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.buttonsPanel, new GridBagConstraints(0, 2, 2, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.okBtn.setActionCommand(OK_CMD);
        this.okBtn.addActionListener(this);
        this.cancelBtn.setActionCommand(CANCEL_CMD);
        this.cancelBtn.addActionListener(this);
        this.buttonsPanel.add(this.okBtn);
        this.buttonsPanel.add(this.cancelBtn);
        this.jScrollPane2.setBorder(this.titledBorder2);
        this.jScrollPane2.getViewport().add((Component)this.supportTable, null);
    }

    public void setDocument(DeployConfigDocument document) {
        this.document = document;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(OK_CMD)) {
            this.okAction();
        } else if (cmd.equals(CANCEL_CMD)) {
            ((Component)((Object)this)).setVisible(false);
        }
    }

    public void fillFields() {
        this.userField.setText(this.document.getInfo().getUserName());
        ((JTextComponent)this.passwordField).setText(this.document.getInfo().getUserPassword());
        this.hostField.setText(this.document.getInfo().getRemoteHost());
        this.portField.setText(String.valueOf(this.document.getInfo().getRemotePort()));
        this.supportModel.initModel(this.document.getSupports(), null);
        if (this.document.getDeployProperties() != null) {
            Properties clonedProp = (Properties)((Hashtable)this.document.getDeployProperties()).clone();
            this.setXmlProperties(clonedProp);
        }
        String layer = this.document.getInfo().getTransportProtocol() != null && this.document.getInfo().getTransportProtocol()[0] != null ? this.document.getInfo().getTransportProtocol()[0] : "None";
        int i = 0;
        while (i < this.layers.length) {
            if (layer.equals(this.layers[i])) {
                this.layerCombo.setSelectedIndex(i);
            }
            ++i;
        }
    }

    public void getFields() {
        this.document.getInfo().setUserName(this.userField.getText());
        this.document.getInfo().setUserPassword(new String(this.passwordField.getPassword()));
        this.document.getInfo().setRemoteHost(this.hostField.getText());
        this.document.getInfo().setTransportProtocol(new String[]{(String)this.layerCombo.getSelectedItem()});
        if (!this.portField.getText().equals("")) {
            this.document.getInfo().setRemotePort(Integer.parseInt(this.portField.getText()));
        }
        this.document.setSupports(this.supportModel.getSelected());
        this.document.setDeployProperties(this.getXmlProperties());
    }

    public Properties getXmlProperties() {
        return this.propEditor.getProps();
    }

    public void setXmlProperties(Properties xmlProperties) {
        if (xmlProperties != null) {
            this.propEditor.initProperties(xmlProperties);
        }
    }

    public void keyPressed(KeyEvent e) {
        String cmd = "";
        if (e.getKeyCode() == 27) {
            cmd = CANCEL_CMD;
        } else if (e.getKeyCode() == 10) {
            cmd = OK_CMD;
        }
        if (cmd.equals(OK_CMD)) {
            this.getFields();
            ((Component)((Object)this)).setVisible(false);
        } else if (cmd.equals(CANCEL_CMD)) {
            ((Component)((Object)this)).setVisible(false);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private void okAction() {
        this.getFields();
        ((Component)((Object)this)).setVisible(false);
    }

    protected void performEnterAction(KeyEvent e) {
        this.okAction();
    }
}

