/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.components;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.deploy.tool.components.ServletJSPTableModel;
import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.LogMessageDialog;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.SortTable;
import com.sap.engine.services.servlets_jsp.descriptor.ServletDescriptor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class ServletJSPDialog
extends CEscapeDialog
implements ActionListener,
KeyListener {
    private ServletJSPTableModel tableModel = new ServletJSPTableModel();
    private Frame frame;
    private SortTable table;
    private JPanel panel;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton selectAllBtn;
    private JButton deselectAllBtn;
    private final String OK_CMD = "OK";
    private final String CANCEL_CMD = "CANCEL";
    private final String SELECT_ALL_CMD = "SELECT_ALL";
    private final String DESELECT_ALL_CMD = "DESELECT_ALL";
    private boolean isOk = false;

    public ServletJSPDialog(Frame frame1) {
        super(frame1);
        this.frame = frame1;
        this.init();
        LookAndFeelHandler.add((Component)((Object)this));
    }

    private void init() {
        ((Component)((Object)this)).addKeyListener(this);
        this.table = new SortTable((TableModel)this.tableModel);
        this.table.setModel((AbstractTableModel)this.tableModel);
        this.panel = new JPanel();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand("CANCEL");
        this.cancelButton.addActionListener(this);
        this.selectAllBtn = new JButton("Select All");
        this.selectAllBtn.setActionCommand("SELECT_ALL");
        this.selectAllBtn.addActionListener(this);
        this.deselectAllBtn = new JButton("Deselect All");
        this.deselectAllBtn.setActionCommand("DESELECT_ALL");
        this.deselectAllBtn.addActionListener(this);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(400);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(140);
        this.buttonPanel.add(this.selectAllBtn);
        this.buttonPanel.add(this.deselectAllBtn);
        this.buttonPanel.add(new JSeparator());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.panel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Editor Panel"));
        this.panel.setLayout(new GridBagLayout());
        this.panel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 0.01, 0.01, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.panel.setPreferredSize(new Dimension(300, 300));
        ((Dialog)((Object)this)).setModal(true);
        ((Component)((Object)this)).setSize(new Dimension(640, 460));
        ((Dialog)((Object)this)).setResizable(true);
        ((Dialog)((Object)this)).setTitle("Add Servlet and JSP");
        ((JDialog)((Object)this)).getContentPane().add(this.panel);
        ((Window)((Object)this)).setLocationRelativeTo(this.frame);
    }

    public void initData(String[] servlJsp) {
        this.tableModel.initData(servlJsp);
    }

    public void updateData(String[] servlJsp) {
        this.tableModel.updateData(servlJsp);
    }

    public ServletDescriptor[] getDescriptors() {
        String[] servlJsp = this.tableModel.getSelected(1);
        String[] servlJspNames = this.tableModel.getSelected(2);
        ServletDescriptor[] descr = new ServletDescriptor[servlJsp.length];
        int i = 0;
        while (i < servlJsp.length) {
            ServletDescriptor servletDescr = new ServletDescriptor();
            servletDescr.setName(servlJspNames[i]);
            servletDescr.setDisplayName(servlJspNames[i]);
            if (servlJsp[i].toLowerCase().endsWith(".jsp") || servlJsp[i].toLowerCase().endsWith(".jsf") || servlJsp[i].toLowerCase().endsWith(".jspf")) {
                servletDescr.setJspFile(servlJsp[i]);
            } else {
                servletDescr.setServletClass(servlJsp[i]);
            }
            descr[i] = servletDescr;
            ++i;
        }
        return descr;
    }

    public boolean isOk() {
        return this.isOk;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("OK")) {
            this.okAction();
        } else if (cmd.equals("CANCEL")) {
            this.cancelAction();
        } else if (cmd.equals("SELECT_ALL")) {
            this.tableModel.selectAll(true);
        } else if (cmd.equals("DESELECT_ALL")) {
            this.tableModel.selectAll(false);
        }
    }

    private void okAction() {
        String isCorect1 = ApplicationInformationProvider.vectorToString(this.tableModel.hasRepeatable(2));
        if (isCorect1 != null) {
            String b = isCorect1.replace(File.pathSeparatorChar, '\n');
            LogMessageDialog logErrorDialog = LogMessageDialog.getInstance((Frame)this.frame);
            logErrorDialog.showWarningDialogNoLogFile("There are components with duplicated names.\nChange names or remove the selection from the components with repeated names.", b);
            return;
        }
        String isCorect2 = ApplicationInformationProvider.vectorToString(this.tableModel.hasRepeatable(1));
        if (isCorect2 != null) {
            LogMessageDialog logErrorDialog = LogMessageDialog.getInstance((Frame)this.frame);
            logErrorDialog.showWarningDialogNoLogFile("There is a Servlet or JSP with the same class(es) already.\nRemove duplicated classes from the additional files or remove the selection from repeated \nfiles and try again. ", isCorect2.replace(File.pathSeparatorChar, '\n'));
            return;
        }
        this.isOk = true;
        ((Component)((Object)this)).setVisible(false);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.okAction();
        } else if (keyEvent.getKeyCode() == 27) {
            ((Component)((Object)this)).setVisible(false);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void cancelAction() {
        this.isOk = false;
        ((Component)((Object)this)).setVisible(false);
    }

    protected void performEnterAction(KeyEvent e) {
        this.okAction();
    }

    protected void performEscapeAction(KeyEvent e) {
        this.cancelAction();
    }
}

