/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.components;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.deploy.components.J2EEArchive;
import com.sap.engine.deploy.components.J2EEComponentsGenerator;
import com.sap.engine.deploy.components.J2EEGeneratorDoc;
import com.sap.engine.deploy.components.J2EEGeneratorException;
import com.sap.engine.deploy.components.XMLComponentsGenerator;
import com.sap.engine.deploy.ejb.descriptors.xml.EJB20DescriptorDocument;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.deploy.tool.RenameDialog;
import com.sap.engine.deploy.tool.components.BeanDialog;
import com.sap.engine.deploy.tool.components.ComponentsTab;
import com.sap.engine.deploy.tool.components.LocalLoader;
import com.sap.engine.deploy.tool.components.NewDialog;
import com.sap.engine.deploy.tool.components.ServletJSPDialog;
import com.sap.engine.deploy.tool.tree.ArchiveDescriptorNode;
import com.sap.engine.deploy.tool.tree.BasicDescriptorNode;
import com.sap.engine.deploy.tool.tree.ClientDescriptorNode;
import com.sap.engine.deploy.tool.tree.ConnectorDescriptorNode;
import com.sap.engine.deploy.tool.tree.DescriptorNode;
import com.sap.engine.deploy.tool.tree.EJBDescriptorNode;
import com.sap.engine.deploy.tool.tree.EJBJarDescriptorNode;
import com.sap.engine.deploy.tool.tree.FilterDescriptorNode;
import com.sap.engine.deploy.tool.tree.ListenerDescriptorNode;
import com.sap.engine.deploy.tool.tree.ServletDescriptorNode;
import com.sap.engine.deploy.tool.tree.WebDescriptorNode;
import com.sap.engine.gui.LogMessageDialog;
import com.sap.engine.gui.LogViewerDialog;
import com.sap.engine.gui.TreeUtils;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.ResorceAdapterDescriptorDocument;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.ear.common.StringCutter;
import com.sap.engine.services.deploy.gui.mapping.MappingObject;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.FilterDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ListenerDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ServletDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ComponentsActionManager
implements ActionListener {
    private StandardDOMWriter writer;
    private StandardDOMParser parser;
    public static final String J2EE_ADD_EJB_GROUP_CMD = "J2EE_ADD_EJB_GROUP_CMD";
    public static final String J2EE_ADD_CONNECTOR_CMD = "J2EE_ADD_CONNECTOR_CMD";
    public static final String J2EE_ADD_BEAN_CMD = "J2EE_ADD_BEAN_CMD";
    public static final String J2EE_ADD_WEB_CMD = "J2EE_ADD_WEB_CMD";
    public static final String J2EE_ADD_SERVLET_OR_JSP_CMD = "J2EE_ADD_SERVLET_OR_JSP_CMD";
    public static final String J2EE_ADD_FILTER_CMD = "J2EE_ADD_FILTER_CMD";
    public static final String J2EE_ADD_LISTENER_CMD = "J2EE_ADD_LISTENER_CMD";
    public static final String J2EE_ADD_CLIENT_CMD = "J2EE_ADD_CLIENT_CMD";
    public static final String J2EE_REMOVE_CMD = "J2EE_REMOVE_CMD";
    public static final String J2EE_MAKE_ARCH_CMD = "J2EE_MAKE_ARCH_CMD";
    public static final String J2EE_MAKE_ALL_ARCH_CMD = "J2EE_MAKE_ALL_ARCH_CMD";
    public static final String J2EE_VIEW_LOG_FILE = "J2EE_VIEW_LOG_FILE";
    public static final String J2EE_ADD_SERVLET_OR_JSP_FROM_CMD = "J2EE_ADD_SERVLET_OR_JSP_FROM_CMD";
    public static final String J2EE_RENAME_CMD = "J2EE_RENAME_CMD";
    public String archiveName = null;
    protected BasicDescriptorNode root;
    protected JTree tree;
    protected Frame mainFrame;
    protected J2EEComponentsGenerator generator = new J2EEComponentsGenerator();
    protected LogMessageDialog error;
    protected boolean firstAdd = true;
    protected ServletJSPDialog servletDialog;
    private Hashtable classpathTable = new Hashtable();
    private DefaultTreeModel treeModel = null;
    protected ComponentsTab tab = null;
    private ArchiveDescriptor archive;
    private ArchiveDescriptorNode archiveNode;
    private DescriptorNode descriptorNode;
    private J2EEGeneratorDoc document = null;
    private String componentsXML = null;
    protected String classPath = "";
    private boolean madeArchive = false;
    private File logFile = null;
    static /* synthetic */ Class class$javax$servlet$Servlet;

    public ComponentsActionManager() {
        this.initXMLToolkit();
    }

    public ComponentsActionManager(ComponentsTab tab) {
        this.tab = tab;
        this.initXMLToolkit();
    }

    public void actionPerformed(ActionEvent e) {
        ArchiveDescriptorNode parent = null;
        String cmd = e.getActionCommand();
        if (cmd.equalsIgnoreCase(J2EE_REMOVE_CMD)) {
            this.tab.checkNeeded = false;
            this.removeArchive();
            this.tab.needSaveing = true;
            return;
        }
        this.treeModel = (DefaultTreeModel)this.tree.getModel();
        this.tab.updateNodeProperties();
        this.tab.status.repaint();
        this.tab.status.validate();
        if (cmd.equalsIgnoreCase(J2EE_ADD_EJB_GROUP_CMD)) {
            this.tab.needSaveing = this.addEJBGroupAction(null);
        } else if (cmd.equalsIgnoreCase(J2EE_ADD_BEAN_CMD)) {
            if (!this.tree.getSelectionModel().isSelectionEmpty() && (parent = (ArchiveDescriptorNode)this.tree.getSelectionModel().getSelectionPath().getLastPathComponent()) instanceof EJBJarDescriptorNode) {
                this.tab.needSaveing = this.addBean(parent, null);
            }
        } else if (cmd.equalsIgnoreCase(J2EE_ADD_WEB_CMD)) {
            this.tab.needSaveing = this.addWebGroupAction(null);
        } else if (cmd.equalsIgnoreCase(J2EE_ADD_SERVLET_OR_JSP_CMD)) {
            if (!this.tree.getSelectionModel().isSelectionEmpty() && (parent = (ArchiveDescriptorNode)this.tree.getSelectionModel().getSelectionPath().getLastPathComponent()) instanceof WebDescriptorNode) {
                this.tab.needSaveing = this.addJspOrServlet(parent);
            }
        } else if (cmd.equalsIgnoreCase(J2EE_ADD_FILTER_CMD)) {
            if (!this.tree.getSelectionModel().isSelectionEmpty() && (parent = (ArchiveDescriptorNode)this.tree.getSelectionModel().getSelectionPath().getLastPathComponent()) instanceof WebDescriptorNode) {
                this.tab.needSaveing = this.addFilter(parent);
            }
        } else if (cmd.equalsIgnoreCase(J2EE_ADD_LISTENER_CMD)) {
            if (!this.tree.getSelectionModel().isSelectionEmpty() && (parent = (ArchiveDescriptorNode)this.tree.getSelectionModel().getSelectionPath().getLastPathComponent()) instanceof WebDescriptorNode) {
                this.tab.needSaveing = this.addListener(parent);
            }
        } else if (cmd.equalsIgnoreCase(J2EE_ADD_CLIENT_CMD)) {
            this.tab.needSaveing = this.addClient(null);
        } else if (cmd.equalsIgnoreCase(J2EE_ADD_CONNECTOR_CMD)) {
            this.addConnector(null);
        } else if (cmd.equalsIgnoreCase(J2EE_MAKE_ARCH_CMD)) {
            this.makeArchive();
        } else if (cmd.equalsIgnoreCase(J2EE_MAKE_ALL_ARCH_CMD)) {
            this.makeAllArchives();
        } else if (cmd.equalsIgnoreCase(J2EE_VIEW_LOG_FILE)) {
            if (this.tab.getLogViewerDialog() == null) {
                this.tab.logViewerDialog = new LogViewerDialog(this.mainFrame, "Log");
            }
            this.logFile = new File(this.tab.projectDir + File.separator + "j2ee_generator_log.txt");
            if (!this.logFile.exists()) {
                JOptionPane.showMessageDialog(this.mainFrame, "There is no log file.", "Warning", 2);
            } else {
                this.tab.getLogViewerDialog().show(this.mainFrame, this.logFile);
            }
        } else if (cmd.equalsIgnoreCase(J2EE_ADD_SERVLET_OR_JSP_FROM_CMD)) {
            this.addServlJspFormAction();
        } else if (cmd.equalsIgnoreCase(J2EE_RENAME_CMD) && !this.tree.getSelectionModel().isSelectionEmpty()) {
            this.renameAction();
        }
    }

    protected boolean addEJBGroupAction(NewDialog dialog) {
        this.archive = new EJBJarDescriptor();
        if (dialog == null) {
            dialog = new NewDialog(this.mainFrame, "Load EJB JAR", true, "New Jar Name:", 0);
        }
        ((Window)((Object)dialog)).setLocationRelativeTo(this.mainFrame);
        ((Component)((Object)dialog)).setVisible(true);
        String archName = dialog.getArhName();
        String xmlFileName = dialog.getXMLName();
        String[] dir = dialog.getDirNames();
        if (!archName.toLowerCase().endsWith(".jar")) {
            archName = archName + ".jar";
        } else if (!archName.endsWith(".jar")) {
            archName = archName.substring(0, archName.length() - 4) + ".jar";
        }
        this.archiveName = this.tab.projectDir.getAbsolutePath() + File.separator + archName;
        this.root = (BasicDescriptorNode)this.treeModel.getRoot();
        if (dialog.isOkAction()) {
            if (this.checkExistingNode(archName)) {
                JOptionPane.showMessageDialog(this.mainFrame, "Already exists component with name: " + archName + ". Please try with other name. \n", "Error", 0);
                return this.addEJBGroupAction(dialog);
            }
            if (!dialog.createBrandNew()) {
                this.generator.addNewArchive(this.archiveName, 1);
                if (dir != null && dir.length > 0) {
                    this.addAdditionalClassPath(dir);
                }
                try {
                    this.archive = this.generator.getConvertedEJBDescriptor(this.tab.getLoader(), xmlFileName);
                }
                catch (J2EEGeneratorException ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this.mainFrame, "Exception occurred while loading xml " + xmlFileName + " \n " + ex.toString(), "Error", 0);
                    return false;
                }
                if (this.archive.getDisplayName() == null || this.archive.getDisplayName().trim().equals("")) {
                    this.archive.setDisplayName(archName.substring(0, archName.lastIndexOf(".")));
                }
                this.archiveNode = new EJBJarDescriptorNode(archName);
                this.archiveNode.setArchiveDescriptor(this.archive);
                this.archiveNode.setAdditionalFiles(this.makeAdditionalFiles(dir, new Vector(), false));
                this.archiveNode.setArchiveFileName(this.archiveName);
                if (dir != null && dir.length > 0) {
                    this.addAdditionalClassPath(dir);
                }
                this.tab.getAppInfoProvider().setClassPath(this.classPath);
                this.tab.setLoader(new DynamicClassLoader(this.classPath));
                this.archiveNode.setArchiveFileName(this.archiveName);
                this.generator.addAdditionalClassPath(this.archiveName, dir);
                this.classpathTable.put(archName, dir);
                this.treeModel.insertNodeInto(this.archiveNode, this.root, 0);
                if (this.firstAdd) {
                    this.treeModel.reload();
                    this.tab.checkEnable(null);
                    this.firstAdd = false;
                }
                TreeUtils.expandTree((JTree)this.tree, (int)2);
                DeploymentDescriptor[] descrs = (DeploymentDescriptor[])this.archive.getDescriptors();
                if (descrs != null) {
                    int i = 0;
                    while (i < descrs.length) {
                        if (descrs[i].getDisplayName() != null && !descrs[i].getDisplayName().equals("")) {
                            this.descriptorNode = new EJBDescriptorNode(descrs[i].getDisplayName());
                        } else {
                            descrs[i].setDisplayName(descrs[i].getEjbName());
                            this.descriptorNode = new EJBDescriptorNode(descrs[i].getEjbName());
                        }
                        this.descriptorNode.setDescriptor(descrs[i]);
                        this.treeModel.insertNodeInto(this.descriptorNode, this.archiveNode, i);
                        if (this.firstAdd) {
                            this.tab.checkEnable(null);
                            this.treeModel.reload();
                            this.firstAdd = false;
                        }
                        TreeUtils.expandTree((JTree)this.tree, (int)2);
                        ++i;
                    }
                }
            } else {
                this.generator.addNewArchive(this.archiveName, 1);
                this.archiveNode = new EJBJarDescriptorNode(archName);
                if (dir != null && dir.length > 0) {
                    this.addAdditionalClassPath(dir);
                }
                this.tab.getAppInfoProvider().setClassPath(this.classPath);
                this.archiveNode.setAdditionalFiles(this.makeAdditionalFiles(dir, new Vector(), false));
                this.archiveNode.setArchiveFileName(this.archiveName);
                EJBJarDescriptor jar = new EJBJarDescriptor();
                if (jar.getDisplayName() == null) {
                    this.archive.setDisplayName(archName.substring(0, archName.lastIndexOf(".")));
                }
                this.archiveNode.setArchiveDescriptor(jar);
                this.treeModel.insertNodeInto(this.archiveNode, (BasicDescriptorNode)this.treeModel.getRoot(), 0);
                if (this.firstAdd) {
                    this.treeModel.reload();
                    this.tab.checkEnable(null);
                    this.firstAdd = false;
                }
                TreeUtils.expandTree((JTree)this.tree, (int)2);
            }
            this.tab.status.setText("EJB Group is added");
            return true;
        }
        return false;
    }

    protected boolean checkExistingChild(ArchiveDescriptorNode parent, String name) {
        int length = parent.getChildCount();
        int i = 0;
        while (i < length) {
            if (((DescriptorNode)parent.getChildAt(i)).getCurrentDescriptor().getName().equals(name)) {
                JOptionPane.showMessageDialog(this.mainFrame, "There is already a component named : <" + name + ">.\nPlease choose another name for the new component.\n", "Error", 0);
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean checkExistingNode(String name) {
        BasicDescriptorNode node = null;
        String node_name = null;
        int childs = ((DefaultMutableTreeNode)this.tree.getModel().getRoot()).getChildCount();
        if (childs == 0) {
            return false;
        }
        int i = 0;
        while (i < childs) {
            node = (BasicDescriptorNode)((DefaultTreeModel)this.tree.getModel()).getChild((DefaultMutableTreeNode)this.tree.getModel().getRoot(), i);
            node_name = node.getName();
            if (node_name.equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean addBean(ArchiveDescriptorNode parent, BeanDialog d) {
        DeploymentDescriptor descriptor = null;
        Vector<DeploymentDescriptor> descrs = new Vector<DeploymentDescriptor>();
        if (d == null) {
            d = new BeanDialog(this.mainFrame, " Load New Bean ", true);
        }
        d.setClassPaths(this.classPath);
        d.setArchiveName(this.archiveName);
        ((Window)((Object)d)).setLocationRelativeTo(this.mainFrame);
        ((Component)((Object)d)).setVisible(true);
        if (!d.isOkAction()) {
            this.tab.status.setText("");
        }
        if (d.isOkAction()) {
            if (!this.checkExistingChild(parent, d.getBeanName())) {
                if (d.createNew()) {
                    if (d.getBeanType().equals("SESSION_BEAN")) {
                        descriptor = new SessionDescriptor();
                    } else if (d.getBeanType().equals("ENTITY_BEAN")) {
                        descriptor = new CMPEntityDescriptor();
                        ((CMPEntityDescriptor)descriptor).setAbstractSchemaName(d.getBeanName());
                    } else if (d.getBeanType().equals("MESSAGE_DRIVEN_BEAN")) {
                        descriptor = new MessageDrivenDescriptor();
                    }
                    descriptor.setDisplayName(d.getBeanName());
                    descriptor.setBeanName(d.getBeanName());
                    descrs.addElement(descriptor);
                    Object[] dds = new DeploymentDescriptor[descrs.size()];
                    descrs.copyInto(dds);
                    if (parent instanceof EJBJarDescriptorNode) {
                        this.archive = this.generator.getArchive(parent.getArchiveFileName());
                        if (this.archive != null) {
                            this.archive.setDescriptors((Descriptor[])dds);
                        }
                        this.descriptorNode = new EJBDescriptorNode(d.getBeanName());
                        this.descriptorNode.setDescriptor(descriptor);
                        int child_count = parent.getChildCount();
                        if (child_count != 0) {
                            this.treeModel.insertNodeInto(this.descriptorNode, parent, child_count);
                            this.tab.status.setText("EJB is added");
                        } else {
                            this.treeModel.insertNodeInto(this.descriptorNode, parent, 0);
                            this.tab.status.setText("EJB is added");
                        }
                        TreeUtils.expandTree((JTree)this.tree, (int)2);
                    }
                } else {
                    String[] dir = d.getSelectedDirs();
                    if (dir != null) {
                        this.addAdditionalClassPath(dir);
                        parent.setAdditionalFiles(this.makeAdditionalFiles(dir, new Vector(), false));
                        this.tab.getAppInfoProvider().setClassPath(dir);
                        if (this.classpathTable.get(parent.getArchiveFileName()) != null) {
                            String[] newDirSource = (String[])this.classpathTable.get(parent.getArchiveFileName());
                            String[] newDirsTemp = new String[dir.length + newDirSource.length];
                            System.arraycopy(dir, 0, newDirsTemp, 0, dir.length);
                            System.arraycopy(newDirSource, 0, newDirsTemp, dir.length, newDirSource.length);
                            this.classpathTable.put(parent.getArchiveFileName(), newDirsTemp);
                        } else {
                            this.classpathTable.put(parent.getName(), dir);
                        }
                    }
                    EJBJarDescriptor jar = new EJBJarDescriptor();
                    try {
                        block27: {
                            try {
                                DynamicClassLoader loader = new DynamicClassLoader(this.classPath);
                                jar = this.generator.getConvertedEJBDescriptor(loader, d.getXMLFileName());
                                DeploymentDescriptor[] descriptors = jar.getDDescriptors();
                                if (descriptors == null) break block27;
                                boolean findBean = false;
                                int i = 0;
                                while (i < descriptors.length) {
                                    if (d.getBeanName().trim().equalsIgnoreCase(descriptors[i].getName())) {
                                        findBean = true;
                                        descriptor = descriptors[i];
                                        descriptor.setDisplayName(d.getBeanName());
                                        this.descriptorNode = new EJBDescriptorNode(descriptor.getDisplayName() != null ? descriptor.getDisplayName() : descriptor.getEjbName());
                                        this.descriptorNode.setDescriptor(descriptor);
                                        this.treeModel.insertNodeInto(this.descriptorNode, parent, parent.getChildCount());
                                        TreeUtils.expandTree((JTree)this.tree, (int)2);
                                        break;
                                    }
                                    ++i;
                                }
                                if (findBean) break block27;
                                JOptionPane.showMessageDialog(this.mainFrame, "There is no such bean " + d.getBeanName() + " in XML file. \n", "Error", 0);
                            }
                            catch (Exception exc) {
                                JOptionPane.showMessageDialog(this.mainFrame, "Could not load EJB descriptor. \n" + exc.toString(), "Error", 0);
                                boolean findBean = false;
                                Object var12_18 = null;
                                return findBean;
                            }
                        }
                        Object var12_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_19 = null;
                        throw throwable;
                    }
                }
                Vector<Descriptor> temp = new Vector<Descriptor>();
                int length = parent.getChildCount();
                int i = 0;
                while (i < length) {
                    EJBDescriptorNode node = (EJBDescriptorNode)parent.getChildAt(i);
                    if (node.getCurrentDescriptor() != null) {
                        temp.add(node.getCurrentDescriptor());
                    }
                    ++i;
                }
                Object[] DD = new DeploymentDescriptor[temp.size()];
                temp.copyInto(DD);
                parent.getCurrentDescriptor().setDescriptors((Descriptor[])DD);
            } else {
                return this.addBean(parent, d);
            }
        }
        this.tab.setLoader(new DynamicClassLoader(this.classPath));
        this.tab.treeValueChanged(parent);
        return true;
    }

    protected boolean addWebGroupAction(NewDialog d) {
        String tempName = null;
        if (d == null) {
            d = new NewDialog(this.mainFrame, "Load WAR", true, "", 1);
        }
        ((Window)((Object)d)).setLocationRelativeTo(this.mainFrame);
        ((Dialog)((Object)d)).show();
        String xmlName = d.getXMLName();
        String new_name = d.getArhName();
        if (d.isOkAction()) {
            if (new_name != null && !new_name.equals("")) {
                if (!new_name.toLowerCase().endsWith(".war")) {
                    new_name = new_name + ".war";
                } else if (!new_name.endsWith(".war")) {
                    new_name = new_name.substring(0, new_name.length() - 4) + ".war";
                }
                tempName = this.tab.projectDir + File.separator + new_name;
                if (this.checkExistingNode(new_name)) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Already exists component with name: " + new_name + ". Please try with other name. \n", "Error", 0);
                    return this.addWebGroupAction(d);
                }
                if (d.createBrandNew()) {
                    this.archiveNode = new WebDescriptorNode(new_name);
                    WebDeploymentDescriptor web = new WebDeploymentDescriptor();
                    web.setDisplayName(new_name.substring(0, new_name.lastIndexOf(46)));
                    this.archiveNode.setArchiveDescriptor(web);
                    this.archiveNode.setArchiveFileName(tempName);
                    this.archiveNode.setAdditionalFiles(this.makeAdditionalFiles(d.getDirNames(), new Vector(), true));
                    this.treeModel.insertNodeInto(this.archiveNode, (BasicDescriptorNode)this.treeModel.getRoot(), 0);
                    if (this.firstAdd) {
                        this.treeModel.reload();
                        this.tab.checkEnable(null);
                        this.firstAdd = false;
                    }
                    TreeUtils.expandTree((JTree)this.tree, (int)2);
                    this.archiveName = tempName;
                    this.generator.addNewArchive(this.archiveName, 4);
                } else {
                    ServletDescriptor[] servletDescriptors = null;
                    FilterDescriptor[] filterDescriptors = null;
                    ListenerDescriptor[] listenerDescriptors = null;
                    WebDeploymentDescriptor war = new WebDeploymentDescriptor();
                    this.archiveNode = new WebDescriptorNode(new_name);
                    this.archiveNode.setAdditionalFiles(this.makeAdditionalFiles(d.getDirNames(), new Vector(), false));
                    this.generator.addNewArchive(tempName, 4);
                    try {
                        try {
                            int i;
                            war = this.generator.getConvertedWebDescriptor(xmlName);
                            this.archiveNode.setArchiveDescriptor(war);
                            this.archiveNode.setArchiveFileName(tempName);
                            this.generator.setArchiveDescriptor(tempName, war);
                            this.treeModel.insertNodeInto(this.archiveNode, (BasicDescriptorNode)this.treeModel.getRoot(), 0);
                            if (this.firstAdd) {
                                this.treeModel.reload();
                                this.tab.checkEnable(null);
                                this.firstAdd = false;
                            }
                            TreeUtils.expandTree((JTree)this.tree, (int)2);
                            servletDescriptors = war.getServlets();
                            listenerDescriptors = war.getListenersDescriptor();
                            filterDescriptors = war.getFilters();
                            if (servletDescriptors != null) {
                                String nameServlet = null;
                                i = 0;
                                while (i < servletDescriptors.length) {
                                    nameServlet = servletDescriptors[i].getName();
                                    this.descriptorNode = new ServletDescriptorNode(nameServlet);
                                    this.descriptorNode.setDescriptor(servletDescriptors[i]);
                                    this.treeModel.insertNodeInto(this.descriptorNode, this.archiveNode, i);
                                    ++i;
                                }
                            }
                            if (listenerDescriptors != null) {
                                String nameListener = null;
                                i = 0;
                                while (i < listenerDescriptors.length) {
                                    nameListener = listenerDescriptors[i].getName();
                                    this.descriptorNode = new ListenerDescriptorNode(nameListener);
                                    this.descriptorNode.setDescriptor(listenerDescriptors[i]);
                                    this.treeModel.insertNodeInto(this.descriptorNode, this.archiveNode, i);
                                    ++i;
                                }
                            }
                            if (filterDescriptors != null) {
                                String nameFilter = null;
                                i = 0;
                                while (i < filterDescriptors.length) {
                                    nameFilter = filterDescriptors[i].getName();
                                    this.descriptorNode = new FilterDescriptorNode(nameFilter);
                                    this.descriptorNode.setDescriptor(filterDescriptors[i]);
                                    this.treeModel.insertNodeInto(this.descriptorNode, this.archiveNode, i);
                                    ++i;
                                }
                            }
                            TreeUtils.expandTree((JTree)this.tree, (int)2);
                        }
                        catch (Exception exc) {
                            JOptionPane.showMessageDialog(this.mainFrame, "Could not load War. \n" + exc.toString(), "Error", 0);
                            boolean bl = false;
                            Object var12_15 = null;
                            return bl;
                        }
                        Object var12_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_16 = null;
                        throw throwable;
                    }
                }
            }
            if (d.getDirNames() != null && d.getDirNames().length != 0) {
                this.addAdditionalClassPath(d.getDirNames());
                this.tab.getAppInfoProvider().setClassPath(this.classPath);
            }
            this.tab.status.setText("Web archive is added");
            return true;
        }
        return false;
    }

    protected void removeArchive() {
        String temp_parent = null;
        if (!this.tree.isSelectionEmpty()) {
            TreePath path = this.tree.getLeadSelectionPath();
            BasicDescriptorNode selNode = (BasicDescriptorNode)path.getLastPathComponent();
            String name = selNode.getName();
            if (selNode instanceof ArchiveDescriptorNode) {
                if (selNode.getArchiveFileName() != null && !selNode.getArchiveFileName().equals("")) {
                    temp_parent = selNode.getArchiveFileName();
                    this.generator.removeArchive(temp_parent);
                } else {
                    if (selNode instanceof WebDescriptorNode) {
                        temp_parent = this.tab.projectDir + File.separator + name + ".war";
                        this.generator.removeArchive(temp_parent);
                    } else if (selNode instanceof EJBJarDescriptorNode) {
                        temp_parent = this.tab.projectDir + File.separator + name + ".jar";
                        this.generator.removeArchive(temp_parent);
                    }
                    this.tab.removeTransferInfo(temp_parent);
                }
            } else if (selNode instanceof DescriptorNode) {
                ArchiveDescriptorNode parent = (ArchiveDescriptorNode)selNode.getParent();
                String parent_name = parent.getName();
                if (selNode instanceof ServletDescriptorNode) {
                    temp_parent = this.tab.projectDir + File.separator + parent_name + ".war";
                    this.generator.removeComponentFromArchive(temp_parent, name);
                } else if (selNode instanceof EJBDescriptorNode) {
                    temp_parent = this.tab.projectDir + File.separator + parent_name + ".jar";
                    this.generator.removeComponentFromArchive(temp_parent, name);
                }
                ArchiveDescriptor archiveD = parent.getCurrentDescriptor();
                Descriptor[] descr = archiveD.getDescriptors();
                descr = archiveD.removeElement(descr, ((DescriptorNode)selNode).getCurrentDescriptor());
                archiveD.setDescriptors(descr);
                parent.setModifiedDescriptor(archiveD);
            }
            this.treeModel.removeNodeFromParent(selNode);
            if (!this.firstAdd && ((DefaultMutableTreeNode)this.treeModel.getRoot()).getChildCount() == 0) {
                this.firstAdd = true;
            }
            this.tab.getPropertiesPanel().removeAll();
            this.tab.getPropertiesPanel().repaint();
        }
        this.tab.lastSelectedNode = null;
        this.tab.checkEnable(null);
        this.tab.checkNeeded = true;
    }

    protected boolean addJspOrServlet(ArchiveDescriptorNode parent) {
        String new_name = JOptionPane.showInputDialog(this.mainFrame, (Object)"Insert name for JSP or servlet:");
        if (new_name != null && !new_name.trim().equals("")) {
            if (!this.checkExistingChild(parent, new_name)) {
                if (parent instanceof WebDescriptorNode) {
                    this.descriptorNode = new ServletDescriptorNode(new_name);
                    ServletDescriptor servletDescr = new ServletDescriptor();
                    servletDescr.setName(new_name);
                    servletDescr.setDisplayName(new_name);
                    this.descriptorNode.setDescriptor(servletDescr);
                    this.generator.setDescriptor(parent.getArchiveFileName(), new_name, servletDescr);
                    int count = parent.getChildCount();
                    if (count != 0) {
                        this.treeModel.insertNodeInto(this.descriptorNode, parent, count);
                    } else {
                        try {
                            this.treeModel.insertNodeInto(this.descriptorNode, parent, 0);
                        }
                        catch (Exception exc) {
                            JOptionPane.showMessageDialog(this.mainFrame, "Could not add JSP or Servlet \n", "Error", 0);
                            return false;
                        }
                    }
                    TreeUtils.expandTree((JTree)this.tree, (int)2);
                    this.tab.updateWebPanel();
                }
                this.tab.status.setText("Web component is added to archive: " + parent.getName());
                return true;
            }
            return this.addJspOrServlet(parent);
        }
        return false;
    }

    protected boolean addClient(NewDialog nDialog) {
        if (nDialog == null) {
            nDialog = new NewDialog(this.mainFrame, "Load Java Client", true, "Client name", 2);
        }
        ((Window)((Object)nDialog)).setLocationRelativeTo(this.mainFrame);
        ((Component)((Object)nDialog)).setVisible(true);
        if (!nDialog.isOkAction()) {
            return false;
        }
        String new_name = nDialog.getArhName();
        if (new_name != null && !new_name.equals("")) {
            if (!new_name.toLowerCase().endsWith(".jar")) {
                new_name = new_name + ".jar";
            } else if (!new_name.endsWith(".war")) {
                new_name = new_name.substring(0, new_name.length() - 4) + ".jar";
            }
            if (this.checkExistingNode(new_name)) {
                JOptionPane.showMessageDialog(this.mainFrame, "Already exists component with name: " + new_name + ". Please try with other name. \n", "Error", 0);
                return this.addClient(nDialog);
            }
            ClientDescriptorNode node = new ClientDescriptorNode(new_name);
            ApplicationClientDescriptor appDescr = new ApplicationClientDescriptor();
            appDescr.setDisplayName(new_name.substring(0, new_name.lastIndexOf(".")));
            node.setArchiveDescriptor(appDescr);
            node.setAdditionalFiles(this.makeAdditionalFiles(nDialog.getDirNames(), new Vector(), false));
            this.generator.setArchiveDescriptor(new_name, appDescr);
            this.archiveName = this.tab.projectDir + File.separator + new_name;
            node.setArchiveFileName(this.archiveName);
            this.treeModel.insertNodeInto(node, (BasicDescriptorNode)this.treeModel.getRoot(), 0);
            if (this.firstAdd) {
                this.treeModel.reload();
                this.firstAdd = false;
            }
            this.generator.addNewArchive(this.archiveName, 3);
            this.tab.status.setText("Application client is added");
            return true;
        }
        return false;
    }

    protected boolean addConnector(NewDialog nDialog) {
        if (nDialog == null) {
            nDialog = new NewDialog(this.mainFrame, "Load Resource Adapter", true, "Component name", 3);
        }
        ((Window)((Object)nDialog)).setLocationRelativeTo(this.mainFrame);
        ((Component)((Object)nDialog)).setVisible(true);
        JCDescriptor connectorDescr = null;
        if (!nDialog.isOkAction()) {
            return false;
        }
        String new_name = nDialog.getArhName();
        if (new_name != null && !new_name.equals("")) {
            if (!new_name.toLowerCase().endsWith(".rar")) {
                new_name = new_name + ".rar";
            } else if (!new_name.endsWith(".war") || !new_name.endsWith(".jar")) {
                new_name = new_name.substring(0, new_name.length() - 4) + ".rar";
            }
            if (this.checkExistingNode(new_name)) {
                JOptionPane.showMessageDialog(this.mainFrame, "Already exists component with name: " + new_name + ". Please try with other name. \n", "Error", 0);
                return this.addConnector(nDialog);
            }
        }
        ConnectorDescriptorNode node = new ConnectorDescriptorNode(new_name);
        if (!nDialog.createBrandNew()) {
            ResorceAdapterDescriptorDocument resDocument = new ResorceAdapterDescriptorDocument();
            Document doc = null;
            try {
                doc = this.parser.parse(nDialog.getXMLName());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.mainFrame, "Could not open " + nDialog.getXMLName() + "\n" + ex.toString(), "Error", 0);
                return false;
            }
            catch (SAXException saxExc) {
                JOptionPane.showMessageDialog(this.mainFrame, "Could not parse " + nDialog.getXMLName() + "\n" + saxExc.toString(), "Error", 0);
                return false;
            }
            connectorDescr = resDocument.loadDescriptorFromDocument(doc);
        } else {
            connectorDescr = new JCDescriptor();
        }
        if (connectorDescr.getDisplayName() == null || connectorDescr.getDisplayName().equals("")) {
            connectorDescr.setDisplayName(new_name.substring(0, new_name.lastIndexOf(46)));
        }
        node.setArchiveDescriptor(connectorDescr);
        node.setAdditionalFiles(this.makeAdditionalFiles(nDialog.getDirNames(), new Vector(), false));
        this.generator.setArchiveDescriptor(new_name, connectorDescr);
        this.archiveName = this.tab.projectDir + File.separator + new_name;
        node.setArchiveFileName(this.archiveName);
        this.treeModel.insertNodeInto(node, (BasicDescriptorNode)this.treeModel.getRoot(), 0);
        if (this.firstAdd) {
            this.treeModel.reload();
            this.firstAdd = false;
        }
        this.generator.addNewArchive(this.archiveName, 5);
        this.tab.status.setText("Resource Adapter is added");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void makeAllArchives() {
        int i2;
        String[] transInfo22;
        Throwable throwable2;
        block12: {
            String[] transInfo22;
            this.tab.commitSelected();
            int childs = ((DefaultMutableTreeNode)this.tree.getModel().getRoot()).getChildCount();
            if (childs == 0) {
                return;
            }
            this.saveXMLFile();
            XMLComponentsGenerator gen = new XMLComponentsGenerator(this.componentsXML, this.tab.projectDir + File.separator + "j2ee_generator_log.txt");
            try {
                block11: {
                    int i2;
                    String[] transInfo22;
                    try {
                        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
                        int i3 = 0;
                        while (true) {
                            if (i3 >= childs) {
                                gen.makeArchive();
                                this.tab.status.setText("The archives are made successfully!");
                                break block11;
                            }
                            gen.addArchiveDescr(((ArchiveDescriptorNode)root.getChildAt(i3)).getArchiveFileName(), ((ArchiveDescriptorNode)root.getChildAt(i3)).getCurrentDescriptor());
                            ++i3;
                        }
                    }
                    catch (Exception ioe) {
                        this.tab.status.setText("ERROR");
                        JOptionPane.showMessageDialog(this.mainFrame, "Could not make archives. \n" + ioe.toString(), "Error", 0);
                        Object var6_7 = null;
                        transInfo22 = gen.getMadeArchives();
                        if (transInfo22 == null) return;
                        if (transInfo22.length <= 0) return;
                        this.madeArchive = true;
                        i2 = 0;
                    }
                    while (i2 < transInfo22.length) {
                        this.tab.addTransferInfo(transInfo22[i2], null);
                        ++i2;
                    }
                    return;
                }
                Object var6_6 = null;
                transInfo22 = gen.getMadeArchives();
                if (transInfo22 == null) return;
            }
            catch (Throwable throwable2) {
                Object var6_8 = null;
                transInfo22 = gen.getMadeArchives();
                if (transInfo22 == null) throw throwable2;
                if (transInfo22.length <= 0) throw throwable2;
                this.madeArchive = true;
                i2 = 0;
                break block12;
            }
            if (transInfo22.length <= 0) return;
            this.madeArchive = true;
            int i2 = 0;
            while (i2 < transInfo22.length) {
                this.tab.addTransferInfo(transInfo22[i2], null);
                ++i2;
            }
            return;
        }
        while (true) {
            if (i2 >= transInfo22.length) {
                throw throwable2;
            }
            this.tab.addTransferInfo(transInfo22[i2], null);
            ++i2;
        }
    }

    protected void addLastAddFiles(String archiveName, ArchiveDescriptorNode selNode) {
        J2EEArchive j2eearch = new J2EEArchive();
        j2eearch.setFileInfo(selNode.getAdditionalFiles());
        if (j2eearch.getFileInfo() != null) {
            this.generator.addAdditionalFiles(archiveName, j2eearch.getFileInfo());
        } else {
            this.generator.addAdditionalFiles(archiveName, new InfoObject[0]);
        }
    }

    protected void makeArchive() {
        block8: {
            this.tab.commitSelected();
            String name = null;
            ArchiveDescriptorNode parent = null;
            if (!this.tree.getSelectionModel().isSelectionEmpty()) {
                parent = (ArchiveDescriptorNode)this.tree.getSelectionModel().getSelectionPath().getLastPathComponent();
                name = parent.getArchiveFileName();
                try {
                    try {
                        String[] errors;
                        this.saveXMLFile();
                        this.tab.status.setText("Making archive ...");
                        this.addLastAddFiles(name, parent);
                        this.generator.startLog(this.tab.projectDir + File.separator + "j2ee_generator_log.txt");
                        this.generator.addAdditionalClassPath(name, ApplicationInformationProvider.tokenizerToArray(this.classPath, File.pathSeparator));
                        if (parent.getCurrentDescriptor() instanceof EJBJarDescriptor && (errors = this.generator.checkDescriptor(new DynamicClassLoader(this.classPath), (EJBJarDescriptor)parent.getCurrentDescriptor(), parent.getXMLFileName())) != null && errors.length > 0) {
                            String message = "";
                            int i = 0;
                            while (i < errors.length) {
                                message = message + errors[i] + "\n";
                                ++i;
                            }
                            throw new J2EEGeneratorException("Errors in Archive: \n" + message);
                        }
                        this.generator.setArchiveDescriptor(name, parent.getXMLFileName());
                        this.generator.makeArchive(name);
                        this.tab.status.setText("Archive " + name + " is made!");
                        this.tab.addTransferInfo(name, null);
                        this.madeArchive = true;
                    }
                    catch (IOException exc) {
                        this.tab.status.setText("ERROR");
                        this.generator.toLog("STACK TRACE : \n " + this.generator.loadStackTrace(exc));
                        JOptionPane.showMessageDialog(this.mainFrame, "Could not make archive: " + name + "\n" + exc.toString(), "Error", 0);
                        Object var7_9 = null;
                        this.generator.stopLog();
                        break block8;
                    }
                    catch (J2EEGeneratorException genExc) {
                        this.tab.status.setText("ERROR");
                        this.generator.toLog("STACK TRACE : \n " + this.generator.loadStackTrace(genExc));
                        JOptionPane.showMessageDialog(this.mainFrame, "Could not make archive: " + name + "\n" + genExc.toString(), "Error", 0);
                        Object var7_10 = null;
                        this.generator.stopLog();
                    }
                    Object var7_8 = null;
                    this.generator.stopLog();
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    this.generator.stopLog();
                    throw throwable;
                }
            }
        }
    }

    public void setRoot(BasicDescriptorNode _root) {
        this.root = _root;
    }

    public void setTree(JTree tree) {
        this.tree = tree;
    }

    public void setFrame(Frame frame) {
        this.mainFrame = frame;
    }

    public void initOnProjectOpen(String xmlFile, String[] path) throws IOException {
        this.tab.clearOnProjectClose();
        this.classPath = "";
        this.addAdditionalClassPath(path);
        this.tab.status.setText("");
        this.treeModel = (DefaultTreeModel)this.tree.getModel();
        this.tab.getAppInfoProvider().initRenamedHashtable();
        if (this.tab.projectDir == null) {
            this.tab.projectDir = new File(xmlFile).getParentFile();
        }
        if (xmlFile == null) {
            return;
        }
        this.componentsXML = xmlFile;
        this.document = new J2EEGeneratorDoc();
        try {
            this.document.readFromXMLFile(this.componentsXML);
            this.document.loadProjectDir(this.tab.getProjectFileDir());
            J2EEArchive[] archives = this.document.getJ2EEComponentArchive();
            this.initTree(archives);
            this.tab.checkEnable(null);
        }
        catch (J2EEGeneratorException e) {
            throw new IOException(e.toString());
        }
    }

    public void saveXMLFile() {
        J2EEArchive[] archives = null;
        if (((DefaultMutableTreeNode)this.tree.getModel().getRoot()).getChildCount() == 0) {
            if (this.componentsXML != null) {
                this.document = new J2EEGeneratorDoc();
                this.document.loadProjectDir(this.tab.getProjectFileDir());
                this.document.writeToXMLFile(this.componentsXML);
            }
            return;
        }
        int node_count = this.treeModel.getChildCount((BasicDescriptorNode)this.treeModel.getRoot());
        ArchiveDescriptorNode archiveNode = null;
        DescriptorNode[] descriptors = null;
        DescriptorNode descriptor = null;
        String xmlDescriptorName = null;
        String xmlDescriptorName1 = null;
        String xmlDescriptorName2 = null;
        String xmlDescriptorName3 = null;
        String xmlFileName = this.tab.projectDir.getAbsolutePath() + File.separator + "components.xml";
        WebDeploymentDescriptor web = new WebDeploymentDescriptor();
        ApplicationClientDescriptor appClient = new ApplicationClientDescriptor();
        JCDescriptor connector = new JCDescriptor();
        EJBJarDescriptor ejbeanJar = new EJBJarDescriptor();
        archives = new J2EEArchive[node_count];
        if (this.tab.projectDir == null) {
            this.tab.projectDir = new File(SystemProperties.getProperty("user.dir"));
        }
        if (this.componentsXML == null) {
            this.componentsXML = xmlFileName;
        }
        String displayArchiveDD = null;
        int i = 0;
        while (i < node_count) {
            String illegalArgumentException;
            archiveNode = (ArchiveDescriptorNode)this.treeModel.getChild((BasicDescriptorNode)this.treeModel.getRoot(), i);
            archives[i] = new J2EEArchive();
            displayArchiveDD = archiveNode.getName();
            displayArchiveDD = displayArchiveDD.replace('.', '_') + "_DD";
            archives[i].setFileName(this.getRelativePath(archiveNode.getArchiveFileName()));
            int childs = archiveNode.getChildCount();
            descriptors = new DescriptorNode[childs];
            archives[i].setAddClasspath(this.classPath);
            if (archiveNode instanceof EJBJarDescriptorNode) {
                archives[i].setDescriptorIntType(1);
                ejbeanJar = (EJBJarDescriptor)archiveNode.getCurrentDescriptor();
                int child = archiveNode.getChildCount();
                EJBDescriptorNode childNode = null;
                DeploymentDescriptor tempDD = null;
                Vector<DeploymentDescriptor> newDD = new Vector<DeploymentDescriptor>();
                int k = 0;
                while (k < child) {
                    childNode = (EJBDescriptorNode)archiveNode.getChildAt(k);
                    tempDD = (DeploymentDescriptor)childNode.getCurrentDescriptor();
                    newDD.add(tempDD);
                    ++k;
                }
                Object[] descr = new DeploymentDescriptor[newDD.size()];
                newDD.copyInto(descr);
                ejbeanJar.setDescriptors((DeploymentDescriptor[])descr);
                if (archiveNode.getXMLFileName() != null) {
                    xmlDescriptorName = archiveNode.getXMLFileName();
                } else {
                    xmlDescriptorName = this.tab.projectDir + File.separator + displayArchiveDD + ".xml";
                    archiveNode.setXMLFileName(xmlDescriptorName);
                }
            } else if (archiveNode instanceof WebDescriptorNode) {
                archives[i].setDescriptorIntType(4);
                web = (WebDeploymentDescriptor)archiveNode.getCurrentDescriptor();
                web.setServlets(null);
                web.setFilters(null);
                web.setListeners(null);
                if (archiveNode.getXMLFileName() != null) {
                    xmlDescriptorName1 = archiveNode.getXMLFileName();
                } else {
                    xmlDescriptorName1 = this.tab.projectDir + File.separator + displayArchiveDD + ".xml";
                    archiveNode.setXMLFileName(xmlDescriptorName1);
                }
            } else if (archiveNode instanceof ClientDescriptorNode) {
                archives[i].setDescriptorIntType(3);
                appClient = (ApplicationClientDescriptor)archiveNode.getCurrentDescriptor();
                if (archiveNode.getXMLFileName() != null) {
                    xmlDescriptorName2 = archiveNode.getXMLFileName();
                } else {
                    xmlDescriptorName2 = this.tab.projectDir + File.separator + displayArchiveDD + ".xml";
                    archiveNode.setXMLFileName(xmlDescriptorName2);
                }
            } else if (archiveNode instanceof ConnectorDescriptorNode) {
                archives[i].setDescriptorIntType(5);
                connector = (JCDescriptor)archiveNode.getCurrentDescriptor();
                if (archiveNode.getXMLFileName() != null) {
                    xmlDescriptorName3 = archiveNode.getXMLFileName();
                } else {
                    xmlDescriptorName3 = this.tab.projectDir + File.separator + displayArchiveDD + ".xml";
                    archiveNode.setXMLFileName(xmlDescriptorName3);
                }
            }
            archives[i].setFileInfo(archiveNode.getAdditionalFiles());
            int j = 0;
            while (j < childs) {
                descriptors[j] = (DescriptorNode)archiveNode.getChildAt(j);
                descriptor = descriptors[j];
                if (descriptor instanceof EJBDescriptorNode) {
                    if (ejbeanJar.getDisplayName() == null) {
                        ejbeanJar.setDisplayName(new File(this.archiveName).getName().substring(0, new File(this.archiveName).getName().lastIndexOf(".")));
                    }
                } else if (descriptor instanceof ServletDescriptorNode) {
                    if (web.getDisplayName() == null) {
                        web.setDisplayName(new File(this.archiveName).getName().substring(0, new File(this.archiveName).getName().lastIndexOf(".")));
                    }
                    web.addServlet((ServletDescriptor)descriptor.getCurrentDescriptor());
                } else if (descriptor instanceof FilterDescriptorNode) {
                    if (web.getDisplayName() == null) {
                        web.setDisplayName(new File(this.archiveName).getName().substring(0, new File(this.archiveName).getName().lastIndexOf(".")));
                    }
                    web.addFilter((FilterDescriptor)descriptor.getCurrentDescriptor());
                } else if (descriptor instanceof ListenerDescriptorNode) {
                    if (web.getDisplayName() == null) {
                        web.setDisplayName(new File(this.archiveName).getName().substring(0, new File(this.archiveName).getName().lastIndexOf(".")));
                    }
                    web.addListener((ListenerDescriptor)descriptor.getCurrentDescriptor());
                }
                ++j;
            }
            if (archives[i].getDescriptorIntType() == 4) {
                illegalArgumentException = web.saveToFile(xmlDescriptorName1);
                if (illegalArgumentException != null && illegalArgumentException.length() != 0) {
                    JOptionPane.showMessageDialog(this.mainFrame, "These errors occurred during saving of " + new File(xmlDescriptorName1).getName() + " in Components Tab: " + illegalArgumentException, "Illegal Argument Errors", 2);
                }
                archives[i].setDescriptorLocation(this.getRelativePath(xmlDescriptorName1));
            } else if (archives[i].getDescriptorIntType() == 1) {
                this.saveEjbAltDDToFile(xmlDescriptorName, ejbeanJar);
                archives[i].setDescriptorLocation(this.getRelativePath(xmlDescriptorName));
            } else if (archives[i].getDescriptorIntType() == 3) {
                illegalArgumentException = appClient.saveToFile(xmlDescriptorName2);
                if (illegalArgumentException != null && illegalArgumentException.length() != 0) {
                    JOptionPane.showMessageDialog(this.mainFrame, "These errors occurred during saving of " + new File(xmlDescriptorName2).getName() + " in Components Tab: " + illegalArgumentException, "Illegal Argument Errors", 2);
                }
                archives[i].setDescriptorLocation(this.getRelativePath(xmlDescriptorName2));
            } else if (archives[i].getDescriptorIntType() == 5) {
                illegalArgumentException = connector.saveToFile(xmlDescriptorName3);
                if (illegalArgumentException != null && illegalArgumentException.length() != 0) {
                    JOptionPane.showMessageDialog(this.mainFrame, "These errors occurred during saving of " + new File(xmlDescriptorName3).getName() + " in Components Tab: " + illegalArgumentException, "Illegal Argument Errors", 2);
                }
                archives[i].setDescriptorLocation(this.getRelativePath(xmlDescriptorName3));
            }
            archives[i].setFileName(this.getRelativePath(archiveNode.getArchiveFileName()));
            ++i;
        }
        this.document = new J2EEGeneratorDoc();
        this.document.loadProjectDir(this.tab.getProjectFileDir());
        this.document.loadJ2EEArchive(archives);
        this.document.writeToXMLFile(this.componentsXML);
    }

    private void saveEjbAltDDToFile(String xmlDescriptorName, EJBJarDescriptor jar) {
        EJB20DescriptorDocument doc = new EJB20DescriptorDocument();
        doc.setCompliance(false);
        Document document = null;
        try {
            document = doc.loadEJBJarDescriptor(jar);
            this.writer.write(document, xmlDescriptorName, "<!DOCTYPE ejb-jar PUBLIC '-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN' 'http://java.sun.com/dtd/ejb-jar_2_0.dtd'>", "UTF-8");
            String illegalArgumentException = doc.getIllegalArgumentException();
            if (illegalArgumentException != null && illegalArgumentException.length() != 0) {
                JOptionPane.showMessageDialog(this.mainFrame, "These errors occurred during saving of " + new File(xmlDescriptorName).getName() + " in Components Tab: " + illegalArgumentException, "Illegal Argument Errors", 2);
            }
        }
        catch (IllegalArgumentException iaex) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error occurred during saving of " + new File(xmlDescriptorName).getName() + " in J2EE Components Tab: " + iaex, "Illegal Argument Error", 0);
        }
        catch (IOException ioex) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error occurred during saving of " + new File(xmlDescriptorName).getName() + " in J2EE Components Tab: " + ioex, "IO Error", 0);
        }
        catch (Throwable thr) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error occurred during saving of " + new File(xmlDescriptorName).getName() + " in J2EE Components Tab: " + thr, "Error", 0);
        }
    }

    private String[] tokenizertoArray(String temp) {
        Object[] result = null;
        Vector<String> resultV = new Vector<String>();
        StringTokenizer st = new StringTokenizer(temp, ";");
        while (st.hasMoreTokens()) {
            resultV.add(st.nextToken());
        }
        result = new String[resultV.size()];
        resultV.copyInto(result);
        return result;
    }

    protected void initTree(J2EEArchive[] archives) {
        ArchiveDescriptorNode node = null;
        DescriptorNode descriptorNode = null;
        Descriptor[] descriptors = null;
        ServletDescriptor[] servlets = null;
        ListenerDescriptor[] listeners = null;
        FilterDescriptor[] filters = null;
        InfoObject[] infoes = null;
        ArchiveDescriptor archive = null;
        Vector infoVector = new Vector();
        String displayName = null;
        String tempName = null;
        String classpathLocal = null;
        String nodeName = null;
        if (archives != null) {
            int type = -1;
            int i = 0;
            while (i < archives.length) {
                type = archives[i].getDescriptorIntType();
                tempName = archives[i].getFileName();
                nodeName = displayName = tempName.substring(tempName.lastIndexOf(File.separator) + 1, tempName.lastIndexOf("."));
                switch (type) {
                    case 1: {
                        int j;
                        classpathLocal = archives[i].getAddClasspath() + classpathLocal;
                        node = new EJBJarDescriptorNode(displayName);
                        node.setArchiveFileName(tempName);
                        node.setXMLFileName(archives[i].getDescriptorLocation());
                        if (!nodeName.endsWith(".jar")) {
                            nodeName = nodeName + ".jar";
                        }
                        node.setName(nodeName);
                        infoVector = archives[i].getFileInfoVector();
                        infoes = archives[i].getFileInfo();
                        this.generator.addAdditionalFiles(tempName, infoes);
                        node.setAdditionalFiles(infoVector);
                        node.setBaseAddFiles(infoVector);
                        this.generator.addNewArchive(tempName, 1);
                        this.archiveName = tempName;
                        if (archives[i].getDescriptorLocation() != null) {
                            try {
                                archive = this.generator.getConvertedEJBDescriptor(new DynamicClassLoader(this.classPath), archives[i].getDescriptorLocation(), false);
                            }
                            catch (J2EEGeneratorException ex) {
                                JOptionPane.showMessageDialog(this.mainFrame, StringCutter.stringFrameCut("Exception occurred while loading xml " + archives[i].getDescriptorLocation() + " \n " + ex.toString(), this.mainFrame), "Error", 0);
                                return;
                            }
                            archive.setSmallIcon(this.validateIcons(infoVector, archive.getSmallIcon()));
                            archive.setLargeIcon(this.validateIcons(infoVector, archive.getLargeIcon()));
                            this.treeModel.insertNodeInto(node, (BasicDescriptorNode)this.treeModel.getRoot(), i);
                            if (this.firstAdd) {
                                this.treeModel.reload();
                                this.firstAdd = false;
                            }
                            TreeUtils.expandTree((JTree)this.tree, (int)2);
                            descriptors = ((EJBJarDescriptor)archive).getDDescriptors();
                            archive.setDescriptors(descriptors);
                            node.setArchiveDescriptor(archive);
                            this.generator.setArchiveDescriptor(tempName, archive);
                            String[] paths = new String[]{classpathLocal};
                            this.generator.addAdditionalClassPath(tempName, paths);
                            this.treeModel.reload();
                            TreeUtils.expandTree((JTree)this.tree, (int)2);
                            if (descriptors != null) {
                                SerializableFile icon = null;
                                j = 0;
                                while (j < descriptors.length) {
                                    icon = this.validateIcons(infoVector, ((DeploymentDescriptor)descriptors[j]).getSmallIcon());
                                    if (icon != null) {
                                        ((DeploymentDescriptor)descriptors[j]).setSmallIcon(icon.getAbsoluteFilePath());
                                    }
                                    if ((icon = this.validateIcons(infoVector, ((DeploymentDescriptor)descriptors[j]).getLargeIcon())) != null) {
                                        ((DeploymentDescriptor)descriptors[j]).setLargeIcon(icon.getAbsoluteFilePath());
                                    }
                                    descriptorNode = new EJBDescriptorNode(((DeploymentDescriptor)descriptors[j]).getDisplayName());
                                    descriptorNode.setDescriptor(descriptors[j]);
                                    descriptorNode.setXMLFileName(archives[i].getDescriptorLocation());
                                    node.add(descriptorNode);
                                    this.treeModel.reload();
                                    TreeUtils.expandTree((JTree)this.tree, (int)2);
                                    ++j;
                                }
                            }
                        }
                        this.tab.getAppInfoProvider().setClassPath(classpathLocal);
                        break;
                    }
                    case 4: {
                        int j;
                        node = new WebDescriptorNode(displayName);
                        node.setArchiveFileName(tempName);
                        if (!nodeName.endsWith(".war")) {
                            nodeName = nodeName + ".war";
                        }
                        node.setName(nodeName);
                        infoVector = archives[i].getFileInfoVector();
                        infoes = archives[i].getFileInfo();
                        node.setAdditionalFiles(infoVector);
                        node.setBaseAddFiles(infoVector);
                        this.generator.addAdditionalFiles(tempName, infoes);
                        this.generator.addNewArchive(tempName, 4);
                        node.setXMLFileName(archives[i].getDescriptorLocation());
                        this.treeModel.insertNodeInto(node, (BasicDescriptorNode)this.treeModel.getRoot(), i);
                        if (this.firstAdd) {
                            this.treeModel.reload();
                            this.firstAdd = false;
                        }
                        if (archives[i].getDescriptorLocation() != null) {
                            try {
                                archive = this.generator.getConvertedWebDescriptor(archives[i].getDescriptorLocation());
                            }
                            catch (J2EEGeneratorException ex) {
                                JOptionPane.showMessageDialog(this.mainFrame, "Exception occurred while loading xml " + archives[i].getDescriptorLocation() + " \n " + ex.toString(), "Error", 0);
                                return;
                            }
                            archive.setSmallIcon(this.validateIcons(infoVector, archive.getSmallIcon()));
                            archive.setLargeIcon(this.validateIcons(infoVector, archive.getLargeIcon()));
                            servlets = ((WebDeploymentDescriptor)archive).getServlets();
                            listeners = ((WebDeploymentDescriptor)archive).getListenersDescriptor();
                            filters = ((WebDeploymentDescriptor)archive).getFilters();
                            node.setArchiveDescriptor(archive);
                            this.generator.setArchiveDescriptor(tempName, archive);
                            int index = 0;
                            String webComponentName = null;
                            if (servlets != null) {
                                j = 0;
                                while (j < servlets.length) {
                                    servlets[j].setSmallIcon(this.validateIcons(infoVector, servlets[j].getSmallIcon()));
                                    servlets[j].setLargeIcon(this.validateIcons(infoVector, servlets[j].getLargeIcon()));
                                    webComponentName = servlets[j].getDisplayName();
                                    if (webComponentName == null || webComponentName.equals("")) {
                                        webComponentName = servlets[j].getName();
                                    }
                                    descriptorNode = new ServletDescriptorNode(webComponentName);
                                    descriptorNode.setDescriptor(servlets[j]);
                                    descriptorNode.setXMLFileName(archives[i].getDescriptorLocation());
                                    this.treeModel.insertNodeInto(descriptorNode, node, index);
                                    ++j;
                                    ++index;
                                }
                            }
                            if (listeners != null) {
                                j = 0;
                                while (j < listeners.length) {
                                    descriptorNode = new ListenerDescriptorNode(listeners[j].getName());
                                    descriptorNode.setDescriptor(listeners[j]);
                                    descriptorNode.setXMLFileName(archives[i].getDescriptorLocation());
                                    this.treeModel.insertNodeInto(descriptorNode, node, index);
                                    ++j;
                                    ++index;
                                }
                            }
                            if (filters != null) {
                                j = 0;
                                while (j < filters.length) {
                                    filters[j].setSmallIcon(this.validateIcons(infoVector, filters[j].getSmallIcon()));
                                    filters[j].setLargeIcon(this.validateIcons(infoVector, filters[j].getLargeIcon()));
                                    webComponentName = filters[j].getDisplayName();
                                    if (webComponentName == null || webComponentName.equals("")) {
                                        webComponentName = filters[j].getName();
                                    }
                                    descriptorNode = new FilterDescriptorNode(webComponentName);
                                    descriptorNode.setDescriptor(filters[j]);
                                    descriptorNode.setXMLFileName(archives[i].getDescriptorLocation());
                                    this.treeModel.insertNodeInto(descriptorNode, node, index);
                                    ++j;
                                    ++index;
                                }
                            }
                        }
                        TreeUtils.expandTree((JTree)this.tree, (int)2);
                        break;
                    }
                    case 3: {
                        node = new ClientDescriptorNode(displayName);
                        archive = new ApplicationClientDescriptor();
                        archive.loadFromFile(archives[i].getDescriptorLocation());
                        node.setXMLFileName(archives[i].getDescriptorLocation());
                        node.setArchiveFileName(tempName);
                        infoVector = archives[i].getFileInfoVector();
                        infoes = archives[i].getFileInfo();
                        this.generator.addAdditionalFiles(tempName, infoes);
                        node.setAdditionalFiles(infoVector);
                        node.setBaseAddFiles(infoVector);
                        archive.setSmallIcon(this.validateIcons(infoVector, archive.getSmallIcon()));
                        archive.setLargeIcon(this.validateIcons(infoVector, archive.getLargeIcon()));
                        if (!nodeName.endsWith(".jar")) {
                            nodeName = nodeName + ".jar";
                        }
                        node.setName(nodeName);
                        node.setArchiveDescriptor(archive);
                        this.generator.addNewArchive(tempName, 3);
                        this.generator.setArchiveDescriptor(tempName, archive);
                        this.treeModel.insertNodeInto(node, (BasicDescriptorNode)this.treeModel.getRoot(), i);
                        if (!this.firstAdd) break;
                        this.treeModel.reload();
                        this.firstAdd = false;
                        break;
                    }
                    case 5: {
                        node = new ConnectorDescriptorNode(displayName);
                        archive = new JCDescriptor();
                        archive.loadFromFile(archives[i].getDescriptorLocation());
                        node.setXMLFileName(archives[i].getDescriptorLocation());
                        node.setArchiveFileName(tempName);
                        infoVector = archives[i].getFileInfoVector();
                        infoes = archives[i].getFileInfo();
                        this.generator.addAdditionalFiles(tempName, infoes);
                        node.setAdditionalFiles(infoVector);
                        node.setBaseAddFiles(infoVector);
                        archive.setSmallIcon(this.validateIcons(infoVector, archive.getSmallIcon()));
                        archive.setLargeIcon(this.validateIcons(infoVector, archive.getLargeIcon()));
                        if (!nodeName.endsWith(".rar")) {
                            nodeName = nodeName + ".rar";
                        }
                        node.setName(nodeName);
                        node.setArchiveDescriptor(archive);
                        this.generator.addNewArchive(tempName, 5);
                        this.generator.setArchiveDescriptor(tempName, archive);
                        this.treeModel.insertNodeInto(node, (BasicDescriptorNode)this.treeModel.getRoot(), i);
                        if (!this.firstAdd) break;
                        this.treeModel.reload();
                        this.firstAdd = false;
                    }
                }
                ++i;
            }
            if (classpathLocal != null && !classpathLocal.equals("")) {
                this.addAdditionalClassPath(ApplicationInformationProvider.tokenizerToArray(classpathLocal, File.pathSeparator));
            }
        }
    }

    private SerializableFile validateIcons(Vector additional, SerializableFile file) {
        if (additional == null || file == null) {
            return file;
        }
        String fileName = file.getFileName();
        Object obj = null;
        int i = 0;
        while (i < additional.size()) {
            obj = additional.elementAt(i);
            if (obj != null && obj instanceof InfoObject && ((InfoObject)obj).getEntryName() != null && ((InfoObject)obj).getEntryName().equals(fileName)) {
                return new SerializableFile(((InfoObject)obj).getFilePath());
            }
            ++i;
        }
        return file;
    }

    private boolean renameAction() {
        String result;
        BasicDescriptorNode parental = (BasicDescriptorNode)this.tree.getSelectionModel().getSelectionPath().getLastPathComponent();
        if (parental instanceof ArchiveDescriptorNode) {
            RenameDialog dialog = new RenameDialog(this.tab.projectDir.getAbsolutePath(), this.mainFrame);
            this.generator.startLog(this.tab.projectDir + File.separator + "j2ee_generator_log.txt");
            String lastPath = parental.getArchiveFileName();
            this.generator.toLog("Start rename archive " + lastPath);
            dialog.setPath(lastPath);
            if (parental instanceof ClientDescriptorNode) {
                dialog.setType((byte)0);
            } else if (parental instanceof ConnectorDescriptorNode) {
                dialog.setType((byte)2);
            } else if (parental instanceof EJBJarDescriptorNode) {
                dialog.setType((byte)0);
            } else if (parental instanceof WebDescriptorNode) {
                dialog.setType((byte)1);
            }
            ((Component)((Object)dialog)).setVisible(true);
            String newPath = dialog.getPath();
            this.generator.toLog("New name: " + newPath);
            if (lastPath.equals(newPath)) {
                this.generator.toLog("Old and new names are the same.");
                this.generator.stopLog();
                return true;
            }
            File lastFile = new File(lastPath);
            if (!lastFile.exists()) {
                lastFile = new File(this.tab.projectDir.getAbsolutePath() + File.separator + lastPath);
                if (lastFile.exists()) {
                    lastPath = this.tab.projectDir.getAbsolutePath() + File.separator + lastPath;
                } else {
                    this.renameAltDDs(parental, newPath);
                    this.addToNode(parental, newPath);
                    this.renameManifestFile(lastPath, newPath);
                    this.tab.getAppInfoProvider().saveRenameInformation(lastPath, newPath);
                    this.generator.toLog("Rename successful");
                    this.generator.stopLog();
                    return true;
                }
            }
            File newFile = new File(newPath);
            if (newPath.substring(0, newPath.lastIndexOf(File.separator)).equals(lastPath.substring(0, lastPath.lastIndexOf(File.separator)))) {
                if (!lastFile.renameTo(newFile)) {
                    this.generator.toLog("ERROR Cannot rename archive");
                    this.generator.stopLog();
                    return false;
                }
            } else {
                File backup = null;
                if (newFile.exists()) {
                    newFile.renameTo(new File(newPath + ".bac"));
                    backup = newFile;
                    newFile = new File(newPath);
                }
                try {
                    FileUtils.copyFile(lastFile, newFile);
                }
                catch (IOException io) {
                    io.printStackTrace();
                    if (backup != null) {
                        backup.renameTo(new File(newPath));
                    }
                    this.generator.toLog("ERROR Cannot rename archive");
                    this.generator.stopLog();
                    return false;
                }
                lastFile.delete();
            }
            this.renameAltDDs(parental, newPath);
            this.addToNode(parental, newPath);
            this.renameManifestFile(lastPath, newPath);
            this.tab.getAppInfoProvider().saveRenameInformation(lastPath, newPath);
            this.tab.addTransferInfo(newPath, lastPath);
            this.saveXMLFile();
            this.generator.toLog("Rename successful");
            this.generator.stopLog();
        } else if (parental instanceof DescriptorNode && (result = JOptionPane.showInputDialog(this.mainFrame, "Enter new name.", "Rename", 1)) != null && !result.equals("")) {
            this.tab.setDisplayName(result);
            ((DescriptorNode)parental).setName(result);
        }
        return true;
    }

    private boolean renameAltDDs(BasicDescriptorNode parental, String newPath) {
        boolean result = false;
        if (((ArchiveDescriptorNode)parental).getXMLFileName() != null) {
            this.generator.toLog("Rename alternative xml " + ((ArchiveDescriptorNode)parental).getXMLFileName());
            File altXML = new File(((ArchiveDescriptorNode)parental).getXMLFileName());
            if (altXML.exists() && (result = altXML.renameTo(new File(this.tab.projectDir.getAbsolutePath() + File.separator + newPath.substring(newPath.lastIndexOf(File.separator) + File.separator.length()).replace('.', '_') + "_DD.xml")))) {
                parental.setXMLFileName(this.tab.projectDir.getAbsolutePath() + File.separator + newPath.substring(newPath.lastIndexOf(File.separator) + File.separator.length()).replace('.', '_') + "_DD.xml");
            }
        } else {
            result = true;
        }
        return result;
    }

    private void addToNode(BasicDescriptorNode parental, String newPath) {
        parental.setArchiveFileName(newPath);
        if (newPath.lastIndexOf(File.separator) != -1) {
            this.tab.setDisplayName(newPath.substring(newPath.lastIndexOf(File.separator) + File.separator.length()));
            parental.setName(newPath.substring(newPath.lastIndexOf(File.separator) + File.separator.length()));
        } else {
            this.tab.setDisplayName(newPath);
            parental.setName(newPath);
        }
        int type = 1;
        if (parental instanceof ClientDescriptorNode) {
            type = 3;
        } else if (parental instanceof ConnectorDescriptorNode) {
            type = 5;
        } else if (parental instanceof EJBJarDescriptorNode) {
            type = 1;
        } else if (parental instanceof WebDescriptorNode) {
            type = 4;
        }
        this.generator.addNewArchive(newPath, type);
    }

    private void renameManifestFile(String lastPath, String newMFPath) {
        int index = lastPath.lastIndexOf(46);
        String oldPath = lastPath.substring(0, index) + '_' + lastPath.substring(index + 1) + ".mf";
        File mfFile = new File(oldPath);
        this.generator.toLog("Rename manifest file: " + mfFile.getAbsolutePath());
        if (mfFile.exists()) {
            index = newMFPath.lastIndexOf(46);
            File newFile = new File(newMFPath.substring(0, index) + '_' + newMFPath.substring(index + 1) + ".mf");
            if (newFile.exists()) {
                newFile.delete();
            }
            if (mfFile.getParent().equals(newFile.getParent())) {
                mfFile.renameTo(newFile);
            } else {
                try {
                    FileUtils.copyFile(mfFile, newFile);
                }
                catch (IOException io) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Rename failed.\n " + io.toString(), "Rename failed.", 0);
                }
                catch (Throwable th) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Rename failed.\n " + th.toString(), "Rename failed.", 0);
                }
                mfFile.delete();
            }
            Vector infoes = ((ArchiveDescriptorNode)this.tab.lastSelectedNode).getAdditionalFiles();
            if (infoes != null) {
                InfoObject temp = null;
                int i = 0;
                while (i < infoes.size()) {
                    if (infoes.get(i) instanceof InfoObject && (temp = (InfoObject)infoes.get(i)).getFilePath().equals(oldPath)) {
                        temp.setFilePath(newFile.getAbsolutePath());
                    }
                    ++i;
                }
            }
        }
    }

    public void setClasspath(String[] path) {
        if (path == null) {
            this.classPath = "";
            this.tab.getAppInfoProvider().setClassPath((String)null);
            return;
        }
        this.classPath = "";
        int i = 0;
        while (i < path.length) {
            this.classPath = this.classPath + path[i] + File.pathSeparator;
            ++i;
        }
        this.tab.setLoader(new DynamicClassLoader(this.classPath));
        this.tab.getAppInfoProvider().setClassPath(this.classPath);
    }

    private void addAdditionalClassPath(String[] path) {
        String newPath = null;
        int consist = -1;
        int i = 0;
        while (i < path.length) {
            consist = -1;
            newPath = path[i];
            if (newPath != null && !newPath.equals("") && !newPath.equals("null") && (consist = this.classPath.indexOf(newPath)) == -1) {
                this.classPath = this.classPath + path[i] + File.pathSeparator;
            }
            ++i;
        }
        String[] clsPaths = ApplicationInformationProvider.tokenizerToArray(this.classPath, File.pathSeparator);
        if (clsPaths == null) {
            clsPaths = new String[]{};
        }
        this.tab.setLoader(new DynamicClassLoader(this.classPath));
        BasicDescriptorNode node = null;
        int childs = ((DefaultMutableTreeNode)this.tree.getModel().getRoot()).getChildCount();
        if (childs == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < childs) {
            node = (BasicDescriptorNode)((DefaultTreeModel)this.tree.getModel()).getChild((DefaultMutableTreeNode)this.tree.getModel().getRoot(), i2);
            this.generator.addAdditionalClassPath(node.getArchiveFileName(), clsPaths);
            ++i2;
        }
    }

    private String getRelativePath(String fileName) {
        if (fileName == null) {
            return null;
        }
        int projDirLength = this.tab.dlpFileDir.length();
        String result = null;
        result = fileName.indexOf(this.tab.dlpFileDir) != -1 ? fileName.substring(projDirLength) : fileName;
        return result;
    }

    public boolean isCheckNeeded() {
        return this.tab.checkNeeded;
    }

    public void setCheckNeeded(boolean checkNeeded) {
        this.tab.checkNeeded = checkNeeded;
    }

    public String[] getClassPath() {
        return ApplicationInformationProvider.tokenizerToArray(this.classPath, File.pathSeparator);
    }

    public void addServlJspFormAction() {
        TreePath selectPath = this.tree.getSelectionModel().getSelectionPath();
        if (selectPath == null) {
            return;
        }
        WebDescriptorNode node = (WebDescriptorNode)selectPath.getLastPathComponent();
        Vector addFiles = node.getAdditionalFiles();
        if (addFiles == null || addFiles.size() == 0) {
            JOptionPane.showMessageDialog(this.mainFrame, "No additional files available. ", "Could not add servlet or jsp", 1);
            return;
        }
        Vector servlJsp = new Vector();
        J2EEArchive arch = new J2EEArchive();
        arch.setFileInfo(addFiles);
        InfoObject[] infoes = arch.getFileInfo();
        this.findServlets(servlJsp, infoes);
        this.findJsp(servlJsp, infoes);
        Object[] foundServlJsp = null;
        if (servlJsp.size() == 0) {
            JOptionPane.showMessageDialog(this.mainFrame, "No servlet or jsp found in additional files of current archive.", "Could not add servlet or jsp", 1);
            return;
        }
        foundServlJsp = new String[servlJsp.size()];
        servlJsp.copyInto(foundServlJsp);
        if (this.servletDialog == null) {
            this.servletDialog = new ServletJSPDialog(this.mainFrame);
            this.servletDialog.initData((String[])foundServlJsp);
            ((Dialog)((Object)this.servletDialog)).show();
        } else {
            this.servletDialog.updateData((String[])foundServlJsp);
            ((Dialog)((Object)this.servletDialog)).show();
        }
        ServletDescriptor[] descriptors = this.servletDialog.getDescriptors();
        if (!this.servletDialog.isOk() || descriptors == null || descriptors.length == 0) {
            return;
        }
        TreePath path = this.tree.getLeadSelectionPath();
        WebDescriptorNode webNode = (WebDescriptorNode)path.getLastPathComponent();
        boolean hasToOverwrite = false;
        int j = 0;
        while (j < descriptors.length) {
            if (this.findServletByName(descriptors[j].getName(), webNode) != -1) {
                int option = JOptionPane.showConfirmDialog(this.mainFrame, "You have tried to add jsp and servlets with duplicated names.\nDo you want to overwrite old components?", "Warning", 0);
                if (option != 0) break;
                hasToOverwrite = true;
                break;
            }
            ++j;
        }
        int childIndex = -1;
        int i = 0;
        while (i < descriptors.length) {
            childIndex = this.findServletByName(descriptors[i].getName(), webNode);
            this.descriptorNode = new ServletDescriptorNode(descriptors[i].getName());
            this.descriptorNode.setDescriptor(descriptors[i]);
            if (childIndex == -1) {
                this.treeModel.insertNodeInto(this.descriptorNode, webNode, 0);
            } else if (hasToOverwrite) {
                this.removeServlet((ServletDescriptorNode)webNode.getChildAt(childIndex));
                this.treeModel.insertNodeInto(this.descriptorNode, webNode, 0);
            }
            ++i;
        }
        this.treeModel.reload();
        TreeUtils.expandTree((JTree)this.tree, (int)2);
        this.tab.updateWebPanel();
        this.tab.checkEnable(null);
        this.tab.checkNeeded = true;
        this.tab.repaint();
    }

    private void removeServlet(ServletDescriptorNode servletNode) {
        ArchiveDescriptorNode parent = (ArchiveDescriptorNode)servletNode.getParent();
        String parent_name = parent.getName();
        String name = servletNode.getCurrentDescriptor().getName();
        String temp_parent = this.tab.projectDir + File.separator + parent_name + ".war";
        this.generator.removeComponentFromArchive(temp_parent, name);
        ArchiveDescriptor archiveD = parent.getCurrentDescriptor();
        Descriptor[] descr = archiveD.getDescriptors();
        descr = archiveD.removeElement(descr, servletNode.getCurrentDescriptor());
        archiveD.setDescriptors(descr);
        parent.setModifiedDescriptor(archiveD);
        this.treeModel.removeNodeFromParent(servletNode);
    }

    private int findServletByName(String name, WebDescriptorNode parent) {
        int i = 0;
        while (i < parent.getChildCount()) {
            if (((ServletDescriptor)((ServletDescriptorNode)parent.getChildAt(i)).getCurrentDescriptor()).getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void findServlets(Vector servlJsp, InfoObject[] infoes) {
        String servlClass = null;
        String path = null;
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (infoes == null) {
            return;
        }
        int i = 0;
        while (i < infoes.length) {
            path = infoes[i].getFilePath();
            if (path.endsWith(".class") && (servlClass = this.loadServlet(path, infoes, i)) != null && !table.containsKey(servlClass)) {
                table.put(servlClass, infoes[i].getFilePath());
                servlJsp.add(servlClass);
            }
            ++i;
        }
    }

    private void findJsp(Vector servlJsp, InfoObject[] infoes) {
        if (infoes == null) {
            return;
        }
        int i = 0;
        while (i < infoes.length) {
            if (infoes[i].getEntryName().toLowerCase().endsWith(".jsp") || infoes[i].getEntryName().toLowerCase().endsWith(".jspf") || infoes[i].getEntryName().toLowerCase().endsWith(".jsf")) {
                servlJsp.add(infoes[i].getEntryName());
            }
            ++i;
        }
    }

    private String loadServlet(String className, InfoObject[] infoes, int index) {
        String nodeClassPath = new String();
        int i = 0;
        while (i < infoes.length) {
            if ((infoes[i].getFilePath().toLowerCase().endsWith(".jar") || infoes[i].getFilePath().toLowerCase().endsWith(".zip")) && infoes[i].getEntryName().toLowerCase().startsWith("web-inf/lib")) {
                nodeClassPath = nodeClassPath + infoes[i].getFilePath() + File.pathSeparator;
            }
            ++i;
        }
        String loaderClassPath = "." + File.pathSeparator + this.classPath + File.pathSeparator + nodeClassPath;
        String token = className.substring(0, className.lastIndexOf(File.separator) + 1);
        LocalLoader loader = null;
        Class<?> c = null;
        if (className.toLowerCase().endsWith(".class")) {
            className = className.substring(0, className.length() - 6);
        }
        while (token != null && token != "" && token.lastIndexOf(File.separator) != -1) {
            try {
                loader = new LocalLoader(loaderClassPath + token + File.pathSeparator);
                if (!className.startsWith(token)) break;
                c = loader.loadClass(className.substring(token.length()).replace(File.separatorChar, '.'));
                break;
            }
            catch (Exception cnfex) {
                JOptionPane.showMessageDialog(this.mainFrame, "Error occurred while loading servlet class:\n" + cnfex.toString(), "Error", 0);
                return null;
            }
            catch (NoClassDefFoundError thr) {
                JOptionPane.showMessageDialog(this.mainFrame, "Error occurred while loading servlet class:\n" + thr.toString(), "Error", 0);
                token = token.substring(0, token.substring(0, token.length() - 1).lastIndexOf(File.separator) + 1);
            }
        }
        if (c == null) {
            return null;
        }
        String entry = "";
        try {
            if ((class$javax$servlet$Servlet == null ? (class$javax$servlet$Servlet = ComponentsActionManager.class$("javax.servlet.Servlet")) : class$javax$servlet$Servlet).isAssignableFrom(c)) {
                if ((className = className + ".class") != null && className.equals(infoes[index].getFilePath())) {
                    entry = infoes[index].getEntryName();
                    if (entry != null && entry != "" && token.length() >= 1 && !(entry = entry.replace(File.separatorChar, '/')).endsWith(className.substring(token.length() - 1).replace(File.separatorChar, '/'))) {
                        entry = entry.lastIndexOf(47) != -1 ? entry.substring(0, entry.lastIndexOf(47)) + className.substring(token.length() - 1) : className.substring(token.length() - 1);
                    }
                    if (entry != null) {
                        entry = entry.replace(File.separatorChar, '/');
                    }
                    infoes[index].setEntryName(entry);
                }
                return c.getName();
            }
            return null;
        }
        catch (Throwable tr) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error occurred while loading servlet class:\n" + tr.toString(), "Error", 0);
            return null;
        }
    }

    public boolean hasMadeArchive() {
        return this.madeArchive;
    }

    public void setMadeArchive(boolean hasMade) {
        this.madeArchive = hasMade;
    }

    private boolean addFilter(ArchiveDescriptorNode parent) {
        String new_name = JOptionPane.showInputDialog(this.mainFrame, (Object)"Insert name for filter:");
        if (new_name != null && !new_name.trim().equals("")) {
            if (!this.checkExistingChild(parent, new_name)) {
                if (parent instanceof WebDescriptorNode) {
                    this.descriptorNode = new FilterDescriptorNode(new_name);
                    FilterDescriptor filterDescr = new FilterDescriptor();
                    filterDescr.setName(new_name);
                    filterDescr.setDisplayName(new_name);
                    this.descriptorNode.setDescriptor(filterDescr);
                    this.generator.setDescriptor(parent.getArchiveFileName(), new_name, filterDescr);
                    int count = parent.getChildCount();
                    if (count != 0) {
                        this.treeModel.insertNodeInto(this.descriptorNode, parent, count);
                    } else {
                        try {
                            this.treeModel.insertNodeInto(this.descriptorNode, parent, 0);
                        }
                        catch (Exception exc) {
                            JOptionPane.showMessageDialog(this.mainFrame, "Could not add Filter \n", "Error", 0);
                            return false;
                        }
                    }
                    TreeUtils.expandTree((JTree)this.tree, (int)2);
                    this.tab.updateWebPanel();
                }
                this.tab.status.setText("Web component is added to archive: " + parent.getName());
                return true;
            }
            return this.addFilter(parent);
        }
        return false;
    }

    private boolean addListener(ArchiveDescriptorNode parent) {
        String new_name = JOptionPane.showInputDialog(this.mainFrame, (Object)"Insert name of the listener class:");
        if (new_name != null && !new_name.trim().equals("")) {
            if (!this.checkExistingChild(parent, new_name)) {
                if (parent instanceof WebDescriptorNode) {
                    this.descriptorNode = new ListenerDescriptorNode(new_name);
                    ListenerDescriptor listenerDescr = new ListenerDescriptor();
                    listenerDescr.setName(new_name);
                    this.descriptorNode.setDescriptor(listenerDescr);
                    this.generator.setDescriptor(parent.getArchiveFileName(), new_name, listenerDescr);
                    int count = parent.getChildCount();
                    if (count != 0) {
                        this.treeModel.insertNodeInto(this.descriptorNode, parent, count);
                    } else {
                        try {
                            this.treeModel.insertNodeInto(this.descriptorNode, parent, 0);
                        }
                        catch (Exception exc) {
                            JOptionPane.showMessageDialog(this.mainFrame, "Could not add Listener \n", "Error", 0);
                            return false;
                        }
                    }
                    TreeUtils.expandTree((JTree)this.tree, (int)2);
                }
                this.tab.status.setText("Web component is added to archive: " + parent.getName());
                return true;
            }
            return this.addListener(parent);
        }
        return false;
    }

    public File getLogFile() {
        return this.logFile;
    }

    private Vector makeAdditionalFiles(String[] dir, Vector addFiles, boolean isWeb) {
        if (dir != null) {
            int i = 0;
            while (i < dir.length) {
                if (dir[i] != null || new File(dir[i]).exists()) {
                    if (isWeb) {
                        Properties p = new Properties();
                        p.setProperty(".class", "WEB-INF/classes");
                        p.setProperty(".jar", "WEB-INF/lib");
                        addFiles = this.tab.getAppInfoProvider().getAllMappings(dir[i], p, addFiles);
                    } else {
                        addFiles = this.tab.getAppInfoProvider().getAllMappings(dir[i], null, addFiles);
                    }
                }
                ++i;
            }
        }
        return addFiles;
    }

    private void findSubDirs(String dir, Vector dirs, boolean isWeb) {
        File tempDir = new File(dir);
        MappingObject tempMapping = null;
        File[] children = tempDir.listFiles();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                tempDir = children[i];
                if (tempDir.isDirectory()) {
                    tempMapping = new MappingObject();
                    tempMapping.setFilePath(tempDir.getAbsolutePath());
                    if (isWeb) {
                        Properties mappings = new Properties();
                        mappings.setProperty(".class", "WEB-INF/classes");
                        tempMapping.setMappings(mappings);
                    }
                    if (!dirs.contains(tempMapping)) {
                        dirs.add(tempMapping);
                        this.findSubDirs(tempDir.getAbsolutePath(), dirs, isWeb);
                    }
                }
                ++i;
            }
        }
    }

    public String getComponentsXML() {
        return this.componentsXML;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setComponentsXML(String componentsXML) {
        this.componentsXML = componentsXML;
    }

    private void initXMLToolkit() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.writer = new StandardDOMWriter();
        this.parser = new StandardDOMParser();
        Thread.currentThread().setContextClassLoader(cl);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

