/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool.components;

import com.sap.engine.deploy.ejb.descriptors.xml.EJBJarParser;
import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.services.deploy.gui.SFileChooser;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BeanDialog
extends CEscapeDialog
implements ActionListener,
DocumentListener,
KeyListener {
    public static final String ENTITY_BEAN = "ENTITY_BEAN";
    public static final String SESSION_BEAN = "SESSION_BEAN";
    public static final String MESSAGE_DRIVEN_BEAN = "MESSAGE_DRIVEN_BEAN";
    public static final String OK_CMD = "OK_CMD";
    public static final String CANCEL_CMD = "CANCEL_CMD";
    public static final String BROWSE1_CMD = "BROWSE1_CMD";
    public static final String BROWSE2_CMD = "BROWSE2_CMD";
    public static final String NEW_CMD = "NEW_CMD";
    public static final String LOAD_CMD = "LOAD_CMD";
    public static final String ENTITY_CMD = "ENTITY_CMD";
    public static final String SESSION_CMD = "SESSION_CMD";
    public static final String MESSAGE_DRIVEN_CMD = "MESSAGE_DRIVEN_CMD";
    public static String EJB_NAME = "EJB Name:";
    public static String EJB_JAR_NAME = "EJB Jar Name:";
    protected SFileChooser chooser = null;
    protected Frame frame;
    protected boolean isOkAction = false;
    protected boolean createNew = true;
    private String type = "ENTITY_BEAN";
    protected String beanName = null;
    private String archiveName = null;
    private String classPaths = null;
    protected String xmlFileName = null;
    private DeploymentDescriptor descriptor = null;
    JPanel panel1 = new JPanel();
    JPanel loadPanel = new JPanel();
    JPanel newPanel = new JPanel();
    JPanel buttonsPanel = new JPanel();
    JLabel nameLabel1 = new JLabel();
    JLabel xmlLabel = new JLabel();
    JLabel nameLabel2 = new JLabel();
    JLabel dirLabel = new JLabel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JRadioButton makeNewButton = new JRadioButton();
    JRadioButton sessionButton = new JRadioButton();
    JRadioButton messageDrivenButton = new JRadioButton();
    JRadioButton entityButton = new JRadioButton();
    JRadioButton loadButton = new JRadioButton();
    ButtonGroup group1 = new ButtonGroup();
    ButtonGroup group2 = new ButtonGroup();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    TitledBorder titledBorder2;
    Border border3;
    TitledBorder titledBorder3;
    JTextField jTextField1 = new JTextField();
    JTextField jTextField2 = new JTextField();
    JTextField jTextField3 = new JTextField();
    JTextField jTextField4 = new JTextField();
    JComboBox comboBox = new JComboBox();
    JButton cancelButton = new JButton();
    JButton okButton = new JButton();
    JButton browseButton1 = new JButton();
    JButton browseButton2 = new JButton();

    public BeanDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.frame = frame;
        try {
            this.jbInit();
            ((Window)((Object)this)).pack();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(frame, "Could not initialize bean dialog.\n " + ex.toString(), "Error", 0);
        }
    }

    public BeanDialog() {
        this(null, "", false);
    }

    void jbInit() throws Exception {
        ((Component)((Object)this)).addKeyListener(this);
        this.jTextField2.getDocument().addDocumentListener(this);
        this.jTextField3.getDocument().addDocumentListener(this);
        this.comboBox.setEnabled(false);
        this.entityButton.setSelected(true);
        this.makeNewButton.setSelected(true);
        this.disableLoad();
        this.border1 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), "EJB Type");
        this.border2 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.titledBorder2 = new TitledBorder(this.border2, "New EJB");
        this.border3 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.titledBorder3 = new TitledBorder(this.border3, "Load EJB");
        this.panel1.setLayout(this.gridBagLayout1);
        this.nameLabel1.setText("Bean Name:");
        this.makeNewButton.setText("Make New EJB:");
        this.makeNewButton.addActionListener(this);
        this.makeNewButton.setActionCommand(NEW_CMD);
        this.sessionButton.setText("Session");
        this.sessionButton.addActionListener(this);
        this.sessionButton.setActionCommand(SESSION_CMD);
        this.messageDrivenButton.setText("Message-Driven");
        this.messageDrivenButton.addActionListener(this);
        this.messageDrivenButton.setActionCommand(MESSAGE_DRIVEN_CMD);
        this.entityButton.setText("Entity");
        this.entityButton.addActionListener(this);
        this.entityButton.setActionCommand(ENTITY_CMD);
        this.loadPanel.setLayout(this.gridBagLayout2);
        ((JDialog)((Object)this)).getContentPane().setLayout(this.borderLayout1);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand(CANCEL_CMD);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand(OK_CMD);
        this.newPanel.setBorder(this.titledBorder1);
        this.panel1.setBorder(this.titledBorder2);
        this.loadButton.setText("Load Existing EJB");
        this.loadButton.addActionListener(this);
        this.loadButton.setActionCommand(LOAD_CMD);
        this.xmlLabel.setText("ejb-jar xml file:");
        this.nameLabel2.setText("Available EJBs:");
        this.dirLabel.setText("Classes Directory:");
        this.loadPanel.setBorder(this.titledBorder3);
        this.browseButton1.setText("...");
        this.browseButton1.addActionListener(this);
        this.browseButton1.setActionCommand(BROWSE1_CMD);
        this.browseButton2.setText("...");
        this.browseButton2.addActionListener(this);
        this.browseButton2.setActionCommand(BROWSE2_CMD);
        ((JDialog)((Object)this)).getContentPane().add((Component)this.loadPanel, "Center");
        this.loadPanel.add((Component)this.loadButton, new GridBagConstraints(3, 3, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.loadPanel.add((Component)this.xmlLabel, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 15, 5, 5), 0, 0));
        this.loadPanel.add((Component)this.nameLabel2, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.loadPanel.add((Component)this.dirLabel, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.loadPanel.add((Component)this.jTextField2, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.loadPanel.add((Component)this.jTextField3, new GridBagConstraints(4, 5, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.loadPanel.add((Component)this.browseButton1, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.loadPanel.add((Component)this.browseButton2, new GridBagConstraints(5, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.loadPanel.add((Component)this.comboBox, new GridBagConstraints(4, 6, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        ((JDialog)((Object)this)).getContentPane().add((Component)this.panel1, "North");
        this.panel1.add((Component)this.makeNewButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel1.add((Component)this.nameLabel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.panel1.add((Component)this.jTextField1, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.panel1.add((Component)this.newPanel, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.entityButton, null);
        this.newPanel.add((Component)this.sessionButton, null);
        this.newPanel.add((Component)this.messageDrivenButton, null);
        ((JDialog)((Object)this)).getContentPane().add((Component)this.buttonsPanel, "South");
        this.buttonsPanel.add((Component)this.okButton, null);
        this.buttonsPanel.add((Component)this.cancelButton, null);
        this.group1.add(this.makeNewButton);
        this.group1.add(this.loadButton);
        this.group2.add(this.sessionButton);
        this.group2.add(this.entityButton);
        this.group2.add(this.messageDrivenButton);
    }

    public void actionPerformed(ActionEvent e) {
        this.isOkAction = false;
        String cmd = e.getActionCommand();
        if (cmd.equals(OK_CMD)) {
            this.okAction();
        } else if (cmd.equals(CANCEL_CMD)) {
            this.cancelAction();
        } else if (cmd.equals(BROWSE1_CMD)) {
            if (this.chooser == null) {
                this.chooser = SFileChooser.getInstance((JFrame)this.frame);
            }
            this.chooser.setFilters(new String[]{".xml"});
            this.browse1Action();
            if (this.xmlFileName != null) {
                this.jTextField2.setText(this.xmlFileName);
            }
        } else if (cmd.equals(BROWSE2_CMD)) {
            String[] files = null;
            if (this.chooser == null) {
                this.chooser = SFileChooser.getInstance((JFrame)this.frame);
            }
            if ((files = this.chooser.showDirDialog("Select Directory To Add", false, true, false)) != null) {
                String text = "";
                int i = 0;
                while (i < files.length) {
                    if (i > 0) {
                        text = text + File.pathSeparator;
                    }
                    text = text + files[i];
                    ++i;
                }
                this.jTextField3.setText(text);
            }
        } else if (cmd.equals(NEW_CMD)) {
            this.createNew = true;
            this.enableNew();
            this.disableLoad();
            this.beanName = this.jTextField1.getText();
        } else if (cmd.equals(LOAD_CMD)) {
            this.createNew = false;
            this.enableLoad();
            this.disableNew();
        } else if (cmd.equals(ENTITY_CMD)) {
            this.type = ENTITY_BEAN;
            this.descriptor = new EntityDescriptor();
            this.setDescriptor(this.descriptor);
            this.descriptor.setDisplayName(this.getBeanName());
        } else if (cmd.equals(SESSION_CMD)) {
            this.type = SESSION_BEAN;
            this.descriptor = new SessionDescriptor();
            this.setDescriptor(this.descriptor);
            this.descriptor.setDisplayName(this.getBeanName());
        } else if (cmd.equals(MESSAGE_DRIVEN_CMD)) {
            this.type = MESSAGE_DRIVEN_BEAN;
            this.descriptor = new MessageDrivenDescriptor();
            this.setDescriptor(this.descriptor);
            this.descriptor.setDisplayName(this.getBeanName());
        }
    }

    private void okAction() {
        if (this.createNew) {
            if (this.jTextField1.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "The obligatory fields are not filled in!", "Warning", 0);
                return;
            }
        } else {
            if (!new File(this.jTextField2.getText().trim()).exists()) {
                JOptionPane.showMessageDialog(this.frame, "Select valid xml file name!", "Warning", 0);
                return;
            }
            if (this.jTextField3.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "Select classes directory!", "Warning", 0);
                return;
            }
            if (this.comboBox.getItemCount() < 2) {
                JOptionPane.showMessageDialog(this.frame, "Selected xml file contains no beans!", "Warning", 0);
                return;
            }
            if ((String)this.comboBox.getSelectedItem() == null || ((String)this.comboBox.getSelectedItem()).equals("")) {
                JOptionPane.showMessageDialog(this.frame, "Choose an EJB from available beans!", "Warning", 0);
                return;
            }
        }
        this.beanName = this.createNew ? this.jTextField1.getText() : this.jTextField4.getText();
        this.isOkAction = true;
        ((Component)((Object)this)).setVisible(false);
    }

    protected void enableLoad() {
        this.browseButton1.setEnabled(true);
        this.browseButton2.setEnabled(true);
        this.jTextField2.setEditable(true);
        this.jTextField3.setEditable(true);
        this.jTextField4.setEditable(true);
    }

    protected void disableLoad() {
        this.browseButton1.setEnabled(false);
        this.browseButton2.setEnabled(false);
        this.jTextField2.setEditable(false);
        this.jTextField3.setEditable(false);
        this.jTextField4.setEditable(false);
    }

    protected void disableNew() {
        this.jTextField1.setEnabled(false);
        this.entityButton.setEnabled(false);
        this.sessionButton.setEnabled(false);
        this.messageDrivenButton.setEnabled(false);
    }

    protected void enableNew() {
        this.jTextField1.setEnabled(true);
        this.entityButton.setEnabled(true);
        this.sessionButton.setEnabled(true);
        this.messageDrivenButton.setEnabled(true);
    }

    public String getXMLName() {
        return this.jTextField2.getText();
    }

    protected void browse1Action() {
        String[] files = null;
        this.chooser.setFilters(new String[]{".xml"});
        files = this.chooser.showFileDialog("Select XML File To Add", false, false, false);
        if (files != null && files[0] != null) {
            this.xmlFileName = files[0];
        }
    }

    public String getXMLFileName() {
        return this.xmlFileName;
    }

    public String[] getSelectedDirs() {
        String text = this.jTextField3.getText();
        String[] res = null;
        if (text != null) {
            StringTokenizer tokenizer = new StringTokenizer(text, File.pathSeparator);
            res = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                res[i++] = tokenizer.nextToken();
            }
        }
        return res;
    }

    protected String getBeanName() {
        this.beanName = this.createNew ? this.jTextField1.getText() : (String)this.comboBox.getSelectedItem();
        if (this.beanName == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Insert bean name value", "Error", 2);
        }
        return this.beanName;
    }

    public void setDescriptor(DeploymentDescriptor descr) {
        this.descriptor = descr;
    }

    public String getBeanType() {
        return this.type;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public void setClassPaths(String classPaths) {
        this.classPaths = classPaths;
    }

    public boolean createNew() {
        return this.createNew;
    }

    public boolean isOkAction() {
        return this.isOkAction;
    }

    public void changedUpdate(DocumentEvent de) {
        this.fillComboBox();
    }

    public void removeUpdate(DocumentEvent de) {
        this.fillComboBox();
    }

    public void insertUpdate(DocumentEvent de) {
        this.fillComboBox();
    }

    /*
     * Loose catch block
     */
    private void fillComboBox() {
        block19: {
            BufferedInputStream xmlStream;
            FileInputStream fis;
            block18: {
                String xml = this.jTextField2.getText().trim();
                String dirName = this.jTextField3.getText().trim();
                this.comboBox.removeAllItems();
                if (xml.equals("") || !xml.toLowerCase().endsWith(".xml")) {
                    this.comboBox.setEnabled(false);
                    return;
                }
                File f = new File(xml);
                if (!f.exists()) {
                    this.comboBox.setEnabled(false);
                    return;
                }
                if (dirName.equals("")) {
                    this.comboBox.setEnabled(false);
                    return;
                }
                EJBJarParser parser = new EJBJarParser();
                EJBJarDescriptor jar = new EJBJarDescriptor();
                fis = null;
                xmlStream = null;
                fis = new FileInputStream(f);
                xmlStream = new BufferedInputStream(fis);
                DynamicClassLoader loader = new DynamicClassLoader(this.classPaths);
                loader.addClasspath(dirName);
                jar = parser.parseXml(xmlStream, new Vector(), loader, null, xml);
                xmlStream.close();
                DeploymentDescriptor[] descriptors = jar.getDDescriptors();
                if (descriptors == null) break block18;
                this.comboBox.addItem("");
                int i = 0;
                while (i < descriptors.length) {
                    this.comboBox.addItem(descriptors[i].getName());
                    ++i;
                }
            }
            Object var12_12 = null;
            try {
                if (xmlStream != null) {
                    xmlStream.close();
                }
                if (fis != null) {
                    fis.close();
                }
                break block19;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.frame, "Error occurred while closing streams for reading XML file.\n" + e.toString(), "Error", 0);
            }
            break block19;
            {
                catch (Exception exc) {
                    exc.printStackTrace();
                    this.comboBox.setEnabled(false);
                    Object var12_13 = null;
                    try {
                        if (xmlStream != null) {
                            xmlStream.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this.frame, "Error occurred while closing streams for reading XML file.\n" + e.toString(), "Error", 0);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (xmlStream != null) {
                        xmlStream.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this.frame, "Error occurred while closing streams for reading XML file.\n" + e.toString(), "Error", 0);
                }
                throw throwable;
            }
        }
        this.comboBox.setEnabled(true);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.okAction();
        } else if (keyEvent.getKeyCode() == 27) {
            this.isOkAction = false;
            ((Component)((Object)this)).setVisible(false);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void cancelAction() {
        this.isOkAction = false;
        ((Component)((Object)this)).setVisible(false);
    }

    protected void performEnterAction(KeyEvent e) {
        this.okAction();
    }

    protected void performEscapeAction(KeyEvent e) {
        this.cancelAction();
    }
}

