/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.services.deploy.gui.SFileChooser;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RenameDialog
extends CEscapeDialog
implements ActionListener {
    private static final String BROWSE_CMD = "BROWSE";
    private static final String OK_CMD = "OK";
    private static final String CANCEL_CMD = "CANCEL";
    private JPanel mainPanel = new JPanel();
    private JPanel buttonsPanel = new JPanel();
    private JLabel fileLabel = new JLabel("File:");
    private JTextField fileField = new JTextField();
    private JButton browseButton = new JButton("...");
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private SFileChooser chooser = null;
    private Frame mainFrame = null;
    private String path = new String("");
    private String workingDirectory = new String("");
    private byte fileType;
    private static final String JAR_EXT = ".jar";
    private static final String WAR_EXT = ".war";
    private static final String RAR_EXT = ".rar";
    private static final String EAR_EXT = ".ear";
    public static final byte JAR = 0;
    public static final byte WAR = 1;
    public static final byte RAR = 2;
    public static final byte EAR = 3;

    public RenameDialog(String workDir, Frame frame) {
        super(frame, "Enter Archive Name", true);
        this.mainFrame = frame;
        this.workingDirectory = workDir;
        this.workingDirectory = this.workingDirectory.replace('/', File.separatorChar);
        this.workingDirectory = this.workingDirectory.replace('\\', File.separatorChar);
        try {
            this.init();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Visualization of panels cannot be initialized properly\nReason: " + e.toString() + "\nRestart of the tool is recommended.\n We are sorry for the inconvenience.", "Error in visualization", 0);
        }
    }

    private void init() throws Exception {
        this.fileField.setText("");
        this.browseButton.setPreferredSize(new Dimension(21, 21));
        this.browseButton.setMinimumSize(new Dimension(21, 21));
        this.browseButton.setMaximumSize(new Dimension(21, 21));
        this.buttonsPanel.add(this.okButton);
        this.buttonsPanel.add(this.cancelButton);
        this.initButtons();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.add((Component)this.fileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.fileField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.mainPanel.add((Component)this.browseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.buttonsPanel, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        ((JDialog)((Object)this)).getContentPane().add(this.mainPanel);
        ((Component)((Object)this)).setSize(300, 90);
        ((Dialog)((Object)this)).setModal(true);
        ((Window)((Object)this)).setLocationRelativeTo(this.mainFrame);
    }

    private void initButtons() {
        this.browseButton.setActionCommand(BROWSE_CMD);
        this.browseButton.addActionListener(this);
        this.okButton.setActionCommand(OK_CMD);
        this.okButton.addActionListener(this);
        this.cancelButton.setActionCommand(CANCEL_CMD);
        this.cancelButton.addActionListener(this);
    }

    private void initChooser() {
        File parent;
        if (this.chooser == null) {
            this.chooser = SFileChooser.getInstance((JFrame)this.mainFrame);
        }
        if (this.fileType == 0) {
            this.chooser.setFilters(new String[]{JAR_EXT});
        } else if (this.fileType == 1) {
            this.chooser.setFilters(new String[]{WAR_EXT});
        } else if (this.fileType == 2) {
            this.chooser.setFilters(new String[]{RAR_EXT});
        } else if (this.fileType == 3) {
            this.chooser.setFilters(new String[]{EAR_EXT});
        }
        if (this.isAbsolute(new File(this.path)) && new File(this.path).exists() && (parent = new File(this.path).getParentFile()) != null) {
            this.chooser.goToDir(parent.getAbsolutePath());
            return;
        }
        if (this.path.lastIndexOf(File.separator) == -1) {
            this.chooser.goToDir(this.workingDirectory + File.separator + this.path);
        } else {
            this.chooser.goToDir(this.workingDirectory + File.separator + this.path.substring(0, this.path.lastIndexOf(File.separator)));
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(BROWSE_CMD)) {
            this.browseAction();
        } else if (cmd.equals(OK_CMD)) {
            this.okAction();
        } else if (cmd.equals(CANCEL_CMD)) {
            this.cancelAction();
        }
    }

    private void browseAction() {
        this.initChooser();
        String[] files = this.chooser.showFileDialog("Select file to overwrite", false, false, true);
        String currentPath = null;
        if (files != null) {
            int index;
            currentPath = files[0];
            if (currentPath.startsWith(this.workingDirectory)) {
                currentPath = currentPath.substring(this.workingDirectory.length());
                while (currentPath.startsWith(File.separator)) {
                    currentPath = currentPath.substring(File.separator.length());
                }
            }
            if ((index = currentPath.lastIndexOf(46)) != -1) {
                currentPath = currentPath.substring(0, index);
            }
            if (this.fileType == 0) {
                currentPath = currentPath + JAR_EXT;
            } else if (this.fileType == 3) {
                currentPath = currentPath + EAR_EXT;
            } else if (this.fileType == 1) {
                currentPath = currentPath + WAR_EXT;
            } else if (this.fileType == 2) {
                currentPath = currentPath + RAR_EXT;
            }
            this.setTextFileField(currentPath);
        }
    }

    private void okAction() {
        String newPath = this.fileField.getText();
        if (!this.existingDrive(newPath)) {
            return;
        }
        newPath = newPath.replace('/', File.separatorChar);
        if (this.isAbsolute(new File(newPath = newPath.replace('\\', File.separatorChar))) && !this.exists(new File(newPath))) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Not valid absolute path \"" + newPath + "\" ", "ERROR", 0);
            return;
        }
        this.path = newPath;
        int index = this.path.lastIndexOf(46);
        if (index != -1) {
            this.path = this.path.substring(0, index);
        }
        if (this.fileType == 0) {
            this.path = this.path + JAR_EXT;
        } else if (this.fileType == 3) {
            this.path = this.path + EAR_EXT;
        } else if (this.fileType == 1) {
            this.path = this.path + WAR_EXT;
        } else if (this.fileType == 2) {
            this.path = this.path + RAR_EXT;
        }
        ((Component)((Object)this)).setVisible(false);
    }

    private void cancelAction() {
        ((Component)((Object)this)).setVisible(false);
    }

    protected void performEnterAction(KeyEvent e) {
        this.okAction();
    }

    protected void performEscapeAction(KeyEvent e) {
        this.cancelAction();
    }

    public String getPath() {
        if (this.isAbsolute(new File(this.path))) {
            return this.path;
        }
        return this.workingDirectory + File.separator + this.path;
    }

    private boolean existingDrive(String newPath) {
        if (newPath.length() > 1 && newPath.charAt(1) == ':' && !new File(newPath.substring(0, 3)).exists()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No such drive \"" + newPath.substring(0, 2) + "\" or drive no ready", "ERROR", 0);
            return false;
        }
        return true;
    }

    private boolean isAbsolute(File file) {
        if (file.isAbsolute()) {
            return true;
        }
        if (file.getParentFile() != null) {
            return this.isAbsolute(file.getParentFile());
        }
        return false;
    }

    private boolean exists(File file) {
        if (file.exists()) {
            return true;
        }
        if (file.getParentFile() != null) {
            return this.exists(file.getParentFile());
        }
        return false;
    }

    public void setPath(String filePath) {
        this.path = filePath;
        this.path = this.path.replace('\\', File.separatorChar);
        this.path = this.path.replace('/', File.separatorChar);
        if (this.path.startsWith(this.workingDirectory)) {
            this.path = this.path.substring(this.workingDirectory.length());
            while (this.path.startsWith(File.separator)) {
                this.path = this.path.substring(File.separator.length());
            }
        }
        this.setTextFileField(this.path);
    }

    private void setTextFileField(String filePath) {
        this.fileField.setText(filePath);
        int size = 60 + filePath.length() * 6;
        if (size > 330 && size < 700) {
            ((Component)((Object)this)).setSize(new Dimension(size, 90));
        } else if (size < 330) {
            ((Component)((Object)this)).setSize(new Dimension(330, 90));
        } else if (size > 700) {
            ((Component)((Object)this)).setSize(new Dimension(700, 90));
        }
        ((Component)((Object)this)).repaint();
    }

    public void setType(byte type) {
        this.fileType = type;
    }
}

