/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.AdditionalTab;
import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.lf.LAFPanel;
import com.sap.engine.services.deploy.gui.CClassPathPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class ProjectOptionsDialog
extends CEscapeDialog
implements ActionListener {
    private JTabbedPane tabPane;
    private JFrame frame;
    private CClassPathPanel classPathPanel;
    private AdditionalTab additionalTabsPanel;
    private Properties property;
    private Properties lafProperty;
    private LAFPanel lafPanel;
    private boolean isOK = false;
    private Properties variables = new Properties();

    public ProjectOptionsDialog(JFrame frame, Properties property) {
        super((Frame)frame, "Project Options", true);
        this.frame = frame;
        this.property = property;
        this.initialization();
    }

    private void initialization() {
        this.tabPane = new JTabbedPane();
        Enumeration enumeration = ((Hashtable)this.property).keys();
        Properties p = new Properties();
        while (enumeration.hasMoreElements()) {
            String key2 = (String)enumeration.nextElement();
            if (!key2.startsWith("Path_Variable:")) continue;
            String keyForPass = key2.substring("Path_Variable:".length());
            p.setProperty(keyForPass, this.property.getProperty(key2));
        }
        this.classPathPanel = this.property != null ? (this.property.getProperty("Classpath") != null ? new CClassPathPanel(ApplicationInformationProvider.parseClassPathToRelative(this.property.getProperty("Classpath").replace(';', File.pathSeparatorChar), p), this.frame) : new CClassPathPanel(this.property.getProperty("Classpath"), this.frame)) : new CClassPathPanel(this.frame);
        this.classPathPanel.setVariables(p);
        this.additionalTabsPanel = new AdditionalTab(this.property, this.frame, (JDialog)((Object)this));
        this.lafProperty = this.convertToLAFProperties(this.property);
        this.lafPanel = new LAFPanel(this.lafProperty, UIManager.getLookAndFeel().getName());
        JPanel buttonPanel = new JPanel();
        ((JDialog)((Object)this)).getContentPane().setLayout(new BorderLayout());
        JButton cancelButton = new JButton("Cancel");
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(this);
        okButton.setActionCommand("Ok");
        cancelButton.addActionListener(this);
        cancelButton.setActionCommand("Cancel");
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add((Component)okButton, null);
        buttonPanel.add((Component)cancelButton, null);
        this.tabPane.addTab("Classpath", this.classPathPanel);
        this.tabPane.addTab("Additional", (Component)this.additionalTabsPanel);
        this.tabPane.addTab("Look And Feel", (Component)this.lafPanel);
        ((JDialog)((Object)this)).getContentPane().add((Component)this.tabPane, "Center");
        ((JDialog)((Object)this)).getContentPane().add((Component)buttonPanel, "South");
        ((Window)((Object)this)).pack();
    }

    private String getStringFromVector(Vector vec) {
        String str = "";
        int i = 0;
        while (i < vec.size()) {
            str = str + (String)vec.elementAt(i) + ";";
            ++i;
        }
        return str;
    }

    public Properties getProperties() {
        return this.property;
    }

    public String getLookAndFeelName() {
        return this.lafPanel.getLafName();
    }

    public String getLookAndFeelClass() {
        return this.lafPanel.getLafClass();
    }

    private void commitChanges() {
        Vector temp = new Vector();
        if (this.property == null) {
            this.property = new Properties();
        }
        temp = this.additionalTabsPanel.getVector();
        String avTabs = "";
        String defTabs = "";
        int i = 0;
        while (i < temp.size()) {
            JCheckBox cb = new JCheckBox();
            cb = (JCheckBox)temp.elementAt(i);
            avTabs = avTabs + cb.getText() + ";";
            if (cb.isSelected()) {
                defTabs = defTabs + cb.getText() + ";";
            }
            ++i;
        }
        this.property.setProperty("AvailableTabs", avTabs);
        this.property.setProperty("DefaultTabs", defTabs);
        this.property.setProperty("BrowserPath", this.additionalTabsPanel.getBrowserPath());
        Vector temp2 = new Vector();
        temp2 = this.additionalTabsPanel.getAddedTabs();
        int i2 = 0;
        while (i2 < temp2.size()) {
            StringTokenizer st = new StringTokenizer((String)temp2.elementAt(i2), "=");
            String firstName = null;
            String firstClass = null;
            if (st.hasMoreTokens()) {
                firstName = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                firstClass = st.nextToken();
            }
            if (firstName != null && firstClass != null) {
                this.property.setProperty(firstName, firstClass);
            }
            ++i2;
        }
        String classPathTemp = this.getStringFromVector(this.classPathPanel.getClassPath());
        this.property.setProperty("Classpath", classPathTemp);
        this.lafProperty = this.lafPanel.getLafs();
        this.property = this.convertToOriginalProperties(this.lafProperty, this.property);
        String status = "";
        status = this.additionalTabsPanel.getTransferTabsStatus() ? "true" : "false";
        Properties tempProp = this.classPathPanel.getVariables();
        this.variables = new Properties();
        Enumeration enum1 = ((Hashtable)tempProp).keys();
        String key12 = null;
        while (enum1.hasMoreElements()) {
            key12 = (String)enum1.nextElement();
            String inputKey = !key12.startsWith("Path_Variable:") ? "Path_Variable:" + key12 : key12;
            this.property.setProperty(inputKey, tempProp.getProperty(key12));
            this.variables.setProperty(inputKey, tempProp.getProperty(key12));
        }
        this.property.setProperty("TransferBetweenTabs", status);
    }

    public boolean getOK() {
        return this.isOK;
    }

    public void initOK() {
        this.isOK = false;
    }

    private Properties convertToOriginalProperties(Properties lfProperty, Properties origProperty) {
        String s = "";
        Enumeration<?> en = lfProperty.propertyNames();
        String lf = "";
        while (en.hasMoreElements()) {
            String sTemp = "";
            sTemp = (String)en.nextElement();
            lf = lf + sTemp + ";";
            origProperty.setProperty("LAF", lf);
            origProperty.setProperty(sTemp, lfProperty.getProperty(sTemp));
        }
        return origProperty;
    }

    private Properties convertToLAFProperties(Properties origProperty) {
        Properties tempProperty = new Properties();
        if (origProperty == null) {
            return tempProperty;
        }
        String s = "";
        if (origProperty.getProperty("LAF") != null) {
            s = origProperty.getProperty("LAF");
            StringTokenizer st = new StringTokenizer(s, ";");
            while (st.hasMoreTokens()) {
                String sTemp = "";
                sTemp = st.nextToken();
                tempProperty.setProperty(sTemp, origProperty.getProperty(sTemp));
            }
        }
        return tempProperty;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Cancel") {
            this.cancelAction();
        }
        if (e.getActionCommand() == "Ok") {
            this.okAction();
        }
    }

    private void cancelAction() {
        this.isOK = false;
        ((Component)((Object)this)).setVisible(false);
    }

    private void okAction() {
        if (!this.additionalTabsPanel.hasSelectedTab()) {
            this.tabPane.setSelectedIndex(1);
            JOptionPane.showMessageDialog((Component)((Object)this), "At least one tab must be selected", "Warning!", 2);
            return;
        }
        this.isOK = true;
        this.commitChanges();
        ((Component)((Object)this)).setVisible(false);
    }

    protected void performEnterAction(KeyEvent e) {
        this.okAction();
    }

    protected void performEscapeAction(KeyEvent e) {
        this.cancelAction();
    }

    public void setProperty(Properties property) {
        this.property = property;
    }

    public Properties getVariables() {
        return this.variables;
    }

    public void setVariables(Properties variables) {
        this.classPathPanel.setVariables(variables);
        this.variables = variables;
    }
}

