/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool;

import com.sap.engine.deploy.ejb.descriptors.jar.ReadEjbJar;
import com.sap.engine.deploy.ejb.descriptors.xml.EJBJarParser;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.appclient.descriptor.ClientJar;
import com.sap.engine.services.connector.jca.deploy.descriptor.jar.ReadRar;
import com.sap.engine.services.deploy.converter.EJBConverter;
import com.sap.engine.services.deploy.converter.WebConverter;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.ejb.deploy.admintool.RMappingTool;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.jar.WebWar;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class JarHelper {
    String jarName = null;
    private String classPath = "";
    private Vector errors = new Vector();
    private boolean isRealApplcaiction = true;

    public JarHelper() {
    }

    public JarHelper(String jarName) {
        this.jarName = jarName;
    }

    public void setJarName(String jarName) {
        this.jarName = jarName;
    }

    public String getJarName() {
        return this.jarName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getJarComponentType(String filePath) throws Exception {
        this.jarName = filePath;
        if (filePath.endsWith(".war")) {
            return 4;
        }
        try {
            ZipFile file;
            block25: {
                int n;
                block24: {
                    int n2;
                    block23: {
                        int n3;
                        block22: {
                            int n4;
                            block21: {
                                file = new ZipFile(filePath);
                                try {
                                    ZipEntry entry = file.getEntry("META-INF/ejb-jar.xml");
                                    if (entry == null && (entry = file.getEntry("meta-inf/ejb-jar.xml")) == null) {
                                        entry = file.getEntry("META-INF/EJB-JAR.XML");
                                    }
                                    if (entry != null) {
                                        n4 = 1;
                                        Object var6_9 = null;
                                        break block21;
                                    }
                                    entry = file.getEntry("META-INF/service-jar.xml");
                                    if (entry == null && (entry = file.getEntry("meta-inf/service-jar.xml")) == null) {
                                        entry = file.getEntry("META-INF/SERVICE-JAR.XML");
                                    }
                                    if (entry != null) {
                                        n3 = 2;
                                        break block22;
                                    }
                                    entry = file.getEntry("META-INF/application-client.xml");
                                    if (entry == null && (entry = file.getEntry("meta-inf/application-client.xml")) == null) {
                                        entry = file.getEntry("META-INF/APPLICATION_CLIENT.XML");
                                    }
                                    if (entry != null) {
                                        n2 = 3;
                                        break block23;
                                    }
                                    entry = file.getEntry("meta-inf/ra.xml");
                                    if (entry == null && (entry = file.getEntry("meta-inf/RA.xml")) == null) {
                                        entry = file.getEntry("META-INF/ra.xml");
                                    }
                                    if (entry != null) {
                                        n = 5;
                                        break block24;
                                    }
                                    if (entry == null) {
                                        throw new IOException("Can't find xml file in jar file.");
                                    }
                                    break block25;
                                }
                                catch (Throwable throwable) {
                                    Object var6_14 = null;
                                    try {
                                        file.close();
                                        throw throwable;
                                    }
                                    catch (Exception ee) {
                                        throw new Exception("Error occurred while closing ZIP file:\n" + ee.getMessage());
                                    }
                                }
                            }
                            try {}
                            catch (Exception ee) {
                                throw new Exception("Error occurred while closing ZIP file:\n" + ee.getMessage());
                            }
                            file.close();
                            return n4;
                        }
                        Object var6_10 = null;
                        try {}
                        catch (Exception ee) {
                            throw new Exception("Error occurred while closing ZIP file:\n" + ee.getMessage());
                        }
                        file.close();
                        return n3;
                    }
                    Object var6_11 = null;
                    try {}
                    catch (Exception ee) {
                        throw new Exception("Error occurred while closing ZIP file:\n" + ee.getMessage());
                    }
                    file.close();
                    return n2;
                }
                Object var6_12 = null;
                try {}
                catch (Exception ee) {
                    throw new Exception("Error occurred while closing ZIP file:\n" + ee.getMessage());
                }
                file.close();
                return n;
            }
            Object var6_13 = null;
            try {}
            catch (Exception ee) {
                throw new Exception("Error occurred while closing ZIP file:\n" + ee.getMessage());
            }
            file.close();
            return -1;
        }
        catch (Exception exc) {
            throw new Exception("Error occurred while processing ZIP file:\n" + exc.getMessage());
        }
    }

    public Descriptor[] loadDescriptorsFromArchive(String name) throws Exception {
        this.jarName = name;
        int type = -1;
        try {
            type = this.getJarComponentType(name);
        }
        catch (Exception exc) {
            throw new Exception(exc.toString());
        }
        switch (type) {
            case 1: {
                try {
                    ReadEjbJar readjar = new ReadEjbJar(name, this.classPath);
                    EJBJarDescriptor jar = readjar.getEjbJarDescriptor();
                    this.errors = readjar.getErrors();
                    if (jar == null) {
                        return null;
                    }
                    return jar.getDescriptors();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    break;
                }
            }
            case 4: {
                try {
                    WebWar jar = new WebWar(name);
                    return jar.getDescriptor() == null ? null : jar.getDescriptor().getDescriptors();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    break;
                }
            }
            case 3: {
                try {
                    ClientJar jar = new ClientJar(name);
                    return jar.getDescriptor() == null ? null : jar.getDescriptor().getDescriptors();
                }
                catch (Exception exc) {
                    throw new Exception("Error occurred while getting Client Descriptor" + exc.toString());
                }
            }
        }
        return null;
    }

    public ArchiveDescriptor loadArchiveDescriptor(String name) throws Exception {
        this.jarName = name;
        int type = -1;
        try {
            type = this.getJarComponentType(name);
        }
        catch (Exception exc) {
            throw new Exception(exc.getMessage());
        }
        switch (type) {
            case 1: {
                try {
                    ReadEjbJar readjar = new ReadEjbJar(name, this.classPath);
                    EJBJarDescriptor descr = readjar.getEjbJarDescriptor();
                    this.errors = readjar.getErrors();
                    return descr;
                }
                catch (Exception exc) {
                    throw new IOException(exc.getMessage());
                }
            }
            case 4: {
                try {
                    WebWar jar = new WebWar(name);
                    return jar.getWebDescriptor();
                }
                catch (Exception exc) {
                    throw new Exception(exc.getMessage());
                }
            }
            case 3: {
                try {
                    ClientJar jar = new ClientJar(name);
                    return jar.getClientJarDescriptor();
                }
                catch (Exception exc) {
                    throw new Exception(exc.getMessage());
                }
            }
            case 5: {
                try {
                    ReadRar rar = new ReadRar(name);
                    if (!this.isRealApplcaiction) {
                        rar.setIsRealApplication(this.isRealApplcaiction);
                    }
                    return rar.getDescriptor();
                }
                catch (Exception exc) {
                    throw new Exception(exc.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getFilesFromArchive(String filePath) throws Exception {
        InfoObject currentInfo = null;
        Vector<InfoObject> infoes = new Vector<InfoObject>();
        ZipFile file = null;
        int type = -1;
        try {
            type = this.getJarComponentType(filePath);
            try {
                if (type == 4) {
                    file = new ZipFile(filePath);
                    Enumeration<? extends ZipEntry> enumeration = file.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry entry = enumeration.nextElement();
                        if (entry.getName().endsWith("web.xml") || entry.isDirectory()) continue;
                        currentInfo = new InfoObject(entry.getName(), filePath);
                        infoes.addElement(currentInfo);
                    }
                } else if (type == 1) {
                    file = new ZipFile(filePath);
                    Enumeration<? extends ZipEntry> enumeration = file.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry entry = enumeration.nextElement();
                        if (entry.getName().endsWith("ejb-jar.xml") && entry.getName().endsWith("storage.xml") && entry.getName().endsWith(".class") || entry.isDirectory()) continue;
                        currentInfo = new InfoObject(entry.getName(), filePath);
                        infoes.addElement(currentInfo);
                    }
                } else if (type == 2) {
                    file = new ZipFile(filePath);
                    Enumeration<? extends ZipEntry> enumeration = file.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry entry = enumeration.nextElement();
                        if (entry.getName().endsWith("service-jar.xml") && entry.getName().endsWith(".class") || entry.isDirectory()) continue;
                        currentInfo = new InfoObject(entry.getName(), filePath);
                        infoes.addElement(currentInfo);
                    }
                } else if (type == 3) {
                    file = new ZipFile(filePath);
                    Enumeration<? extends ZipEntry> enumeration = file.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry entry = enumeration.nextElement();
                        if (entry.getName().endsWith("client.xml") || entry.isDirectory()) continue;
                        currentInfo = new InfoObject(entry.getName(), filePath);
                        infoes.addElement(currentInfo);
                    }
                }
            }
            catch (Exception exc) {
                throw new Exception("Error occurred while getting files from ZIP file " + filePath + ":\n" + exc.getMessage());
            }
            Object var9_16 = null;
            if (file == null) return infoes;
        }
        catch (Throwable throwable) {
            Object var9_17 = null;
            if (file == null) throw throwable;
            try {
                file.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new Exception("Error occurred while closing ZIP file:\n" + e.toString());
            }
        }
        try {
            file.close();
            return infoes;
        }
        catch (Exception e) {
            throw new Exception("Error occurred while closing ZIP file:\n" + e.toString());
        }
    }

    public void setClassPath(String classpath) {
        this.classPath = classpath;
    }

    public EJBJarDescriptor getConvertedEJBDescriptor(ClassLoader loader, String xmlFileLocation) throws Exception {
        return this.getConvertedEJBDescriptor(loader, xmlFileLocation, true);
    }

    public EJBJarDescriptor getConvertedEJBDescriptor(ClassLoader loader, String xmlFileLocation, boolean compliance) throws Exception {
        Document document = null;
        EJBJarDescriptor result = new EJBJarDescriptor();
        BufferedInputStream buffer = null;
        try {
            buffer = new BufferedInputStream(new FileInputStream(xmlFileLocation));
        }
        catch (IOException io) {
            throw new Exception("Can not parse ejb-jar.xml. Reason : " + io.toString());
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            StandardDOMParser domParser = new StandardDOMParser();
            Thread.currentThread().setContextClassLoader(cl);
            domParser.setSystemId(xmlFileLocation);
            document = domParser.parse((InputStream)buffer);
        }
        catch (IOException ioe) {
            throw new Exception("Can not parse ejb-jar.xml. Reason : " + ioe.toString());
        }
        catch (Exception ex) {
            throw new Exception("Can not parse ejb-jar.xml. Reason : " + ex.toString());
        }
        DocumentType dt = document.getDoctype();
        String dtd = "<!DOCTYPE ejb-jar [\n<!ELEMENT ejb-jar (description?, display-name?, small-icon?, large-icon?, enterprise-beans, assembly-descriptor?)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT enterprise-beans (session|entity)+ > \n<!ELEMENT session (description?, display-name?, small-icon?, large-icon?, \n ejb-name, home, remote, ejb-class, session-type,session-timeout?, transaction-type, bean-count,\n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT entity (description?, display-name?, small-icon?, large-icon?,\n ejb-name, home, remote, ejb-class, persistence-type, prim-key-class, reentrant, bean-count, cmp-field*, primkey-field?, \n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT ejb-name (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-class (#PCDATA)>\n<!ELEMENT session-type (#PCDATA)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT transaction-type (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link, user-name, password)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT password (#PCDATA)>\n<!ELEMENT persistence-type (#PCDATA)>\n<!ELEMENT prim-key-class (#PCDATA)>\n<!ELEMENT reentrant (#PCDATA)>\n<!ELEMENT cmp-field (description?, field-name)>\n<!ELEMENT field-name (#PCDATA)>\n<!ELEMENT primkey-field (#PCDATA)>\n<!ELEMENT assembly-descriptor (security-role*, method-permission*, container-transaction*)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT method-permission (description?, role-name+, method+, pid?)>\n<!ELEMENT method (description?, ejb-name, method-intf?, method-name, method-params?)>\n<!ELEMENT method-intf (#PCDATA)>\n<!ELEMENT method-name (#PCDATA)>\n<!ELEMENT method-params (method-param*)>\n<!ELEMENT method-param (#PCDATA) >\n<!ELEMENT pid (#PCDATA)>\n<!ELEMENT bean-count (#PCDATA)>\n<!ELEMENT container-transaction (description?, method+, trans-attribute)>\n<!ELEMENT trans-attribute (#PCDATA)>\n]>";
        if (dt != null && (dtd = dt.getSystemId()) == null) {
            dtd = "<!DOCTYPE ejb-jar [\n<!ELEMENT ejb-jar (description?, display-name?, small-icon?, large-icon?, enterprise-beans, assembly-descriptor?)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT enterprise-beans (session|entity)+ > \n<!ELEMENT session (description?, display-name?, small-icon?, large-icon?, \n ejb-name, home, remote, ejb-class, session-type,session-timeout?, transaction-type, bean-count,\n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT entity (description?, display-name?, small-icon?, large-icon?,\n ejb-name, home, remote, ejb-class, persistence-type, prim-key-class, reentrant, bean-count, cmp-field*, primkey-field?, \n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT ejb-name (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-class (#PCDATA)>\n<!ELEMENT session-type (#PCDATA)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT transaction-type (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link, user-name, password)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT password (#PCDATA)>\n<!ELEMENT persistence-type (#PCDATA)>\n<!ELEMENT prim-key-class (#PCDATA)>\n<!ELEMENT reentrant (#PCDATA)>\n<!ELEMENT cmp-field (description?, field-name)>\n<!ELEMENT field-name (#PCDATA)>\n<!ELEMENT primkey-field (#PCDATA)>\n<!ELEMENT assembly-descriptor (security-role*, method-permission*, container-transaction*)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT method-permission (description?, role-name+, method+, pid?)>\n<!ELEMENT method (description?, ejb-name, method-intf?, method-name, method-params?)>\n<!ELEMENT method-intf (#PCDATA)>\n<!ELEMENT method-name (#PCDATA)>\n<!ELEMENT method-params (method-param*)>\n<!ELEMENT method-param (#PCDATA) >\n<!ELEMENT pid (#PCDATA)>\n<!ELEMENT bean-count (#PCDATA)>\n<!ELEMENT container-transaction (description?, method+, trans-attribute)>\n<!ELEMENT trans-attribute (#PCDATA)>\n]>";
        }
        if (dtd.equals("<!DOCTYPE ejb-jar [\n<!ELEMENT ejb-jar (description?, display-name?, small-icon?, large-icon?, enterprise-beans, assembly-descriptor?)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT enterprise-beans (session|entity)+ > \n<!ELEMENT session (description?, display-name?, small-icon?, large-icon?, \n ejb-name, home, remote, ejb-class, session-type,session-timeout?, transaction-type, bean-count,\n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT entity (description?, display-name?, small-icon?, large-icon?,\n ejb-name, home, remote, ejb-class, persistence-type, prim-key-class, reentrant, bean-count, cmp-field*, primkey-field?, \n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT ejb-name (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-class (#PCDATA)>\n<!ELEMENT session-type (#PCDATA)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT transaction-type (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link, user-name, password)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT password (#PCDATA)>\n<!ELEMENT persistence-type (#PCDATA)>\n<!ELEMENT prim-key-class (#PCDATA)>\n<!ELEMENT reentrant (#PCDATA)>\n<!ELEMENT cmp-field (description?, field-name)>\n<!ELEMENT field-name (#PCDATA)>\n<!ELEMENT primkey-field (#PCDATA)>\n<!ELEMENT assembly-descriptor (security-role*, method-permission*, container-transaction*)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT method-permission (description?, role-name+, method+, pid?)>\n<!ELEMENT method (description?, ejb-name, method-intf?, method-name, method-params?)>\n<!ELEMENT method-intf (#PCDATA)>\n<!ELEMENT method-name (#PCDATA)>\n<!ELEMENT method-params (method-param*)>\n<!ELEMENT method-param (#PCDATA) >\n<!ELEMENT pid (#PCDATA)>\n<!ELEMENT bean-count (#PCDATA)>\n<!ELEMENT container-transaction (description?, method+, trans-attribute)>\n<!ELEMENT trans-attribute (#PCDATA)>\n]>") || dtd.indexOf("http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd") > 0) {
            EJBConverter converter = new EJBConverter();
            converter.setLoader(loader);
            result = (EJBJarDescriptor)converter.parseDocument(document);
            converter.applyChanges(result);
        } else {
            try {
                EJBJarParser parser = new EJBJarParser();
                parser.setCompliance(compliance);
                result = parser.parseXml(document, new Vector(), loader, "");
                if (compliance) {
                    RMappingTool rTool = new RMappingTool(result.getAbstractSchema());
                    rTool.createSchemaMapping();
                } else if (result.getAbstractSchema() != null) {
                    RMappingTool rTool = new RMappingTool(result.getAbstractSchema());
                    rTool.createSchemaMapping();
                }
            }
            catch (Exception e) {
                throw new Exception("Can not parse ejb-jar.xml. Reason : " + e.toString());
            }
        }
        try {
            buffer.close();
        }
        catch (Exception e) {
            throw new Exception("Error occurred while closing BufferedInputStream for " + xmlFileLocation + " file:\n" + e.toString());
        }
        return result;
    }

    public WebDeploymentDescriptor getConvertedWebDescriptor(String xmlFileLocation) throws Exception {
        Document document = null;
        WebDeploymentDescriptor result = new WebDeploymentDescriptor();
        BufferedInputStream buffer = null;
        try {
            buffer = new BufferedInputStream(new FileInputStream(xmlFileLocation));
        }
        catch (IOException io) {
            throw new Exception("Can not parse web.xml. Reason : " + io.toString());
        }
        try {
            StandardDOMParser domParser = new StandardDOMParser();
            domParser.setSystemId(xmlFileLocation);
            document = domParser.parse((InputStream)buffer);
            buffer.close();
        }
        catch (IOException ioe) {
            throw new Exception("Can not parse web.xml. Reason : " + ioe.toString());
        }
        catch (Exception ex) {
            throw new Exception("Can not parse web.xml. Reason : " + ex.toString());
        }
        DocumentType dt = document.getDoctype();
        String dtd = "<!DOCTYPE web-app [\n<!ELEMENT web-app (icon?, display-name?, description?, distributable?,\n context-param*, filter*, filter-mapping*, listener*, servlet*, servlet-mapping*, session-config?,\n mime-mapping*, welcome-file-list?, error-page*, taglib*,\n resource-ref*, security-constraint*, login-config?,\n security-role*, env-entry*, ejb-ref*, response-status*)>\n<!ELEMENT icon (small-icon?, large-icon?)>\n <!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT distributable EMPTY>\n<!ELEMENT context-param (param-name, param-value, description?)>\n<!ELEMENT param-name (#PCDATA)>\n<!ELEMENT param-value (#PCDATA)>\n<!ELEMENT filter (icon?, filter-name, display-name?, description?, filter-class, init-param*)>\n<!ELEMENT filter-name (#PCDATA)>\n<!ELEMENT filter-class (#PCDATA)>\n<!ELEMENT filter-mapping (filter-name, (url-pattern | servlet-name))>\n<!ELEMENT listener (listener-class)>\n<!ELEMENT listener-class (#PCDATA)>\n<!ELEMENT servlet (icon?, servlet-name, display-name?, description?,\n(servlet-class|jsp-file), init-param*, load-on-startup?, security-role-ref*)>\n<!ELEMENT servlet-name (#PCDATA)>\n<!ELEMENT servlet-class (#PCDATA)>\n<!ELEMENT jsp-file (#PCDATA)>\n<!ELEMENT init-param (param-name, param-value, description?)>\n<!ELEMENT load-on-startup (#PCDATA)>\n<!ELEMENT servlet-mapping (servlet-name, url-pattern)>\n<!ELEMENT url-pattern (#PCDATA)>\n<!ELEMENT session-config (session-timeout?)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT mime-mapping (extension, mime-type)>\n<!ELEMENT extension (#PCDATA)>\n<!ELEMENT mime-type (#PCDATA)>\n<!ELEMENT welcome-file-list (welcome-file+)>\n<!ELEMENT welcome-file (#PCDATA)>\n<!ELEMENT taglib (taglib-uri, taglib-location)>\n<!ELEMENT taglib-uri (#PCDATA)>\n<!ELEMENT taglib-location (#PCDATA)>\n<!ELEMENT error-page ((error-code | exception-type), location)>\n<!ELEMENT error-code (#PCDATA)>\n<!ELEMENT exception-type (#PCDATA)>\n<!ELEMENT location (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT security-constraint (web-resource-collection+,\n auth-constraint?, user-data-constraint?)>\n<!ELEMENT web-resource-collection (web-resource-name, description?,\n url-pattern*, http-method*)>\n<!ELEMENT web-resource-name (#PCDATA)>\n<!ELEMENT http-method (#PCDATA)>\n<!ELEMENT user-data-constraint (description?, transport-guarantee)>\n<!ELEMENT transport-guarantee (#PCDATA)>\n<!ELEMENT auth-constraint (description?, role-name*)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT login-config (auth-method?, realm-name?, form-login-config?)>\n<!ELEMENT realm-name (#PCDATA)>\n<!ELEMENT form-login-config (form-login-page, form-error-page)>\n<!ELEMENT form-login-page (#PCDATA)>\n<!ELEMENT form-error-page (#PCDATA)>\n<!ELEMENT auth-method (#PCDATA)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-value?,\n env-entry-type)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home,\n   remote,ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n <!ELEMENT response-status (code, description)>\n <!ELEMENT code (#PCDATA)>\n]>";
        if (dt != null && (dtd = dt.getSystemId()) == null) {
            dtd = "<!DOCTYPE web-app [\n<!ELEMENT web-app (icon?, display-name?, description?, distributable?,\n context-param*, filter*, filter-mapping*, listener*, servlet*, servlet-mapping*, session-config?,\n mime-mapping*, welcome-file-list?, error-page*, taglib*,\n resource-ref*, security-constraint*, login-config?,\n security-role*, env-entry*, ejb-ref*, response-status*)>\n<!ELEMENT icon (small-icon?, large-icon?)>\n <!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT distributable EMPTY>\n<!ELEMENT context-param (param-name, param-value, description?)>\n<!ELEMENT param-name (#PCDATA)>\n<!ELEMENT param-value (#PCDATA)>\n<!ELEMENT filter (icon?, filter-name, display-name?, description?, filter-class, init-param*)>\n<!ELEMENT filter-name (#PCDATA)>\n<!ELEMENT filter-class (#PCDATA)>\n<!ELEMENT filter-mapping (filter-name, (url-pattern | servlet-name))>\n<!ELEMENT listener (listener-class)>\n<!ELEMENT listener-class (#PCDATA)>\n<!ELEMENT servlet (icon?, servlet-name, display-name?, description?,\n(servlet-class|jsp-file), init-param*, load-on-startup?, security-role-ref*)>\n<!ELEMENT servlet-name (#PCDATA)>\n<!ELEMENT servlet-class (#PCDATA)>\n<!ELEMENT jsp-file (#PCDATA)>\n<!ELEMENT init-param (param-name, param-value, description?)>\n<!ELEMENT load-on-startup (#PCDATA)>\n<!ELEMENT servlet-mapping (servlet-name, url-pattern)>\n<!ELEMENT url-pattern (#PCDATA)>\n<!ELEMENT session-config (session-timeout?)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT mime-mapping (extension, mime-type)>\n<!ELEMENT extension (#PCDATA)>\n<!ELEMENT mime-type (#PCDATA)>\n<!ELEMENT welcome-file-list (welcome-file+)>\n<!ELEMENT welcome-file (#PCDATA)>\n<!ELEMENT taglib (taglib-uri, taglib-location)>\n<!ELEMENT taglib-uri (#PCDATA)>\n<!ELEMENT taglib-location (#PCDATA)>\n<!ELEMENT error-page ((error-code | exception-type), location)>\n<!ELEMENT error-code (#PCDATA)>\n<!ELEMENT exception-type (#PCDATA)>\n<!ELEMENT location (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT security-constraint (web-resource-collection+,\n auth-constraint?, user-data-constraint?)>\n<!ELEMENT web-resource-collection (web-resource-name, description?,\n url-pattern*, http-method*)>\n<!ELEMENT web-resource-name (#PCDATA)>\n<!ELEMENT http-method (#PCDATA)>\n<!ELEMENT user-data-constraint (description?, transport-guarantee)>\n<!ELEMENT transport-guarantee (#PCDATA)>\n<!ELEMENT auth-constraint (description?, role-name*)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT login-config (auth-method?, realm-name?, form-login-config?)>\n<!ELEMENT realm-name (#PCDATA)>\n<!ELEMENT form-login-config (form-login-page, form-error-page)>\n<!ELEMENT form-login-page (#PCDATA)>\n<!ELEMENT form-error-page (#PCDATA)>\n<!ELEMENT auth-method (#PCDATA)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-value?,\n env-entry-type)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home,\n   remote,ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n <!ELEMENT response-status (code, description)>\n <!ELEMENT code (#PCDATA)>\n]>";
        }
        if (dtd.equals("<!DOCTYPE web-app [\n<!ELEMENT web-app (icon?, display-name?, description?, distributable?,\n context-param*, filter*, filter-mapping*, listener*, servlet*, servlet-mapping*, session-config?,\n mime-mapping*, welcome-file-list?, error-page*, taglib*,\n resource-ref*, security-constraint*, login-config?,\n security-role*, env-entry*, ejb-ref*, response-status*)>\n<!ELEMENT icon (small-icon?, large-icon?)>\n <!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT distributable EMPTY>\n<!ELEMENT context-param (param-name, param-value, description?)>\n<!ELEMENT param-name (#PCDATA)>\n<!ELEMENT param-value (#PCDATA)>\n<!ELEMENT filter (icon?, filter-name, display-name?, description?, filter-class, init-param*)>\n<!ELEMENT filter-name (#PCDATA)>\n<!ELEMENT filter-class (#PCDATA)>\n<!ELEMENT filter-mapping (filter-name, (url-pattern | servlet-name))>\n<!ELEMENT listener (listener-class)>\n<!ELEMENT listener-class (#PCDATA)>\n<!ELEMENT servlet (icon?, servlet-name, display-name?, description?,\n(servlet-class|jsp-file), init-param*, load-on-startup?, security-role-ref*)>\n<!ELEMENT servlet-name (#PCDATA)>\n<!ELEMENT servlet-class (#PCDATA)>\n<!ELEMENT jsp-file (#PCDATA)>\n<!ELEMENT init-param (param-name, param-value, description?)>\n<!ELEMENT load-on-startup (#PCDATA)>\n<!ELEMENT servlet-mapping (servlet-name, url-pattern)>\n<!ELEMENT url-pattern (#PCDATA)>\n<!ELEMENT session-config (session-timeout?)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT mime-mapping (extension, mime-type)>\n<!ELEMENT extension (#PCDATA)>\n<!ELEMENT mime-type (#PCDATA)>\n<!ELEMENT welcome-file-list (welcome-file+)>\n<!ELEMENT welcome-file (#PCDATA)>\n<!ELEMENT taglib (taglib-uri, taglib-location)>\n<!ELEMENT taglib-uri (#PCDATA)>\n<!ELEMENT taglib-location (#PCDATA)>\n<!ELEMENT error-page ((error-code | exception-type), location)>\n<!ELEMENT error-code (#PCDATA)>\n<!ELEMENT exception-type (#PCDATA)>\n<!ELEMENT location (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT security-constraint (web-resource-collection+,\n auth-constraint?, user-data-constraint?)>\n<!ELEMENT web-resource-collection (web-resource-name, description?,\n url-pattern*, http-method*)>\n<!ELEMENT web-resource-name (#PCDATA)>\n<!ELEMENT http-method (#PCDATA)>\n<!ELEMENT user-data-constraint (description?, transport-guarantee)>\n<!ELEMENT transport-guarantee (#PCDATA)>\n<!ELEMENT auth-constraint (description?, role-name*)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT login-config (auth-method?, realm-name?, form-login-config?)>\n<!ELEMENT realm-name (#PCDATA)>\n<!ELEMENT form-login-config (form-login-page, form-error-page)>\n<!ELEMENT form-login-page (#PCDATA)>\n<!ELEMENT form-error-page (#PCDATA)>\n<!ELEMENT auth-method (#PCDATA)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-value?,\n env-entry-type)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home,\n   remote,ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n <!ELEMENT response-status (code, description)>\n <!ELEMENT code (#PCDATA)>\n]>") || dtd.indexOf("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd") > 0) {
            WebConverter converter = new WebConverter();
            result = (WebDeploymentDescriptor)converter.parseDocument(document);
            converter.applyChanges(result);
        } else {
            try {
                result.loadFromDocument(document);
            }
            catch (Exception e) {
                throw new Exception("Can not parse web.xml. Reason : " + e.toString());
            }
        }
        return result;
    }

    public Vector getErrors() {
        return this.errors;
    }

    public void setIsRealApplcaiction(boolean isRealApp) {
        this.isRealApplcaiction = isRealApp;
    }
}

