/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DeployPrjDocument {
    protected StandardDOMWriter writer = null;
    protected StandardDOMParser parser = null;
    protected Document mainDocument = null;
    public static final String dtd = "<!DOCTYPE deploy-project [\n<!ELEMENT deploy-project ( project-dir?,options, tabs)>\n<!ELEMENT project-dir (#PCDATA)>\n<!ELEMENT options (class-path?, tab-transfer)>\n<!ELEMENT class-path (#PCDATA)>\n<!ELEMENT tab-transfer (#PCDATA)>\n<!ELEMENT tabs (tab*)>\n<!ELEMENT tab (#PCDATA)>\n<!ATTLIST tab tab-name CDATA #REQUIRED>]>";

    public DeployPrjDocument() {
        this.initXMLToolkit();
    }

    protected void initDocument() {
        this.mainDocument = StandardDOMParser.createDocument();
    }

    public void loadTabs(String[] xMLLocations, String[] attrValues) {
        Element tabsElement;
        Element mainElement;
        if (this.mainDocument == null) {
            this.initDocument();
        }
        if ((mainElement = this.mainDocument.getDocumentElement()) == null) {
            mainElement = this.mainDocument.createElement("deploy-project");
            this.mainDocument.appendChild(mainElement);
        }
        if ((tabsElement = (Element)this.getFirstChild(mainElement, "tabs")) == null) {
            tabsElement = this.createSimpleElement(mainElement, "tabs", "");
        } else {
            this.removeAllElementsByName(tabsElement, "tab");
        }
        int i = 0;
        while (i < xMLLocations.length) {
            if (xMLLocations[i] != null) {
                Element tabEl = this.createSimpleElement(tabsElement, "tab", xMLLocations[i]);
                tabEl.setAttribute("tab-name", attrValues[i]);
            }
            ++i;
        }
    }

    public void loadOptions(String classPath, String tabTransfer) {
        Element optionsElement;
        Element mainElement;
        if (this.mainDocument == null) {
            this.initDocument();
        }
        if ((mainElement = this.mainDocument.getDocumentElement()) == null) {
            mainElement = this.mainDocument.createElement("deploy-project");
            this.mainDocument.appendChild(mainElement);
        }
        if ((optionsElement = (Element)this.getFirstChild(mainElement, "options")) == null) {
            optionsElement = this.createSimpleElement(mainElement, "options", "");
        } else {
            this.removeAllElementsByName(optionsElement, "class-path");
            this.removeAllElementsByName(optionsElement, "tab-transfer");
        }
        if (classPath == null) {
            this.createSimpleElement(optionsElement, "class-path", "");
        } else {
            this.createSimpleElement(optionsElement, "class-path", classPath);
        }
        if (tabTransfer == null) {
            this.createSimpleElement(optionsElement, "tab-transfer", "");
        } else {
            this.createSimpleElement(optionsElement, "tab-transfer", tabTransfer);
        }
    }

    public void loadProjectDir(String dir) {
        Element mainElement;
        if (this.mainDocument == null) {
            this.initDocument();
        }
        if ((mainElement = this.mainDocument.getDocumentElement()) == null) {
            mainElement = this.mainDocument.createElement("deploy-project");
            this.mainDocument.appendChild(mainElement);
        } else {
            this.removeAllElementsByName(mainElement, "project-dir");
        }
        if (dir == null) {
            this.createSimpleElement(mainElement, "project-dir", "");
        } else {
            this.createSimpleElement(mainElement, "project-dir", dir);
        }
    }

    public String getProjectDir() {
        Element dirElement = (Element)this.getFirstDocumentElement("project-dir");
        return this.getElementValue(dirElement);
    }

    public String[] getXMLLocationsTabs() {
        Element tabsElement = (Element)this.getFirstDocumentElement("tabs");
        NodeList list = tabsElement.getElementsByTagName("tab");
        if (list.getLength() == 0) {
            return null;
        }
        String[] names = new String[list.getLength()];
        int i = 0;
        while (i < list.getLength()) {
            names[i] = this.getElementValue((Element)list.item(i));
            ++i;
        }
        return names;
    }

    public String getClassPath() {
        Element classPathEl = (Element)this.getFirstDocumentElement("class-path");
        String classPath = this.getElementValue(classPathEl);
        if (classPath == null) {
            return "";
        }
        return classPath;
    }

    public String getTabTransfer() {
        Element tabTransferEl = (Element)this.getFirstDocumentElement("tab-transfer");
        String tabTransfer = this.getElementValue(tabTransferEl);
        if (tabTransfer == null) {
            return "";
        }
        return tabTransfer;
    }

    public String[] getTabsNames() {
        Element tabsElement = (Element)this.getFirstDocumentElement("tabs");
        NodeList list = tabsElement.getElementsByTagName("tab");
        if (list.getLength() == 0) {
            return null;
        }
        String[] names = new String[list.getLength()];
        int i = 0;
        while (i < list.getLength()) {
            names[i] = ((Element)list.item(i)).getAttribute("tab-name");
            ++i;
        }
        return names;
    }

    public String getTabsNamesToken() {
        Element tabsElement = (Element)this.getFirstDocumentElement("tabs");
        NodeList list = tabsElement.getElementsByTagName("tab");
        if (list.getLength() == 0) {
            return null;
        }
        String names = new String("");
        int i = 0;
        while (i < list.getLength()) {
            names = names + ((Element)list.item(i)).getAttribute("tab-name") + ";";
            ++i;
        }
        return names;
    }

    public String writeProjectToXML(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (!fileName.endsWith(".dlp")) {
            fileName = fileName + ".dlp";
        }
        File xmlFile = new File(fileName);
        try {
            this.writer.write(this.mainDocument, fileName, dtd, "UTF-8");
            return fileName;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Element createSimpleElement(Element parent, String tag, String value) {
        Element newEl = this.mainDocument.createElement(tag);
        newEl.appendChild(this.mainDocument.createTextNode(value));
        parent.appendChild(newEl);
        return newEl;
    }

    public void readXMLPrjFile(String fileName) throws IOException {
        this.mainDocument = null;
        FileInputStream xMLfis = null;
        BufferedInputStream xmlStream = null;
        try {
            xMLfis = new FileInputStream(fileName);
            xmlStream = new BufferedInputStream(xMLfis);
            try {
                this.parser.setSystemId(fileName);
                this.mainDocument = this.parser.parse((InputStream)xmlStream);
            }
            catch (SAXException sax) {
                throw new IOException(sax.getMessage());
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                xmlStream.close();
                xMLfis.close();
            }
            catch (Exception ioEx) {
                throw new IOException(ioEx.getMessage());
            }
            throw throwable;
        }
        try {
            xmlStream.close();
            xMLfis.close();
        }
        catch (Exception ioEx) {
            throw new IOException(ioEx.getMessage());
        }
        Element docElement = this.mainDocument.getDocumentElement();
    }

    private Node getFirstChild(Element el, String name) {
        NodeList list = el.getElementsByTagName(name);
        if (list == null || list.getLength() == 0) {
            return null;
        }
        return list.item(0);
    }

    private String getElementValue(Element el) {
        if (el == null) {
            return null;
        }
        Node child = el.getFirstChild();
        if (child == null) {
            return null;
        }
        return child.getNodeValue().trim();
    }

    private Node getFirstDocumentElement(String name) {
        NodeList list = this.mainDocument.getElementsByTagName(name);
        if (list.getLength() == 0) {
            return null;
        }
        return list.item(0);
    }

    private void removeAllElementsByName(Element el, String name) {
        NodeList list = el.getElementsByTagName(name);
        int i = 0;
        while (i < list.getLength()) {
            el.removeChild(list.item(i));
            ++i;
        }
    }

    private void initXMLToolkit() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.writer = new StandardDOMWriter();
        this.parser = new StandardDOMParser();
        Thread.currentThread().setContextClassLoader(cl);
    }
}

