/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.tool;

import com.sap.engine.gui.lf.LookAndFeelFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class DeployFrameOptions
extends Properties {
    public static int INITIAL_WIDTH = 510;
    public static int INITIAL_HEIGHT = 515;
    public static int MAX_RECONNECT = 4;
    private String fileName;
    private String optionsName = "Basic Deploy Frame Options";
    protected LookAndFeelFactory lfFactory = new LookAndFeelFactory();
    public static String REMOTE_P4_PORT = "RemotePort";
    public static String HTTP_TUNNELING_PORT = "Http_tunneling_port";
    public static String SSL_PORT = "Ssl_port";
    public static String HTTPS_PORT = "Https_port";

    public DeployFrameOptions(String fileName, String optionsName) {
        this.fileName = fileName;
        this.optionsName = optionsName;
        try {
            FileInputStream propStream = new FileInputStream(fileName);
            this.load(propStream);
            propStream.close();
            this.lfFactory.load((Properties)this);
        }
        catch (IOException ex) {
            this.initDefaultProperties();
        }
        this.recoverProperties();
        String availableTabs = this.getProperty("AvailableTabs");
        String defaultTabs = this.getProperty("DefaultTabs");
        boolean hasServerComponent = false;
        int index = -1;
        index = defaultTabs.indexOf(";ServerComponents");
        if (index != -1) {
            defaultTabs = defaultTabs.substring(0, index) + defaultTabs.substring(index + 17);
            hasServerComponent = true;
        }
        if ((index = defaultTabs.indexOf(";Server Components")) != -1) {
            defaultTabs = defaultTabs.substring(0, index) + defaultTabs.substring(index + 18);
            hasServerComponent = true;
        }
        if ((index = availableTabs.indexOf(";ServerComponents")) != -1) {
            availableTabs = availableTabs.substring(0, index) + availableTabs.substring(index + 17);
        }
        if ((index = availableTabs.indexOf(";Server Components")) != -1) {
            availableTabs = availableTabs.substring(0, index) + availableTabs.substring(index + 18);
        }
        if (availableTabs != null && availableTabs.indexOf("Server Components") == -1) {
            if (availableTabs.endsWith(";")) {
                this.setProperty("AvailableTabs", availableTabs + "Server Components");
                availableTabs = availableTabs + "Server Components";
            } else {
                this.setProperty("AvailableTabs", availableTabs + ";Server Components");
                availableTabs = availableTabs + ";Server Components";
            }
        }
        if (defaultTabs != null && defaultTabs.indexOf("Server Components") == -1 && hasServerComponent) {
            if (defaultTabs.endsWith(";")) {
                this.setProperty("DefaultTabs", defaultTabs + "Server Components");
                defaultTabs = defaultTabs + "Server Components";
            } else {
                this.setProperty("DefaultTabs", defaultTabs + ";Server Components");
                defaultTabs = defaultTabs + ";Server Components";
            }
        }
        if (this.getProperty("ServerComponents") != null) {
            ((Hashtable)this).remove("ServerComponents");
        }
        if (this.getProperty("Server Components") == null) {
            this.setProperty("Server Components", "com.sap.engine.deploy.tool.server.ServerComponentsTab");
        }
        if (this.getProperty("J2EEComponents") != null) {
            ((Hashtable)this).remove("J2EEComponents");
        }
        if (this.getProperty("J2EE Components") == null) {
            this.setProperty("J2EE Components", "com.sap.engine.deploy.tool.components.ComponentsTab");
        }
        this.setProperty("AvailableTabs", availableTabs);
        this.setProperty("DefaultTabs", defaultTabs);
    }

    public String getLookAndFeel() {
        return this.getProperty("LookAndFeel");
    }

    public void setLookAndFeel(String landf) {
        ((Hashtable)this).put("LookAndFeel", landf);
    }

    public void setBrowserPath(String path) {
        ((Hashtable)this).put("BrowserPath", path);
    }

    public void saveProperties() {
        try {
            this.lfFactory.store((Properties)this);
            FileOutputStream propStream = new FileOutputStream(this.fileName);
            this.store(propStream, this.optionsName);
            propStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void putAvailableLF(Properties prop) {
        if (prop == null) {
            return;
        }
        String s = "";
        if (prop.getProperty("LAF") != null) {
            s = prop.getProperty("LAF");
            StringTokenizer st = new StringTokenizer(s, ";");
            while (st.hasMoreTokens()) {
                String sTemp = "";
                sTemp = st.nextToken();
                this.lfFactory.add(sTemp, prop.getProperty(sTemp));
            }
        }
    }

    public void loadAvailableLF(Properties prop) {
        if (prop == null) {
            return;
        }
        String lfNames = this.getProperty("UsersLookAndFeelNames");
        String lfClasses = this.getProperty("UsersLookAndFeelClasses");
        if (lfNames == null || lfClasses == null) {
            return;
        }
        StringTokenizer stNames = new StringTokenizer(lfNames, ";");
        StringTokenizer stClasses = new StringTokenizer(lfClasses, ";");
        if (stNames.countTokens() != stClasses.countTokens()) {
            return;
        }
        prop.setProperty("LAF", lfNames);
        String sName = "";
        String sClass = "";
        while (stNames.hasMoreTokens()) {
            sName = stNames.nextToken();
            sClass = stClasses.nextToken();
            if (sName == null || stClasses == null) continue;
            prop.setProperty(sName, sClass);
        }
    }

    public void setFrameProperties(Frame frame) {
        int locatX = frame.getLocation().x;
        int locatY = frame.getLocation().y;
        int width = frame.getSize().width;
        int height = frame.getSize().height;
        ((Hashtable)this).put("FrameLocationX", String.valueOf(locatX));
        ((Hashtable)this).put("FrameLocationY", String.valueOf(locatY));
        ((Hashtable)this).put("FrameWidth", String.valueOf(width));
        ((Hashtable)this).put("FrameHeight", String.valueOf(height));
    }

    public void updateFrameLocation(Frame frame) {
        try {
            int locatX = Integer.parseInt(this.getProperty("FrameLocationX"));
            int locatY = Integer.parseInt(this.getProperty("FrameLocationY"));
            int width = Integer.parseInt(this.getProperty("FrameWidth"));
            int height = Integer.parseInt(this.getProperty("FrameHeight"));
            ((Component)frame).setLocation(locatX, locatY);
            ((Component)frame).setSize(width, height);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(frame, "Saved location and/or size for this frame is not correct.\n" + ex.toString(), "Warning", 2);
        }
    }

    public LookAndFeelFactory getLookAndFeelFactory() {
        return this.lfFactory;
    }

    public void setLookAndFeelFactory(LookAndFeelFactory factory) {
        this.lfFactory = factory;
        this.saveProperties();
    }

    public void setTabs(Properties properties) {
        if (properties == null) {
            return;
        }
        String availableTabs = properties.getProperty("AvailableTabs");
        String defaultTabs = properties.getProperty("DefaultTabs");
        if (defaultTabs == null) {
            return;
        }
        ((Hashtable)this).put("DefaultTabs", defaultTabs);
        this.saveProperties();
    }

    private String searchBrowser() {
        String fs = File.separator;
        File f1 = new File("C:\\Program Files\\Netscape\\Communicator\\Program\\netscape.exe");
        if (f1.exists()) {
            return f1.getAbsolutePath();
        }
        f1 = new File("C:\\Program Files\\Plus!\\Microsoft Internet\\Iexplore.exe");
        if (f1.exists()) {
            return f1.getAbsolutePath();
        }
        f1 = new File("c:\\program files\\internet explorer\\iexplore.exe");
        if (f1.exists()) {
            return f1.getAbsolutePath();
        }
        f1 = new File("/usr/bin/netscape");
        if (f1.exists()) {
            return f1.getAbsolutePath();
        }
        return "";
    }

    public void initDefaultProperties() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int locatX = screenSize.width / 2 - INITIAL_WIDTH / 2;
        int locatY = screenSize.height / 2 - INITIAL_HEIGHT / 2;
        ((Hashtable)this).put("FrameLocationX", String.valueOf(locatX));
        ((Hashtable)this).put("FrameLocationY", String.valueOf(locatY));
        ((Hashtable)this).put("FrameWidth", String.valueOf(INITIAL_WIDTH));
        ((Hashtable)this).put("FrameHeight", String.valueOf(INITIAL_HEIGHT));
        ((Hashtable)this).put("LookAndFeel", "Metal");
        ((Hashtable)this).put("DefaultTabs", "J2EE Components;Assembler;Deployer;Server Components");
        ((Hashtable)this).put("AvailableTabs", "J2EE Components;Assembler;Deployer;Server Components");
        ((Hashtable)this).put("J2EE Components", "com.sap.engine.deploy.tool.components.ComponentsTab");
        ((Hashtable)this).put("Assembler", "com.sap.engine.deploy.tool.assembler.AssembleTab");
        ((Hashtable)this).put("Deployer", "com.sap.engine.deploy.tool.deployer.DeployTab");
        ((Hashtable)this).put("Server Components", "com.sap.engine.deploy.tool.server.ServerComponentsTab");
        ((Hashtable)this).put("BrowserPath", this.searchBrowser());
        ((Hashtable)this).put(REMOTE_P4_PORT, "50004");
        ((Hashtable)this).put(HTTP_TUNNELING_PORT, "50005");
        ((Hashtable)this).put(SSL_PORT, "50006");
        ((Hashtable)this).put(HTTPS_PORT, "50001");
        this.saveProperties();
    }

    private void recoverProperties() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int locatX = screenSize.width / 2 - INITIAL_WIDTH / 2;
        int locatY = screenSize.height / 2 - INITIAL_HEIGHT / 2;
        if (this.getProperty("FrameLocationX") == null) {
            ((Hashtable)this).put("FrameLocationX", String.valueOf(locatX));
        }
        if (this.getProperty("FrameLocationY") == null) {
            ((Hashtable)this).put("FrameLocationY", String.valueOf(locatY));
        }
        if (this.getProperty("FrameWidth") == null) {
            ((Hashtable)this).put("FrameWidth", String.valueOf(INITIAL_WIDTH));
        }
        if (this.getProperty("FrameHeight") == null) {
            ((Hashtable)this).put("FrameHeight", String.valueOf(INITIAL_HEIGHT));
        }
        if (this.getProperty("LookAndFeel") == null) {
            ((Hashtable)this).put("LookAndFeel", "Metal");
        }
        if (this.getProperty("DefaultTabs") == null) {
            ((Hashtable)this).put("DefaultTabs", "J2EE Components;Assembler;Deployer;Server Components");
        }
        if (this.getProperty("AvailableTabs") == null) {
            ((Hashtable)this).put("AvailableTabs", "J2EE Components;Assembler;Deployer;Server Components");
        }
        if (this.getProperty("J2EE Components") == null) {
            ((Hashtable)this).put("J2EE Components", "com.sap.engine.deploy.tool.components.ComponentsTab");
        }
        if (this.getProperty("Assembler") == null) {
            ((Hashtable)this).put("Assembler", "com.sap.engine.deploy.tool.assembler.AssembleTab");
        }
        if (this.getProperty("Deployer") == null) {
            ((Hashtable)this).put("Deployer", "com.sap.engine.deploy.tool.deployer.DeployTab");
        }
        if (this.getProperty("Server Components") == null) {
            ((Hashtable)this).put("Server Components", "com.sap.engine.deploy.tool.server.ServerComponentsTab");
        }
        if (this.getProperty(REMOTE_P4_PORT) == null) {
            ((Hashtable)this).put(REMOTE_P4_PORT, "50004");
        }
        if (this.getProperty(HTTP_TUNNELING_PORT) == null) {
            ((Hashtable)this).put(HTTP_TUNNELING_PORT, "50005");
        }
        if (this.getProperty(SSL_PORT) == null) {
            ((Hashtable)this).put(SSL_PORT, "50006");
        }
        if (this.getProperty(HTTPS_PORT) == null) {
            ((Hashtable)this).put(HTTPS_PORT, "50001");
        }
    }
}

