/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.server.provider;

import com.sap.engine.deploy.server.provider.MainProviderDocument;
import com.sap.engine.deploy.tool.server.common.ServiceSecurity;
import com.sap.engine.lib.xml.StandardDOMParser;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceProviderDocument
extends MainProviderDocument {
    protected String communication = null;
    protected String application = null;
    protected ServiceSecurity security = null;
    protected String runtimeEditor = null;
    public static final String dtd = "<!DOCTYPE provider-descriptor SYSTEM \"service.provider.dtd\">";
    public static final String dtd_old = "<!DOCTYPE provider-descriptor [<!ELEMENT provider-descriptor (display-name, component-name, description?, communication-frame?, application-frame?, runtime-editor?, major-version, minor-version, micro-version, provider-name?, group-name?, references?, jars, security?)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT component-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT communication-frame (#PCDATA)>\n<!ELEMENT application-frame (#PCDATA)>\n<!ELEMENT runtime-editor (#PCDATA)>\n<!ELEMENT major-version (#PCDATA)>\n<!ELEMENT minor-version (#PCDATA)>\n<!ELEMENT micro-version (#PCDATA)>\n<!ELEMENT provider-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT references (reference*)>\n<!ELEMENT reference (#PCDATA)>\n  <!ATTLIST reference type (service|library|interface) #REQUIRED>\n  <!ATTLIST reference strength (weak|hard|notify) #REQUIRED>\n<!ELEMENT jars (jar-name+)>\n<!ELEMENT jar-name (#PCDATA)>\n<!ELEMENT security (resource+)>\n<!ELEMENT resource (action+)>\n  <!ATTLIST resource class CDATA #REQUIRED> \n<!ELEMENT action EMPTY> \n  <!ATTLIST action method CDATA #REQUIRED>   <!ATTLIST action security-role (administrators|all|guests) #REQUIRED> \n]>";

    public MainProviderDocument loadFieldsFromDocument() {
        Element mainElement = this.mainDocument.getDocumentElement();
        NodeList list = mainElement.getChildNodes();
        Element elm = null;
        String name = null;
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() == 1) {
                    elm = (Element)list.item(i);
                    name = elm.getTagName();
                    if (name.equals("display-name")) {
                        this.displayName = this.getTextValue(elm);
                    } else if (name.equals("component-name")) {
                        this.componentName = this.getTextValue(elm);
                    } else if (name.equals("description")) {
                        this.description = this.getTextValue(elm);
                    } else if (name.equals("communication-frame")) {
                        this.communication = this.getTextValue(elm);
                    } else if (name.equals("application-frame")) {
                        this.application = this.getTextValue(elm);
                    } else if (name.equals("runtime-editor")) {
                        this.runtimeEditor = this.getTextValue(elm);
                    } else if (name.equals("major-version")) {
                        this.majorVersion = this.getTextValue(elm);
                    } else if (name.equals("minor-version")) {
                        this.minorVersion = this.getTextValue(elm);
                    } else if (name.equals("micro-version")) {
                        this.microVersion = this.getTextValue(elm);
                    } else if (name.equals("provider-name")) {
                        this.providerName = this.getTextValue(elm);
                    } else if (name.equals("group-name")) {
                        this.groupName = this.getTextValue(elm);
                    } else if (name.equals("references")) {
                        this.initRefs(elm);
                    } else if (name.equals("jars")) {
                        this.initJars(elm);
                    } else if (name.toLowerCase().equals("security")) {
                        this.initSecurity(elm);
                    }
                }
                ++i;
            }
        }
        return this;
    }

    public Document loadDocumentFromFields() {
        this.mainDocument = StandardDOMParser.createDocument();
        Element mainElement = this.mainDocument.createElement("provider-descriptor");
        this.mainDocument.appendChild(mainElement);
        this.load(mainElement, this.displayName, "display-name");
        this.load(mainElement, this.componentName, "component-name");
        if (this.description != null) {
            this.load(mainElement, this.description, "description");
        }
        if (this.communication != null && !this.communication.trim().equals("")) {
            this.load(mainElement, this.communication, "communication-frame");
        }
        if (this.application != null && !this.application.trim().equals("")) {
            this.load(mainElement, this.application, "application-frame");
        }
        this.load(mainElement, this.runtimeEditor, "runtime-editor");
        this.load(mainElement, this.majorVersion, "major-version");
        this.load(mainElement, this.minorVersion, "minor-version");
        this.load(mainElement, this.microVersion, "micro-version");
        if (this.providerName != null) {
            this.load(mainElement, this.providerName, "provider-name");
        }
        this.load(mainElement, this.groupName, "group-name");
        if (this.references != null && this.references.size() > 0) {
            this.loadRefs(mainElement);
        }
        this.loadJars(mainElement);
        this.loadSecurity(mainElement);
        return this.mainDocument;
    }

    public void setCommunicationFrame(String commFrame) {
        this.communication = commFrame;
    }

    public void setApplicationFrame(String appFrame) {
        this.application = appFrame;
    }

    public String getCommunicationFrame() {
        return this.communication;
    }

    public String getApplicationFrame() {
        return this.application;
    }

    public void initSecurity(Element parent) {
        Hashtable resources = new Hashtable();
        Hashtable<String, String> actions = null;
        String className = null;
        NodeList resList = parent.getChildNodes();
        Node resNode = null;
        NodeList actList = null;
        Node actNode = null;
        if (resList != null) {
            int i = 0;
            while (i < resList.getLength()) {
                resNode = resList.item(i);
                if (resNode.getNodeType() == 1) {
                    className = ((Element)resNode).getAttribute("class");
                    actList = resNode.getChildNodes();
                    actions = new Hashtable<String, String>();
                    int j = 0;
                    while (j < actList.getLength()) {
                        actNode = actList.item(j);
                        if (actNode.getNodeType() == 1) {
                            actions.put(((Element)actNode).getAttribute("method"), ((Element)actNode).getAttribute("security-role"));
                        }
                        ++j;
                    }
                    resources.put(className, actions);
                }
                ++i;
            }
            this.security = new ServiceSecurity(resources);
        }
    }

    protected void loadSecurity(Element parent) {
        if (this.security != null) {
            Element secEl = this.mainDocument.createElement("security");
            Hashtable resources = this.security.getResources();
            String className = null;
            Hashtable actions = null;
            String method = null;
            Element el_1 = null;
            Element el_2 = null;
            Enumeration e = resources.keys();
            while (e.hasMoreElements()) {
                className = (String)e.nextElement();
                el_1 = this.load(secEl, null, "resource");
                el_1.setAttribute("class", className);
                actions = (Hashtable)resources.get(className);
                Enumeration enumeration = actions.keys();
                while (enumeration.hasMoreElements()) {
                    method = (String)enumeration.nextElement();
                    el_2 = this.load(el_1, null, "action");
                    el_2.setAttribute("method", method);
                    el_2.setAttribute("security-role", (String)actions.get(method));
                }
            }
            parent.appendChild(secEl);
        }
    }

    public ServiceSecurity getSecurity() {
        return this.security;
    }

    public void setSecurity(ServiceSecurity _security) {
        this.security = _security;
    }

    public String getRuntimeEditor() {
        return this.runtimeEditor;
    }

    public void setRuntimeEditor(String _runtimeEditor) {
        this.runtimeEditor = _runtimeEditor;
    }
}

