/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.server.provider;

import com.sap.engine.lib.xml.StandardDOMParser;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class MainProviderDocument {
    public static final String dtd = "";
    public static final String SERVICE_REF_TYPE = "service";
    public static final String LIBRARY_REF_TYPE = "library";
    public static final String INTERFACE_REF_TYPE = "interface";
    public static final String WEAK_REF = "weak";
    public static final String HARD_REF = "hard";
    public static final String NOTIFY_REF = "notify";
    protected String displayName = null;
    protected String componentName = null;
    protected String description = null;
    protected String majorVersion = "1";
    protected String minorVersion = "1";
    protected String microVersion = "1";
    protected String providerName = "sap.com";
    protected String groupName = null;
    protected Hashtable references = new Hashtable();
    protected Hashtable refStrength = new Hashtable();
    protected String[] jars = null;
    protected Document mainDocument;

    public MainProviderDocument loadFieldsFromDocument() {
        Element mainElement = this.mainDocument.getDocumentElement();
        NodeList list = mainElement.getChildNodes();
        Element elm = null;
        String name = null;
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() == 1) {
                    elm = (Element)list.item(i);
                    name = elm.getTagName();
                    if (name.equals("display-name")) {
                        this.displayName = this.getTextValue(elm);
                    } else if (name.equals("component-name")) {
                        this.componentName = this.getTextValue(elm);
                    } else if (name.equals("description")) {
                        this.description = this.getTextValue(elm);
                    } else if (name.equals("major-version")) {
                        this.majorVersion = this.getTextValue(elm);
                    } else if (name.equals("minor-version")) {
                        this.minorVersion = this.getTextValue(elm);
                    } else if (name.equals("micro-version")) {
                        this.microVersion = this.getTextValue(elm);
                    } else if (name.equals("provider-name")) {
                        this.providerName = this.getTextValue(elm);
                    } else if (name.equals("group-name")) {
                        this.groupName = this.getTextValue(elm);
                    } else if (name.equals("references")) {
                        this.initRefs(elm);
                    } else if (name.equals("jars")) {
                        this.initJars(elm);
                    }
                }
                ++i;
            }
        }
        return this;
    }

    protected void initJars(Element parent) {
        NodeList list = parent.getChildNodes();
        this.jars = null;
        if (list != null) {
            Vector<String> v = new Vector<String>();
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() == 1) {
                    v.add(this.getTextValue((Element)list.item(i)));
                }
                ++i;
            }
            if (v.size() > 0) {
                this.jars = new String[v.size()];
                v.copyInto(this.jars);
            }
        }
    }

    protected void initRefs(Element parent) {
        NodeList list = parent.getChildNodes();
        this.references = new Hashtable();
        if (list != null) {
            this.refStrength = new Hashtable();
            String name = null;
            String refType = null;
            String refStr = null;
            Element elm = null;
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() == 1) {
                    elm = (Element)list.item(i);
                    name = this.getTextValue(elm);
                    refType = elm.getAttribute("type");
                    this.references.put(name, refType);
                    refStr = elm.getAttribute("strength");
                    this.refStrength.put(name, refStr);
                }
                ++i;
            }
        }
    }

    public Document loadDocumentFromFields() {
        this.mainDocument = StandardDOMParser.createDocument();
        Element mainElement = this.mainDocument.createElement("provider-descriptor");
        this.mainDocument.appendChild(mainElement);
        this.load(mainElement, this.displayName, "display-name");
        this.load(mainElement, this.componentName, "component-name");
        if (this.description != null) {
            this.load(mainElement, this.description, "description");
        }
        this.load(mainElement, this.majorVersion, "major-version");
        this.load(mainElement, this.minorVersion, "minor-version");
        this.load(mainElement, this.microVersion, "micro-version");
        this.load(mainElement, this.providerName, "provider-name");
        if (this.groupName != null) {
            this.load(mainElement, this.groupName, "group-name");
        }
        if (this.references != null && this.references.size() > 0) {
            this.loadRefs(mainElement);
        }
        this.loadJars(mainElement);
        return this.mainDocument;
    }

    protected void loadJars(Element parent) {
        if (this.jars != null) {
            Element jarsEl = this.mainDocument.createElement("jars");
            int i = 0;
            while (i < this.jars.length) {
                this.load(jarsEl, this.jars[i], "jar-name");
                ++i;
            }
            parent.appendChild(jarsEl);
        }
    }

    protected void loadRefs(Element parent) {
        if (this.references != null) {
            Element refsEl = this.mainDocument.createElement("references");
            String key = null;
            String type = null;
            String refStr = null;
            Element el = null;
            Enumeration enumeration = this.references.keys();
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                type = (String)this.references.get(key);
                refStr = (String)this.refStrength.get(key);
                el = this.load(refsEl, key, "reference");
                el.setAttribute("type", type);
                el.setAttribute("strength", refStr);
            }
            parent.appendChild(refsEl);
        }
    }

    protected String getTextValue(Element element) {
        Node node;
        if (element != null && (node = element.getFirstChild()) != null && node.getNodeType() == 3) {
            String value = node.getNodeValue();
            if (value.trim().equals(dtd) || value.trim().equals("null")) {
                return null;
            }
            return value.trim();
        }
        return null;
    }

    protected Element load(Element el, String value, String tagName) {
        if (value == null) {
            value = dtd;
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return nextElement;
    }

    public void setMainDocument(Document document) {
        this.mainDocument = document;
    }

    public Document getMainDocument() {
        return this.mainDocument;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public String getMicroVersion() {
        return this.microVersion;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Hashtable getReferences() {
        return this.references;
    }

    public Hashtable getRefStrength() {
        return this.refStrength;
    }

    public String[] getJars() {
        return this.jars;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setComponentName(String _componentName) {
        this.componentName = _componentName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMajorVersion(String majorVersion) {
        this.majorVersion = majorVersion;
    }

    public void setMinorVersion(String minorVersion) {
        this.minorVersion = minorVersion;
    }

    public void setMicroVersion(String microVersion) {
        this.microVersion = microVersion;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setReferences(Hashtable references) {
        this.references = references;
    }

    public void setRefStrength(Hashtable refStrength) {
        this.refStrength = refStrength;
    }

    public void setJars(String[] jars) {
        this.jars = jars;
    }
}

