/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.server.provider;

import com.sap.engine.deploy.server.provider.MainProviderDocument;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InterfaceProviderDocument
extends MainProviderDocument {
    public static final String dtd = "<!DOCTYPE provider-descriptor SYSTEM \"interface.provider.dtd\">";
    public static final String dtd_old = "<!DOCTYPE provider-descriptor [<!ELEMENT provider-descriptor (display-name, component-name, description?,  major-version, minor-version, micro-version, provider-name?, group-name?, references?, jars)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT component-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT major-version (#PCDATA)>\n<!ELEMENT minor-version (#PCDATA)>\n<!ELEMENT micro-version (#PCDATA)>\n<!ELEMENT provider-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT references (reference)*>\n<!ELEMENT reference (#PCDATA)>\n  <!ATTLIST reference type (interface) #REQUIRED>\n  <!ATTLIST reference strength (weak) #REQUIRED>\n<!ELEMENT jars (jar-name)*>\n  <!ATTLIST jars default (true) #IMPLIED><!ELEMENT jar-name (#PCDATA)>\n]>";
    private boolean isDefaultJars = false;

    protected void initJars(Element parent) {
        NodeList list = parent.getChildNodes();
        this.jars = null;
        if (list != null && list.getLength() > 0) {
            Vector<String> v = new Vector<String>();
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() == 1) {
                    v.add(this.getTextValue((Element)list.item(i)));
                }
                ++i;
            }
            if (v.size() > 0) {
                this.jars = new String[v.size()];
                v.copyInto(this.jars);
            }
        }
        if (parent.getAttribute("default").equals("true") || this.jars == null) {
            this.isDefaultJars = true;
            this.jars = new String[0];
        }
    }

    protected void loadJars(Element parent) {
        Element jarsEl = this.mainDocument.createElement("jars");
        if (this.isDefaultJars) {
            jarsEl.setAttribute("default", "true");
        } else if (this.jars == null || this.jars.length == 0) {
            jarsEl.setAttribute("default", "true");
        } else {
            int i = 0;
            while (i < this.jars.length) {
                this.load(jarsEl, this.jars[i], "jar-name");
                ++i;
            }
        }
        parent.appendChild(jarsEl);
    }

    protected void initRefs(Element parent) {
        NodeList list = parent.getChildNodes();
        this.references = new Hashtable();
        if (list != null) {
            this.refStrength = new Hashtable();
            String name = null;
            Element elm = null;
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() == 1) {
                    elm = (Element)list.item(i);
                    name = this.getTextValue(elm);
                    this.references.put(name, "interface");
                    this.refStrength.put(name, "weak");
                }
                ++i;
            }
        }
    }

    protected void loadRefs(Element parent) {
        if (this.references != null) {
            Element refsEl = this.mainDocument.createElement("references");
            String key = null;
            Element el = null;
            Enumeration enumeration = this.references.keys();
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                el = this.load(refsEl, key, "reference");
                el.setAttribute("type", "interface");
                el.setAttribute("strength", "weak");
            }
            parent.appendChild(refsEl);
        }
    }

    public boolean isDefaultJars() {
        return this.isDefaultJars;
    }

    public void setDefaultJars(boolean defaultJars) {
        this.isDefaultJars = defaultJars;
    }
}

