/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.server;

import com.sap.engine.deploy.manager.LoginInfo;
import com.sap.engine.deploy.server.CPropertyObject;
import com.sap.engine.deploy.server.SComponentObject;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.xml.StandardDOMParser;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ServerComponentDocument {
    private SComponentObject[] components;
    private String prjDir = null;
    private LoginInfo info = new LoginInfo();
    private Document mainDocument = null;
    public static final String dtd = "<!DOCTYPE server-components-generator [ \n<!ELEMENT server-components-generator (project-dir?, components, login-info?)>\n<!ELEMENT components (component+)>\n<!ELEMENT component (name?, file-name,  jars, components-properties)>\n<!ATTLIST component component-type (service|library|interfase) #REQUIRED>\n<!ELEMENT name (#PCDATA)>\n<!ELEMENT file-name (#PCDATA)>\n<!ELEMENT jars (jar+)>\n<!ELEMENT jar (file-path, entry-name)>\n<!ELEMENT entry-name (#PCDATA)>\n<!ELEMENT file-path (#PCDATA)>\n<!ELEMENT components-properties (provider-xml+, property-file*, service-dir?)>\n<!ELEMENT property-file (#PCDATA)>\n<!ATTLIST property-file target (alone|server|dispatcher) #REQUIRED>\n<!ELEMENT provider-xml (#PCDATA)>\n<!ATTLIST provider-xml target (alone|server|dispatcher) #REQUIRED>\n<!ELEMENT login-info (host, port, transport-protocol*, user-name, user-password)>\n<!ELEMENT host (#PCDATA)>\n<!ELEMENT port (#PCDATA)>\n<!ELEMENT transport-protocol (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT user-password (#PCDATA)>\n]>";

    public void setSComponents(SComponentObject[] components) {
        this.components = components;
    }

    public SComponentObject[] getSComponent() {
        return this.components;
    }

    public String getProjectDir() {
        return this.prjDir;
    }

    public void setProjectDir(String prjDir) {
        this.prjDir = prjDir;
    }

    public void setLoginInfo(LoginInfo info) {
        this.info = info;
    }

    public LoginInfo getLoginInfo() {
        return this.info;
    }

    public SComponentObject[] loadFieldsFromDocument(Document mainDocument) {
        Element mainEl = mainDocument.getDocumentElement();
        NodeList list = mainEl.getChildNodes();
        NodeList list1 = null;
        String tag = null;
        Vector<SComponentObject> comps = new Vector<SComponentObject>();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                tag = list.item(i).getNodeName();
                if (tag.equals("project-dir")) {
                    this.prjDir = this.getTextValue((Element)list.item(i));
                } else if (tag.equals("components")) {
                    list1 = list.item(i).getChildNodes();
                    int i1 = 0;
                    while (i1 < list1.getLength()) {
                        if (list1.item(i1).getNodeType() == 1 && list1.item(i1).getNodeName().equals("component")) {
                            comps.add(this.initComponent((Element)list1.item(i1)));
                        }
                        ++i1;
                    }
                } else if (tag.equals("login-info")) {
                    this.initLoginInfo((Element)list.item(i));
                }
            }
            ++i;
        }
        this.components = new SComponentObject[comps.size()];
        comps.copyInto(this.components);
        return this.components;
    }

    private SComponentObject initComponent(Element compEl) {
        SComponentObject component = new SComponentObject();
        NodeList list = compEl.getChildNodes();
        component.setCompType(compEl.getAttribute("component-type"));
        Element element = null;
        String tag = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                element = (Element)list.item(i);
                tag = element.getTagName();
                if (tag.equals("name")) {
                    component.setName(this.getTextValue(element));
                } else if (tag.equals("file-name")) {
                    component.setFileName(this.getTextValue(element));
                } else if (tag.equals("jars")) {
                    this.initJars(component, element);
                } else if (tag.equals("components-properties")) {
                    this.initProps(component, element);
                }
            }
            ++i;
        }
        return component;
    }

    private void initProps(SComponentObject compObj, Element propsEl) {
        NodeList list = propsEl.getChildNodes();
        Element temp = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                temp = (Element)list.item(i);
                if (temp.getTagName().equals("provider-xml")) {
                    compObj.addProviderXML(this.getTextValue(temp), temp.getAttribute("target"));
                } else if (temp.getTagName().equals("property-file")) {
                    compObj.addPropertyFile(this.getTextValue(temp), temp.getAttribute("target"));
                } else if (temp.getTagName().equals("service-dir")) {
                    compObj.addServiceDir(this.getTextValue(temp), temp.getAttribute("target"));
                }
            }
            ++i;
        }
    }

    private void initJars(SComponentObject compObj, Element jarsEl) {
        NodeList list = jarsEl.getChildNodes();
        NodeList tempList = null;
        Element temp = null;
        String path = null;
        String entry = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1 && ((Element)list.item(i)).getTagName().equals("jar")) {
                tempList = ((Element)list.item(i)).getChildNodes();
                path = null;
                entry = null;
                int i1 = 0;
                while (i1 < tempList.getLength()) {
                    if (tempList.item(i1).getNodeType() == 1) {
                        temp = (Element)tempList.item(i1);
                        if (temp.getTagName().equals("file-path")) {
                            path = this.getTextValue(temp);
                        } else if (temp.getTagName().equals("entry-name")) {
                            entry = this.getTextValue(temp);
                        }
                    }
                    ++i1;
                }
                compObj.addJar(path, entry);
            }
            ++i;
        }
    }

    protected void initLoginInfo(Element el) {
        NodeList loginList = el.getChildNodes();
        if (loginList != null) {
            Element loginEl = null;
            String nextElTag = null;
            String value = null;
            Vector<String> protocol = new Vector<String>();
            int i = 0;
            while (i < loginList.getLength()) {
                if (loginList.item(i).getNodeType() == 1) {
                    loginEl = (Element)loginList.item(i);
                    nextElTag = loginEl.getNodeName();
                    if (nextElTag.equals("host")) {
                        value = this.getTextValue(loginEl);
                        this.info.setRemoteHost(value);
                    } else if (nextElTag.equals("port")) {
                        value = this.getTextValue(loginEl);
                        this.info.setRemotePort(Integer.parseInt(value));
                    } else if (nextElTag.equals("transport-protocol")) {
                        value = this.getTextValue(loginEl);
                        protocol.add(value);
                    } else if (nextElTag.equals("user-name")) {
                        value = this.getTextValue(loginEl);
                        this.info.setUserName(value);
                    } else if (nextElTag.equals("user-password")) {
                        value = this.getTextValue(loginEl);
                        this.info.setUserPassword(value);
                    }
                }
                ++i;
            }
            Object[] transportProtocol = new String[protocol.size()];
            protocol.copyInto(transportProtocol);
            this.info.setTransportProtocol((String[])transportProtocol);
        }
    }

    public Document loadDocumentFromFields() {
        this.mainDocument = StandardDOMParser.createDocument();
        Element mainEl = this.mainDocument.createElement("server-components-generator");
        if (this.prjDir != null) {
            this.load(mainEl, this.prjDir, "project-dir");
        }
        if (this.components == null || this.components.length == 0) {
            return this.mainDocument;
        }
        Element tempEl = this.mainDocument.createElement("components");
        int i = 0;
        while (i < this.components.length) {
            this.loadComponent(tempEl, this.components[i]);
            ++i;
        }
        mainEl.appendChild(tempEl);
        if (this.info != null) {
            tempEl = this.mainDocument.createElement("login-info");
            this.loadLoginInfo(tempEl);
            mainEl.appendChild(tempEl);
        }
        this.mainDocument.appendChild(mainEl);
        return this.mainDocument;
    }

    public void loadComponent(Element parent, SComponentObject compObj) {
        Element el = this.mainDocument.createElement("component");
        el.setAttribute("component-type", compObj.getCompType());
        if (compObj.getName() != null && !compObj.getName().equals("")) {
            this.load(el, compObj.getName(), "name");
        }
        if (compObj.hasChanged()) {
            this.load(el, "", "file-name");
        } else if (compObj.getFileName() != null && !compObj.getFileName().equals("")) {
            this.load(el, compObj.getFileName(), "file-name");
        }
        if (compObj.getJars() != null && compObj.getJars().length > 0) {
            Element jarsEl = this.mainDocument.createElement("jars");
            this.loadJars(jarsEl, compObj.getJars());
            el.appendChild(jarsEl);
        }
        Element propsEl = this.mainDocument.createElement("components-properties");
        this.loadProps(propsEl, compObj.getProviderXMLs(), "provider-xml");
        this.loadProps(propsEl, compObj.getPropertyFiles(), "property-file");
        this.loadProps(propsEl, compObj.getServiceDirs(), "service-dir");
        el.appendChild(propsEl);
        parent.appendChild(el);
    }

    private void loadJars(Element parent, InfoObject[] jars) {
        int i = 0;
        while (i < jars.length) {
            Element jar = this.mainDocument.createElement("jar");
            if (jars[i].getFilePath() != null && !jars[i].getFilePath().equals("")) {
                this.load(jar, jars[i].getFilePath(), "file-path");
            }
            if (jars[i].getEntryName() != null && !jars[i].getEntryName().equals("")) {
                this.load(jar, jars[i].getEntryName(), "entry-name");
            }
            parent.appendChild(jar);
            ++i;
        }
    }

    private void loadProps(Element parent, CPropertyObject[] props, String tagName) {
        Element propsEl = null;
        if (props != null && props.length > 0) {
            int i = 0;
            while (i < props.length) {
                if (props[i].getFilePath() != null && !props[i].getFilePath().equals("") && props[i].getTargetEntry() != null) {
                    propsEl = this.load(parent, props[i].getFilePath(), tagName);
                    propsEl.setAttribute("target", props[i].getTargetEntry());
                }
                ++i;
            }
        }
    }

    private void loadLoginInfo(Element el) {
        this.load(el, this.info.getRemoteHost(), "host");
        this.load(el, String.valueOf(this.info.getRemotePort()), "port");
        String[] transportProtocol = this.info.getTransportProtocol();
        int i = 0;
        while (i < transportProtocol.length) {
            this.load(el, transportProtocol[i], "transport-protocol");
            ++i;
        }
        this.load(el, this.info.getUserName(), "user-name");
        this.load(el, this.info.getUserPassword(), "user-password");
    }

    private Element load(Element el, String value, String tagName) {
        if (value == null) {
            value = new String("");
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return nextElement;
    }

    private String getTextValue(Element element) {
        Node node;
        if (element != null && (node = element.getFirstChild()) != null && node.getNodeType() == 3) {
            String value = node.getNodeValue();
            if (value.trim().equals("") || value.trim().equals("null")) {
                return null;
            }
            return value.trim();
        }
        return null;
    }
}

