/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.server;

import com.sap.engine.deploy.server.CPropertyObject;
import com.sap.engine.lib.jar.InfoObject;
import java.io.File;
import java.util.Vector;

public class SComponentObject {
    public static final String LIBRARY_TYPE = "library";
    public static final String INTERFACE_TYPE = "interface";
    public static final String SERVICE_TYPE = "service";
    public static final String ALONE = "alone";
    public static final String SERVER = "server";
    public static final String DISPATCHER = "dispatcher";
    private String componentName = null;
    private String fileName = null;
    private InfoObject[] jars = null;
    private boolean isJarsAreDefaultJars = false;
    private String compType = null;
    private CPropertyObject[] providerXML = null;
    private CPropertyObject[] propertyFiles = null;
    private CPropertyObject[] serverDir = null;
    private CPropertyObject[] serviceDirs = null;
    private boolean hasChanged = false;

    public SComponentObject() {
    }

    public SComponentObject(String fileName) {
        this.fileName = fileName;
    }

    public SComponentObject(String fileName, byte _type) {
        this.fileName = fileName;
        switch (_type) {
            case 0: {
                this.compType = LIBRARY_TYPE;
                break;
            }
            case 1: {
                this.compType = INTERFACE_TYPE;
                break;
            }
            case 2: {
                this.compType = SERVICE_TYPE;
            }
        }
    }

    public SComponentObject(String fileName, String type) {
        this.fileName = fileName;
        this.compType = type;
    }

    public void setFileName(String outputFile) {
        this.fileName = outputFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setCompType(String type) {
        this.compType = type;
    }

    public String getCompType() {
        return this.compType;
    }

    public void setName(String name) {
        this.componentName = name;
    }

    public String getName() {
        return this.componentName;
    }

    public void setJars(String[] jarFiles) {
        if (jarFiles != null) {
            this.jars = new InfoObject[jarFiles.length];
            int i = 0;
            while (i < this.jars.length) {
                jarFiles[i] = jarFiles[i].replace('\\', File.separatorChar).replace('/', File.separatorChar);
                this.jars[i] = jarFiles[i].indexOf(File.separatorChar) != -1 ? new InfoObject(jarFiles[i].substring(jarFiles[i].lastIndexOf(File.separatorChar) + 1), jarFiles[i]) : new InfoObject(jarFiles[i], jarFiles[i]);
                ++i;
            }
        } else {
            this.jars = null;
        }
    }

    public void addJar(String path, String entry) {
        if (this.jars == null) {
            this.jars = new InfoObject[]{new InfoObject(entry, path)};
        } else {
            InfoObject[] temp = new InfoObject[this.jars.length + 1];
            System.arraycopy(this.jars, 0, temp, 0, this.jars.length);
            temp[this.jars.length] = new InfoObject(entry, path);
            this.jars = temp;
        }
    }

    public void setJars(InfoObject[] jars) {
        this.jars = jars;
    }

    public InfoObject[] getJars() {
        return this.jars;
    }

    public boolean isJarsAreDefaultJars() {
        return this.isJarsAreDefaultJars;
    }

    public void setJarsAreDefaultJars(boolean _jarsAreDefaultJars) {
        this.isJarsAreDefaultJars = _jarsAreDefaultJars;
    }

    public void addProviderXML(String xml, String target) {
        this.providerXML = this.addCPropertyObject(this.providerXML, target, xml);
    }

    public CPropertyObject[] getProviderXMLs() {
        return this.providerXML;
    }

    public void setProviderXMLs(CPropertyObject[] providerXML) {
        this.providerXML = providerXML;
    }

    public void setPropertyFiles(CPropertyObject[] propertyFiles) {
        this.propertyFiles = propertyFiles;
    }

    public CPropertyObject[] getPropertyFiles() {
        return this.propertyFiles;
    }

    public void addPropertyFile(String propertyFile, String target) {
        this.propertyFiles = this.addCPropertyObject(this.propertyFiles, target, propertyFile);
    }

    public void removePropertyFile(String propertyFile, String target) {
        this.propertyFiles = this.removeCPropertyObject(this.propertyFiles, target, propertyFile);
    }

    public void setServiceDirs(CPropertyObject[] serviceDirs) {
        this.serviceDirs = this.propertyFiles;
    }

    public CPropertyObject[] getServiceDirs() {
        return this.serviceDirs;
    }

    public String getServiceDir(String target) {
        if (this.serviceDirs != null) {
            int i = 0;
            while (i < this.serviceDirs.length) {
                if (this.serviceDirs[i].getTargetEntry().equals(target)) {
                    return this.serviceDirs[i].getFilePath();
                }
                ++i;
            }
        }
        return null;
    }

    public void addServiceDir(String dir, String target) {
        this.serviceDirs = this.addCPropertyObject(this.serviceDirs, target, dir);
    }

    public void setHasChanged(boolean flag) {
        this.hasChanged = flag;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    private CPropertyObject[] addCPropertyObject(CPropertyObject[] arr, String target, String value) {
        if (arr == null) {
            return new CPropertyObject[]{new CPropertyObject(target, value)};
        }
        int i = 0;
        while (i < arr.length) {
            if (arr[i].getTargetEntry().equals(target) && !arr[i].getFilePath().endsWith("properties")) {
                arr[i].setFilePath(value);
                return arr;
            }
            ++i;
        }
        CPropertyObject[] temp = new CPropertyObject[arr.length + 1];
        System.arraycopy(arr, 0, temp, 0, arr.length);
        temp[arr.length] = new CPropertyObject(target, value);
        return temp;
    }

    private CPropertyObject[] removeCPropertyObject(CPropertyObject[] arr, String target, String value) {
        Vector<CPropertyObject> vector = new Vector<CPropertyObject>();
        if (arr == null) {
            return arr;
        }
        int i = 0;
        while (i < arr.length) {
            if (!arr[i].getTargetEntry().equals(target) && arr[i].getFilePath().endsWith("properties")) {
                vector.add(arr[i]);
            }
            ++i;
        }
        Object[] temp = new CPropertyObject[vector.size()];
        vector.copyInto(temp);
        return temp;
    }
}

