/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.rmic;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.deploy.rmic.ClassFilter;
import com.sap.engine.deploy.rmic.FileObject;
import com.sap.engine.deploy.rmic.FileTreeModel;
import com.sap.engine.deploy.rmic.JavaCompiler;
import com.sap.engine.deploy.rmic.RMICTreeRenderer;
import com.sap.engine.lib.lang.RunExec;
import com.sap.engine.services.iiop.server.generator.StubTieGenerator;
import com.sap.engine.services.rmi_p4.P4StubSkeletonGenerator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;

public class RMIC
extends JFrame
implements ActionListener,
Runnable {
    private static String where = ".";
    private static String whereClass = ".";
    public static final String FRAME_TITLE = " RMI Improved Generator";
    public static final String MAINTAB_NAME = "Generator";
    public static final String HELPTAB_NAME = "Help";
    public static final String MAINTAB_TIP = "Generate Stub/Skeleton/Tie...";
    public static final String HELPTAB_TIP = "Help about options...";
    public static boolean debug = false;
    public static final String SAPLOGO_FILEPATH = "images/logo72.jpg";
    private static final String guiHelp = "GUIHelp.txt";
    private static final String consoleHelp = "ConsoleHelp.txt";
    private String whereNow = ".";
    private JTree listDirectory = null;
    private JScrollPane treeScrollView = null;
    private FileObject topTreeNode = null;
    private FileTreeModel fileModel = null;
    private File rootTreeFile = null;
    private File classRootFile = null;
    private FileTreeModel classModel = null;
    private JScrollPane classTreeView = null;
    private JTree classTree = null;
    private FileObject topClassNode = null;
    private JPanel infoPanel = null;
    private JPanel basePanel = new JPanel();
    private ImageIcon sapLogo = null;
    private JLabel logoLabel = null;
    private JLabel toolName = null;
    private JTextArea winHelpArea = null;
    private JScrollPane helpAreaScroll = null;
    public static final String JAVA_DEST_DIR = "Generator Directory:";
    public static final String COMPILER_DEST_DIR = "Compiler Directory:";
    public static final String CLASSNAME = "Class Name:";
    public static final String ADD_CLASSPATH = "Additional Classpath:";
    public static final String REMOTE_SUPPORT = " Remote Support ";
    public static final String SPEC_P4_SUPPORT = " RMI_P4 Support         ";
    public static final String SPEC_IIOP_SUPPORT = "RMI_IIOP Support";
    public static final String GEN_P4_SUPPORT = " P4 Support ";
    public static final String GEN_IIOP_SUPPORT = " IIOP Support ";
    public static final String ADDITIONAL_STUBS = "Additional Stubs";
    public static final String USE_P4_SECURITY = "Use RMI_P4 Security";
    public static final String KEEP_FILES = "Keep Java Files";
    public static final String APPLY_EXEC_CONTEXT = "Apply Execution Context";
    public static final String BUT_GENERATE = "Generate...";
    public static final String BUT_EXIT = "Exit";
    public static final String OPTIONS = "Options:";
    public static final String ADD_SETTINGS = " Addtional Settings ";
    public static final String STATUS_LINE = "  Status :";
    public static final String DRIVE = "  Drive:";
    public static final String SET_PATH = "ClassPath:";
    public static final String CLASS_CHOOSER_TREE = "ClassChooser:";
    public static final String PATH_CHOOSER_TREE = "PathChooser:";
    public static final String BUTTON_LABEL = " << ";
    public static final String BUTTON_BACK_LABEL = " >> ";
    private JTextField javaDestDirectory = new JTextField();
    private JTextField compilerDestDirectory = new JTextField();
    private JTextField className = new JTextField();
    private JTextField classpathAdd = new JTextField();
    private JLabel javaDestDirLabel = new JLabel();
    private JLabel compilerDestDirLabel = new JLabel();
    private JLabel classNameLabel = new JLabel();
    private JLabel classpathLabel = new JLabel();
    private JLabel driveLabel = new JLabel();
    private JButton addJavaDestBut = new JButton(" << ");
    private JButton addCompDestBut = new JButton(" << ");
    private JButton addClassBut = new JButton(" << ");
    private JButton addPathBut = new JButton(" << ");
    private JButton removePathBut = new JButton(" >> ");
    private JButton setTreePath = new JButton(new ImageIcon(this.getClass().getResource("images/move_down.jpg")));
    private JCheckBox isRmi_P4 = new JCheckBox();
    private JCheckBox isRmi_IIOP = new JCheckBox();
    private JCheckBox additionalStubs = new JCheckBox();
    private JCheckBox isSecuritySkel = new JCheckBox();
    private JCheckBox keepJava = new JCheckBox();
    private JCheckBox applyExecContext = new JCheckBox();
    private JScrollPane listPathScroll = null;
    private JLabel classChooserName = new JLabel("ClassChooser:");
    private JLabel pathChooserName = new JLabel("PathChooser:");
    private JComboBox driveChooser = null;
    private JPanel innerPanel1 = new JPanel();
    private JPanel innerPanel2 = new JPanel();
    private JPanel innerPanel3 = new JPanel();
    private JPanel innerPanel4 = new JPanel();
    private JPanel innerPanel5 = new JPanel();
    private JPanel innerPanel6 = new JPanel();
    private JPanel innerPanel7 = new JPanel();
    private File[] allDrives = null;
    private Vector classpathStored = null;
    private static boolean javac = true;
    private static boolean rmi_p4 = true;
    private static boolean rmi_iiop = false;
    private static boolean keep = true;
    private static boolean additional = false;
    private static boolean securitySkel = true;
    private static boolean isApplied = false;
    private static String classpath = "";
    private static String classFileName = "";
    private static boolean isProcess = false;
    private static Hashtable access = new Hashtable();
    private JPanel mainPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JTextField destDir = new JTextField();
    private JButton destButton = new JButton();
    private JButton classpathButton = new JButton();
    private JPanel buttonsPanel = new JPanel();
    private JButton goButton = new JButton();
    private JButton close = new JButton();
    static JLabel log = new JLabel();
    private ImageIcon icon = null;
    private JTabbedPane basePane = null;
    private Component p1 = null;
    private Component p2 = null;
    private JPanel pp = null;
    private JList listPath = null;
    static /* synthetic */ Class class$com$sap$engine$deploy$rmic$RMIC;

    public RMIC() {
        this.setTitle(FRAME_TITLE);
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RMIC(String sTitle) {
        this();
        this.setTitle(sTitle);
    }

    public void setVisible(boolean b) {
        if (b) {
            ((Component)this).setSize(800, 570);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int locatX = screenSize.width / 2 - 250;
            int locatY = screenSize.height / 2 - 150;
            ((Component)this).setLocation(locatX, locatY);
        }
        this.innerPanel7.setPreferredSize(new Dimension(300, 560));
        super.setVisible(b);
    }

    private static void ebcdicConvert(String[] args) {
        String platform = SystemProperties.getProperty("platform.notASCII");
        if (platform != null && platform.equalsIgnoreCase("false")) {
            System.setErr(System.out);
            String ASCII = "ISO8859_1";
            String EBCDIC = "Cp1047";
            try {
                int i = 0;
                while (i < args.length) {
                    args[i] = new String(args[i].getBytes(ASCII), EBCDIC);
                    ++i;
                }
            }
            catch (Exception ex) {
                return;
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args != null && args.length > 0 && args[0].indexOf("debug") != -1) {
            debug = true;
            String[] copy = new String[args.length - 1];
            System.arraycopy(args, 1, copy, 0, args.length - 1);
            args = copy;
        }
        RMIC.ebcdicConvert(args);
        if (args.length == 0) {
            new RMIC().setVisible(true);
        } else {
            RMIC.parseArgs(args);
            if (isProcess) {
                RMIC.generate();
            } else {
                RMIC.generate_process();
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
    }

    public void run() {
        try {
            classFileName = this.className.getText();
            where = this.javaDestDirectory.getText() == "" ? "." : this.javaDestDirectory.getText();
            whereClass = this.compilerDestDirectory.getText() == "" ? "." : this.compilerDestDirectory.getText();
            classpath = this.classpathAdd.getText();
            rmi_p4 = this.isRmi_P4.isSelected();
            keep = this.keepJava.isSelected();
            rmi_iiop = this.isRmi_IIOP.isSelected();
            additional = this.additionalStubs.isSelected();
            securitySkel = this.isSecuritySkel.isSelected();
            isApplied = this.applyExecContext.isSelected();
            int returnValue = RMIC.generate_process();
            if (returnValue == 0) {
                this.dump(" Status : Files generated succesfully!");
            } else {
                this.dump(" Status : Exception occurred during creating files.");
            }
        }
        catch (Exception e) {
            this.dump(" Status : Exception occurred during creating files. Message :" + e.getMessage());
        }
        this.goButton.setEnabled(true);
        this.close.setEnabled(true);
    }

    public void close_actionPerformed(ActionEvent event) {
        this.dump("....Exit");
        this.setVisible(false);
        System.exit(0);
    }

    private static int generate_process() throws IOException {
        String[] cmd = new String[17];
        String quote = "";
        cmd[0] = "java";
        cmd[1] = "-Ddebug=true";
        cmd[2] = "-classpath";
        cmd[3] = quote + classpath + File.pathSeparator + SystemProperties.getProperty("java.class.path") + quote;
        cmd[4] = "com.sap.engine.deploy.rmic.RMIC";
        cmd[5] = "-d";
        cmd[6] = whereClass;
        cmd[7] = "-process";
        cmd[8] = "-dc";
        cmd[9] = where;
        int i = 10;
        if (!rmi_p4) {
            cmd[i++] = "-nrmi_p4";
        }
        if (rmi_iiop) {
            cmd[i++] = "-iiop";
        }
        if (additional) {
            cmd[i++] = "-additional";
        }
        if (!keep) {
            cmd[i++] = "-nkeep";
        }
        if (!securitySkel) {
            cmd[i++] = "-nsecurity";
        }
        if (!rmi_p4) {
            cmd[i++] = "-nrmi_p4";
        }
        if (isApplied) {
            cmd[i++] = "-apply";
        }
        cmd[i] = classFileName;
        String[] command = new String[i + 1];
        System.arraycopy(cmd, 0, command, 0, i + 1);
        if (debug) {
            int j = 0;
            while (j < command.length) {
                System.out.println("[debug]-->>  com " + command[j]);
                ++j;
            }
        }
        RunExec r = new RunExec(command);
        r.exec();
        int returnValue = -1;
        try {
            returnValue = r.waitFor();
        }
        catch (Exception ex) {
            RMIC.dumpStErr("Error occurs while RunExec instance wait.", ex);
        }
        RMIC.dumpSt(r.getOutput());
        RMIC.dumpSt(r.getError());
        return returnValue;
    }

    private static void generate() throws IOException {
        File dir;
        String aPackage;
        String className;
        Class<?> objectClass;
        JavaCompiler javaComp = null;
        try {
            objectClass = Class.forName(classFileName);
        }
        catch (ClassNotFoundException ce) {
            RMIC.dumpSt(" Status : ClassNotFoundException occurred.");
            RMIC.dumpStCons("Class not found:" + classFileName);
            RMIC.dumpStErr(ce.getMessage(), ce);
            return;
        }
        RMIC.dumpSt("generating stub and skeleton ...");
        if (rmi_p4) {
            className = objectClass.getName();
            aPackage = "";
            if (className.lastIndexOf(46) != -1) {
                aPackage = className.substring(0, className.lastIndexOf(46));
            }
            dir = new File(where, aPackage.replace('.', File.separatorChar));
            File dirClass = new File(whereClass, aPackage.replace('.', File.separatorChar));
            dir.mkdirs();
            dirClass.mkdirs();
            javaComp = new JavaCompiler(SystemProperties.getProperty("java.class.path"));
            javaComp.setDestination(whereClass);
            Class<?> proxy = objectClass;
            Vector stubsANDskels = null;
            P4StubSkeletonGenerator p4Generate = null;
            if (securitySkel) {
                access.put(proxy, proxy.getName());
                p4Generate = new P4StubSkeletonGenerator(proxy, where, access);
                if (!isApplied) {
                    p4Generate.setApplyExecutionContext(false);
                }
                stubsANDskels = p4Generate.generate();
            } else {
                p4Generate = new P4StubSkeletonGenerator(proxy, where, access);
                if (!isApplied) {
                    p4Generate.setApplyExecutionContext(false);
                }
                stubsANDskels = p4Generate.generate();
            }
            if (javac) {
                int i = 0;
                while (i < stubsANDskels.size()) {
                    javaComp.addClass(where, (String)stubsANDskels.elementAt(i));
                    ++i;
                }
            }
            try {
                RMIC.dumpSt("compiling stubs and skeletons for P4 ...");
                javaComp.compile();
                if (!keep) {
                    javaComp.delete();
                }
            }
            catch (Exception e) {
                RMIC.dumpStErr("There are problems with compiling stubs and skeletons for P4 or may be has a problem with delete .java-files :" + e.getMessage(), e);
            }
        }
        if (rmi_iiop) {
            className = objectClass.getName();
            aPackage = "";
            if (className.lastIndexOf(46) != -1) {
                aPackage = className.substring(0, className.lastIndexOf(46));
            }
            dir = new File(where, aPackage.replace('.', File.separatorChar));
            dir.mkdirs();
            Class<?> proxyCls = objectClass;
            javaComp = new JavaCompiler(SystemProperties.getProperty("java.class.path"));
            javaComp.setDestination(whereClass);
            try {
                Vector stubsAndTies = new StubTieGenerator(proxyCls, where, new Hashtable(), additional).generate();
                if (javac) {
                    int i = 0;
                    while (i < stubsAndTies.size()) {
                        String tmp = (String)stubsAndTies.elementAt(i);
                        String generated = tmp.substring(where.length() + 1, tmp.lastIndexOf(46));
                        javaComp.addClass(where, generated);
                        ++i;
                    }
                }
                javaComp.compile();
                if (!keep) {
                    javaComp.delete();
                }
            }
            catch (Exception e) {
                RMIC.dumpStErr("There are problems with compiling iiop stub or skeletons : " + e.getMessage(), e);
                RMIC.dumpStErr(e.getMessage(), new IOException(e.getMessage()));
            }
        }
    }

    private static void parseArgs(String[] args) {
        if (args.length == 0 || args.length == 1 || args[0].indexOf("?") != -1) {
            try {
                InputStream in = (class$com$sap$engine$deploy$rmic$RMIC == null ? (class$com$sap$engine$deploy$rmic$RMIC = RMIC.class$("com.sap.engine.deploy.rmic.RMIC")) : class$com$sap$engine$deploy$rmic$RMIC).getResource(consoleHelp).openStream();
                int all = in.available();
                int current = 0;
                byte[] arr = new byte[in.available()];
                current = in.read(arr);
                while (current < all) {
                    current += in.read(arr, current, all - current);
                }
                System.out.println(new String(arr));
            }
            catch (Exception e) {
                RMIC.dumpStErr("There are problems with console help file", e);
            }
            System.exit(0);
        }
        int i = 0;
        while (i < args.length - 1) {
            if (args[i].equals("-dc")) {
                where = args[++i];
            } else if (args[i].equals("-nsecurity")) {
                securitySkel = false;
            } else if (args[i].equals("-classpath")) {
                classpath = args[++i];
            } else if (args[i].equals("-nkeep")) {
                keep = false;
            } else if (args[i].equals("-additional")) {
                additional = true;
            } else if (args[i].equals("-iiop")) {
                rmi_iiop = true;
            } else if (args[i].equals("-nrmi_p4")) {
                rmi_p4 = false;
            } else if (args[i].equals("-process")) {
                isProcess = true;
            } else if (args[i].equals("-apply")) {
                isApplied = true;
            } else if (args[i].equals("-d")) {
                whereClass = args[++i];
            } else {
                System.out.println("Invalid argument :" + args[i]);
            }
            ++i;
        }
        classFileName = args[args.length - 1];
        if (debug) {
            System.out.println("\n\n[debug]\n[rmic output]: CONSOLE RMIC - SET PARAMETERS: \n<output=" + (where != null ? where : new File(".").getAbsolutePath()) + ">  \n<classpath=" + classpath + ">  \n<compile path=" + whereClass + ">  \n<use rmi_p4 protocol=" + rmi_p4 + ">  \n<generate Security Skels=" + securitySkel + ">  \n<use rmi_iiop protocol=" + rmi_iiop + ">  \n<additional iiop sutbs=" + additional + ">  \n<keep java files=" + keep + ">  \n<apply execution context=" + isApplied + ">  \n<class name=" + classFileName + ">\n\n");
        }
    }

    protected Component makeInfoTab() {
        this.sapLogo = new ImageIcon(this.getClass().getResource(SAPLOGO_FILEPATH));
        this.logoLabel = new JLabel(this.sapLogo);
        this.toolName = new JLabel(FRAME_TITLE);
        this.toolName.setFont(new Font("Verdana", 1, 20));
        String help = null;
        try {
            InputStream in = this.getClass().getResource(guiHelp).openStream();
            int all = in.available();
            int current = 0;
            byte[] arr = new byte[in.available()];
            current = in.read(arr);
            while (current < all) {
                current += in.read(arr, current, all - current);
            }
            help = new String(arr);
        }
        catch (Exception e) {
            this.dumpErr("There are problems with GUIHelp.txt file", e);
        }
        this.winHelpArea = new JTextArea(help != null ? help : "There are problems with help file");
        this.winHelpArea.setColumns(40);
        this.winHelpArea.setWrapStyleWord(false);
        this.winHelpArea.setLineWrap(true);
        this.winHelpArea.setEditable(false);
        this.helpAreaScroll = new JScrollPane(this.winHelpArea);
        this.helpAreaScroll.setSize(100, 50);
        this.infoPanel = new JPanel(new GridBagLayout());
        this.infoPanel.add((Component)this.logoLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 11, new Insets(25, 5, 5, 5), 0, 0));
        this.infoPanel.add((Component)this.toolName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 11, new Insets(25, 5, 5, 5), 0, 0));
        this.infoPanel.add((Component)this.helpAreaScroll, new GridBagConstraints(0, 1, 2, 10, 0.2, 1.3, 13, 1, new Insets(25, 5, 5, 5), 0, 0));
        return this.infoPanel;
    }

    protected Component makeMainTab() throws Exception {
        this.basePanel.setLayout(new GridBagLayout());
        this.innerPanel1.setLayout(new GridBagLayout());
        this.innerPanel2.setLayout(new GridBagLayout());
        this.innerPanel3.setLayout(new GridBagLayout());
        this.innerPanel4.setLayout(new GridBagLayout());
        this.innerPanel5.setLayout(new GridBagLayout());
        this.innerPanel6.setLayout(new GridBagLayout());
        this.innerPanel7.setLayout(new GridBagLayout());
        this.javaDestDirLabel.setText(JAVA_DEST_DIR);
        this.javaDestDirectory.setColumns(28);
        this.compilerDestDirLabel.setText(COMPILER_DEST_DIR);
        this.compilerDestDirectory.setColumns(28);
        this.classNameLabel.setText(CLASSNAME);
        this.className.setColumns(28);
        this.classpathLabel.setText(ADD_CLASSPATH);
        this.classpathAdd.setColumns(28);
        this.addJavaDestBut.setToolTipText("Choose a directory for .java-files from Path Chooser");
        this.addCompDestBut.setToolTipText("Choose a directory for .class-files from Path Chooser");
        this.addClassBut.setToolTipText("Choose a remote class FROM CLASS CHOOSER");
        this.addPathBut.setToolTipText("Add directories or jar-files to classpath from Path Chooser");
        this.removePathBut.setToolTipText("Remove redundant directory or jar-files from List of Additional ClassPath");
        this.javaDestDirectory.setText(this.whereNow);
        this.compilerDestDirectory.setText(this.whereNow);
        this.addJavaDestBut.addActionListener(new AddSelectedJavaDir(this));
        this.addCompDestBut.addActionListener(new AddSelectedClassDir(this));
        this.addClassBut.addActionListener(new AddClass(this));
        this.makeTree();
        this.makeClassTree();
        this.addPathBut.addActionListener(new SetAdditionalClassPath(this));
        this.listPath = new JList<Object>(new Object[]{""});
        this.listPath.setVisibleRowCount(2);
        this.listPathScroll = new JScrollPane(this.listPath);
        this.removePathBut.addActionListener(new RemoveResOrPath(this));
        this.innerPanel1.add((Component)this.javaDestDirLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.innerPanel1.add((Component)this.javaDestDirectory, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.innerPanel1.add((Component)this.addJavaDestBut, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.innerPanel1.add((Component)this.compilerDestDirLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.innerPanel1.add((Component)this.compilerDestDirectory, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.innerPanel1.add((Component)this.addCompDestBut, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.innerPanel1.add((Component)this.classNameLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.innerPanel1.add((Component)this.className, new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.innerPanel1.add((Component)this.addClassBut, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.innerPanel1.add((Component)this.classpathLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.innerPanel1.add((Component)this.listPathScroll, new GridBagConstraints(1, 2, 1, 2, 0.1, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.innerPanel1.add((Component)this.addPathBut, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.innerPanel1.add((Component)this.removePathBut, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.innerPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(GEN_P4_SUPPORT), BorderFactory.createEmptyBorder(5, 5, 0, 5)));
        this.isRmi_P4.setText(SPEC_P4_SUPPORT);
        this.isRmi_P4.setToolTipText("Make Stub/Skeleton for P4 Provider");
        this.isRmi_P4.addActionListener(new P4CheckBut(this));
        this.isSecuritySkel.setText(USE_P4_SECURITY);
        this.isSecuritySkel.setToolTipText("Set security checks in the Skeleton");
        this.innerPanel2.add((Component)this.isRmi_P4, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.innerPanel2.add((Component)this.isSecuritySkel, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.isRmi_IIOP.setText(SPEC_IIOP_SUPPORT);
        this.isRmi_IIOP.setToolTipText("Make Tie/Stub for IIOP Provider");
        this.isRmi_IIOP.addActionListener(new IIOPCheckBut(this));
        this.additionalStubs.setText(ADDITIONAL_STUBS);
        this.additionalStubs.setEnabled(false);
        this.innerPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(GEN_IIOP_SUPPORT), BorderFactory.createEmptyBorder(5, 5, 0, 5)));
        this.innerPanel3.add((Component)this.isRmi_IIOP, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.innerPanel3.add((Component)this.additionalStubs, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.innerPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(REMOTE_SUPPORT), BorderFactory.createEmptyBorder(5, 5, 0, 5)));
        this.innerPanel4.add((Component)this.innerPanel2, new GridBagConstraints(0, 1, 2, 1, 0.1, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.innerPanel4.add((Component)this.innerPanel3, new GridBagConstraints(0, 2, 2, 1, 0.1, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.keepJava.setText(KEEP_FILES);
        this.keepJava.setToolTipText("Keep Java Generated Stub/Tie/Skeleton Files ");
        this.keepJava.addActionListener(new KeepJava(this));
        this.applyExecContext.setText(APPLY_EXEC_CONTEXT);
        this.goButton.setText(BUT_GENERATE);
        this.goButton.setToolTipText("Generate and compile Stub/Tie/Skeleton");
        this.close.setText(BUT_EXIT);
        this.innerPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ADD_SETTINGS), BorderFactory.createEmptyBorder(5, 5, 0, 5)));
        this.innerPanel5.add((Component)this.keepJava, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.innerPanel5.add((Component)this.applyExecContext, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        String[] all = new String[this.allDrives.length];
        int i = 0;
        while (i < all.length) {
            all[i] = this.allDrives[i].toString();
            ++i;
        }
        this.driveChooser = new JComboBox<String>(all);
        this.driveChooser.addActionListener(new ChangeDrive(this));
        this.driveLabel.setText(DRIVE);
        this.setTreePath.addActionListener(new SetPathForClass(this));
        this.listDirectory.addTreeExpansionListener(new TreeListener(this));
        this.classTree.addTreeExpansionListener(new ClassTreeListener(this));
        this.innerPanel7.add((Component)this.pathChooserName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.innerPanel7.add((Component)this.treeScrollView, new GridBagConstraints(0, 1, 4, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.innerPanel7.add((Component)this.driveChooser, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.innerPanel7.add((Component)this.driveLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.innerPanel7.add((Component)this.setTreePath, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.innerPanel7.add((Component)this.classChooserName, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.innerPanel7.add((Component)this.classTreeView, new GridBagConstraints(0, 3, 4, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.basePanel.add((Component)this.innerPanel1, new GridBagConstraints(0, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.basePanel.add((Component)this.innerPanel4, new GridBagConstraints(0, 1, 1, 1, 0.2, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.basePanel.add((Component)this.innerPanel5, new GridBagConstraints(0, 2, 1, 1, 0.2, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.basePanel.add((Component)this.innerPanel7, new GridBagConstraints(1, 0, 1, 4, 0.1, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.basePanel.add((Component)this.buttonsPanel, new GridBagConstraints(0, 3, 1, 1, 0.2, 0.0, 10, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.basePanel.add((Component)log, new GridBagConstraints(0, 4, 6, 1, 0.4, 0.0, 15, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.mainPanel.setLayout(this.gridBagLayout1);
        this.destDir.setToolTipText("Set the directory where the Stub/Skeleton will be generated");
        log.setText(STATUS_LINE);
        log.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.destButton.setPreferredSize(new Dimension(19, 19));
        this.destButton.setText("...");
        this.classpathButton.setPreferredSize(new Dimension(19, 19));
        this.classpathButton.setText("...");
        this.buttonsPanel.setLayout(new FlowLayout(1, 35, 0));
        this.buttonsPanel.add(this.goButton);
        this.buttonsPanel.add(this.close);
        this.innerPanel2.setVisible(true);
        this.innerPanel3.setVisible(true);
        this.isRmi_P4.setSelected(true);
        this.isRmi_IIOP.setSelected(false);
        this.additionalStubs.setSelected(false);
        this.isSecuritySkel.setSelected(false);
        this.keepJava.setSelected(true);
        this.applyExecContext.setSelected(false);
        this.setResizable(false);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.goButton.addActionListener(new GenerateStub(this));
        this.goButton.setEnabled(true);
        this.close.addActionListener(new ExitBut(this));
        this.close.setEnabled(true);
        this.innerPanel7.setPreferredSize(new Dimension(300, 560));
        return this.basePanel;
    }

    public void init() {
        try {
            this.basePane = new JTabbedPane();
            this.p1 = this.makeInfoTab();
            try {
                this.p2 = this.makeMainTab();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.basePane.addTab(MAINTAB_NAME, null, this.p2, "Generate Stubs/Skeletons/Ties");
            this.basePane.addTab(HELPTAB_NAME, null, this.p1, "Some help");
            this.basePane.setSelectedIndex(0);
            this.pp = new JPanel(new GridLayout(1, 1));
            this.pp.add(this.basePane);
            this.getContentPane().add(this.pp);
            this.pack();
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void treeExpanded(TreeExpansionEvent e) {
        Object[] path = e.getPath().getPath();
        FileObject rr = (FileObject)path[path.length - 1];
        if (path != null && rr.getChildCount() == 0) {
            File cFile = new File(rr.getFullName());
            File[] subD = this.arrange(cFile.listFiles());
            FileObject child = null;
            if (subD != null) {
                int j = 0;
                while (j < subD.length) {
                    child = new FileObject(false, subD[j].getAbsolutePath(), subD[j].getName());
                    rr.add(child);
                    FileTreeModel fff = (FileTreeModel)this.listDirectory.getModel();
                    fff.insertNodeInto(child, rr, j);
                    ++j;
                }
            }
        }
    }

    public void classTreeExpand(TreeExpansionEvent event) {
        Object[] nodes = event.getPath().getPath();
        FileObject last = (FileObject)nodes[nodes.length - 1];
        if (nodes != null && last.getChildCount() == 0) {
            ClassFilter filter = new ClassFilter();
            File selected = new File(last.getFullName());
            File[] listD = this.arrange(selected.listFiles(filter));
            if (listD != null) {
                int i = 0;
                while (i < listD.length) {
                    FileObject child = new FileObject(false, listD[i].getAbsolutePath(), listD[i].getName());
                    last.add(child);
                    FileTreeModel mmm = (FileTreeModel)this.classTree.getModel();
                    mmm.insertNodeInto(child, last, i);
                    ++i;
                }
            }
        }
    }

    public void generateButton(ActionEvent e) {
        this.dump(" Status : Generating files ... Please wait!");
        if (this.className.getText() == null || this.className.getText().equals("")) {
            this.dump(" Select Class File");
            return;
        }
        this.goButton.setEnabled(false);
        this.close.setEnabled(false);
        Thread th = new Thread(this);
        th.start();
        this.goButton.setEnabled(true);
        this.close.setEnabled(true);
        this.dump("");
    }

    public void changeDrive(ActionEvent e) {
        File newDrive = new File((String)this.driveChooser.getSelectedItem());
        if (newDrive != null) {
            String root = (String)this.driveChooser.getSelectedItem();
            this.topTreeNode = new FileObject(true, root, root);
            File[] listDir = this.arrange(newDrive.listFiles());
            FileTreeModel fileModel1 = new FileTreeModel(this.topTreeNode);
            this.listDirectory.setModel(fileModel1);
            int i = 0;
            while (i < listDir.length) {
                File[] dd;
                FileObject child = new FileObject(false, listDir[i].getAbsolutePath(), listDir[i].getName());
                this.topTreeNode.setChild(child);
                fileModel1.insertNodeInto(child, this.topTreeNode, i);
                if (listDir[i].isDirectory() && (dd = this.arrange(listDir[i].listFiles())) != null) {
                    int k = 0;
                    while (k < dd.length) {
                        FileObject ff = new FileObject(false, dd[k].getAbsolutePath(), dd[k].getName());
                        child.setChild(ff);
                        fileModel1.insertNodeInto(ff, child, k);
                        ++k;
                    }
                }
                ++i;
            }
        } else {
            this.dump("This Device doesn't work!!! Choose new...");
        }
    }

    public void addSelectedJavaDir(ActionEvent e) {
        try {
            if (this.javaDestDirectory.isEditable()) {
                FileObject examp = (FileObject)this.listDirectory.getLastSelectedPathComponent();
                File check = new File(examp.getFullName());
                if (check.isDirectory()) {
                    this.javaDestDirectory.setText(examp.getFullName());
                } else {
                    this.dump("SET JAVA OUTPUT -> [" + check.getAbsolutePath() + "] !!!This is not directory!!!");
                }
            }
        }
        catch (Exception e1) {
            this.dump("!->Select a Direcory for the Java Output");
            log.setText("  Status : Select a Directory for Java Out");
        }
    }

    public void addSelecetedCompilerDir(ActionEvent e) {
        try {
            FileObject examp = (FileObject)this.listDirectory.getLastSelectedPathComponent();
            File check = new File(examp.getFullName());
            if (check.isDirectory()) {
                this.compilerDestDirectory.setText(examp.getFullName());
            } else {
                this.dump("SET COMPILER OUTPUT -> [" + check.getAbsolutePath() + "] !!!This is not directory!!!");
            }
        }
        catch (Exception e1) {
            this.dump("!->Select a Directory for the Compiler Output");
        }
    }

    public void setPathInClassTree(ActionEvent e) {
        try {
            File classRoot = new File(((FileObject)this.listDirectory.getLastSelectedPathComponent()).getFullName());
            String currentClassPath = this.topClassNode.getFullName();
            String curr = this.classpathAdd.getText();
            if (curr != null && curr.length() > 0 && curr.indexOf(currentClassPath) != -1) {
                String s1 = curr.substring(curr.indexOf(";") != -1 ? 1 : 0, curr.indexOf(currentClassPath));
                String s2 = curr.substring(curr.indexOf(currentClassPath) + currentClassPath.length());
                this.classpathAdd.setText(s1 + s2 + ";" + classRoot.getAbsolutePath());
            } else if (curr.length() == 0) {
                this.classpathAdd.setText(classRoot.getAbsolutePath());
            }
            if (this.classpathStored == null) {
                this.classpathStored = new Vector();
            }
            this.classpathStored.add(classRoot.getAbsolutePath());
            if (this.classpathStored.indexOf(classRoot.getAbsolutePath()) == -1 && (classRoot.getAbsolutePath().endsWith(".jar") || new File(classRoot.getAbsolutePath()).isDirectory())) {
                this.classpathStored.add(classRoot.getAbsolutePath());
            }
            try {
                this.classpathStored.remove(this.topClassNode.getFullName());
            }
            catch (Exception exx) {
                this.dump("Error occurs while removing top class node from stored classpaths.");
            }
            this.listPath.setListData(this.classpathStored);
            ClassFilter filter = new ClassFilter();
            if (classRoot != null && classRoot.isDirectory()) {
                this.topClassNode = new FileObject(true, classRoot.getAbsolutePath(), classRoot.getAbsolutePath());
                File[] listDir = classRoot.listFiles(filter);
                FileTreeModel fileModel1 = new FileTreeModel(this.topClassNode);
                this.classTree.setModel(fileModel1);
                int i = 0;
                while (i < listDir.length) {
                    FileObject current = new FileObject(false, listDir[i].getAbsolutePath(), listDir[i].getName());
                    this.topClassNode.add(current);
                    fileModel1.insertNodeInto(current, this.topClassNode, i);
                    ++i;
                }
            } else {
                this.dump("May be you are not select directory");
            }
        }
        catch (Exception e1) {
            this.dump("Select Directory for Classes of ClassTree");
        }
    }

    public void addAdditionalPath(ActionEvent e) {
        try {
            TreePath[] all = this.listDirectory.getSelectionModel().getSelectionPaths();
            String[] allChooses = new String[all.length];
            int i = 0;
            while (i < all.length) {
                String comp = "";
                Object[] aaa = all[i].getPath();
                int j = 0;
                while (j < aaa.length) {
                    comp = comp + (comp.equals("") || comp.endsWith("\\") ? "" : "\\") + aaa[j].toString();
                    ++j;
                }
                allChooses[i] = comp;
                ++i;
            }
            if (this.classpathStored == null) {
                this.classpathStored = new Vector();
            }
            int j = 0;
            while (j < allChooses.length) {
                if (this.classpathStored.indexOf(allChooses[j]) == -1 && (allChooses[j].endsWith(".jar") || new File(allChooses[j]).isDirectory())) {
                    this.classpathStored.add(allChooses[j]);
                }
                ++j;
            }
            this.listPath.setListData(this.classpathStored);
            File addpath = new File(((FileObject)this.listDirectory.getLastSelectedPathComponent()).getFullName());
            if (addpath != null && (addpath.isDirectory() || addpath.getAbsolutePath().endsWith(".jar"))) {
                this.classpathAdd.setText(this.classpathAdd.getText() + ";" + addpath.getAbsolutePath());
            } else {
                this.dump("choose directory or jar-file");
            }
        }
        catch (Exception e1) {
            this.dump("!->You are not select anything. Choose directory or jar-file");
        }
    }

    public void remoteClassPath(ActionEvent e) {
        try {
            Object[] current = this.listPath.getSelectedValues();
            int i = 0;
            while (i < current.length) {
                try {
                    this.classpathStored.remove(current[i]);
                }
                catch (Exception e1) {
                    this.dump("!->Select some added classpath for remove");
                }
                this.listPath.setListData(this.classpathStored);
                ++i;
            }
        }
        catch (Exception e1) {
            this.dump("!->Select some added classpath for remove");
        }
    }

    public void addClassForGenerate(ActionEvent e) {
        try {
            FileObject remoteClass = (FileObject)this.classTree.getLastSelectedPathComponent();
            String temp = remoteClass.getFullName();
            File remoteFile = new File(temp);
            if (remoteFile != null && remoteFile.isFile() && temp.endsWith(".class")) {
                String classPakage = temp.substring(temp.indexOf(this.topClassNode.getFullName()) + this.topClassNode.getFullName().length() + 1, temp.indexOf(".class")).replace('\\', '.');
                this.className.setText(classPakage);
            }
        }
        catch (Exception e1) {
            this.dump("!->Select Class File ! ");
        }
    }

    public void checkP4(ActionEvent e) {
        if (this.isRmi_P4.isSelected()) {
            this.isSecuritySkel.setEnabled(true);
        } else {
            this.isSecuritySkel.setEnabled(false);
        }
    }

    public void checkIIOP(ActionEvent e) {
        if (this.isRmi_IIOP.isSelected()) {
            this.additionalStubs.setEnabled(true);
        } else {
            this.additionalStubs.setEnabled(false);
        }
    }

    public void keepJavaFiles(ActionEvent e) {
        if (this.keepJava.isSelected()) {
            this.javaDestDirectory.setEditable(true);
        } else {
            this.javaDestDirectory.setEditable(false);
        }
    }

    private void makeTree() {
        this.setDefaultCloseOperation(3);
        String os = System.getProperty("os.name").toLowerCase();
        Vector<File> allDr = new Vector<File>();
        this.allDrives = null;
        if (os.indexOf("windows") != -1) {
            char c = 'C';
            while (c <= 'Z') {
                char[] ac = new char[]{c, ':', '\\'};
                String s = new String(ac);
                File file = new File(s);
                if (file != null && file.exists()) {
                    allDr.addElement(file);
                }
                c = (char)(c + 1);
            }
            this.allDrives = new File[allDr.size()];
            int i = 0;
            while (i < this.allDrives.length) {
                this.allDrives[i] = (File)allDr.elementAt(i);
                ++i;
            }
        } else if (os.indexOf("unix") != -1) {
            this.allDrives = new File[]{new File("/")};
        }
        this.rootTreeFile = this.allDrives != null && this.allDrives.length > 0 ? this.allDrives[0] : new File(this.whereNow);
        this.topTreeNode = new FileObject(true, this.rootTreeFile.getAbsolutePath(), this.rootTreeFile.toString());
        this.fileModel = new FileTreeModel(this.topTreeNode);
        this.listDirectory = new JTree(this.fileModel);
        RMICTreeRenderer rend = new RMICTreeRenderer();
        this.listDirectory.setCellRenderer(rend);
        this.listDirectory.getSelectionModel().setSelectionMode(4);
        File[] listDir = this.arrange(this.rootTreeFile.listFiles());
        int i = 0;
        while (i < listDir.length) {
            File[] subCh;
            FileObject child = new FileObject(false, listDir[i].getAbsolutePath(), listDir[i].getName());
            this.topTreeNode.add(child);
            this.fileModel.insertNodeInto(child, this.topTreeNode, i);
            if (listDir[i].isDirectory() && (subCh = this.arrange(listDir[i].listFiles())) != null) {
                int k = 0;
                while (k < subCh.length) {
                    FileObject ff = new FileObject(false, subCh[k].getAbsolutePath(), subCh[k].getName());
                    child.add(ff);
                    this.fileModel.insertNodeInto(ff, child, k);
                    ++k;
                }
            }
            ++i;
        }
        this.listDirectory.setName("Listed Drive");
        this.treeScrollView = new JScrollPane(this.listDirectory);
        this.treeScrollView.setFont(new Font("Verdana", 1, 12));
        this.treeScrollView.setVisible(true);
    }

    public void makeClassTree() {
        this.classRootFile = new File(this.whereNow);
        ClassFilter filter = new ClassFilter();
        this.topClassNode = new FileObject(true, this.classRootFile.getAbsolutePath(), this.classRootFile.getAbsolutePath());
        File[] listDir = this.classRootFile.listFiles(filter);
        this.classModel = new FileTreeModel(this.topClassNode);
        this.classTree = new JTree(this.classModel);
        RMICTreeRenderer rend = new RMICTreeRenderer();
        this.classTree.setCellRenderer(rend);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        int i = 0;
        while (i < listDir.length) {
            File[] children;
            FileObject child = new FileObject(false, listDir[i].getAbsolutePath(), listDir[i].getName());
            this.topClassNode.add(child);
            this.classModel.insertNodeInto(child, this.topClassNode, i);
            if (listDir[i].isDirectory() && (children = this.arrange(listDir[i].listFiles(filter))) != null) {
                int j = 0;
                while (j < children.length) {
                    FileObject curr = new FileObject(false, children[j].getAbsolutePath(), children[j].getName());
                    child.add(curr);
                    this.classModel.insertNodeInto(curr, child, j);
                    ++j;
                }
            }
            ++i;
        }
        this.classTree.setName("Classes List");
        this.classTree.getSelectionModel().setSelectionMode(1);
        this.classTreeView = new JScrollPane(this.classTree);
        this.classTreeView.setFont(new Font("Verdana", 1, 12));
        this.classTreeView.setVisible(true);
    }

    public void dump(String msg) {
        System.out.println("[rmic output]: " + msg);
        log.setText(STATUS_LINE + msg);
    }

    public void dumpCons(String msg) {
        System.out.println("[rmic output]: " + msg);
    }

    public static void dumpSt(String msg) {
        System.out.println("[rmic output]: " + msg);
        log.setText(STATUS_LINE + msg);
    }

    public static void dumpStCons(String msg) {
        System.out.println("[rmic output]: " + msg);
    }

    public void dumpErr(String msg, Throwable e) {
        System.out.println("[rmic output error]: " + msg);
        e.printStackTrace();
    }

    public static void dumpStErr(String msg, Throwable e) {
        System.out.println("[rmic output error]: " + msg);
        e.printStackTrace();
    }

    private File[] arrange(File[] list) {
        Vector<File> dirs = new Vector<File>();
        Vector<File> files = new Vector<File>();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                if (list[i].isDirectory()) {
                    dirs.add(list[i]);
                } else {
                    files.add(list[i]);
                }
                ++i;
            }
            File[] all = new File[list.length];
            System.arraycopy(dirs.toArray(new File[0]), 0, all, 0, dirs.size());
            System.arraycopy(files.toArray(new File[0]), 0, all, dirs.size(), files.size());
            return all;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class KeepJava
    implements ActionListener {
        RMIC rmic = null;

        public KeepJava(RMIC rmic) {
            this.rmic = rmic;
        }

        public void actionPerformed(ActionEvent e) {
            this.rmic.keepJavaFiles(e);
        }
    }

    class IIOPCheckBut
    implements ActionListener {
        RMIC rmic = null;

        public IIOPCheckBut(RMIC rmic) {
            this.rmic = rmic;
        }

        public void actionPerformed(ActionEvent e) {
            this.rmic.checkIIOP(e);
        }
    }

    class P4CheckBut
    implements ActionListener {
        RMIC rmic = null;

        public P4CheckBut(RMIC rmic) {
            this.rmic = rmic;
        }

        public void actionPerformed(ActionEvent e) {
            this.rmic.checkP4(e);
        }
    }

    class AddClass
    implements ActionListener {
        RMIC rmic = null;

        public AddClass(RMIC rmic) {
            this.rmic = rmic;
        }

        public void actionPerformed(ActionEvent e) {
            this.rmic.addClassForGenerate(e);
        }
    }

    class RemoveResOrPath
    implements ActionListener {
        RMIC rmic = null;

        public RemoveResOrPath(RMIC rmic) {
            this.rmic = rmic;
        }

        public void actionPerformed(ActionEvent e) {
            this.rmic.remoteClassPath(e);
        }
    }

    class SetAdditionalClassPath
    implements ActionListener {
        RMIC rmic = null;

        public SetAdditionalClassPath(RMIC rmic) {
            this.rmic = rmic;
        }

        public void actionPerformed(ActionEvent e) {
            this.rmic.addAdditionalPath(e);
        }
    }

    class SetPathForClass
    implements ActionListener {
        RMIC rmic = null;

        public SetPathForClass(RMIC rmic) {
            this.rmic = rmic;
        }

        public void actionPerformed(ActionEvent e) {
            this.rmic.setPathInClassTree(e);
        }
    }

    class AddSelectedClassDir
    implements ActionListener {
        RMIC rmic = null;

        public AddSelectedClassDir(RMIC rmic) {
            this.rmic = rmic;
        }

        public void actionPerformed(ActionEvent e) {
            this.rmic.addSelecetedCompilerDir(e);
        }
    }

    class AddSelectedJavaDir
    implements ActionListener {
        RMIC rmic = null;

        public AddSelectedJavaDir(RMIC rmic) {
            this.rmic = rmic;
        }

        public void actionPerformed(ActionEvent e) {
            this.rmic.addSelectedJavaDir(e);
        }
    }

    class ChangeDrive
    implements ActionListener {
        RMIC rmic = null;

        public ChangeDrive(RMIC rmic) {
            this.rmic = rmic;
        }

        public void actionPerformed(ActionEvent e) {
            this.rmic.changeDrive(e);
        }
    }

    class GenerateStub
    implements ActionListener {
        RMIC rmic = null;

        public GenerateStub(RMIC rmic) {
            this.rmic = rmic;
        }

        public void actionPerformed(ActionEvent e) {
            this.rmic.generateButton(e);
        }
    }

    class ClassTreeListener
    implements TreeExpansionListener {
        RMIC rmic = null;

        public ClassTreeListener(RMIC rmic) {
            this.rmic = rmic;
        }

        public void treeExpanded(TreeExpansionEvent event) {
            this.rmic.classTreeExpand(event);
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            this.rmic.classTreeExpand(event);
        }
    }

    class TreeListener
    implements TreeExpansionListener {
        RMIC rmic = null;

        public TreeListener(RMIC rmic) {
            this.rmic = rmic;
        }

        public void treeExpanded(TreeExpansionEvent event) {
            this.rmic.treeExpanded(event);
        }

        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }

    class ExitBut
    implements ActionListener {
        RMIC rmic = null;

        public ExitBut(RMIC rmic) {
            this.rmic = rmic;
        }

        public void actionPerformed(ActionEvent e) {
            this.rmic.close_actionPerformed(e);
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            RMIC.this.setVisible(false);
            System.exit(0);
        }
    }
}

