/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.rmic;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.deploy.rmic.ErrorParser;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class JavaCompiler {
    private Vector files = new Vector();
    private Vector classes = new Vector();
    private String classPath;
    private String destination = null;
    private static boolean debug = SystemProperties.getBoolean("debug");

    public JavaCompiler(String classpath) {
        this.classPath = classpath;
    }

    public String[] getClasses() {
        Object[] result = new String[this.classes.size()];
        this.classes.copyInto(result);
        return result;
    }

    public String[] getClassFileNames() {
        Object[] result = new String[this.files.size()];
        this.files.copyInto(result);
        return result;
    }

    public void addClass(String destDir, String className) {
        if (this.classes.contains(className)) {
            return;
        }
        String fileName = destDir + File.separatorChar + className.replace('.', File.separatorChar) + ".java";
        this.files.addElement(fileName);
        this.classes.addElement(className);
    }

    public void setClassPath(String classpath) {
        this.classPath = classpath;
    }

    public void compile() throws IOException {
        Runtime r = Runtime.getRuntime();
        if (this.files.size() == 0) {
            return;
        }
        String[] cmd = new String[this.files.size() + 7];
        String quote = "";
        cmd[0] = "javac";
        cmd[1] = "-encoding";
        cmd[2] = SystemProperties.getProperty("file.encoding");
        cmd[3] = "-classpath";
        cmd[4] = quote + this.classPath + File.pathSeparator + SystemProperties.getProperty("java.class.path") + quote;
        cmd[5] = "-d";
        cmd[6] = quote + (this.destination != null ? this.destination : ".");
        int i = 0;
        while (i < this.files.size()) {
            cmd[i + 7] = quote + (String)this.files.elementAt(i) + quote;
            ++i;
        }
        Process p = r.exec(cmd);
        System.out.println();
        new ErrorParser().parse(p.getErrorStream(), debug);
        while (true) {
            try {
                if (p.exitValue() == 0) break;
                throw new IOException("Error in compiling.");
            }
            catch (IllegalThreadStateException e) {
                continue;
            }
            break;
        }
    }

    public void compileAll(String dirName) throws IOException {
        Runtime r = Runtime.getRuntime();
        if (this.files.size() == 0) {
            return;
        }
        String[] cmd = new String[8];
        String quote = "";
        cmd[0] = "javac";
        cmd[1] = "-encoding";
        cmd[2] = SystemProperties.getProperty("file.encoding");
        cmd[3] = "-classpath";
        cmd[4] = quote + this.classPath + File.pathSeparator + SystemProperties.getProperty("java.class.path") + quote;
        cmd[5] = dirName + File.separator + "*.java";
        cmd[6] = "-d";
        cmd[7] = quote + (this.destination != null ? this.destination : ".");
        Process p = r.exec(cmd);
        int i = 0;
        while (i < cmd.length) {
            System.out.print(cmd[i]);
            ++i;
        }
        System.out.println();
        new ErrorParser().parse(p.getErrorStream(), debug);
        while (true) {
            try {
                if (p.exitValue() == 0) break;
                throw new IOException("Error in compiling.");
            }
            catch (IllegalThreadStateException e) {
                continue;
            }
            break;
        }
    }

    public void delete() {
        int i = 0;
        while (i < this.files.size()) {
            new File((String)this.files.elementAt(i)).delete();
            ++i;
        }
    }

    public boolean contains(String className) {
        return this.classes.contains(className);
    }

    public void clear() {
        this.files = new Vector();
        this.classes = new Vector();
        this.classPath = "";
    }

    public void setDestination(String des) {
        this.destination = des;
    }
}

