/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.manager.component;

import com.sap.engine.deploy.manager.component.ComponentInfo;
import com.sap.engine.lib.xml.StandardDOMParser;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SComponentsXmlDocument {
    private ComponentInfo[] sComponents = null;
    private Document mainDocument;
    private StandardDOMParser parser = null;
    public static final String dtd = "<!DOCTYPE server-components-management [\n<!ELEMENT server-components-management (component*)>\n<!ELEMENT component (component-name, component-file)>\n<!ATTLIST component action (deploy|update|remove) \"deploy\">\n<!ATTLIST component type (library|service|interface) #REQUIRED>\n<!ELEMENT component-name (#PCDATA)>\n<!ELEMENT component-file (archive-file-location, server-mapping-location?)>\n<!ELEMENT archive-file-location (#PCDATA)>\n<!ELEMENT server-mapping-location (#PCDATA)>\n]>";

    public SComponentsXmlDocument() {
        this.initXMLToolkit();
    }

    public Document loadDocumentFromFields() {
        Object tempElement = null;
        Object storageEl = null;
        this.mainDocument = StandardDOMParser.createDocument();
        Element mainElement = this.mainDocument.createElement("library-management");
        this.mainDocument.appendChild(mainElement);
        if (this.sComponents != null) {
            this.loadComponetnts(mainElement);
        }
        return this.mainDocument;
    }

    public void loadFieldsFromDocument(Document doc) {
        Element elm = doc.getDocumentElement();
        NodeList list = elm.getChildNodes();
        Element element = null;
        String tag = null;
        Vector<ComponentInfo> components = new Vector<ComponentInfo>();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1 && (tag = (element = (Element)list.item(i)).getTagName()).equals("component")) {
                components.add(this.initComponent(element));
            }
            ++i;
        }
        this.sComponents = new ComponentInfo[components.size()];
        components.copyInto(this.sComponents);
    }

    private ComponentInfo initComponent(Element compEl) {
        NodeList list = compEl.getChildNodes();
        Element el = null;
        String tag = null;
        ComponentInfo cInfo = new ComponentInfo();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                el = (Element)list.item(i);
                tag = el.getTagName();
                if (tag.equals("component-name")) {
                    cInfo.setName(this.getTextValue(el));
                } else if (tag.equals("component-file")) {
                    cInfo.setFileName(this.getTextValue(el));
                }
            }
            ++i;
        }
        cInfo.setActoinType(compEl.getAttribute("action"));
        cInfo.setCompType(compEl.getAttribute("type"));
        return cInfo;
    }

    public void loadComponetnts(Element parent) {
        Element compEl = this.mainDocument.createElement("component");
        int i = 0;
        while (i < this.sComponents.length) {
            compEl = this.mainDocument.createElement("component");
            if (this.sComponents[i].getName() != null && !this.sComponents[i].getName().equals("")) {
                this.load(compEl, this.sComponents[i].getName(), "component-name");
            }
            this.load(compEl, this.sComponents[i].getFileName(), "component-file");
            compEl.setAttribute("action", this.sComponents[i].getActionType());
            compEl.setAttribute("type", this.sComponents[i].getCompType());
            parent.appendChild(compEl);
            ++i;
        }
    }

    public void setComponents(ComponentInfo[] cInfo) {
        this.sComponents = cInfo;
    }

    public ComponentInfo[] getComponemnts() {
        return this.sComponents;
    }

    protected String getTextValue(Element element) {
        Node node;
        if (element != null && (node = element.getFirstChild()) != null && node.getNodeType() == 3) {
            String value = node.getNodeValue();
            if (value.trim().equals("") || value.trim().equals("null")) {
                return null;
            }
            return value.trim();
        }
        return null;
    }

    protected Element load(Element el, String value, String tagName) {
        if (value == null) {
            value = "";
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return nextElement;
    }

    private void initXMLToolkit() {
        if (this.parser == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.parser = new StandardDOMParser();
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

