/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.manager;

import com.sap.engine.services.deploy.DeployEvent;
import com.sap.engine.services.deploy.DeployListener;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ProgressEvent;
import java.rmi.RemoteException;
import java.util.Vector;

public class FinishListener
implements DeployListener {
    public static final byte START_ACTION = 0;
    public static final byte STOP_ACTION = 1;
    private String[] applications = new String[0];
    private int counter = 0;
    private DeployService deploy = null;
    private Vector remoteExcs = new Vector();

    public FinishListener(String[] apps, DeployService ds) throws DeploymentException {
        if (apps == null || apps.length == 0) {
            throw new DeploymentException("No applications specified!");
        }
        int i = 0;
        while (i < this.applications.length) {
            if (this.applications[i] == null) {
                throw new DeploymentException("Error in listing applications!");
            }
            ++i;
        }
        this.applications = apps;
        this.counter = this.applications.length;
        this.deploy = ds;
    }

    public void makeAction(byte action) {
        switch (action) {
            case 0: {
                int i = 0;
                while (i < this.applications.length) {
                    try {
                        this.deploy.startApplication(this.applications[i]);
                    }
                    catch (RemoteException rex) {
                        this.remoteExcs.add(rex);
                        this.uncheckApp(i);
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < this.applications.length) {
                    try {
                        this.deploy.stopApplication(this.applications[i]);
                    }
                    catch (RemoteException rex) {
                        this.remoteExcs.add(rex);
                        this.uncheckApp(i);
                    }
                    ++i;
                }
                break;
            }
        }
    }

    public void waitForFinish(long timeout) throws InterruptedException {
        FinishListener finishListener = this;
        synchronized (finishListener) {
            if (this.counter > 0) {
                if (timeout == 0L) {
                    this.wait();
                } else {
                    this.wait(timeout);
                }
            }
        }
    }

    public void processApplicationEvent(DeployEvent event) {
        int i = 0;
        while (i < this.applications.length) {
            if (this.applications[i] != null && this.applications[i].equals(event.getComponentName()) && event.getAction() == 1) {
                this.uncheckApp(i);
            }
            ++i;
        }
    }

    public void processServiceEvent(DeployEvent event) {
    }

    public void processLibraryEvent(DeployEvent event) {
    }

    public void processInterfaceEvent(DeployEvent event) {
    }

    public void processReferenceEvent(DeployEvent event) {
    }

    public void processStandaloneModuleEvent(DeployEvent event) {
    }

    public void processContainerEvent(ProgressEvent event) {
    }

    public void callbackLost(String serverName) {
    }

    public void serverAdded(String serverName) {
    }

    private void uncheckApp(int i) {
        this.applications[i] = null;
        FinishListener finishListener = this;
        synchronized (finishListener) {
            --this.counter;
            if (this.counter == 0) {
                this.notify();
            }
        }
    }

    public RemoteException[] getExceptions() {
        RemoteException[] res = new RemoteException[this.remoteExcs.size()];
        this.remoteExcs.toArray(res);
        return res;
    }

    public String[] getUnfinishedApplications() {
        Vector<String> apps = new Vector<String>();
        int i = 0;
        while (i < this.applications.length) {
            if (this.applications[i] != null) {
                apps.add(this.applications[i]);
            }
            ++i;
        }
        String[] res = new String[apps.size()];
        apps.toArray(res);
        return res;
    }
}

