/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.manager;

import com.sap.engine.deploy.ToolBundle;
import com.sap.engine.deploy.manager.IncorrectJ2EEException;
import com.sap.engine.deploy.manager.UserInfo;
import com.sap.engine.deploy.manager.UserRoleMappings;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.ear.xml.ApplicationJ2EEEngineDocument;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class EnvironmentXMLHelper {
    private static final String[] DTD = new String[]{"<!DOCTYPE ejb-j2ee-engine SYSTEM 'ejb-j2ee-engine.dtd'>", "<!DOCTYPE web-j2ee-engine SYSTEM 'ejb-j2ee-engine.dtd'>"};
    private static final String[] DOCS_ELEMENTS = new String[]{"ejb-j2ee-engine", "web-j2ee-engine"};
    private static final String[] ENGINE_XML_FILES = new String[]{"ejb-j2ee-engine.xml", "web-j2ee-engine.xml"};
    private static final String[] ENGINE_XML_ENTRIES = new String[]{"META-INF/ejb-j2ee-engine.xml", "WEB-INF/web-j2ee-engine.xml"};
    private static final String[] DESCR_XML_ENTRIES = new String[]{"META-INF/ejb-jar.xml", "WEB-INF/web.xml"};
    private static final int EJB_TYPE = 0;
    private static final int WEB_TYPE = 1;
    private String archiveName = null;
    private String beanName = null;
    private String earName = "";
    private StandardDOMWriter writer = new StandardDOMWriter();
    private StandardDOMParser parser = new StandardDOMParser();
    private StringWriter strWr = new StringWriter();

    public EnvironmentXMLHelper() {
        this.initXMLToolkit();
    }

    public void setEar(String earName) {
        this.earName = earName;
    }

    public Hashtable makeSecurityRoles(UserRoleMappings map, String dir, Hashtable altXmls) throws Exception {
        if (map == null || map.getMappings() == null || map.getMappings().size() == 0) {
            return new Hashtable();
        }
        Document doc = this.parseXml("META-INF/Application.xml", null);
        if (doc == null) {
            throw new IncorrectJ2EEException("Missing entry META-INF/Application.xml in EAR file: " + this.earName);
        }
        Hashtable ejbModules = this.getModules(doc, "ejb");
        if (altXmls == null) {
            altXmls = new Hashtable();
        }
        this.makeSecurityRoles(map, dir, altXmls, 0, ejbModules);
        Hashtable webModules = this.getModules(doc, "web");
        this.makeSecurityRoles(map, dir, altXmls, 1, webModules);
        return altXmls;
    }

    public void makeSecurityRoles(UserRoleMappings map, String dir, Hashtable altXmls, int type, Hashtable modules) throws Exception {
        Document doc = null;
        String moduleName = null;
        NodeList roleList = null;
        Vector<String> rolesVector = new Vector<String>();
        NodeList permissionList = null;
        Element permisionElement = null;
        Object roleMapEl = null;
        Object temp = null;
        Object roleName = null;
        Object users = null;
        Hashtable mapH = map.getMappings();
        boolean flag = false;
        Object tempRoleMapEl = null;
        Object tempRoleEl = null;
        Element mainElement = null;
        String alt_dd = null;
        Enumeration enumeration = modules.keys();
        while (enumeration.hasMoreElements()) {
            moduleName = (String)enumeration.nextElement();
            alt_dd = (String)modules.get(moduleName);
            doc = alt_dd.equals("") ? this.parseXml(DESCR_XML_ENTRIES[type], moduleName) : this.parseXml(alt_dd, null);
            if (doc == null) {
                throw new IncorrectJ2EEException("Missing deployment descriptor for module " + moduleName);
            }
            roleList = doc.getElementsByTagName("security-role");
            if (roleList != null) {
                int r = 0;
                while (r < roleList.getLength()) {
                    rolesVector.add(this.getElementValue((Element)((Element)roleList.item(r)).getElementsByTagName("role-name").item(0)).toLowerCase());
                    ++r;
                }
            }
            doc = null;
            InfoObject[] infoes = null;
            int info_index = -1;
            try {
                if (altXmls != null && altXmls.get(moduleName) != null) {
                    infoes = (InfoObject[])altXmls.get(moduleName);
                    int in = 0;
                    while (in < infoes.length) {
                        if (infoes[in] != null && infoes[in].getEntryName().equalsIgnoreCase(ENGINE_XML_ENTRIES[type])) {
                            this.parser.setSystemId(infoes[in].getFilePath());
                            doc = this.parser.parse((InputStream)new FileInputStream(infoes[in].getFilePath()));
                            info_index = in;
                            break;
                        }
                        ++in;
                    }
                }
                if (doc == null) {
                    doc = this.parseXml(ENGINE_XML_ENTRIES[type], moduleName);
                    if (doc == null) {
                        doc = StandardDOMParser.createDocument();
                        mainElement = doc.createElement(DOCS_ELEMENTS[type]);
                        doc.appendChild(mainElement);
                    } else {
                        mainElement = doc.getDocumentElement();
                    }
                } else {
                    mainElement = doc.getDocumentElement();
                }
            }
            catch (IOException ioe) {
                doc = StandardDOMParser.createDocument();
                mainElement = doc.createElement(DOCS_ELEMENTS[type]);
                doc.appendChild(mainElement);
            }
            if (info_index == -1) {
                if (infoes == null) {
                    infoes = new InfoObject[1];
                    info_index = 0;
                } else {
                    InfoObject[] tempInfo = new InfoObject[infoes.length + 1];
                    System.arraycopy(infoes, 0, tempInfo, 0, infoes.length);
                    infoes = tempInfo;
                }
            }
            if (type == 0) {
                permissionList = doc.getElementsByTagName("security-permission");
                if (permissionList == null || permissionList.getLength() == 0) {
                    permisionElement = doc.createElement("security-permission");
                }
                this.loadSecurityRoleMappings(doc, permisionElement, rolesVector, mapH);
                if (permisionElement.getChildNodes() != null && permisionElement.getChildNodes().getLength() > 0) {
                    mainElement.appendChild(permisionElement);
                }
            } else {
                Document tempDoc = StandardDOMParser.createDocument();
                Element tempMainElement = tempDoc.createElement(DOCS_ELEMENTS[type]);
                tempDoc.appendChild(tempMainElement);
                String[] webJ2eeDtdElements = new String[]{"resource-ref", "resource-env-ref", "ejb-ref", "ejb-local-ref", "server-component-ref"};
                NodeList list = mainElement.getChildNodes();
                String nodeName = null;
                Element element = null;
                boolean hasElementNode = false;
                int i = 0;
                while (i < list.getLength()) {
                    if (list.item(i).getNodeType() == 1) {
                        hasElementNode = true;
                        break;
                    }
                    ++i;
                }
                if (!hasElementNode) {
                    this.loadSecurityRoleMappings(tempDoc, tempMainElement, rolesVector, mapH);
                } else {
                    boolean priorMapping = false;
                    boolean mappingsDone = false;
                    int i2 = 0;
                    while (i2 < list.getLength()) {
                        if (list.item(i2).getNodeType() == 1) {
                            element = (Element)list.item(i2);
                            nodeName = element.getTagName();
                            priorMapping = false;
                            int j = 0;
                            while (j < webJ2eeDtdElements.length && !priorMapping) {
                                if (webJ2eeDtdElements.equals(nodeName)) {
                                    priorMapping = true;
                                }
                                ++j;
                            }
                            if (priorMapping) {
                                tempMainElement.appendChild(element);
                            } else if (!mappingsDone) {
                                this.loadSecurityRoleMappings(tempDoc, tempMainElement, rolesVector, mapH);
                                mappingsDone = true;
                            } else {
                                tempMainElement.appendChild(element);
                            }
                        }
                        ++i2;
                    }
                }
                doc = tempDoc;
            }
            File jarDir = new File(dir + File.separator + moduleName);
            jarDir.mkdirs();
            String filePath = jarDir.getAbsolutePath() + File.separator + ENGINE_XML_FILES[type];
            this.writer.write(doc, filePath, DTD[type]);
            infoes[info_index] = new InfoObject(ENGINE_XML_ENTRIES[type], filePath);
            altXmls.put(moduleName, infoes);
        }
    }

    public ReferenceObject[] getEarReferences() throws Exception {
        ReferenceObject[] references = new ReferenceObject[]{};
        Document doc = this.parseXml("META-INF/application-j2ee-engine.xml", null);
        if (doc == null) {
            return references;
        }
        NodeList list = doc.getDocumentElement().getChildNodes();
        Element element = null;
        String tag = null;
        ApplicationJ2EEEngineDocument appJ2eeEng = new ApplicationJ2EEEngineDocument();
        ReferenceObject[] tempArray = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i) != null && list.item(i).getNodeType() == 1 && (tag = (element = (Element)list.item(i)).getTagName()) != null && tag.equals("reference")) {
                tempArray = new ReferenceObject[references.length + 1];
                System.arraycopy(references, 0, tempArray, 0, references.length);
                tempArray[references.length] = appJ2eeEng.initReference(element);
                references = tempArray;
            }
            ++i;
        }
        return references;
    }

    public ReferenceObject[] getLibraryReferences(File libJar) throws Exception {
        FileInputStream is;
        ReferenceObject[] references;
        block8: {
            references = new ReferenceObject[]{};
            is = null;
            InputStream xmlis = null;
            boolean exists = false;
            try {
                is = new FileInputStream(libJar);
                xmlis = this.parseXml(is, "server/provider.xml");
                if (xmlis != null) {
                    exists = true;
                    references = this.parseLibraryXML(xmlis, libJar.getAbsolutePath() + "#server/provider.xml");
                }
                if ((xmlis = this.parseXml(is, "dispatcher/provider.xml")) != null) {
                    exists = true;
                    ReferenceObject[] refs = this.parseLibraryXML(xmlis, libJar.getAbsolutePath() + "#dispatcher/provider.xml");
                    ReferenceObject[] temp = new ReferenceObject[references.length + refs.length];
                    System.arraycopy(references, 0, temp, 0, references.length);
                    System.arraycopy(refs, 0, temp, references.length, refs.length);
                    references = temp;
                }
                if (!exists) {
                    throw new IOException("There is no provider xml in library jar!");
                }
                Object var9_8 = null;
                if (xmlis == null) break block8;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (xmlis != null) {
                    xmlis.close();
                }
                if (is != null) {
                    ((InputStream)is).close();
                }
                throw throwable;
            }
            xmlis.close();
        }
        if (is != null) {
            ((InputStream)is).close();
        }
        return references;
    }

    private void loadSecurityRoleMappings(Document doc, Element parent, Vector rolesVector, Hashtable mapH) {
        NodeList rolMapList = parent.getElementsByTagName("security-role-map");
        Element tempRoleMapEl = null;
        Element tempRoleEl = null;
        String roleName = null;
        UserInfo[] users = null;
        Element roleMapEl = null;
        int p = 0;
        while (p < rolesVector.size()) {
            roleName = (String)rolesVector.elementAt(p);
            users = (UserInfo[])mapH.get(roleName);
            if (users != null) {
                roleMapEl = doc.createElement("security-role-map");
                this.load(doc, roleMapEl, roleName, "role-name");
                int u = 0;
                while (u < users.length) {
                    this.load(doc, roleMapEl, users[u].getName(), users[u].getType() ? "user-name" : "group-name");
                    ++u;
                }
                boolean flag = false;
                int t = 0;
                while (t < rolMapList.getLength()) {
                    tempRoleMapEl = (Element)rolMapList.item(t);
                    tempRoleEl = (Element)tempRoleMapEl.getElementsByTagName("role-name").item(0);
                    if (roleName.equals(this.getElementValue(tempRoleEl))) {
                        flag = true;
                        parent.removeChild(tempRoleMapEl);
                        parent.appendChild(roleMapEl);
                    }
                    ++t;
                }
                if (!flag) {
                    parent.appendChild(roleMapEl);
                }
            }
            ++p;
        }
    }

    private Element loadSecurityRoleMap(Document doc, Element permisionElement, String roleName, UserInfo[] users) {
        Element roleMapEl = doc.createElement("security-role-map");
        this.load(doc, roleMapEl, roleName, "role-name");
        int u = 0;
        while (u < users.length) {
            this.load(doc, roleMapEl, users[u].getName(), users[u].getType() ? "user-name" : "group-name");
            ++u;
        }
        permisionElement.appendChild(roleMapEl);
        return roleMapEl;
    }

    private Hashtable getModules(Document doc, String type) throws Exception {
        Element docElement = doc.getDocumentElement();
        NodeList moduleList = docElement.getElementsByTagName("module");
        if (moduleList == null || moduleList.getLength() == 0) {
            return null;
        }
        Hashtable<String, String> resultHash = new Hashtable<String, String>();
        String alt_dd = null;
        Element moduleEl = null;
        Node child = null;
        int i = 0;
        while (i < moduleList.getLength()) {
            if (moduleList.item(i).getNodeType() == 1) {
                moduleEl = (Element)moduleList.item(i);
            }
            alt_dd = (child = this.getFirstChild(moduleEl, "alt-dd")) != null ? this.getElementValue((Element)child) : "";
            child = this.getFirstChild(moduleEl, type);
            if (child != null) {
                if (type.equals("web")) {
                    resultHash.put(this.getElementValue((Element)this.getFirstChild((Element)child, "web-uri")), alt_dd);
                } else {
                    resultHash.put(this.getElementValue((Element)child), alt_dd);
                }
            }
            ++i;
        }
        return resultHash;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document parseXml(String xmlEntry, String archiveName) throws Exception {
        Document doc;
        InputStream is;
        ZipInputStream zipIs;
        ZipFile zip;
        block16: {
            Document document;
            block14: {
                block15: {
                    zip = new ZipFile(this.earName);
                    Enumeration<? extends ZipEntry> enumeration = zip.entries();
                    ZipEntry entry = null;
                    String entryName = "";
                    InputStream xmlis = null;
                    zipIs = null;
                    is = null;
                    doc = null;
                    String systemId = this.earName + "#" + (archiveName == null ? "" : archiveName + "#") + xmlEntry;
                    try {
                        if (archiveName == null) {
                            while (enumeration.hasMoreElements()) {
                                entry = enumeration.nextElement();
                                entryName = entry.getName();
                                if (!xmlEntry.equalsIgnoreCase(entryName)) continue;
                                xmlis = zip.getInputStream(entry);
                                break;
                            }
                        } else {
                            while (enumeration.hasMoreElements()) {
                                entry = enumeration.nextElement();
                                entryName = entry.getName();
                                if (!archiveName.equalsIgnoreCase(entryName)) continue;
                                is = zip.getInputStream(entry);
                                break;
                            }
                            if (is == null) {
                                throw new IllegalArgumentException(ToolBundle.getResourceString("dm_msg_0021", archiveName));
                            }
                            xmlis = this.parseXml(is, xmlEntry);
                        }
                        if (xmlis == null) {
                            document = null;
                            Object var14_13 = null;
                            if (zipIs == null) break block14;
                            break block15;
                        }
                        this.parser.setSystemId(systemId);
                        doc = this.parser.parse(xmlis);
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var14_15 = null;
                        if (zipIs != null) {
                            zipIs.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                        zip.close();
                        throw throwable;
                    }
                }
                zipIs.close();
            }
            if (is != null) {
                is.close();
            }
            zip.close();
            return document;
        }
        Object var14_14 = null;
        if (zipIs != null) {
            zipIs.close();
        }
        if (is != null) {
            is.close();
        }
        zip.close();
        return doc;
    }

    /*
     * Unable to fully structure code
     */
    private InputStream parseXml(InputStream is, String xmlEntry) throws IOException {
        zipIs = null;
        xmlis = null;
        entry = null;
        r = 1024;
        buff = new byte[r];
        bytes = new byte[]{};
        tempBytes = new byte[]{};
        try {
            zipIs = new ZipInputStream(is);
            entry = zipIs.getNextEntry();
            while (entry != null) {
                if (entry.getName().replace('\\', '/').equalsIgnoreCase(xmlEntry)) {
                    r = zipIs.read(buff, 0, buff.length);
                    while (r > 0) {
                        tempBytes = new byte[bytes.length + r];
                        System.arraycopy(bytes, 0, tempBytes, 0, bytes.length);
                        System.arraycopy(buff, 0, tempBytes, bytes.length, r);
                        bytes = tempBytes;
                        r = zipIs.read(buff, 0, buff.length);
                    }
                    break;
                }
                entry = zipIs.getNextEntry();
            }
            var11_10 = null;
            ** if (zipIs != null) goto lbl-1000
        }
        catch (Throwable var10_12) {
            var11_11 = null;
            if (zipIs == null) {
                zipIs.close();
            }
            throw var10_12;
        }
lbl-1000:
        // 1 sources

        {
            zipIs.close();
        }
lbl-1000:
        // 2 sources

        {
        }
        if (bytes.length == 0) {
            return null;
        }
        xmlis = new ByteArrayInputStream(bytes);
        return xmlis;
    }

    private ReferenceObject[] parseLibraryXML(InputStream xmlis, String parserId) throws Exception {
        this.parser.setSystemId(parserId);
        Document doc = this.parser.parse(xmlis);
        NodeList list = doc.getDocumentElement().getChildNodes();
        Element element = null;
        ReferenceObject ref = null;
        ReferenceObject[] references = new ReferenceObject[]{};
        ReferenceObject[] tempArray = null;
        Element referenceEl = null;
        NodeList referenceList = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1 && (element = (Element)list.item(i)).getTagName().equals("references")) {
                referenceList = element.getElementsByTagName("reference");
                int j = 0;
                while (j < referenceList.getLength()) {
                    referenceEl = (Element)referenceList.item(j);
                    ref = new ReferenceObject();
                    ref.setReferenceTarget(this.getElementValue(referenceEl));
                    ref.setReferenceTargetType(referenceEl.getAttribute("type"));
                    ref.setReferenceType(referenceEl.getAttribute("strength"));
                    ref.setReferenceProviderName(referenceEl.getAttribute("provider-name"));
                    tempArray = new ReferenceObject[references.length + 1];
                    System.arraycopy(references, 0, tempArray, 0, references.length);
                    tempArray[references.length] = ref;
                    references = tempArray;
                    ++j;
                }
            }
            ++i;
        }
        return references;
    }

    private Node getFirstChild(Element el, String name) {
        NodeList list = el.getElementsByTagName(name);
        if (list == null || list.getLength() == 0) {
            return null;
        }
        return list.item(0);
    }

    private String getElementValue(Element el) {
        Node child = el.getFirstChild();
        if (child == null) {
            return null;
        }
        return child.getNodeValue().trim();
    }

    protected Element load(Document mainDocument, Element el, String value, String tagName) {
        if (value == null) {
            value = "";
        }
        Element nextElement = mainDocument.createElement(tagName);
        Text textNode = mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return nextElement;
    }

    private void initXMLToolkit() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.writer = new StandardDOMWriter();
        this.parser = new StandardDOMParser();
        Thread.currentThread().setContextClassLoader(cl);
    }
}

