/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.generator;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.deploy.ToolBundle;
import com.sap.engine.deploy.generator.AltDD;
import com.sap.engine.deploy.generator.EARGeneratorException;
import com.sap.engine.deploy.generator.EarGeneratorImpl;
import com.sap.engine.deploy.generator.EarJob;
import com.sap.engine.deploy.generator.EarObject;
import com.sap.engine.deploy.generator.XMLEarManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class XMLEarGenerator {
    private boolean logStarted = false;
    private RandomAccessFile out = null;
    static final String logSeparator = "***********************************************************";
    private boolean hasLogFile = true;
    private String classPath = "";
    private XMLEarManager earmanager = null;
    private EarGeneratorImpl eargenerator = null;

    public XMLEarGenerator() {
    }

    public XMLEarGenerator(RandomAccessFile out) {
        this.setLog(out);
    }

    public XMLEarGenerator(String s) {
        this.startLog(s);
    }

    public boolean generateEar(String xmlname, String logname) throws EARGeneratorException {
        this.startLog(logname);
        this.earmanager = new XMLEarManager(this.out);
        this.eargenerator = new EarGeneratorImpl(this.out);
        if (logname == null) {
            this.eargenerator.setHasLogFile(false);
            this.earmanager.setHasLogFile(false);
        } else {
            this.eargenerator.setHasLogFile(true);
            this.earmanager.setHasLogFile(true);
        }
        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0022"));
        EarJob job = this.earmanager.readXML(xmlname);
        Enumeration enumeration = job.getEarFiles();
        EarObject eob = null;
        this.eargenerator.startEar(job.getDisplayname());
        this.eargenerator.setSmallIcon(job.getSmallIcon());
        this.eargenerator.setLargeIcon(job.getLargeIcon());
        this.eargenerator.setDescription(job.getDescription());
        while (enumeration.hasMoreElements()) {
            eob = (EarObject)enumeration.nextElement();
            try {
                switch (eob.getType()) {
                    case 1: {
                        this.eargenerator.addJarArchive(eob.getPathname(), eob.getEntryname());
                        break;
                    }
                    case 2: {
                        this.eargenerator.addWarArchive(eob.getPathname(), eob.getEntryname(), eob.getContextroot());
                        break;
                    }
                    case 4: {
                        this.eargenerator.addClientArchive(eob.getPathname(), eob.getEntryname());
                        break;
                    }
                    case 5: {
                        this.eargenerator.addConnectorArchive(eob.getPathname(), eob.getEntryname());
                        break;
                    }
                    default: {
                        this.eargenerator.addOtherFile(eob.getPathname(), eob.getEntryname());
                        break;
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.toLog(ToolBundle.getResourceString("ear_gen_msg_0023", new String[]{e.getMessage(), this.eargenerator.loadStackTrace(e)}));
                throw new EARGeneratorException("ear_gen_err_msg_0016", new String[]{eob.getPathname(), e.getMessage()});
            }
            Enumeration enumdd = eob.getAlternativeDD();
            while (enumdd.hasMoreElements()) {
                AltDD dd = (AltDD)enumdd.nextElement();
                if (dd.getUse() && eob.getType() == 1) {
                    this.eargenerator.addClasspath(this.classPath);
                    this.eargenerator.replaceBeanDescriptor(eob.getEntryname(), dd.getElname(), dd.getPath());
                    continue;
                }
                if (dd.getUse() && eob.getType() == 2) {
                    this.eargenerator.replaceWebDescriptor(eob.getEntryname(), dd.getElname(), dd.getPath());
                    continue;
                }
                if (dd.getUse() && eob.getType() == 5) {
                    this.eargenerator.replaceConnectorDescriptor(eob.getEntryname(), dd.getElname(), dd.getPath());
                    continue;
                }
                if (!dd.getUse() || eob.getType() != 4) continue;
                this.eargenerator.replaceClientDescriptor(eob.getEntryname(), dd.getElname(), dd.getPath());
            }
            this.toLog(ToolBundle.getResourceString("ear_gen_msg_0024", new String[]{eob.getPathname(), eob.getEntryname(), eob.getContextroot()}));
        }
        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0025", job.getOutputname()));
        if (this.eargenerator.makeEar(job.getOutputname())) {
            this.toLog(ToolBundle.getResourceString("ear_gen_msg_0026", job.getOutputname()));
            this.stopLog();
            return true;
        }
        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0027", job.getOutputname()));
        this.stopLog();
        return false;
    }

    public static String getHelpMessage() {
        return ToolBundle.getResourceString("ear_gen_msg_0028");
    }

    private static void ebcdicConvert(String[] args) {
        String platform = SystemProperties.getProperty("platform.notASCII");
        if (platform != null && platform.equalsIgnoreCase("false")) {
            System.setErr(System.out);
            String ASCII = "ISO8859_1";
            String EBCDIC = "Cp1047";
            try {
                int i = 0;
                while (i < args.length) {
                    args[i] = new String(args[i].getBytes(ASCII), EBCDIC);
                    ++i;
                }
            }
            catch (UnsupportedEncodingException e) {
                return;
            }
        }
    }

    public static void main(String[] args) {
        XMLEarGenerator.ebcdicConvert(args);
        if (args.length < 1) {
            System.out.println(XMLEarGenerator.getHelpMessage());
            return;
        }
        try {
            FileInputStream f = new FileInputStream(args[0]);
            f.close();
        }
        catch (FileNotFoundException e) {
            System.out.println(ToolBundle.getResourceString("ear_gen_msg_0029", args[0]));
            return;
        }
        catch (Exception e) {
            System.out.println(ToolBundle.getResourceString("ear_gen_msg_0030", e.getMessage()));
            System.exit(1);
        }
        XMLEarGenerator xm = new XMLEarGenerator();
        try {
            boolean temp;
            if (args.length == 1) {
                xm.hasLogFile = false;
                temp = xm.generateEar(args[0], null);
            } else {
                temp = xm.generateEar(args[0], args[1]);
                if (temp) {
                    System.out.println(ToolBundle.getResourceString("ear_gen_msg_0031"));
                }
            }
            if (!temp) {
                if (xm.hasLogFile) {
                    System.out.println(ToolBundle.getResourceString("ear_gen_msg_0032"));
                }
                System.exit(1);
            }
        }
        catch (EARGeneratorException e) {
            if (xm.hasLogFile) {
                System.out.println(ToolBundle.getResourceString("ear_gen_msg_0033", e.getMessage()));
            }
            xm.toLog(ToolBundle.getResourceString("ear_gen_msg_0034", e.getMessage()));
            xm.stopLog();
            System.exit(1);
        }
        catch (Exception e) {
            if (xm.hasLogFile) {
                System.out.println(ToolBundle.getResourceString("ear_gen_msg_0033", e.getMessage()));
            }
            xm.toLog(ToolBundle.getResourceString("ear_gen_msg_0035", e.getMessage()));
            xm.stopLog();
            System.exit(1);
        }
    }

    private void stopLog() {
        try {
            this.toLog("***********************************************************\n\r ");
            this.logStarted = false;
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception e) {
            System.out.println(ToolBundle.getResourceString("ear_gen_msg_0036", e.getMessage()));
        }
    }

    private void toLog(String str) {
        try {
            if (!this.logStarted) {
                this.startLog();
            }
            String dateString = EarGeneratorImpl.logfileDateFormat.format(new Date()) + " -  ";
            StringBuffer emptyStringBuffer = new StringBuffer(dateString.length());
            int i = 0;
            while (i < dateString.length()) {
                emptyStringBuffer.append(' ');
                ++i;
            }
            String emptyString = emptyStringBuffer.toString();
            StringTokenizer st = new StringTokenizer(str, "\n\r");
            String s = "";
            if (st.hasMoreTokens()) {
                if (this.hasLogFile) {
                    s = dateString + st.nextToken() + "\n";
                    this.out.write(s.getBytes());
                } else {
                    s = dateString + st.nextToken();
                    System.out.println(s);
                }
            }
            while (st.hasMoreTokens()) {
                if (this.hasLogFile) {
                    s = emptyString + st.nextToken() + "\n";
                    this.out.write(s.getBytes());
                    continue;
                }
                s = emptyString + st.nextToken();
                System.out.println(s);
            }
        }
        catch (Exception e) {
            System.out.println(ToolBundle.getResourceString("ear_gen_msg_0017", e.getMessage()));
            e.printStackTrace();
            System.out.println("\n");
        }
    }

    public void setClasspath(String classpath) {
        this.classPath = classpath;
    }

    public void setLog(RandomAccessFile out) {
        this.out = out;
        this.logStarted = true;
    }

    public void startLog(String s) {
        if (s == null) {
            this.logStarted = true;
            this.toLog(logSeparator);
        } else {
            try {
                new File(s).delete();
                this.out = new RandomAccessFile(s, "rw");
                this.logStarted = true;
                this.toLog("***********************************************************\n");
            }
            catch (Exception e) {
                System.out.println(ToolBundle.getResourceString("ear_gen_msg_0017", e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    public void startLog() {
        System.out.println(ToolBundle.getResourceString("ear_gen_msg_0018"));
        this.startLog("logfile.txt");
    }
}

