/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.generator;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.deploy.ToolBundle;
import com.sap.engine.deploy.ejb.descriptors.xml.EJB20DescriptorDocument;
import com.sap.engine.deploy.ejb.descriptors.xml.EJBJarParser;
import com.sap.engine.deploy.generator.EARGeneratorException;
import com.sap.engine.deploy.generator.EarGenerator;
import com.sap.engine.deploy.generator.EarObject;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.appclient.descriptor.xml.J2EEApplicationDocument;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.ResorceAdapterDescriptorDocument;
import com.sap.engine.services.deploy.converter.ApplicationClientConverter;
import com.sap.engine.services.deploy.converter.EJBConverter;
import com.sap.engine.services.deploy.converter.WebConverter;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.extended.ear.EARDescriptor;
import com.sap.engine.services.deploy.extended.ear.MakeEar;
import com.sap.engine.services.ejb.deploy.admintool.RMappingTool;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.xml.WebDescriptorDocument;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class EarGeneratorImpl
implements EarGenerator {
    private Vector archives = new Vector();
    private MakeEar earMaker = new MakeEar();
    private String displayname = null;
    private String smallIcon = null;
    private String largeIcon = null;
    private String description = null;
    private byte[] buf = new byte[10000];
    private boolean logStarted = false;
    private RandomAccessFile out = null;
    static final SimpleDateFormat logfileDateFormat = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
    private boolean hasLogFile = true;
    private String tempDir;
    public String classPath = ".";

    public EarGeneratorImpl() {
    }

    public EarGeneratorImpl(RandomAccessFile out) {
        this.setLog(out);
    }

    public EarGeneratorImpl(String s) {
        this.startLog(s);
    }

    public String getDisplayName() {
        return this.displayname;
    }

    public void setDisplayName(String value) {
        this.displayname = value;
    }

    public Enumeration getEarFiles() {
        return this.archives.elements();
    }

    public void addJarArchive(String path, String entry) throws FileNotFoundException {
        this.archives.add(new EarObject(entry, path, 1));
    }

    public void addClientArchive(String path, String entry) throws FileNotFoundException {
        this.archives.add(new EarObject(entry, path, 4));
    }

    public void addConnectorArchive(String path, String entry) throws FileNotFoundException {
        this.archives.add(new EarObject(entry, path, 5));
    }

    public void addOtherFile(String path, String entry) throws FileNotFoundException {
        this.archives.add(new EarObject(entry, path, 3));
    }

    public void addWarArchive(String path, String entry, String root) throws FileNotFoundException {
        this.archives.add(new EarObject(entry, path, root));
    }

    public void removeArchiveFromEar(String archiveName) throws EARGeneratorException {
        int i = 0;
        while (i < this.archives.size()) {
            if (((EarObject)this.archives.get(i)).getEntryname().equals(archiveName)) {
                this.archives.remove(i);
                this.toLog(ToolBundle.getResourceString("ear_gen_msg_0001", archiveName));
                return;
            }
            ++i;
        }
        throw new EARGeneratorException("ear_gen_err_msg_0001");
    }

    public WebDeploymentDescriptor getWarDescriptor(String warname) throws EARGeneratorException {
        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0002", warname));
        try {
            return (WebDeploymentDescriptor)this.findByEntryName(warname).getArchiveDescriptor(this.classPath);
        }
        catch (Exception e) {
            throw new EARGeneratorException("ear_gen_err_msg_0002", e.getMessage());
        }
    }

    public EJBJarDescriptor getEJBBeanJarDescriptor(String jarname) throws EARGeneratorException {
        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0003", jarname));
        try {
            EarObject obj = this.findByEntryName(jarname);
            EJBJarDescriptor descr = (EJBJarDescriptor)obj.getArchiveDescriptor(this.classPath);
            if (!obj.getErrors().isEmpty()) {
                Vector err = obj.getErrors();
                int i = 0;
                while (i < err.size()) {
                    this.toLog((String)err.elementAt(i));
                    ++i;
                }
            }
            return descr;
        }
        catch (Exception e) {
            throw new EARGeneratorException("ear_gen_err_msg_0003", e.toString());
        }
    }

    public ApplicationClientDescriptor getAppClientDescriptor(String jarname) throws EARGeneratorException {
        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0004", jarname));
        try {
            return (ApplicationClientDescriptor)this.findByEntryName(jarname).getArchiveDescriptor(this.classPath);
        }
        catch (Exception e) {
            throw new EARGeneratorException("ear_gen_err_msg_0017", e.getMessage());
        }
    }

    public DeploymentDescriptor getEJBBeanDescriptor(String jarname, String descname) throws EARGeneratorException {
        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0005", new String[]{jarname, descname}));
        try {
            return (DeploymentDescriptor)this.findByEntryName(jarname).getDeploymentDescriptor(descname);
        }
        catch (Exception e) {
            throw new EARGeneratorException("ear_gen_err_msg_0004", new String[]{jarname, descname, e.getMessage()});
        }
    }

    public void setWarDescriptor(WebDeploymentDescriptor war, String warname) {
        this.findByEntryName(warname).setArchiveDescriptor(war);
    }

    public void setRarDescriptor(JCDescriptor rar, String rarname) {
        this.findByEntryName(rarname).setArchiveDescriptor(rar);
    }

    public void setEJBeanJarDescriptor(EJBJarDescriptor ejbean, String jarname) {
        this.findByEntryName(jarname).setArchiveDescriptor(ejbean);
    }

    public void setAppClientDescriptor(ApplicationClientDescriptor appclient, String jarname) {
        this.findByEntryName(jarname).setArchiveDescriptor(appclient);
    }

    public void setEJBeanDeploymentDescriptor(DeploymentDescriptor dd, String jarname) {
        this.findByEntryName(jarname).setDeploymentDescriptor(dd);
    }

    public void replaceBeanDescriptor(String jarName, String beanName, String xmlFile) throws EARGeneratorException {
        try {
            EJBJarDescriptor beanJar;
            DeploymentDescriptor[] xmlDescriptors = null;
            Object jarDescriptors = null;
            DynamicClassLoader loader = new DynamicClassLoader(this.findByEntryName(jarName).getPathname());
            if (this.classPath != null && !this.classPath.equals("")) {
                loader.addClasspath(this.classPath);
            }
            if ((beanJar = this.getConvertedEJBDescriptor(loader, xmlFile)).getDisplayName() != null && beanJar.getDisplayName().equals(beanName)) {
                this.setEJBeanJarDescriptor(beanJar, jarName);
            }
            xmlDescriptors = beanJar.getDDescriptors();
            int i = 0;
            while (i < xmlDescriptors.length) {
                if (xmlDescriptors[i].getName().equals(beanName)) {
                    this.setEJBeanDeploymentDescriptor(xmlDescriptors[i], jarName);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new EARGeneratorException("ear_gen_err_msg_0005", new String[]{jarName, beanName, xmlFile, e.getMessage()});
        }
    }

    public void replaceWebDescriptor(String jarName, String warName, String xmlFile) throws EARGeneratorException {
        try {
            WebDeploymentDescriptor xmlDescriptor = null;
            Object jarDescriptor = null;
            xmlDescriptor = this.getConvertedWebDescriptor(xmlFile);
            if (xmlDescriptor.getName().equals(warName)) {
                this.setWarDescriptor(xmlDescriptor, jarName);
            }
        }
        catch (Exception e) {
            throw new EARGeneratorException("ear_gen_err_msg_0018", new String[]{jarName, warName, xmlFile, e.getMessage()});
        }
    }

    public void replaceConnectorDescriptor(String jarName, String rarName, String xmlFile) throws EARGeneratorException {
        try {
            StandardDOMParser parser = new StandardDOMParser();
            parser.setSystemId(null);
            Document document = parser.parse(xmlFile);
            ResorceAdapterDescriptorDocument raDoc = new ResorceAdapterDescriptorDocument();
            JCDescriptor xmlDescriptor = raDoc.loadDescriptorFromDocument(document);
            if (xmlDescriptor.getDisplayName().equals(rarName)) {
                this.setRarDescriptor(xmlDescriptor, jarName);
            }
        }
        catch (Exception e) {
            throw new EARGeneratorException("ear_gen_err_msg_0018", new String[]{jarName, rarName, xmlFile, e.getMessage()});
        }
    }

    public void replaceClientDescriptor(String jarName, String clientName, String xmlFile) throws EARGeneratorException {
        try {
            ApplicationClientDescriptor xmlDescriptor = this.getConvertedClientDescriptor(xmlFile);
            if (xmlDescriptor.getDisplayName().equals(clientName)) {
                this.setAppClientDescriptor(xmlDescriptor, jarName);
            }
        }
        catch (Exception e) {
            throw new EARGeneratorException("ear_gen_err_msg_0018", new String[]{jarName, clientName, xmlFile, e.getMessage()});
        }
    }

    public void startEar(String displayname) {
        this.displayname = displayname;
        this.archives.clear();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean makeEar(String earFileName) {
        int i2;
        EarObject eee222;
        Throwable throwable2;
        block26: {
            EarObject eee222;
            this.toLog(ToolBundle.getResourceString("ear_gen_msg_0006", earFileName));
            this.tempDir = new File(earFileName).getParent() + File.separator + "jartemp";
            File tempDirect = new File(this.tempDir);
            tempDirect.mkdirs();
            try {
                block25: {
                    EarObject eee222;
                    boolean bl;
                    int i2;
                    EarObject eee222;
                    boolean infos2;
                    try {
                        EARDescriptor eardesc;
                        Object[] modsarray;
                        Vector<J2EEModule> mods = new Vector<J2EEModule>();
                        Vector<InfoObject> infos2 = new Vector<InfoObject>();
                        int i3 = 0;
                        while (true) {
                            if (i3 >= this.archives.size()) {
                                modsarray = new J2EEModule[mods.size()];
                                mods.copyInto(modsarray);
                                eardesc = new EARDescriptor(this.displayname);
                            }
                            EarObject eob = (EarObject)this.archives.get(i3);
                            this.toLog(ToolBundle.getResourceString("ear_gen_msg_0007", new String[]{eob.getPathname(), eob.getEntryname()}));
                            this.handleEarObject(eob);
                            this.toLog(ToolBundle.getResourceString("ear_gen_msg_0008", eob.getPathname()));
                            infos2.add(new InfoObject(eob.getEntryname(), eob.getPathname()));
                            if (eob.getType() == 1) {
                                mods.add(new J2EEModule(1, eob.getEntryname()));
                            } else if (eob.getType() == 2) {
                                J2EEModule x = new J2EEModule(4, eob.getEntryname());
                                x.setContextRoot(eob.getContextroot());
                                mods.add(x);
                            } else if (eob.getType() == 4) {
                                mods.add(new J2EEModule(3, eob.getEntryname()));
                            } else if (eob.getType() == 5) {
                                mods.add(new J2EEModule(5, eob.getEntryname()));
                            }
                            ++i3;
                        }
                        eardesc.setSmallIconName(this.smallIcon != null ? this.smallIcon : "");
                        eardesc.setLargeIconName(this.largeIcon != null ? this.largeIcon : "");
                        eardesc.setDescription(this.description);
                        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0009"));
                        eardesc.setModules((J2EEModule[])modsarray);
                        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0010"));
                        this.earMaker.setDescriptor(eardesc);
                        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0011"));
                        this.earMaker.setInfoObjects(infos2);
                        this.earMaker.makeEar(earFileName, infos2);
                        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0012", earFileName));
                        break block25;
                    }
                    catch (EARGeneratorException e) {
                        if (this.hasLogFile) {
                            System.out.println(ToolBundle.getResourceString("ear_gen_msg_0013", e.getMessage()));
                        }
                        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0013", e.getMessage()));
                        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0014", this.loadStackTrace(e)));
                        infos2 = false;
                        Object var9_13 = null;
                        eee222 = null;
                        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0016"));
                        FileUtils.deleteDirectory(tempDirect);
                        i2 = 0;
                    }
                    while (i2 < this.archives.size()) {
                        eee222 = (EarObject)this.archives.get(i2);
                        if (eee222.getChanged()) {
                            new File(eee222.getPathname()).delete();
                        }
                        ++i2;
                    }
                    return infos2;
                    catch (Exception e) {
                        if (this.hasLogFile) {
                            System.out.println(ToolBundle.getResourceString("ear_gen_msg_0015", e.getMessage()));
                        }
                        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0015", e.getMessage()));
                        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0014", this.loadStackTrace(e)));
                        bl = false;
                        Object var9_14 = null;
                        eee222 = null;
                        this.toLog(ToolBundle.getResourceString("ear_gen_msg_0016"));
                        FileUtils.deleteDirectory(tempDirect);
                        i2 = 0;
                    }
                    while (i2 < this.archives.size()) {
                        eee222 = (EarObject)this.archives.get(i2);
                        if (eee222.getChanged()) {
                            new File(eee222.getPathname()).delete();
                        }
                        ++i2;
                    }
                    return bl;
                }
                Object var9_12 = null;
                eee222 = null;
                this.toLog(ToolBundle.getResourceString("ear_gen_msg_0016"));
            }
            catch (Throwable throwable2) {
                Object var9_15 = null;
                eee222 = null;
                this.toLog(ToolBundle.getResourceString("ear_gen_msg_0016"));
                FileUtils.deleteDirectory(tempDirect);
                i2 = 0;
                break block26;
            }
            FileUtils.deleteDirectory(tempDirect);
            int i2 = 0;
            while (i2 < this.archives.size()) {
                eee222 = (EarObject)this.archives.get(i2);
                if (eee222.getChanged()) {
                    new File(eee222.getPathname()).delete();
                }
                ++i2;
            }
            return true;
        }
        while (true) {
            if (i2 >= this.archives.size()) {
                throw throwable2;
            }
            eee222 = (EarObject)this.archives.get(i2);
            if (eee222.getChanged()) {
                new File(eee222.getPathname()).delete();
            }
            ++i2;
        }
    }

    protected String createBackup(String name) throws EARGeneratorException {
        String tmpFile = this.tempDir + File.separator + "EarGen_" + System.currentTimeMillis() + name.substring(name.length() - 4);
        try {
            int a;
            FileInputStream fin = new FileInputStream(name);
            FileOutputStream fout = new FileOutputStream(tmpFile);
            while ((a = fin.read(this.buf)) == this.buf.length) {
                fout.write(this.buf);
            }
            if (a > 0) {
                fout.write(this.buf, 0, a);
            }
            fin.close();
            fout.close();
        }
        catch (FileNotFoundException e) {
            throw new EARGeneratorException("ear_gen_err_msg_0006", new String[]{name, e.getMessage()});
        }
        catch (Exception e) {
            throw new EARGeneratorException("ear_gen_err_msg_0007", new String[]{tmpFile, e.getMessage()});
        }
        return tmpFile;
    }

    protected EarObject findByEntryName(String entry) {
        int i = 0;
        while (i < this.archives.size()) {
            if (((EarObject)this.archives.get(i)).getEntryname().equals(entry)) {
                return (EarObject)this.archives.get(i);
            }
            ++i;
        }
        return null;
    }

    protected void replaceJarFile(String jarname, String oldfile, InfoObject newfile) throws EARGeneratorException {
        Vector<InfoObject> infoes = new Vector<InfoObject>();
        ZipEntry entry = null;
        InfoObject info = null;
        JarUtils ju = new JarUtils();
        boolean deleted = false;
        File oldjarfile = null;
        try {
            ZipFile zip = new ZipFile(jarname);
            Enumeration<? extends ZipEntry> enumeration = zip.entries();
            while (enumeration.hasMoreElements()) {
                entry = enumeration.nextElement();
                info = null;
                if (entry != null) {
                    info = EarObject.mkPath(entry.getName()).equalsIgnoreCase(EarObject.mkPath(oldfile)) ? newfile : new InfoObject(entry.getName(), jarname);
                }
                if (info == null) continue;
                infoes.add(info);
            }
            zip.close();
            String newjar = SystemProperties.getProperty("user.dir") + File.separator + "ear_gen" + System.currentTimeMillis() + ".jar";
            ju.makeJarFromFiles(newjar, infoes);
            oldjarfile = new File(jarname);
            File newjarfile = new File(newjar);
            oldjarfile.delete();
            deleted = true;
            newjarfile.renameTo(oldjarfile);
        }
        catch (Exception e) {
            if (!deleted && oldjarfile != null) {
                oldjarfile.delete();
            }
            throw new EARGeneratorException("ear_gen_err_msg_0015", new String[]{oldfile, jarname, newfile.getFilePath(), e.getMessage()});
        }
    }

    protected void handleEarObject(EarObject eob) throws Exception {
        block13: {
            if (eob.getType() == 3) {
                return;
            }
            File tmpFile = null;
            try {
                Object newxml = null;
                eob.setOriginalName(eob.getPathname());
                eob.setPathname(this.createBackup(eob.getPathname()));
                eob.setChanged(true);
                StandardDOMWriter writer = new StandardDOMWriter();
                eob.packDescriptor();
                if (eob.getType() == 2) {
                    WebDeploymentDescriptor descr = (WebDeploymentDescriptor)eob.getArchiveDescriptor(this.classPath);
                    eob.setPathname(this.updateWebWar(descr, eob.getPathname()).getAbsolutePath());
                } else if (eob.getType() == 1) {
                    EJBJarDescriptor ejbean = (EJBJarDescriptor)eob.getArchiveDescriptor(this.classPath);
                    if (!eob.getErrors().isEmpty()) {
                        Vector err = eob.getErrors();
                        int i = 0;
                        while (i < err.size()) {
                            this.toLog((String)err.get(i));
                            ++i;
                        }
                    }
                    eob.setPathname(this.updateEJBJar(ejbean, eob.getPathname()).getAbsolutePath());
                } else if (eob.getType() == 4) {
                    ApplicationClientDescriptor appClientDescr = (ApplicationClientDescriptor)eob.getArchiveDescriptor(this.classPath);
                    eob.setPathname(this.updateClientJar(appClientDescr, eob.getPathname()).getAbsolutePath());
                } else if (eob.getType() == 5) {
                    JCDescriptor jcDescr = (JCDescriptor)eob.getArchiveDescriptor(this.classPath);
                    eob.setPathname(this.updateConnectorJar(jcDescr, eob.getPathname()).getAbsolutePath());
                }
                Object var9_11 = null;
                if (tmpFile == null) break block13;
                tmpFile.delete();
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (tmpFile != null) {
                    tmpFile.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File updateEJBJar(EJBJarDescriptor jar, String file) {
        ejbJarXml = this.tempDir + File.separator + "ejb-jar.xml";
        ejbJarFile = new File(ejbJarXml);
        entry = null;
        entry1 = null;
        in = null;
        tmpName = "_jar" + System.currentTimeMillis() + ".jar";
        out = null;
        buff = null;
        tempfileDir = new File(this.tempDir);
        if (!tempfileDir.exists()) {
            tempfileDir.mkdirs();
        }
        try {
            try {
                out = new ZipOutputStream(new FileOutputStream(this.tempDir + File.separator + tmpName));
                out.setMethod(0);
                zip = new ZipFile(file);
                enum = zip.entries();
                this.saveEJBXmls(ejbJarFile, jar);
                while (true) {
                    if (!enum.hasMoreElements()) {
                        zip.close();
                        tempFile = new File(this.tempDir + File.separator + tmpName);
                        new File(ejbJarXml).delete();
                        var15_18 = tempFile;
                        var17_20 = null;
                        if (out == null) return var15_18;
                        break;
                    }
                    entry1 = enum.nextElement();
                    len = -1;
                    if (entry1 == null) continue;
                    try {
                        entry = new ZipEntry(entry1.getName());
                        if (entry1.getName().equalsIgnoreCase("meta-inf/ejb-jar.xml")) {
                            len = (int)new File(ejbJarXml).length();
                            buff = new byte[len];
                            in = new FileInputStream(ejbJarXml);
                            in.read(buff, 0, buff.length);
                            entry.setSize(len);
                            crc = new CRC32();
                            crc.update(buff);
                            entry.setCrc(crc.getValue());
                            entry.setCompressedSize(len);
                            in.close();
                        } else {
                            buff = new byte[(int)entry1.getSize()];
                            in = new BufferedInputStream(zip.getInputStream(entry1));
                            in.read(buff, 0, buff.length);
                            entry.setSize(buff.length);
                            crc = new CRC32();
                            crc.update(buff);
                            entry.setCrc(crc.getValue());
                            entry.setCompressedSize(buff.length);
                        }
                        out.putNextEntry(entry);
                        out.write(buff);
                        out.closeEntry();
                    }
                    catch (ZipException ze) {
                        this.toLog("Cannot close ZipOutputStream for EJB jar " + file + " after update procedure.\nReason: " + ze.toString());
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.toLog("Cannot find file " + tmpName + " to read from. Reason:" + e.toString());
                var17_21 = null;
                if (out == null) return null;
                try {
                    out.close();
                    return null;
                }
                catch (Exception e) {
                    this.toLog("Cannot close ZipOutputStream for EJB jar " + file + " after update procedure.\nReason: " + e.toString());
                    return null;
                }
            }
            catch (IOException e) {
                this.toLog("Error ocured while trying to read from " + tmpName + ". Reason:" + e.toString());
                var17_22 = null;
                if (out == null) return null;
                try {}
                catch (Exception e) {
                    this.toLog("Cannot close ZipOutputStream for EJB jar " + file + " after update procedure.\nReason: " + e.toString());
                    return null;
                }
                out.close();
                return null;
            }
        }
        catch (Throwable var16_28) {
            var17_23 = null;
            if (out == null) throw var16_28;
            ** try [egrp 3[TRYBLOCK] [4 : 646->654)] { 
lbl92:
            // 1 sources

            out.close();
            throw var16_28;
lbl94:
            // 1 sources

            catch (Exception e) {
                this.toLog("Cannot close ZipOutputStream for EJB jar " + file + " after update procedure.\nReason: " + e.toString());
            }
            throw var16_28;
        }
        ** try [egrp 3[TRYBLOCK] [4 : 646->654)] { 
lbl99:
        // 1 sources

        out.close();
        return var15_18;
lbl101:
        // 1 sources

        catch (Exception e) {
            this.toLog("Cannot close ZipOutputStream for EJB jar " + file + " after update procedure.\nReason: " + e.toString());
        }
        return var15_18;
    }

    protected void saveEJBXmls(File ejbFile, EJBJarDescriptor jar) {
        StandardDOMWriter writer = new StandardDOMWriter();
        Document doc = null;
        try {
            DynamicClassLoader loader = new DynamicClassLoader(ejbFile.getParent());
            EJB20DescriptorDocument ejb20DescriptorDocument = new EJB20DescriptorDocument();
            doc = ejb20DescriptorDocument.loadEJBJarDescriptor(jar);
            writer.write(doc, ejbFile.getAbsolutePath(), "<!DOCTYPE ejb-jar PUBLIC '-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN' 'http://java.sun.com/dtd/ejb-jar_2_0.dtd'>", "UTF-8");
        }
        catch (IOException e) {
            this.toLog("Problems while saving ejb-jar.xml. Reason:" + e.toString());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File updateWebWar(WebDeploymentDescriptor jar, String file) {
        webXml = this.tempDir + File.separator + "web.xml";
        webFile = new File(webXml);
        entry = null;
        entry1 = null;
        in = null;
        tmpName = "_web" + System.currentTimeMillis() + ".war";
        out = null;
        buff = null;
        tempfileDir = new File(this.tempDir);
        if (!tempfileDir.exists()) {
            tempfileDir.mkdirs();
        }
        try {
            try {
                out = new ZipOutputStream(new FileOutputStream(this.tempDir + File.separator + tmpName));
                out.setMethod(0);
                this.saveWebXml(webXml, jar);
                zip = new ZipFile(file);
                enum = zip.entries();
                while (true) {
                    if (!enum.hasMoreElements()) {
                        zip.close();
                        tempFile = new File(this.tempDir + File.separator + tmpName);
                        webFile.delete();
                        var15_18 = tempFile;
                        var17_19 = null;
                        if (out == null) return var15_18;
                        break;
                    }
                    entry1 = enum.nextElement();
                    if (entry1 == null) continue;
                    try {
                        entry1.setExtra(new byte[0]);
                        entry = new ZipEntry(entry1.getName());
                        if (entry1.getName().equalsIgnoreCase("web-inf/web.xml")) {
                            buff = new byte[(int)webFile.length()];
                            in = new FileInputStream(webFile);
                            in.read(buff, 0, buff.length);
                            entry.setSize(webFile.length());
                            crc = new CRC32();
                            crc.update(buff);
                            entry.setCrc(crc.getValue());
                            entry.setCompressedSize(webFile.length());
                            in.close();
                        } else {
                            buff = new byte[(int)entry1.getSize()];
                            in = new BufferedInputStream(zip.getInputStream(entry1));
                            in.read(buff, 0, buff.length);
                            entry.setSize(buff.length);
                            crc = new CRC32();
                            crc.update(buff);
                            entry.setCrc(crc.getValue());
                            entry.setCompressedSize(buff.length);
                        }
                        out.putNextEntry(entry);
                        out.write(buff);
                        out.closeEntry();
                    }
                    catch (ZipException ze) {
                        this.toLog("Cannot close ZipOutputStream for WEB war " + file + " after update procedure.\nReason: " + ze.toString());
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.toLog("Cannot find file " + tmpName + " to read from. Reason:" + e.toString());
                var17_20 = null;
                if (out == null) return null;
                try {
                    out.close();
                    return null;
                }
                catch (Exception e) {
                    this.toLog("Cannot close ZipOutputStream for WEB war " + file + " after update procedure.\nReason: " + e.toString());
                    return null;
                }
            }
            catch (IOException e) {
                this.toLog("Error ocured while trying to read from " + tmpName + ". Reason:" + e.toString());
                var17_21 = null;
                if (out == null) return null;
                try {}
                catch (Exception e) {
                    this.toLog("Cannot close ZipOutputStream for WEB war " + file + " after update procedure.\nReason: " + e.toString());
                    return null;
                }
                out.close();
                return null;
            }
        }
        catch (Throwable var16_27) {
            var17_22 = null;
            if (out == null) throw var16_27;
            ** try [egrp 3[TRYBLOCK] [4 : 639->647)] { 
lbl91:
            // 1 sources

            out.close();
            throw var16_27;
lbl93:
            // 1 sources

            catch (Exception e) {
                this.toLog("Cannot close ZipOutputStream for WEB war " + file + " after update procedure.\nReason: " + e.toString());
            }
            throw var16_27;
        }
        ** try [egrp 3[TRYBLOCK] [4 : 639->647)] { 
lbl98:
        // 1 sources

        out.close();
        return var15_18;
lbl100:
        // 1 sources

        catch (Exception e) {
            this.toLog("Cannot close ZipOutputStream for WEB war " + file + " after update procedure.\nReason: " + e.toString());
        }
        return var15_18;
    }

    protected void saveWebXml(String webFile, WebDeploymentDescriptor jar) {
        StandardDOMWriter writer = new StandardDOMWriter();
        Document doc = null;
        try {
            WebDescriptorDocument webWar = new WebDescriptorDocument();
            doc = webWar.loadDocumentFromDescriptor(jar);
            writer.write(doc, webFile, "<!DOCTYPE web-app PUBLIC '-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN' 'http://java.sun.com/dtd/web-app_2_3.dtd'>", "UTF-8");
        }
        catch (Exception e) {
            this.toLog("Exception occurs while saving WEB XML file " + webFile + ".\nReason: " + e.toString());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File updateClientJar(ApplicationClientDescriptor jar, String file) {
        clientXml = this.tempDir + File.separator + "application-client.xml";
        clientFile = new File(clientXml);
        entry = null;
        entry1 = null;
        in = null;
        tmpName = "_client" + System.currentTimeMillis() + ".jar";
        out = null;
        buff = null;
        tempfileDir = new File(this.tempDir);
        if (!tempfileDir.exists()) {
            tempfileDir.mkdirs();
        }
        try {
            try {
                out = new ZipOutputStream(new FileOutputStream(this.tempDir + File.separator + tmpName));
                out.setMethod(0);
                this.saveClientXml(clientXml, jar);
                zip = new ZipFile(file);
                enum = zip.entries();
                while (true) {
                    if (!enum.hasMoreElements()) {
                        zip.close();
                        tempFile = new File(this.tempDir + File.separator + tmpName);
                        clientFile.delete();
                        var15_18 = tempFile;
                        var17_19 = null;
                        if (out == null) return var15_18;
                        break;
                    }
                    entry1 = enum.nextElement();
                    if (entry1 == null) continue;
                    try {
                        entry = new ZipEntry(entry1.getName());
                        if (entry1.getName().equalsIgnoreCase("meta-inf/application-client.xml")) {
                            buff = new byte[(int)clientFile.length()];
                            in = new FileInputStream(clientFile);
                            in.read(buff, 0, buff.length);
                            entry.setSize(clientFile.length());
                            crc = new CRC32();
                            crc.update(buff);
                            entry.setCrc(crc.getValue());
                            entry.setCompressedSize(clientFile.length());
                            in.close();
                        } else {
                            buff = new byte[(int)entry1.getSize()];
                            in = new BufferedInputStream(zip.getInputStream(entry));
                            in.read(buff, 0, buff.length);
                            entry.setSize(buff.length);
                            crc = new CRC32();
                            crc.update(buff);
                            entry.setCrc(crc.getValue());
                            entry.setCompressedSize(buff.length);
                        }
                        out.putNextEntry(entry);
                        out.write(buff);
                        out.closeEntry();
                    }
                    catch (ZipException ze) {
                        this.toLog("Cannot close ZipOutputStream for client jar " + file + " after update procedure.\nReason: " + ze.toString());
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.toLog("Cannot find file " + tmpName + " to read from. Reason:" + e.toString());
                var17_20 = null;
                if (out == null) return null;
                try {
                    out.close();
                    return null;
                }
                catch (Exception e) {
                    this.toLog("Cannot close ZipOutputStream for Client jar " + file + " after update procedure.\nReason: " + e.toString());
                    return null;
                }
            }
            catch (IOException e) {
                this.toLog("Error ocured while trying to read from " + tmpName + ". Reason:" + e.toString());
                var17_21 = null;
                if (out == null) return null;
                try {}
                catch (Exception e) {
                    this.toLog("Cannot close ZipOutputStream for Client jar " + file + " after update procedure.\nReason: " + e.toString());
                    return null;
                }
                out.close();
                return null;
            }
        }
        catch (Throwable var16_27) {
            var17_22 = null;
            if (out == null) throw var16_27;
            ** try [egrp 3[TRYBLOCK] [4 : 631->639)] { 
lbl90:
            // 1 sources

            out.close();
            throw var16_27;
lbl92:
            // 1 sources

            catch (Exception e) {
                this.toLog("Cannot close ZipOutputStream for Client jar " + file + " after update procedure.\nReason: " + e.toString());
            }
            throw var16_27;
        }
        ** try [egrp 3[TRYBLOCK] [4 : 631->639)] { 
lbl97:
        // 1 sources

        out.close();
        return var15_18;
lbl99:
        // 1 sources

        catch (Exception e) {
            this.toLog("Cannot close ZipOutputStream for Client jar " + file + " after update procedure.\nReason: " + e.toString());
        }
        return var15_18;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File updateConnectorJar(JCDescriptor jar, String file) {
        connectorXml = this.tempDir + File.separator + "ra.xml";
        connectorFile = new File(connectorXml);
        entry = null;
        entry1 = null;
        in = null;
        tmpName = "_connector" + System.currentTimeMillis() + ".rar";
        out = null;
        buff = null;
        tempfileDir = new File(this.tempDir);
        if (!tempfileDir.exists()) {
            tempfileDir.mkdirs();
        }
        try {
            try {
                out = new ZipOutputStream(new FileOutputStream(this.tempDir + File.separator + tmpName));
                out.setMethod(0);
                this.saveConnectorXml(connectorXml, jar);
                zip = new ZipFile(file);
                enum = zip.entries();
                while (true) {
                    if (!enum.hasMoreElements()) {
                        zip.close();
                        tempFile = new File(this.tempDir + File.separator + tmpName);
                        connectorFile.delete();
                        var15_18 = tempFile;
                        var17_19 = null;
                        if (out == null) return var15_18;
                        break;
                    }
                    entry1 = enum.nextElement();
                    if (entry1 == null) continue;
                    try {
                        entry = new ZipEntry(entry1.getName());
                        if (entry1.getName().equalsIgnoreCase("meta-inf/ra.xml")) {
                            buff = new byte[(int)connectorFile.length()];
                            in = new FileInputStream(connectorFile);
                            in.read(buff, 0, buff.length);
                            entry.setSize(connectorFile.length());
                            crc = new CRC32();
                            crc.update(buff);
                            entry.setCrc(crc.getValue());
                            entry.setCompressedSize(connectorFile.length());
                            in.close();
                        } else {
                            buff = new byte[(int)entry1.getSize()];
                            in = new BufferedInputStream(zip.getInputStream(entry));
                            in.read(buff, 0, buff.length);
                            entry.setSize(buff.length);
                            crc = new CRC32();
                            crc.update(buff);
                            entry.setCrc(crc.getValue());
                            entry.setCompressedSize(buff.length);
                        }
                        out.putNextEntry(entry);
                        out.write(buff);
                        out.closeEntry();
                    }
                    catch (ZipException ze) {
                        this.toLog("Cannot close ZipOutputStream for connector rar " + file + " after update procedure.\nReason: " + ze.toString());
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.toLog("Cannot find file " + tmpName + " to read from. Reason:" + e.toString());
                var17_20 = null;
                if (out == null) return null;
                try {
                    out.close();
                    return null;
                }
                catch (Exception e) {
                    this.toLog("Cannot close ZipOutputStream for Connector jar " + file + " after update procedure.\nReason: " + e.toString());
                    return null;
                }
            }
            catch (IOException e) {
                this.toLog("Error ocured while trying to read from " + tmpName + ". Reason:" + e.toString());
                var17_21 = null;
                if (out == null) return null;
                try {}
                catch (Exception e) {
                    this.toLog("Cannot close ZipOutputStream for Connector jar " + file + " after update procedure.\nReason: " + e.toString());
                    return null;
                }
                out.close();
                return null;
            }
        }
        catch (Throwable var16_27) {
            var17_22 = null;
            if (out == null) throw var16_27;
            ** try [egrp 3[TRYBLOCK] [4 : 632->640)] { 
lbl90:
            // 1 sources

            out.close();
            throw var16_27;
lbl92:
            // 1 sources

            catch (Exception e) {
                this.toLog("Cannot close ZipOutputStream for Connector jar " + file + " after update procedure.\nReason: " + e.toString());
            }
            throw var16_27;
        }
        ** try [egrp 3[TRYBLOCK] [4 : 632->640)] { 
lbl97:
        // 1 sources

        out.close();
        return var15_18;
lbl99:
        // 1 sources

        catch (Exception e) {
            this.toLog("Cannot close ZipOutputStream for Connector jar " + file + " after update procedure.\nReason: " + e.toString());
        }
        return var15_18;
    }

    protected void saveClientXml(String clientFile, ApplicationClientDescriptor jar) {
        StandardDOMWriter writer = new StandardDOMWriter();
        Document doc = null;
        try {
            J2EEApplicationDocument clientJar = new J2EEApplicationDocument();
            File clientFileName = new File(clientFile);
            doc = clientJar.loadDocument(jar);
            writer.write(doc, clientFile, "<!DOCTYPE application-client [\n<!ELEMENT application-client (icon?, display-name, description?, env-entry*, ejb-ref*, resource-ref*, resource-env-ref*, callback-handler?)>\n<!ELEMENT icon (small-icon?, large-icon?)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-sharing-scope?)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-sharing-scope (#PCDATA)>\n<!ELEMENT resource-env-ref (description?, resource-env-ref-name, resource-env-ref-type)>\n<!ELEMENT resource-env-ref-name (#PCDATA)>\n<!ELEMENT resource-env-ref-type (#PCDATA)>\n<!ELEMENT callback-handler (#PCDATA)>\n<!ATTLIST application-client id ID #IMPLIED>\n<!ATTLIST callback-handler id ID #IMPLIED>\n<!ATTLIST description id ID #IMPLIED>\n<!ATTLIST display-name id ID #IMPLIED>\n<!ATTLIST ejb-link id ID #IMPLIED>\n<!ATTLIST ejb-ref id ID #IMPLIED>\n<!ATTLIST ejb-ref-name id ID #IMPLIED>\n<!ATTLIST ejb-ref-type id ID #IMPLIED>\n<!ATTLIST env-entry id ID #IMPLIED>\n<!ATTLIST env-entry-name id ID #IMPLIED>\n<!ATTLIST env-entry-type id ID #IMPLIED>\n<!ATTLIST env-entry-value id ID #IMPLIED>\n<!ATTLIST home id ID #IMPLIED>\n<!ATTLIST icon id ID #IMPLIED>\n<!ATTLIST large-icon id ID #IMPLIED>\n<!ATTLIST remote id ID #IMPLIED>\n<!ATTLIST res-auth id ID #IMPLIED>\n<!ATTLIST res-ref-name id ID #IMPLIED>\n<!ATTLIST res-sharing-scope id ID #IMPLIED>\n<!ATTLIST res-type id ID #IMPLIED>\n<!ATTLIST resource-env-ref id ID #IMPLIED>\n<!ATTLIST resource-env-ref-name id ID #IMPLIED>\n<!ATTLIST resource-env-ref-type id ID #IMPLIED>\n<!ATTLIST resource-ref id ID #IMPLIED>\n<!ATTLIST small-icon id ID #IMPLIED> \n]>", "UTF-8");
        }
        catch (Exception e) {
            this.toLog("Exception occurs while saving Client XML file " + clientFile + ".\nReason: " + e.toString());
        }
    }

    protected void saveConnectorXml(String connectorFile, JCDescriptor jar) {
        StandardDOMWriter writer = new StandardDOMWriter();
        Document doc = null;
        try {
            ResorceAdapterDescriptorDocument connectorJar = new ResorceAdapterDescriptorDocument();
            File connectorFileName = new File(connectorFile);
            doc = connectorJar.loadDocumentFromDescriptor(jar);
            writer.write(doc, connectorFile, "<!DOCTYPE connector PUBLIC '-//Sun Microsystems, Inc.//DTD Connector 1.0//EN' 'http://java.sun.com/dtd/connector_1_0.dtd'>", "UTF-8");
        }
        catch (Exception e) {
            this.toLog("Exception occurs while saving Connector XML file " + connectorFile + ".\nReason: " + e.toString());
        }
    }

    public String loadStackTrace(Exception ex) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(out);
        ex.printStackTrace(stream);
        String result = out.toString();
        stream.close();
        try {
            out.close();
        }
        catch (IOException ioe) {
            this.toLog("Exception occurs while loading Stack trace(ByteArrayOutputStream.close() is called).\nReason: " + ioe.toString());
        }
        return result;
    }

    private void toLog(String str) {
        try {
            if (!this.logStarted) {
                this.startLog();
            }
            String dateString = logfileDateFormat.format(new Date()) + " -  ";
            StringBuffer emptyStringBuffer = new StringBuffer(dateString.length());
            int i = 0;
            while (i < dateString.length()) {
                emptyStringBuffer.append(' ');
                ++i;
            }
            String emptyString = emptyStringBuffer.toString();
            StringTokenizer st = new StringTokenizer(str, "\n\r");
            String s = "";
            if (st.hasMoreTokens()) {
                if (this.hasLogFile) {
                    s = dateString + st.nextToken() + "\n";
                    this.out.write(s.getBytes());
                } else {
                    s = dateString + st.nextToken();
                    System.out.println(s);
                }
            }
            while (st.hasMoreTokens()) {
                if (this.hasLogFile) {
                    s = emptyString + st.nextToken() + "\n";
                    this.out.write(s.getBytes());
                    continue;
                }
                s = emptyString + st.nextToken();
                System.out.println(s);
            }
        }
        catch (Exception e) {
            System.out.println(ToolBundle.getResourceString("ear_gen_msg_0017", e.getMessage()));
            e.printStackTrace();
            System.out.println("\n");
        }
    }

    public void setLog(RandomAccessFile out) {
        this.out = out;
        this.logStarted = true;
    }

    public void startLog(String s) {
        if (s == null) {
            this.logStarted = true;
            this.toLog("***********************************************************");
        } else {
            try {
                this.out = new RandomAccessFile(s, "rw");
                this.out.seek(this.out.length());
                this.logStarted = true;
                this.toLog("***********************************************************\n");
            }
            catch (Exception e) {
                System.out.println(ToolBundle.getResourceString("ear_gen_msg_0017", e.getMessage()));
                e.printStackTrace();
                System.out.println("\n");
            }
        }
    }

    public void startLog() {
        System.out.println(ToolBundle.getResourceString("ear_gen_msg_0018"));
        this.startLog("logfile.txt");
    }

    public boolean getHasLogFile() {
        return this.hasLogFile;
    }

    public void setHasLogFile(boolean hasLogFile) {
        this.hasLogFile = hasLogFile;
    }

    public EJBJarDescriptor getConvertedEJBDescriptor(ClassLoader loader, String xmlFileLocation) throws Exception {
        Document document = null;
        EJBJarDescriptor result = new EJBJarDescriptor();
        BufferedInputStream buffer = null;
        try {
            buffer = new BufferedInputStream(new FileInputStream(xmlFileLocation));
        }
        catch (IOException io) {
            throw new Exception(ToolBundle.getResourceString("ear_gen_msg_0019", io.toString()));
        }
        try {
            StandardDOMParser domParser = new StandardDOMParser();
            domParser.setSystemId(xmlFileLocation);
            document = domParser.parse((InputStream)buffer);
            buffer.close();
        }
        catch (IOException ioe) {
            throw new Exception(ToolBundle.getResourceString("ear_gen_msg_0019", ioe.toString()));
        }
        catch (Exception ex) {
            throw new Exception(ToolBundle.getResourceString("ear_gen_msg_0019", ex.toString()));
        }
        DocumentType dt = document.getDoctype();
        String dtd = "<!DOCTYPE ejb-jar [\n<!ELEMENT ejb-jar (description?, display-name?, small-icon?, large-icon?, enterprise-beans, assembly-descriptor?)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT enterprise-beans (session|entity)+ > \n<!ELEMENT session (description?, display-name?, small-icon?, large-icon?, \n ejb-name, home, remote, ejb-class, session-type,session-timeout?, transaction-type, bean-count,\n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT entity (description?, display-name?, small-icon?, large-icon?,\n ejb-name, home, remote, ejb-class, persistence-type, prim-key-class, reentrant, bean-count, cmp-field*, primkey-field?, \n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT ejb-name (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-class (#PCDATA)>\n<!ELEMENT session-type (#PCDATA)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT transaction-type (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link, user-name, password)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT password (#PCDATA)>\n<!ELEMENT persistence-type (#PCDATA)>\n<!ELEMENT prim-key-class (#PCDATA)>\n<!ELEMENT reentrant (#PCDATA)>\n<!ELEMENT cmp-field (description?, field-name)>\n<!ELEMENT field-name (#PCDATA)>\n<!ELEMENT primkey-field (#PCDATA)>\n<!ELEMENT assembly-descriptor (security-role*, method-permission*, container-transaction*)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT method-permission (description?, role-name+, method+, pid?)>\n<!ELEMENT method (description?, ejb-name, method-intf?, method-name, method-params?)>\n<!ELEMENT method-intf (#PCDATA)>\n<!ELEMENT method-name (#PCDATA)>\n<!ELEMENT method-params (method-param*)>\n<!ELEMENT method-param (#PCDATA) >\n<!ELEMENT pid (#PCDATA)>\n<!ELEMENT bean-count (#PCDATA)>\n<!ELEMENT container-transaction (description?, method+, trans-attribute)>\n<!ELEMENT trans-attribute (#PCDATA)>\n]>";
        if (dt != null && (dtd = dt.getSystemId()) == null) {
            dtd = "<!DOCTYPE ejb-jar [\n<!ELEMENT ejb-jar (description?, display-name?, small-icon?, large-icon?, enterprise-beans, assembly-descriptor?)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT enterprise-beans (session|entity)+ > \n<!ELEMENT session (description?, display-name?, small-icon?, large-icon?, \n ejb-name, home, remote, ejb-class, session-type,session-timeout?, transaction-type, bean-count,\n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT entity (description?, display-name?, small-icon?, large-icon?,\n ejb-name, home, remote, ejb-class, persistence-type, prim-key-class, reentrant, bean-count, cmp-field*, primkey-field?, \n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT ejb-name (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-class (#PCDATA)>\n<!ELEMENT session-type (#PCDATA)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT transaction-type (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link, user-name, password)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT password (#PCDATA)>\n<!ELEMENT persistence-type (#PCDATA)>\n<!ELEMENT prim-key-class (#PCDATA)>\n<!ELEMENT reentrant (#PCDATA)>\n<!ELEMENT cmp-field (description?, field-name)>\n<!ELEMENT field-name (#PCDATA)>\n<!ELEMENT primkey-field (#PCDATA)>\n<!ELEMENT assembly-descriptor (security-role*, method-permission*, container-transaction*)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT method-permission (description?, role-name+, method+, pid?)>\n<!ELEMENT method (description?, ejb-name, method-intf?, method-name, method-params?)>\n<!ELEMENT method-intf (#PCDATA)>\n<!ELEMENT method-name (#PCDATA)>\n<!ELEMENT method-params (method-param*)>\n<!ELEMENT method-param (#PCDATA) >\n<!ELEMENT pid (#PCDATA)>\n<!ELEMENT bean-count (#PCDATA)>\n<!ELEMENT container-transaction (description?, method+, trans-attribute)>\n<!ELEMENT trans-attribute (#PCDATA)>\n]>";
        }
        if (dtd.equals("<!DOCTYPE ejb-jar [\n<!ELEMENT ejb-jar (description?, display-name?, small-icon?, large-icon?, enterprise-beans, assembly-descriptor?)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT enterprise-beans (session|entity)+ > \n<!ELEMENT session (description?, display-name?, small-icon?, large-icon?, \n ejb-name, home, remote, ejb-class, session-type,session-timeout?, transaction-type, bean-count,\n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT entity (description?, display-name?, small-icon?, large-icon?,\n ejb-name, home, remote, ejb-class, persistence-type, prim-key-class, reentrant, bean-count, cmp-field*, primkey-field?, \n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT ejb-name (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-class (#PCDATA)>\n<!ELEMENT session-type (#PCDATA)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT transaction-type (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link, user-name, password)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT password (#PCDATA)>\n<!ELEMENT persistence-type (#PCDATA)>\n<!ELEMENT prim-key-class (#PCDATA)>\n<!ELEMENT reentrant (#PCDATA)>\n<!ELEMENT cmp-field (description?, field-name)>\n<!ELEMENT field-name (#PCDATA)>\n<!ELEMENT primkey-field (#PCDATA)>\n<!ELEMENT assembly-descriptor (security-role*, method-permission*, container-transaction*)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT method-permission (description?, role-name+, method+, pid?)>\n<!ELEMENT method (description?, ejb-name, method-intf?, method-name, method-params?)>\n<!ELEMENT method-intf (#PCDATA)>\n<!ELEMENT method-name (#PCDATA)>\n<!ELEMENT method-params (method-param*)>\n<!ELEMENT method-param (#PCDATA) >\n<!ELEMENT pid (#PCDATA)>\n<!ELEMENT bean-count (#PCDATA)>\n<!ELEMENT container-transaction (description?, method+, trans-attribute)>\n<!ELEMENT trans-attribute (#PCDATA)>\n]>") || dtd.indexOf("http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd") > 0) {
            EJBConverter converter = new EJBConverter();
            converter.setLoader(loader);
            try {
                result = (EJBJarDescriptor)converter.parseDocument(document);
                converter.applyChanges(result);
            }
            catch (Exception e) {
                throw new Exception(ToolBundle.getResourceString("ear_gen_msg_0019", e.toString()));
            }
        }
        try {
            EJBJarParser parser = new EJBJarParser();
            parser.setCompliance(false);
            result = parser.parseXml(document, new Vector(), loader, "");
            RMappingTool rTool = new RMappingTool(result.getAbstractSchema());
            rTool.createSchemaMapping();
        }
        catch (Exception e) {
            throw new Exception(ToolBundle.getResourceString("ear_gen_msg_0019", e.toString()));
        }
        return result;
    }

    public WebDeploymentDescriptor getConvertedWebDescriptor(String xmlFileLocation) throws Exception {
        Document document = null;
        WebDeploymentDescriptor result = new WebDeploymentDescriptor();
        BufferedInputStream buffer = null;
        try {
            buffer = new BufferedInputStream(new FileInputStream(xmlFileLocation));
        }
        catch (IOException io) {
            throw new Exception(ToolBundle.getResourceString("ear_gen_msg_0020", io.toString()));
        }
        try {
            StandardDOMParser domParser = new StandardDOMParser();
            domParser.setSystemId(xmlFileLocation);
            document = domParser.parse((InputStream)buffer);
            buffer.close();
        }
        catch (IOException ioe) {
            throw new Exception(ToolBundle.getResourceString("ear_gen_msg_0020", ioe.toString()));
        }
        catch (Exception ex) {
            throw new Exception(ToolBundle.getResourceString("ear_gen_msg_0020", ex.toString()));
        }
        DocumentType dt = document.getDoctype();
        String dtd = "<!DOCTYPE web-app [\n<!ELEMENT web-app (icon?, display-name?, description?, distributable?,\n context-param*, filter*, filter-mapping*, listener*, servlet*, servlet-mapping*, session-config?,\n mime-mapping*, welcome-file-list?, error-page*, taglib*,\n resource-ref*, security-constraint*, login-config?,\n security-role*, env-entry*, ejb-ref*, response-status*)>\n<!ELEMENT icon (small-icon?, large-icon?)>\n <!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT distributable EMPTY>\n<!ELEMENT context-param (param-name, param-value, description?)>\n<!ELEMENT param-name (#PCDATA)>\n<!ELEMENT param-value (#PCDATA)>\n<!ELEMENT filter (icon?, filter-name, display-name?, description?, filter-class, init-param*)>\n<!ELEMENT filter-name (#PCDATA)>\n<!ELEMENT filter-class (#PCDATA)>\n<!ELEMENT filter-mapping (filter-name, (url-pattern | servlet-name))>\n<!ELEMENT listener (listener-class)>\n<!ELEMENT listener-class (#PCDATA)>\n<!ELEMENT servlet (icon?, servlet-name, display-name?, description?,\n(servlet-class|jsp-file), init-param*, load-on-startup?, security-role-ref*)>\n<!ELEMENT servlet-name (#PCDATA)>\n<!ELEMENT servlet-class (#PCDATA)>\n<!ELEMENT jsp-file (#PCDATA)>\n<!ELEMENT init-param (param-name, param-value, description?)>\n<!ELEMENT load-on-startup (#PCDATA)>\n<!ELEMENT servlet-mapping (servlet-name, url-pattern)>\n<!ELEMENT url-pattern (#PCDATA)>\n<!ELEMENT session-config (session-timeout?)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT mime-mapping (extension, mime-type)>\n<!ELEMENT extension (#PCDATA)>\n<!ELEMENT mime-type (#PCDATA)>\n<!ELEMENT welcome-file-list (welcome-file+)>\n<!ELEMENT welcome-file (#PCDATA)>\n<!ELEMENT taglib (taglib-uri, taglib-location)>\n<!ELEMENT taglib-uri (#PCDATA)>\n<!ELEMENT taglib-location (#PCDATA)>\n<!ELEMENT error-page ((error-code | exception-type), location)>\n<!ELEMENT error-code (#PCDATA)>\n<!ELEMENT exception-type (#PCDATA)>\n<!ELEMENT location (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT security-constraint (web-resource-collection+,\n auth-constraint?, user-data-constraint?)>\n<!ELEMENT web-resource-collection (web-resource-name, description?,\n url-pattern*, http-method*)>\n<!ELEMENT web-resource-name (#PCDATA)>\n<!ELEMENT http-method (#PCDATA)>\n<!ELEMENT user-data-constraint (description?, transport-guarantee)>\n<!ELEMENT transport-guarantee (#PCDATA)>\n<!ELEMENT auth-constraint (description?, role-name*)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT login-config (auth-method?, realm-name?, form-login-config?)>\n<!ELEMENT realm-name (#PCDATA)>\n<!ELEMENT form-login-config (form-login-page, form-error-page)>\n<!ELEMENT form-login-page (#PCDATA)>\n<!ELEMENT form-error-page (#PCDATA)>\n<!ELEMENT auth-method (#PCDATA)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-value?,\n env-entry-type)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home,\n   remote,ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n <!ELEMENT response-status (code, description)>\n <!ELEMENT code (#PCDATA)>\n]>";
        if (dt != null && (dtd = dt.getSystemId()) == null) {
            dtd = "<!DOCTYPE web-app [\n<!ELEMENT web-app (icon?, display-name?, description?, distributable?,\n context-param*, filter*, filter-mapping*, listener*, servlet*, servlet-mapping*, session-config?,\n mime-mapping*, welcome-file-list?, error-page*, taglib*,\n resource-ref*, security-constraint*, login-config?,\n security-role*, env-entry*, ejb-ref*, response-status*)>\n<!ELEMENT icon (small-icon?, large-icon?)>\n <!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT distributable EMPTY>\n<!ELEMENT context-param (param-name, param-value, description?)>\n<!ELEMENT param-name (#PCDATA)>\n<!ELEMENT param-value (#PCDATA)>\n<!ELEMENT filter (icon?, filter-name, display-name?, description?, filter-class, init-param*)>\n<!ELEMENT filter-name (#PCDATA)>\n<!ELEMENT filter-class (#PCDATA)>\n<!ELEMENT filter-mapping (filter-name, (url-pattern | servlet-name))>\n<!ELEMENT listener (listener-class)>\n<!ELEMENT listener-class (#PCDATA)>\n<!ELEMENT servlet (icon?, servlet-name, display-name?, description?,\n(servlet-class|jsp-file), init-param*, load-on-startup?, security-role-ref*)>\n<!ELEMENT servlet-name (#PCDATA)>\n<!ELEMENT servlet-class (#PCDATA)>\n<!ELEMENT jsp-file (#PCDATA)>\n<!ELEMENT init-param (param-name, param-value, description?)>\n<!ELEMENT load-on-startup (#PCDATA)>\n<!ELEMENT servlet-mapping (servlet-name, url-pattern)>\n<!ELEMENT url-pattern (#PCDATA)>\n<!ELEMENT session-config (session-timeout?)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT mime-mapping (extension, mime-type)>\n<!ELEMENT extension (#PCDATA)>\n<!ELEMENT mime-type (#PCDATA)>\n<!ELEMENT welcome-file-list (welcome-file+)>\n<!ELEMENT welcome-file (#PCDATA)>\n<!ELEMENT taglib (taglib-uri, taglib-location)>\n<!ELEMENT taglib-uri (#PCDATA)>\n<!ELEMENT taglib-location (#PCDATA)>\n<!ELEMENT error-page ((error-code | exception-type), location)>\n<!ELEMENT error-code (#PCDATA)>\n<!ELEMENT exception-type (#PCDATA)>\n<!ELEMENT location (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT security-constraint (web-resource-collection+,\n auth-constraint?, user-data-constraint?)>\n<!ELEMENT web-resource-collection (web-resource-name, description?,\n url-pattern*, http-method*)>\n<!ELEMENT web-resource-name (#PCDATA)>\n<!ELEMENT http-method (#PCDATA)>\n<!ELEMENT user-data-constraint (description?, transport-guarantee)>\n<!ELEMENT transport-guarantee (#PCDATA)>\n<!ELEMENT auth-constraint (description?, role-name*)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT login-config (auth-method?, realm-name?, form-login-config?)>\n<!ELEMENT realm-name (#PCDATA)>\n<!ELEMENT form-login-config (form-login-page, form-error-page)>\n<!ELEMENT form-login-page (#PCDATA)>\n<!ELEMENT form-error-page (#PCDATA)>\n<!ELEMENT auth-method (#PCDATA)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-value?,\n env-entry-type)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home,\n   remote,ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n <!ELEMENT response-status (code, description)>\n <!ELEMENT code (#PCDATA)>\n]>";
        }
        if (dtd.equals("<!DOCTYPE web-app [\n<!ELEMENT web-app (icon?, display-name?, description?, distributable?,\n context-param*, filter*, filter-mapping*, listener*, servlet*, servlet-mapping*, session-config?,\n mime-mapping*, welcome-file-list?, error-page*, taglib*,\n resource-ref*, security-constraint*, login-config?,\n security-role*, env-entry*, ejb-ref*, response-status*)>\n<!ELEMENT icon (small-icon?, large-icon?)>\n <!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT distributable EMPTY>\n<!ELEMENT context-param (param-name, param-value, description?)>\n<!ELEMENT param-name (#PCDATA)>\n<!ELEMENT param-value (#PCDATA)>\n<!ELEMENT filter (icon?, filter-name, display-name?, description?, filter-class, init-param*)>\n<!ELEMENT filter-name (#PCDATA)>\n<!ELEMENT filter-class (#PCDATA)>\n<!ELEMENT filter-mapping (filter-name, (url-pattern | servlet-name))>\n<!ELEMENT listener (listener-class)>\n<!ELEMENT listener-class (#PCDATA)>\n<!ELEMENT servlet (icon?, servlet-name, display-name?, description?,\n(servlet-class|jsp-file), init-param*, load-on-startup?, security-role-ref*)>\n<!ELEMENT servlet-name (#PCDATA)>\n<!ELEMENT servlet-class (#PCDATA)>\n<!ELEMENT jsp-file (#PCDATA)>\n<!ELEMENT init-param (param-name, param-value, description?)>\n<!ELEMENT load-on-startup (#PCDATA)>\n<!ELEMENT servlet-mapping (servlet-name, url-pattern)>\n<!ELEMENT url-pattern (#PCDATA)>\n<!ELEMENT session-config (session-timeout?)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT mime-mapping (extension, mime-type)>\n<!ELEMENT extension (#PCDATA)>\n<!ELEMENT mime-type (#PCDATA)>\n<!ELEMENT welcome-file-list (welcome-file+)>\n<!ELEMENT welcome-file (#PCDATA)>\n<!ELEMENT taglib (taglib-uri, taglib-location)>\n<!ELEMENT taglib-uri (#PCDATA)>\n<!ELEMENT taglib-location (#PCDATA)>\n<!ELEMENT error-page ((error-code | exception-type), location)>\n<!ELEMENT error-code (#PCDATA)>\n<!ELEMENT exception-type (#PCDATA)>\n<!ELEMENT location (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT security-constraint (web-resource-collection+,\n auth-constraint?, user-data-constraint?)>\n<!ELEMENT web-resource-collection (web-resource-name, description?,\n url-pattern*, http-method*)>\n<!ELEMENT web-resource-name (#PCDATA)>\n<!ELEMENT http-method (#PCDATA)>\n<!ELEMENT user-data-constraint (description?, transport-guarantee)>\n<!ELEMENT transport-guarantee (#PCDATA)>\n<!ELEMENT auth-constraint (description?, role-name*)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT login-config (auth-method?, realm-name?, form-login-config?)>\n<!ELEMENT realm-name (#PCDATA)>\n<!ELEMENT form-login-config (form-login-page, form-error-page)>\n<!ELEMENT form-login-page (#PCDATA)>\n<!ELEMENT form-error-page (#PCDATA)>\n<!ELEMENT auth-method (#PCDATA)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-value?,\n env-entry-type)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home,\n   remote,ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n <!ELEMENT response-status (code, description)>\n <!ELEMENT code (#PCDATA)>\n]>") || dtd.indexOf("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd") > 0) {
            WebConverter converter = new WebConverter();
            try {
                result = (WebDeploymentDescriptor)converter.readXML(xmlFileLocation);
                converter.applyChanges(result);
            }
            catch (Exception e) {
                throw new Exception(ToolBundle.getResourceString("ear_gen_msg_0020", e.toString()));
            }
        }
        try {
            result.loadFromDocument(document);
        }
        catch (Exception e) {
            throw new Exception(ToolBundle.getResourceString("ear_gen_msg_0020", e.toString()));
        }
        return result;
    }

    public ApplicationClientDescriptor getConvertedClientDescriptor(String xmlFileLocation) throws Exception {
        Document document = null;
        ApplicationClientDescriptor result = new ApplicationClientDescriptor();
        BufferedInputStream buffer = null;
        try {
            buffer = new BufferedInputStream(new FileInputStream(xmlFileLocation));
        }
        catch (IOException io) {
            throw new Exception(ToolBundle.getResourceString("ear_gen_msg_0021", io.toString()));
        }
        try {
            StandardDOMParser domParser = new StandardDOMParser();
            domParser.setSystemId(xmlFileLocation);
            document = domParser.parse((InputStream)buffer);
            buffer.close();
        }
        catch (IOException ioe) {
            throw new Exception(ToolBundle.getResourceString("ear_gen_msg_0021", ioe.toString()));
        }
        catch (Exception ex) {
            throw new Exception(ToolBundle.getResourceString("ear_gen_msg_0021", ex.toString()));
        }
        DocumentType dt = document.getDoctype();
        String dtd = null;
        if (dt != null) {
            dtd = dt.getSystemId();
        }
        if (dtd != null && !"<!DOCTYPE application-client [\n<!ELEMENT application-client (icon?, display-name, description?, env-entry*, ejb-ref*, resource-ref*, resource-env-ref*, callback-handler?)>\n<!ELEMENT icon (small-icon?, large-icon?)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-sharing-scope?)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-sharing-scope (#PCDATA)>\n<!ELEMENT resource-env-ref (description?, resource-env-ref-name, resource-env-ref-type)>\n<!ELEMENT resource-env-ref-name (#PCDATA)>\n<!ELEMENT resource-env-ref-type (#PCDATA)>\n<!ELEMENT callback-handler (#PCDATA)>\n<!ATTLIST application-client id ID #IMPLIED>\n<!ATTLIST callback-handler id ID #IMPLIED>\n<!ATTLIST description id ID #IMPLIED>\n<!ATTLIST display-name id ID #IMPLIED>\n<!ATTLIST ejb-link id ID #IMPLIED>\n<!ATTLIST ejb-ref id ID #IMPLIED>\n<!ATTLIST ejb-ref-name id ID #IMPLIED>\n<!ATTLIST ejb-ref-type id ID #IMPLIED>\n<!ATTLIST env-entry id ID #IMPLIED>\n<!ATTLIST env-entry-name id ID #IMPLIED>\n<!ATTLIST env-entry-type id ID #IMPLIED>\n<!ATTLIST env-entry-value id ID #IMPLIED>\n<!ATTLIST home id ID #IMPLIED>\n<!ATTLIST icon id ID #IMPLIED>\n<!ATTLIST large-icon id ID #IMPLIED>\n<!ATTLIST remote id ID #IMPLIED>\n<!ATTLIST res-auth id ID #IMPLIED>\n<!ATTLIST res-ref-name id ID #IMPLIED>\n<!ATTLIST res-sharing-scope id ID #IMPLIED>\n<!ATTLIST res-type id ID #IMPLIED>\n<!ATTLIST resource-env-ref id ID #IMPLIED>\n<!ATTLIST resource-env-ref-name id ID #IMPLIED>\n<!ATTLIST resource-env-ref-type id ID #IMPLIED>\n<!ATTLIST resource-ref id ID #IMPLIED>\n<!ATTLIST small-icon id ID #IMPLIED> \n]>".equals(dtd) && !"<!DOCTYPE application-client PUBLIC \"-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN\" \"http://java.sun.com/dtd/application-client_1_3.dtd\">".equals(dtd)) {
            ApplicationClientConverter converter = new ApplicationClientConverter();
            try {
                result = (ApplicationClientDescriptor)converter.readXML(xmlFileLocation);
                converter.applyChanges(result);
            }
            catch (Exception e) {
                throw new Exception(ToolBundle.getResourceString("ear_gen_msg_0021", e.toString()));
            }
        }
        try {
            result.loadFromDocument(document);
        }
        catch (Exception e) {
            throw new Exception(ToolBundle.getResourceString("ear_gen_msg_0021", e.toString()));
        }
        return result;
    }

    public void addClasspath(String classpath) {
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        String token = null;
        if (!this.classPath.endsWith(File.pathSeparator)) {
            this.classPath = this.classPath + File.pathSeparator;
        }
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (this.classPath.indexOf(token) != -1) continue;
            this.classPath = this.classPath + token + File.pathSeparator;
        }
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

