/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui.persistent;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.LocaleSettings;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.DataBaseProperties;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class PropertiesMappingPanel
extends BasicPanelView {
    private String[] vendors = new String[]{"", "DB2_UDB", "DB2_UDB_AS400", "DB2_UDB_OS390", "MS_SQL_SERVER", "ORACLE", "SAPDB"};
    private JLabel dataNameLabel = new JLabel();
    private JLabel databaseVendorLabel = new JLabel();
    private JComboBox vendorCombo = new JComboBox<String>(this.vendors);
    private JTextField dataSourceName = new JTextField();
    private GridBagLayout layout = new GridBagLayout();
    private ApplicationInformationProvider appProvider;
    private AbstractSchema schema = null;
    private Vector warnings = null;
    private Vector errors = null;

    public PropertiesMappingPanel(Frame frame) {
        this.setFrame(frame);
        try {
            this.init();
            this.vendorCombo.setSelectedItem("");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Visualization of panels cannot be initialized properly\nReason: " + e.toString() + "\nRestart of the tool is recommended.\n We are sorry for the inconvenience.", "Error in visualization", 0);
        }
    }

    private void init() throws Exception {
        this.setLayout(this.layout);
        this.databaseVendorLabel.setText(LocaleSettings.getInstance((String)"EJB").getResourceString("DatabaseVendor", "Database Vendor:"));
        this.dataNameLabel.setText(LocaleSettings.getInstance((String)"EJB").getResourceString("DataSourceName", "Data Source Name:"));
        this.add((Component)this.databaseVendorLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.vendorCombo, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.dataNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.dataSourceName, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void init(int madeFromConstant) {
    }

    public void clear() {
        this.dataSourceName.setText("");
        this.vendorCombo.setSelectedItem("ORACLE");
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        String vendor;
        if (this.schema.getDBProperties() == null) {
            this.schema.setDBProperties(new DataBaseProperties());
        }
        if (!this.dataSourceName.getText().equals(this.schema.getDBProperties().getDataSourceName())) {
            this.schema.getDBProperties().setDataSourceName(this.dataSourceName.getText());
        }
        if (!(vendor = this.vendors[this.vendorCombo.getSelectedIndex()]).equals(this.schema.getDBProperties().getDBVendorName())) {
            this.schema.getDBProperties().setDBVendorName(vendor);
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public void setAbstractSchema(AbstractSchema schema) {
        this.schema = schema;
        if (schema.getDBProperties() != null) {
            this.dataSourceName.setText(schema.getDBProperties().getDataSourceName());
            this.vendorCombo.setSelectedItem(schema.getDBProperties().getDBVendorName());
        }
    }

    public AbstractSchema getAbstractShema() {
        return this.schema;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }
}

