/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui.persistent;

import com.sap.engine.deploy.ejb.gui.persistent.DependentValueMappingsPanel;
import com.sap.engine.deploy.ejb.gui.persistent.FinderDescriptorPanel;
import com.sap.engine.deploy.ejb.gui.persistent.model.DependentValueCellEditor;
import com.sap.engine.deploy.ejb.gui.persistent.model.FieldMappingTableModel;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.LocaleSettings;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.gui.common.DescriptorPanel;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;

public class PersistentPanel
extends DescriptorPanel
implements ItemListener {
    private JLabel tableNameLabel = new JLabel();
    private JTextField tableNameTextField = new JTextField();
    private JLabel uPKIntevalLabel = new JLabel();
    private JTextField uPKIntervalTextField = new JTextField();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JCheckBox readOnlyCheckBox = new JCheckBox();
    private JCheckBox selectForUpdate = new JCheckBox();
    private JTabbedPane theTabbedPane = new JTabbedPane();
    private JPanel fieldMappingPanel = new JPanel();
    private JScrollPane tableScrollPane = new JScrollPane();
    private FinderDescriptorPanel finderDescriptorPanel;
    private FieldMappingTableModel model = new FieldMappingTableModel();
    private JTable fieldMapTable = new JTable(this.model);
    private CMPEntityDescriptor descriptor = null;
    private PersistentField[] fields = null;
    private int madeFrom;
    private ApplicationInformationProvider appProvider;
    static /* synthetic */ Class class$com$sap$engine$deploy$ejb$gui$persistent$DependentValueMappingsPanel;

    public PersistentPanel(Frame frame, int _madeFrom) {
        this.madeFrom = _madeFrom;
        this.finderDescriptorPanel = new FinderDescriptorPanel(this.mainFrame, this.madeFrom);
        this.setFrame(frame);
        try {
            this.init();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Visualization of panels cannot be initialized properly\nReason: " + ex.toString() + "\nRestart of the tool is recommended.\n We are sorry for the inconvenience.", "Error in visualization", 0);
        }
    }

    private void init() throws Exception {
        this.finderDescriptorPanel.init(this.madeFrom);
        this.initTexts();
        this.initTable();
        this.initTabbedPane();
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.tableNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.tableNameTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.readOnlyCheckBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.selectForUpdate, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.theTabbedPane, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.readOnlyCheckBox.addItemListener(this);
        this.selectForUpdate.addItemListener(this);
    }

    private void initTexts() throws Exception {
        this.tableNameLabel.setText(LocaleSettings.getInstance((String)"EJB").getResourceString("EJB_Table_Name", "Table Name:"));
        this.uPKIntevalLabel.setText(LocaleSettings.getInstance((String)"EJB").getResourceString("UNPK_Interval", "Unknown PK Interval:"));
        this.readOnlyCheckBox.setText(LocaleSettings.getInstance((String)"EJB").getResourceString("Reed_Only_Bean", "Read Only"));
        this.selectForUpdate.setText(LocaleSettings.getInstance((String)"EJB").getResourceString("Select_for_update", "Select For Update"));
    }

    private void initTabbedPane() throws Exception {
        this.tableScrollPane.getViewport().add(this.fieldMapTable);
        this.fieldMappingPanel.add(this.tableScrollPane);
        this.theTabbedPane.add((Component)this.tableScrollPane, LocaleSettings.getInstance((String)"EJB").getResourceString("Field_Mapping", "Field Mapping"));
        this.theTabbedPane.add((Component)this.finderDescriptorPanel, LocaleSettings.getInstance((String)"EJB").getResourceString("Finder_Descriptors", "Finder Descriptors"));
    }

    private void initTable() throws Exception {
        DependentValueMappingsPanel panel = new DependentValueMappingsPanel(this.mainFrame);
        this.model.setButtonPanel(panel);
        DependentValueCellEditor editor = new DependentValueCellEditor(this.mainFrame);
        editor.setEditorComponent(panel);
        this.fieldMapTable.setDefaultEditor(class$com$sap$engine$deploy$ejb$gui$persistent$DependentValueMappingsPanel == null ? (class$com$sap$engine$deploy$ejb$gui$persistent$DependentValueMappingsPanel = PersistentPanel.class$("com.sap.engine.deploy.ejb.gui.persistent.DependentValueMappingsPanel")) : class$com$sap$engine$deploy$ejb$gui$persistent$DependentValueMappingsPanel, editor);
    }

    private void initUnknownPKFields() {
        this.remove(this.uPKIntevalLabel);
        this.remove(this.uPKIntervalTextField);
        if (this.descriptor.isUnknownPK()) {
            this.add((Component)this.uPKIntevalLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.uPKIntervalTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.repaint();
        this.validate();
    }

    public void setDescriptor(Descriptor descr) {
        this.clear();
        this.finderDescriptorPanel.setFinderDescriptors(((CMPEntityDescriptor)descr).getFinderDescriptors());
        this.descriptor = (CMPEntityDescriptor)descr;
        this.fields = this.descriptor.getCmpFields();
        PersistentField[] temp = this.descriptor.getPKCmpFields();
        if (this.fields == null && temp != null) {
            this.fields = temp;
        } else if (this.fields != null && temp != null) {
            PersistentField[] temp2 = new PersistentField[this.fields.length + temp.length];
            System.arraycopy(temp, 0, temp2, 0, temp.length);
            System.arraycopy(this.fields, 0, temp2, temp.length, this.fields.length);
            this.fields = temp2;
        }
        this.tableNameTextField.setText(this.descriptor.getTableName());
        if (this.descriptor.isReadOnly()) {
            this.readOnlyCheckBox.setSelected(this.descriptor.isReadOnly());
        } else {
            this.selectForUpdate.setSelected(this.descriptor.useSelectForUpdate());
        }
        this.model.setFields(this.fields);
        this.initUnknownPKFields();
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void init(int madeFromConstant) {
    }

    public void clear() {
        this.fields = new PersistentField[0];
        this.readOnlyCheckBox.setSelected(false);
        this.selectForUpdate.setSelected(false);
        this.tableNameTextField.setText("");
        if (this.descriptor != null && this.descriptor.isUnknownPK()) {
            this.uPKIntervalTextField.setText("");
        }
        this.finderDescriptorPanel.clear();
    }

    public int isCorrect() {
        int isOK = 0;
        int temp = this.finderDescriptorPanel.isCorrect();
        if (temp > isOK) {
            isOK = temp;
        }
        return isOK;
    }

    public void commitChange() {
        if (this.fieldMapTable.getCellEditor() != null) {
            this.fieldMapTable.getCellEditor().stopCellEditing();
            this.fieldMapTable.editingStopped(new ChangeEvent(this.fieldMapTable));
        }
        if (this.descriptor != null) {
            this.descriptor.setTableName(this.tableNameTextField.getText());
            this.descriptor.setReadOnly(this.readOnlyCheckBox.isSelected());
            this.descriptor.setSelectForUpdate(this.selectForUpdate.isSelected());
            this.fields = this.model.applayChanges();
            if (this.descriptor.isUnknownPK()) {
                int value = 100;
                try {
                    value = Integer.parseInt(this.uPKIntervalTextField.getText());
                }
                catch (NumberFormatException nfe) {
                    value = 100;
                }
                this.descriptor.setUnknownPKInterval(value);
            }
        }
        this.finderDescriptorPanel.commitChange();
        this.descriptor.setFinderDescriptors(this.finderDescriptorPanel.getFinders());
    }

    public void setLoader(ClassLoader classLoader) {
        this.finderDescriptorPanel.setLoader(classLoader);
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
        this.finderDescriptorPanel.setApplicationInformationProvider(appProvider);
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src == this.readOnlyCheckBox && this.readOnlyCheckBox.isSelected()) {
            this.selectForUpdate.setSelected(false);
        } else if (src == this.selectForUpdate && this.selectForUpdate.isSelected()) {
            this.readOnlyCheckBox.setSelected(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

