/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui.persistent;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.DescriptionPanel;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.GuiSettings;
import com.sap.engine.services.deploy.gui.common.additional.ListRenderer;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FinderDescriptorPanel
extends BasicPanelView
implements ListSelectionListener {
    private JScrollPane jScrollPane11 = new JScrollPane();
    private JTextArea ejbQL_TextArea = new JTextArea();
    private BorderLayout borderLayout1 = new BorderLayout();
    private BorderLayout borderLayout2 = new BorderLayout();
    private BorderLayout borderLayout3 = new BorderLayout();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JSplitPane mainSplitPane = new JSplitPane();
    private JPanel listPanel = new JPanel();
    private JPanel valuesPanel = new JPanel();
    private DescriptionPanel descrPanel = new DescriptionPanel();
    private JPanel ejbQueryPanel = new JPanel();
    private JScrollPane listScrollPane = new JScrollPane();
    private JList findMethodsList = new JList(new DefaultListModel());
    private JCheckBox storingModeCheckBox = new JCheckBox("Switch Off Storing", false);
    private JLabel loadLabel = new JLabel("Load Selected Objects:");
    private JComboBox loadSelectedCombo = new JComboBox();
    private String[] lockModes = new String[]{"Disabled", "No Lock Attribute", "Read Lock Attribute", "Write Lock Attribute"};
    private JCheckBox qlCheckBox = new JCheckBox("QL 2.1 Compatible", false);
    private Border eatchedBorder = BorderFactory.createEtchedBorder();
    private TitledBorder titledBorder1 = BorderFactory.createTitledBorder(this.eatchedBorder, GuiSettings.getResourceString("FindMethods_border", "Find Methods"));
    private TitledBorder titledBorder2 = BorderFactory.createTitledBorder(this.eatchedBorder, GuiSettings.getResourceString("Query", "EJB QL Query"));
    private JPanel comboPanel = new JPanel();
    private GridBagLayout gridBag = new GridBagLayout();
    private int madeFrom;
    private Frame mainFrame;
    private FinderDescriptor lastSelected;
    private ApplicationInformationProvider appProvider;

    public FinderDescriptorPanel() {
        try {
            this.visualInit();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Visualization of panels cannot be initialized properly\nReason: " + e.toString() + "\nRestart of the tool is recommended.\n We are sorry for the inconvenience.", "Error in visualization", 0);
        }
    }

    public FinderDescriptorPanel(Frame frame, int made) {
        this.madeFrom = made;
        this.mainFrame = frame;
        this.init(this.madeFrom);
        try {
            this.visualInit();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Visualization of panels cannot be initialized properly\nReason: " + e.toString() + "\nRestart of the tool is recommended.\n We are sorry for the inconvenience.", "Error in visualization", 0);
        }
    }

    private void visualInit() {
        this.setLayout(this.borderLayout1);
        this.valuesPanel.setLayout(this.gridBagLayout1);
        this.listPanel.setLayout(this.borderLayout2);
        this.listPanel.setBorder(this.titledBorder1);
        this.ejbQueryPanel.setLayout(this.borderLayout3);
        this.ejbQueryPanel.setBorder(this.titledBorder2);
        this.ejbQueryPanel.add((Component)this.jScrollPane11, "Center");
        this.ejbQL_TextArea.setCaretPosition(0);
        this.jScrollPane11.getViewport().add((Component)this.ejbQL_TextArea, null);
        this.add((Component)this.mainSplitPane, "Center");
        this.mainSplitPane.add((Component)this.listPanel, "left");
        this.listPanel.add((Component)this.listScrollPane, "Center");
        this.listScrollPane.getViewport().add((Component)this.findMethodsList, null);
        this.mainSplitPane.add((Component)this.valuesPanel, "right");
        if (this.madeFrom == 3 || this.madeFrom == 4 || this.madeFrom == 0) {
            this.valuesPanel.add((Component)this.ejbQueryPanel, new GridBagConstraints(0, 1, 4, 1, 0.1, 0.4, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.valuesPanel.add((Component)this.storingModeCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.initCombo();
            this.valuesPanel.add((Component)this.comboPanel, new GridBagConstraints(1, 3, 1, 2, 0.1, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.valuesPanel.add((Component)this.qlCheckBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.valuesPanel.add((Component)this.descrPanel, new GridBagConstraints(0, 5, 4, 1, 0.1, 0.2, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        } else {
            this.valuesPanel.add((Component)this.ejbQueryPanel, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.7, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.valuesPanel.add((Component)this.descrPanel, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.3, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.findMethodsList.setSelectionMode(0);
        this.findMethodsList.addListSelectionListener(this);
        this.findMethodsList.setCellRenderer(new ListRenderer());
        this.mainSplitPane.setDividerLocation(200);
        this.ejbQL_TextArea.setEnabled(false);
        this.descrPanel.setEnabled(false);
    }

    public void setFinderDescriptors(FinderDescriptor[] finders) {
        this.lastSelected = null;
        Vector<ListValues> listValues = new Vector<ListValues>();
        if (finders != null) {
            int i = 0;
            while (i < finders.length) {
                if (finders[i].isLocal()) {
                    listValues.addElement(new ListValues(finders[i], 23));
                } else {
                    listValues.addElement(new ListValues(finders[i], 24));
                }
                ++i;
            }
        }
        this.findMethodsList.setListData(listValues);
    }

    public void init(int madeFrom) {
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.findMethodsList.isSelectionEmpty()) {
            this.storingModeCheckBox.setEnabled(true);
            if (this.madeFrom == 3 || this.madeFrom == 4 || this.madeFrom == 0) {
                this.loadSelectedCombo.setEnabled(true);
            }
            this.qlCheckBox.setEnabled(true);
            FinderDescriptor selectedNode = ((ListValues)this.findMethodsList.getSelectedValue()).getFinderDescriptor();
            this.checkPanel();
            this.ejbQL_TextArea.setText(selectedNode.getQuery() != null ? selectedNode.getQuery() : "");
            this.ejbQL_TextArea.setCaretPosition(0);
            this.descrPanel.setText(selectedNode.getDescription() != null ? selectedNode.getDescription() : "");
            this.ejbQL_TextArea.setEnabled(true);
            this.storingModeCheckBox.setSelected(!selectedNode.getStoringMode());
            if (this.madeFrom == 3 || this.madeFrom == 4 || this.madeFrom == 0) {
                if (selectedNode.toLoadSelectedObjects()) {
                    String lockMode = selectedNode.getLockMode();
                    if (lockMode == null) {
                        this.loadSelectedCombo.setSelectedIndex(1);
                    } else if (lockMode.equalsIgnoreCase("read")) {
                        this.loadSelectedCombo.setSelectedIndex(2);
                    } else if (lockMode.equalsIgnoreCase("write")) {
                        this.loadSelectedCombo.setSelectedIndex(3);
                    }
                } else {
                    this.loadSelectedCombo.setSelectedIndex(0);
                }
            }
            this.qlCheckBox.setSelected(selectedNode.isQLVersion2_1());
            this.descrPanel.setEnabled(true);
            this.lastSelected = selectedNode;
        } else if (this.lastSelected != null) {
            this.checkPanel();
            this.lastSelected = null;
            this.clear();
        } else {
            this.clear();
        }
    }

    private void checkPanel() {
        if (this.lastSelected != null) {
            if (this.lastSelected.getQuery() != null && !this.lastSelected.getQuery().equals(this.ejbQL_TextArea.getText())) {
                this.lastSelected.setQuery(this.ejbQL_TextArea.getText());
            } else if (this.lastSelected.getQuery() == null && !this.ejbQL_TextArea.getText().equals("")) {
                this.lastSelected.setQuery(this.ejbQL_TextArea.getText());
            }
            if (this.lastSelected.getDescription() != null && !this.lastSelected.getDescription().equals(this.descrPanel.getText())) {
                this.lastSelected.setDescription(this.descrPanel.getText());
            }
            if (this.lastSelected.getStoringMode() != !this.storingModeCheckBox.isSelected()) {
                this.lastSelected.setStoringMode(!this.storingModeCheckBox.isSelected());
            }
            if (this.madeFrom == 3 || this.madeFrom == 4 || this.madeFrom == 0) {
                int index = this.loadSelectedCombo.getSelectedIndex();
                if (index == 0) {
                    this.lastSelected.setToLoadSelectedObjects(false);
                    this.lastSelected.setLockMode(null);
                } else if (index == 1) {
                    this.lastSelected.setToLoadSelectedObjects(true);
                    this.lastSelected.setLockMode(null);
                } else if (index == 2) {
                    this.lastSelected.setToLoadSelectedObjects(true);
                    this.lastSelected.setLockMode("read");
                } else if (index == 3) {
                    this.lastSelected.setToLoadSelectedObjects(true);
                    this.lastSelected.setLockMode("write");
                }
            }
            if (this.lastSelected.isQLVersion2_1() != this.qlCheckBox.isSelected()) {
                this.lastSelected.setQLVersionTo2_1(this.qlCheckBox.isSelected());
            }
        }
    }

    public void clear() {
        this.findMethodsList.clearSelection();
        this.ejbQL_TextArea.setText("");
        this.storingModeCheckBox.setSelected(false);
        this.storingModeCheckBox.setEnabled(false);
        if (this.madeFrom == 3 || this.madeFrom == 4 || this.madeFrom == 0) {
            this.loadSelectedCombo.setSelectedIndex(0);
            this.loadSelectedCombo.setEnabled(false);
        }
        this.qlCheckBox.setSelected(false);
        this.qlCheckBox.setEnabled(false);
        this.descrPanel.setText("");
        this.ejbQL_TextArea.setEnabled(false);
        this.descrPanel.setEnabled(false);
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        this.checkPanel();
    }

    public void setFrame(Frame frame) {
        this.mainFrame = frame;
    }

    public void setLoader(ClassLoader loader_) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public FinderDescriptor[] getFinders() {
        ListModel model = this.findMethodsList.getModel();
        int size = model.getSize();
        FinderDescriptor[] finders = new FinderDescriptor[size];
        int i = 0;
        while (i < size) {
            finders[i] = ((ListValues)model.getElementAt(i)).getFinderDescriptor();
            ++i;
        }
        return finders;
    }

    private void initCombo() {
        this.loadSelectedCombo.removeAllItems();
        int i = 0;
        while (i < this.lockModes.length) {
            this.loadSelectedCombo.addItem(this.lockModes[i]);
            ++i;
        }
        this.loadSelectedCombo.setEditable(false);
        this.comboPanel.setLayout(this.gridBag);
        this.comboPanel.add((Component)this.loadLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.comboPanel.add((Component)this.loadSelectedCombo, new GridBagConstraints(2, 3, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
    }
}

