/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui.persistent;

import com.sap.engine.deploy.ejb.gui.persistent.model.ContainerManageFieldTableModel;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ContainerManageFieldPanel
extends BasicPanelView {
    private CMPEntityDescriptor dd = null;
    private ClassLoader loader;
    private String[] ejbFields = null;
    private Hashtable fieldTypes = new Hashtable();
    private int lastSelectedIndex = -1;
    protected BorderLayout layout = new BorderLayout();
    protected JTable ejbTable = new JTable();
    protected JScrollPane tableScrollPane = new JScrollPane();
    protected ContainerManageFieldTableModel tableModel = new ContainerManageFieldTableModel();
    private ApplicationInformationProvider appProvider;
    public Frame mainFrame;

    public ContainerManageFieldPanel(ClassLoader loader) {
        this.loader = loader;
        this.init();
        this.ejbTable.setModel(this.tableModel);
        this.tableModel.setTable(this.ejbTable);
    }

    private void init() {
        this.setLayout(this.layout);
        this.add((Component)this.tableScrollPane, "Center");
        this.tableScrollPane.getViewport().add((Component)this.ejbTable, null);
        this.ejbTable.getSelectionModel().setSelectionMode(0);
        this.tableModel.getDescrPanel().setMinimumSize(new Dimension(250, 150));
        this.tableModel.getDescrPanel().setPreferredSize(new Dimension(250, 150));
        this.tableModel.getDescrPanel().setText("");
        this.add((Component)this.tableModel.getDescrPanel(), "South");
    }

    private String[] getFields(Hashtable fields) {
        if (fields == null) {
            return null;
        }
        Enumeration enumeration = fields.keys();
        String[] result = new String[fields.size()];
        int i = 0;
        while (enumeration.hasMoreElements()) {
            result[i++] = (String)enumeration.nextElement();
        }
        return result;
    }

    public void setDescriptor(CMPEntityDescriptor newDD) {
        this.dd = newDD == null ? new CMPEntityDescriptor() : newDD;
        if (this.appProvider != null) {
            this.ejbFields = newDD.getCmpVersion() == 1 ? this.getFields(this.appProvider.getCMP1_1Fields(this.loader, this.dd.getClassName(), this.dd.getAbstractSchemaName())) : this.getFields(this.appProvider.getAllCMP2_0Fields(this.loader, this.dd.getClassName(), this.dd.getAbstractSchemaName()));
        }
        if (this.dd != null && this.ejbFields != null) {
            PersistentField[] cmp = this.dd.getCmpFields();
            this.tableModel.initModel(this.ejbFields, this.dd.getCmpFields(), this.dd.getPKCmpFields());
        }
        this.tableModel.fireTableDataChanged();
        this.repaint();
        this.validate();
    }

    public void commitChange() {
        String descr;
        PersistentField fld = null;
        Vector<PersistentField> temp = new Vector<PersistentField>();
        int selRow = this.ejbTable.getSelectedRow();
        if (selRow > -1 && (descr = this.tableModel.getDescrPanel().getText()) != null) {
            this.tableModel.setDescriptionAt(this.tableModel.getDescrPanel().getText(), selRow);
        }
        int index = this.tableModel.getRowCount();
        int i = 0;
        while (i < index) {
            if (((Boolean)this.ejbTable.getValueAt(i, 1)).booleanValue()) {
                fld = new PersistentField();
                fld.setFieldName((String)this.tableModel.getValueAt(i, 0));
                fld.setDescription(this.tableModel.getDescriptionAt(i));
                temp.add(fld);
            }
            ++i;
        }
        Object[] arrayPersistent = new PersistentField[temp.size()];
        temp.copyInto(arrayPersistent);
        this.dd.setCmpFields((PersistentField[])arrayPersistent);
        this.ejbTable.getSelectionModel().clearSelection();
    }

    public int isCorrect() {
        return 0;
    }

    public void setLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public void init(int madeFromConstant) {
    }

    public void clear() {
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }
}

