/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.gui.logic;

import com.sap.engine.deploy.ejb.gui.additional.ImageHolder;
import com.sap.engine.deploy.ejb.gui.visual.TransactionPanel;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.TreeUtils;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.deploy.gui.common.ErrorObject;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.SecurityTreeNode;
import com.sap.engine.services.deploy.gui.common.additional.SecurityTreeRenderer;
import com.sap.engine.services.deploy.gui.common.additional.SecurityUserObject;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.ControlDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TransactionPanelLogical
extends TransactionPanel {
    private SecurityTreeNode root = null;
    private SecurityTreeNode bean = null;
    private SecurityTreeNode globalNode = null;
    protected int isoLevel = 0;
    protected int transAttribute = -1;
    protected Hashtable controls = new Hashtable();
    private EJBJarDescriptor jarDescriptor = null;
    private ClassLoader loader = null;
    public int madeFrom = 0;
    private ApplicationInformationProvider appProvider;
    private boolean setValues = false;
    private boolean isComboBoxAdded = true;
    private ErrorReportObject error;
    private int isCorrectIndex;
    static /* synthetic */ Class class$javax$ejb$EJBLocalObject;
    static /* synthetic */ Class class$javax$ejb$EJBObject;

    public TransactionPanelLogical(ClassLoader loader, Frame frame, int made) {
        this.loader = loader;
        this.mainFrame = frame;
        this.madeFrom = made;
        this.methodsTree.setCellRenderer(new SecurityTreeRenderer(ImageHolder.aJarSmallIcon));
    }

    public void setDescriptor(EJBJarDescriptor descr) {
        this.isCorrectIndex = 0;
        this.error = null;
        this.jarDescriptor = descr;
        this.root = new SecurityTreeNode(this.jarDescriptor.getJarName() == null ? "Entire Component" : this.jarDescriptor.getJarName(), 0);
        ((DefaultTreeModel)this.methodsTree.getModel()).setRoot(this.root);
        this.root.removeAllChildren();
        DeploymentDescriptor[] descriptors = descr.getDDescriptors();
        this.controls = new Hashtable();
        if (descriptors != null) {
            String name = null;
            MethodEntry methodEntry = null;
            ControlDescriptor[] trans = null;
            String mainMessage = "These classes can't be loaded. Please set correct class path.\n";
            String loadingMessages = "";
            int i = 0;
            while (i < descriptors.length) {
                loadingMessages = "";
                if (!(descriptors[i] instanceof SessionDescriptor && ((SessionDescriptor)descriptors[i]).getTransactionType() == 0 || descriptors[i] instanceof MessageDrivenDescriptor && ((MessageDrivenDescriptor)descriptors[i]).getTransactionType() == 0)) {
                    name = descriptors[i].getEjbName();
                    trans = descriptors[i].getTransactionDescriptors();
                    if (trans == null) {
                        trans = new ControlDescriptor[]{};
                    }
                    if (name != null && trans != null) {
                        ControlDescriptor[] arr = (ControlDescriptor[])this.controls.get(name);
                        this.controls.put(name, trans);
                        methodEntry = new MethodEntry(name);
                        methodEntry.setEjbName(name);
                        this.bean = new SecurityTreeNode(methodEntry, 12);
                        this.root.add(this.bean);
                    }
                    if (descriptors[i] instanceof CMPEntityDescriptor) {
                        this.bean.setCmpBean();
                    }
                    if (descriptors[i] instanceof MessageDrivenDescriptor) {
                        this.bean.setMDBean();
                    }
                    if (descriptors[i] instanceof SessionDescriptor) {
                        this.bean.setSessBean();
                    }
                    loadingMessages = loadingMessages + this.initAttributes(descriptors[i]);
                    if (!(loadingMessages = loadingMessages + this.initTree(descriptors[i])).trim().equals("")) {
                        loadingMessages = "  The bean " + descriptors[i].getDisplayName() + " needs this classes :\n" + loadingMessages;
                        JOptionPane.showMessageDialog(this.mainFrame, mainMessage + loadingMessages, "WARNING", 2);
                    }
                }
                ++i;
            }
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (!this.setValues) {
            this.treeValueChanged();
        }
    }

    public void treeWillCollapse(TreeExpansionEvent e) {
        this.treeValueChanged();
    }

    public void treeWillExpand(TreeExpansionEvent e) {
    }

    private void treeValueChanged() {
        SecurityTreeNode lastNode = (SecurityTreeNode)this.methodsTree.getLastSelectedPathComponent();
        if (this.methodsTree.isSelectionEmpty()) {
            this.methodDescrPanel.setEnabled(false);
            this.transactionDescrPanel.setEnabled(false);
            this.transactionComboBox.setEnabled(false);
            this.isolationComboBox.setEnabled(false);
        } else {
            this.methodDescrPanel.setEnabled(true);
            this.transactionDescrPanel.setEnabled(true);
            this.transactionComboBox.setEnabled(true);
            this.isolationComboBox.setEnabled(true);
        }
        if (this.globalNode == null) {
            this.initValues(lastNode);
            this.globalNode = lastNode;
        } else {
            this.setValues(this.globalNode);
            this.clearAll();
            this.globalNode = lastNode;
            this.initValues(lastNode);
        }
    }

    private String initAttributes(DeploymentDescriptor dd) {
        Class<?> beanClass = null;
        String message = "";
        if (this.madeFrom == 1 || this.madeFrom == 2) {
            this.transactionPanel.remove(this.isolationComboBox);
            this.transactionPanel.remove(this.isolationLabel);
        }
        if (this.methodsTree.isSelectionEmpty()) {
            this.methodDescrPanel.setEnabled(false);
            this.transactionDescrPanel.setEnabled(false);
            this.transactionComboBox.setEnabled(false);
            this.isolationComboBox.setEnabled(false);
        }
        if (dd != null && dd.getClassName() != null) {
            if (this.loader != null) {
                try {
                    beanClass = this.loader.loadClass(dd.getClassName());
                }
                catch (ClassNotFoundException cnfe) {
                    message = message + "     " + cnfe.getMessage() + "\n";
                }
                catch (NoClassDefFoundError err) {
                    message = message + "     " + err.getMessage() + "\n";
                }
            } else {
                try {
                    beanClass = Class.forName(dd.getClassName());
                }
                catch (ClassNotFoundException cnfe) {
                    message = message + "     " + cnfe.getMessage() + "\n";
                }
                catch (NoClassDefFoundError err) {
                    message = message + "     " + err.getMessage() + "\n";
                }
            }
        }
        return message;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        SecurityTreeNode lastNode = (SecurityTreeNode)this.methodsTree.getLastSelectedPathComponent();
        if (cmd.equals("TRANSACTION_CMD")) {
            this.transactionComboBox_actionPerformed(e);
            if (this.transactionComboBox.getSelectedIndex() == 0 && lastNode != null && lastNode.equals(this.globalNode)) {
                TreePath path = new TreePath(lastNode.getPath());
                this.methodsTree.clearSelection();
                this.methodsTree.setSelectionPath(path);
            }
        } else {
            this.isolationComboBox_actionPerformed(e);
        }
    }

    public void transactionComboBox_actionPerformed(ActionEvent e) {
        if (this.transactionComboBox.getSelectedIndex() > 0) {
            this.transactionDescrPanel.setEnabled(true);
            this.transactionDescrPanel.setText(this.chooseTransactionDescr(this.getAttributes((String)this.transactionComboBox.getSelectedItem())));
        } else {
            this.transactionDescrPanel.setEnabled(false);
        }
    }

    public void isolationComboBox_actionPerformed(ActionEvent e) {
    }

    private String initTree(DeploymentDescriptor dd) {
        Method[] methods = null;
        Class<?> localHomeClass = null;
        Class<?> localClass = null;
        Class<?> remoteHomeClass = null;
        Class<?> remoteClass = null;
        String localHomeClassName = "";
        String localClassName = "";
        String remoteHomeClassName = "";
        String remoteClassName = "";
        String message = "";
        if (dd != null) {
            if (dd instanceof MessageDrivenDescriptor) {
                Class<?> beanClass = null;
                if (this.loader != null) {
                    if (dd.getClassName() != null) {
                        try {
                            beanClass = this.loader.loadClass(dd.getClassName());
                        }
                        catch (NoClassDefFoundError err) {
                            message = message + "     " + err.getMessage() + "\n";
                        }
                        catch (ClassNotFoundException exc) {
                            message = message + "     " + exc.getMessage() + "\n";
                        }
                    }
                } else if (dd.getClassName() != null) {
                    try {
                        beanClass = Class.forName(dd.getClassName());
                    }
                    catch (NoClassDefFoundError err) {
                        message = message + "     " + err.getMessage() + "\n";
                    }
                    catch (ClassNotFoundException exc) {
                        message = message + "     " + exc.getMessage() + "\n";
                    }
                }
                if (beanClass == null) {
                    System.out.println("Class " + dd.getClassName() + " not found. Can not load methods in Transaction Panel.");
                    return message;
                }
                try {
                    methods = beanClass.getMethods();
                }
                catch (NoClassDefFoundError err) {
                    this.isCorrectIndex = 1;
                    this.error = new ErrorReportObject();
                    ErrorObject[] errorObj = new ErrorObject[]{new ErrorObject("TransactionPanelLogical", "T001", 0, "Couldn't load class " + dd.getClassName() + "class path is incomplete", "Couldn't find class " + err.getMessage(), err)};
                    this.error.setErrors(errorObj);
                    this.error.setPanel("TransactionPanelLogical");
                    return message;
                }
                int i = 0;
                while (i < methods.length) {
                    if (methods[i].getName().startsWith("onMessage")) {
                        MethodEntry entry = new MethodEntry(dd.getEjbName(), null, methods[i], null);
                        SecurityTreeNode node = null;
                        node = new SecurityTreeNode(entry, 16);
                        node.setMDBean();
                        this.bean.add(node);
                        TreeUtils.expandTree((JTree)this.methodsTree, (int)2);
                    }
                    ++i;
                }
                return message;
            }
            localHomeClassName = dd.getLocalHomeInterface();
            localClassName = dd.getLocalInterface();
            remoteHomeClassName = dd.getRemoteHomeInterface();
            remoteClassName = dd.getRemoteInterface();
            SecurityTreeNode localHomeParent = null;
            SecurityTreeNode localParent = null;
            SecurityTreeNode remoteHomeParent = null;
            SecurityTreeNode remoteParent = null;
            SecurityTreeNode tempMethodNode = null;
            if (localHomeClassName != null) {
                localHomeParent = new SecurityTreeNode(new MethodEntry(localHomeClassName), 3);
                localHomeParent.getMethodEntry().setEjbName(dd.getEjbName());
                localHomeParent.getMethodEntry().setMethodInterface("LocalHome");
                this.bean.add(localHomeParent);
            }
            if (localClassName != null) {
                localParent = new SecurityTreeNode(new MethodEntry(localClassName), 4);
                localParent.getMethodEntry().setEjbName(dd.getEjbName());
                localParent.getMethodEntry().setMethodInterface("Local");
                this.bean.add(localParent);
            }
            if (remoteHomeClassName != null) {
                remoteHomeParent = new SecurityTreeNode(new MethodEntry(remoteHomeClassName), 3);
                remoteHomeParent.getMethodEntry().setEjbName(dd.getEjbName());
                remoteHomeParent.getMethodEntry().setMethodInterface("Home");
                this.bean.add(remoteHomeParent);
            }
            if (remoteClassName != null) {
                remoteParent = new SecurityTreeNode(new MethodEntry(remoteClassName), 4);
                remoteParent.getMethodEntry().setEjbName(dd.getEjbName());
                remoteParent.getMethodEntry().setMethodInterface("Remote");
                this.bean.add(remoteParent);
            }
            if (this.loader != null) {
                try {
                    if (localHomeClassName != null) {
                        localHomeClass = this.loader.loadClass(localHomeClassName);
                    }
                }
                catch (NoClassDefFoundError err) {
                    message = message + "     " + err.getMessage() + "\n";
                }
                catch (ClassNotFoundException exc) {
                    message = message + "     " + exc.getMessage() + "\n";
                }
                try {
                    if (localClassName != null) {
                        localClass = this.loader.loadClass(localClassName);
                    }
                }
                catch (NoClassDefFoundError err) {
                    message = message + "     " + err.getMessage() + "\n";
                }
                catch (ClassNotFoundException exc) {
                    message = message + "     " + exc.getMessage() + "\n";
                }
                try {
                    if (remoteHomeClassName != null) {
                        remoteHomeClass = this.loader.loadClass(remoteHomeClassName);
                    }
                }
                catch (NoClassDefFoundError err) {
                    message = message + "     " + err.getMessage() + "\n";
                }
                catch (ClassNotFoundException exc) {
                    message = message + "     " + exc.getMessage() + "\n";
                }
                try {
                    if (remoteClassName != null) {
                        remoteClass = this.loader.loadClass(remoteClassName);
                    }
                }
                catch (NoClassDefFoundError err) {
                    message = message + "     " + err.getMessage() + "\n";
                }
                catch (ClassNotFoundException exc) {
                    message = message + "     " + exc.getMessage() + "\n";
                }
            } else {
                try {
                    if (localHomeClassName != null) {
                        localHomeClass = Class.forName(localHomeClassName);
                    }
                    if (localClassName != null) {
                        localClass = Class.forName(localClassName);
                    }
                    if (remoteHomeClassName != null) {
                        remoteHomeClass = Class.forName(remoteHomeClassName);
                    }
                    if (remoteClassName != null) {
                        remoteClass = Class.forName(remoteClassName);
                    }
                }
                catch (NoClassDefFoundError err) {
                    message = message + "     " + err.getMessage() + "\n";
                }
                catch (ClassNotFoundException exc) {
                    message = message + "     " + exc.getMessage() + "\n";
                }
            }
            if (dd instanceof SessionDescriptor) {
                if (localClass != null) {
                    try {
                        methods = this.getClassMethods(localClass);
                        if (methods != null) {
                            int i = 0;
                            while (i < methods.length) {
                                if (!methods[i].getDeclaringClass().equals(class$javax$ejb$EJBLocalObject == null ? TransactionPanelLogical.class$("javax.ejb.EJBLocalObject") : class$javax$ejb$EJBLocalObject)) {
                                    tempMethodNode = this.addRemoteNode(methods[i], localParent, "Local");
                                    tempMethodNode.setSessBean();
                                    this.setMethodDescription(tempMethodNode, dd.getTransactionDescriptors());
                                }
                                ++i;
                            }
                        }
                    }
                    catch (OutOfMemoryError o) {
                        System.out.println("Out of Memory Error! Please increase the memory of VM or reconfigure the server. ");
                        System.exit(666);
                    }
                    catch (Throwable ex) {
                        JOptionPane.showMessageDialog(this, "Methods from Local Interface " + localClass.getName() + " are not added in the visual methods tree.\nReason:" + ex.toString(), "Session EJBean error", 0);
                    }
                }
                if (remoteClass != null) {
                    try {
                        methods = this.getClassMethods(remoteClass);
                        if (methods != null) {
                            int i = 0;
                            while (i < methods.length) {
                                if (!methods[i].getDeclaringClass().equals(class$javax$ejb$EJBObject == null ? TransactionPanelLogical.class$("javax.ejb.EJBObject") : class$javax$ejb$EJBObject)) {
                                    tempMethodNode = this.addRemoteNode(methods[i], remoteParent, "Remote");
                                    tempMethodNode.setSessBean();
                                    this.setMethodDescription(tempMethodNode, dd.getTransactionDescriptors());
                                }
                                ++i;
                            }
                        }
                    }
                    catch (OutOfMemoryError o) {
                        System.out.println("Out of Memory Error! Please increase the memory of VM or reconfigure the server. ");
                        System.exit(666);
                    }
                    catch (Throwable ex) {
                        JOptionPane.showMessageDialog(this, "Methods from Remote Interface " + remoteClass.getName() + " are not added in the visual methods tree.\nReason:" + ex.toString(), "Session EJBean error", 0);
                    }
                }
            } else {
                boolean isCmpBean = false;
                if (dd instanceof CMPEntityDescriptor) {
                    isCmpBean = true;
                }
                if (localHomeClass != null) {
                    try {
                        methods = this.getClassMethods(localHomeClass);
                        if (methods != null) {
                            int i = 0;
                            while (i < methods.length) {
                                if (!methods[i].getName().startsWith("getEJBMetaData") && !methods[i].getName().startsWith("getHomeHandle")) {
                                    tempMethodNode = this.addHomeNode(methods[i], localHomeParent, "LocalHome");
                                    if (isCmpBean) {
                                        tempMethodNode.setCmpBean();
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                    catch (OutOfMemoryError o) {
                        System.out.println("Out of Memory Error! Please increase the memory of VM or reconfigure the server. ");
                        System.exit(666);
                    }
                    catch (Throwable e) {
                        JOptionPane.showMessageDialog(this, "Methods from Local Home Interface " + localHomeClass.getName() + " are not added in the visual methods tree.\nReason:" + e.toString(), "Entity EJBean error", 0);
                    }
                }
                if (localClass != null) {
                    try {
                        methods = this.getClassMethods(localClass);
                        if (methods != null) {
                            int i = 0;
                            while (i < methods.length) {
                                if (!(methods[i].getName().startsWith("getEJBLocalHome") || methods[i].getName().startsWith("getHandle") || methods[i].getName().startsWith("getPrimaryKey") || methods[i].getName().startsWith("isIdentical"))) {
                                    tempMethodNode = this.addRemoteNode(methods[i], localParent, "Local");
                                    if (isCmpBean) {
                                        tempMethodNode.setCmpBean();
                                    }
                                    this.setMethodDescription(tempMethodNode, dd.getTransactionDescriptors());
                                }
                                ++i;
                            }
                        }
                    }
                    catch (OutOfMemoryError o) {
                        System.out.println("Out of Memory Error! Please increase the memory of VM or reconfigure the server. ");
                        System.exit(666);
                    }
                    catch (Throwable e) {
                        JOptionPane.showMessageDialog(this, "Methods from Local Interface " + localClass.getName() + " are not added in the visual methods tree.\nReason:" + e.toString(), "Entity EJBean error", 0);
                    }
                }
                if (remoteHomeClass != null) {
                    try {
                        methods = this.getClassMethods(remoteHomeClass);
                        if (methods != null) {
                            int i = 0;
                            while (i < methods.length) {
                                if (!methods[i].getName().startsWith("getEJBMetaData") && !methods[i].getName().startsWith("getHomeHandle")) {
                                    tempMethodNode = this.addHomeNode(methods[i], remoteHomeParent, "Home");
                                    if (isCmpBean) {
                                        tempMethodNode.setCmpBean();
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                    catch (OutOfMemoryError o) {
                        System.out.println("Out of Memory Error! Please increase the memory of VM or reconfigure the server. ");
                        System.exit(666);
                    }
                    catch (Throwable e) {
                        JOptionPane.showMessageDialog(this, "Methods from Remote Home Interface " + remoteHomeClass.getName() + " are not added in the visual methods tree.\nReason:" + e.toString(), "Entity EJBean error", 0);
                    }
                }
                if (remoteClass != null) {
                    try {
                        methods = this.getClassMethods(remoteClass);
                        if (methods != null) {
                            int i = 0;
                            while (i < methods.length) {
                                if (!(methods[i].getName().startsWith("getEJBHome") || methods[i].getName().startsWith("getHandle") || methods[i].getName().startsWith("getPrimaryKey") || methods[i].getName().startsWith("isIdentical"))) {
                                    tempMethodNode = this.addRemoteNode(methods[i], remoteParent, "Remote");
                                    if (isCmpBean) {
                                        tempMethodNode.setCmpBean();
                                    }
                                    this.setMethodDescription(tempMethodNode, dd.getTransactionDescriptors());
                                }
                                ++i;
                            }
                        }
                    }
                    catch (OutOfMemoryError o) {
                        System.out.println("Out of Memory Error! Please increase the memory of VM or reconfigure the server. ");
                        System.exit(666);
                    }
                    catch (Throwable e) {
                        JOptionPane.showMessageDialog(this, "Methods from Remote Interface " + remoteClass.getName() + " are not added in the visual methods tree.\nReason:" + e.toString(), "Entity EJBean error", 0);
                    }
                }
            }
        }
        ((DefaultTreeModel)this.methodsTree.getModel()).reload();
        TreeUtils.expandTree((JTree)this.methodsTree, (int)1);
        return message;
    }

    private void initValues(SecurityTreeNode theNode) {
        ControlDescriptor[] trans = null;
        MethodEntry methodEntry = null;
        SecurityUserObject lastSelectedObj = null;
        String beanName = null;
        int index = -1;
        if (this.methodsTree.getSelectionPath() == null) {
            return;
        }
        if (theNode.isCmpBean()) {
            if (!this.isComboBoxAdded) {
                this.transactionPanel.add((Component)this.isolationLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
                this.transactionPanel.add((Component)this.isolationComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
                this.transactionPanel.repaint();
                this.transactionPanel.validate();
                this.isComboBoxAdded = true;
            }
        } else if (this.isComboBoxAdded) {
            this.transactionPanel.remove(this.isolationLabel);
            this.transactionPanel.remove(this.isolationComboBox);
            this.transactionPanel.repaint();
            this.transactionPanel.validate();
            this.isComboBoxAdded = false;
        }
        this.setValues = true;
        if (theNode.isMDBean() || theNode.isSessBean()) {
            if (theNode.isMDBean()) {
                this.transactionComboBox.setModel(this.comboModel);
            } else {
                this.transactionComboBox.setModel(this.sessionModel);
            }
        } else {
            this.transactionComboBox.setModel(this.oldModel);
        }
        this.setValues = false;
        try {
            lastSelectedObj = (SecurityUserObject)theNode.getUserObject();
            methodEntry = theNode.getMethodEntry();
            if (lastSelectedObj.getType() == 12) {
                this.methodDescrPanel.setEnabled(true);
                this.transactionComboBox.setEnabled(true);
                this.isolationComboBox.setEnabled(true);
                beanName = theNode.getName();
                trans = (ControlDescriptor[])this.controls.get(beanName);
                index = this.findMethodIndex(methodEntry, trans, false);
                if (index == -1) {
                    this.clearAll();
                } else if (index != -1 && trans != null && index < trans.length) {
                    this.transAttribute = trans[index].getTransactionAttribute();
                    this.isoLevel = trans[index].getIsolationLevel();
                    if (this.isoLevel == -1) {
                        theNode.setBeanIsoLevel(false);
                    } else {
                        theNode.setBeanIsoLevel(true);
                        this.controls.put(beanName, trans);
                    }
                    this.setValues = true;
                    this.transactionComboBox.setSelectedItem(this.chooseAttributes(this.transAttribute, theNode));
                    this.isolationComboBox.setSelectedItem(this.chooseIsolation(this.isoLevel));
                    this.transactionDescrPanel.setText(trans[index].getDescription());
                    this.methodDescrPanel.setText(trans[index].getMethodEntry().getMethodDescription());
                    this.setValues = false;
                }
            } else if (lastSelectedObj.getType() == 3 || lastSelectedObj.getType() == 4 || lastSelectedObj.getType() == 0) {
                this.methodDescrPanel.setEnabled(false);
                this.transactionComboBox.setEnabled(false);
                this.isolationComboBox.setEnabled(false);
            } else if (lastSelectedObj.getType() == 16) {
                index = -1;
                beanName = ((SecurityTreeNode)theNode.getParent()).getName();
                trans = (ControlDescriptor[])this.controls.get(beanName);
                if (trans != null && trans.length > 0) {
                    if (trans.length == 1) {
                        index = 0;
                    } else {
                        int i = 0;
                        while (i < trans.length) {
                            if (trans[i].getMethodEntry().isMethodSpecified()) {
                                index = i;
                                break;
                            }
                            ++i;
                        }
                    }
                }
                this.setValues = true;
                if (index > -1) {
                    this.transactionComboBox.setSelectedItem(this.chooseAttributes(trans[index].getTransactionAttribute(), theNode));
                    this.transactionDescrPanel.setText(trans[index].getDescription());
                    this.methodDescrPanel.setText(trans[index].getMethodEntry().getMethodDescription());
                }
                this.setValues = false;
            } else {
                beanName = ((SecurityTreeNode)theNode.getParent().getParent()).getName();
                trans = (ControlDescriptor[])this.controls.get(beanName);
                this.methodDescrPanel.setEnabled(true);
                if (!((SecurityTreeNode)theNode.getParent().getParent()).hasBeanIsoLevel()) {
                    this.isolationComboBox.setEnabled(true);
                } else {
                    this.isolationComboBox.setEnabled(false);
                }
                index = this.findMethodIndex(methodEntry, trans, false);
                if (index == -1) {
                    this.clearAll();
                } else if (trans != null && index < trans.length) {
                    this.transAttribute = trans[index].getTransactionAttribute();
                    this.isoLevel = !((SecurityTreeNode)theNode.getParent().getParent()).hasBeanIsoLevel() ? trans[index].getIsolationLevel() : -1;
                    this.setValues = true;
                    this.transactionComboBox.setSelectedItem(this.chooseAttributes(this.transAttribute, theNode));
                    this.isolationComboBox.setSelectedItem(this.chooseIsolation(this.isoLevel));
                    this.transactionDescrPanel.setText(trans[index].getDescription());
                    this.methodDescrPanel.setText(trans[index].getMethodEntry().getMethodDescription());
                    this.setValues = false;
                }
            }
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this, "There is problem during value initialization of " + theNode.getName() + ".\nReason : " + exc.getMessage(), "WARNING", 2);
        }
        if (this.madeFrom == 1 || this.madeFrom == 2) {
            this.isolationComboBox.setSelectedIndex(0);
        }
    }

    private void clearAll() {
        this.setValues = true;
        this.transactionDescrPanel.setText("");
        this.methodDescrPanel.setText("");
        this.transactionComboBox.setSelectedIndex(0);
        this.isolationComboBox.setSelectedIndex(0);
        this.setValues = false;
    }

    private void setValues(SecurityTreeNode lastSelectedNode) {
        MethodEntry methodEntry = null;
        SecurityUserObject lastSelectedObj = null;
        String beanName = null;
        ControlDescriptor[] trans = null;
        int index = -1;
        if (lastSelectedNode == null) {
            return;
        }
        this.transAttribute = this.getAttributes((String)this.transactionComboBox.getSelectedItem());
        String isolationLevel = (String)this.isolationComboBox.getSelectedItem();
        this.isoLevel = this.getIsolation(isolationLevel);
        lastSelectedObj = (SecurityUserObject)lastSelectedNode.getUserObject();
        methodEntry = lastSelectedNode.getMethodEntry();
        if (lastSelectedObj.getType() == 12) {
            beanName = lastSelectedNode.getName();
            trans = (ControlDescriptor[])this.controls.get(beanName);
            index = this.findMethodIndex(methodEntry, trans, false);
            if (this.methodDescrPanel.getText() != null) {
                methodEntry.setMethodDescription(this.methodDescrPanel.getText().trim());
            }
            if (index != -1 && trans != null && index < trans.length) {
                trans[index].setMethodEntry(methodEntry);
                if (this.transAttribute == -1 && this.isoLevel == -1) {
                    if ((trans = this.removeTransactionDescriptor(trans, index)).length > 0) {
                        this.controls.put(beanName, trans);
                    } else {
                        this.controls.remove(beanName);
                        lastSelectedNode.setBeanIsoLevel(false);
                    }
                } else {
                    trans[index].setDescription(this.transactionDescrPanel.getText().trim().equals("") ? null : this.transactionDescrPanel.getText().trim());
                    trans[index].setTransactionAttribute(this.transAttribute);
                    if (this.isoLevel != -1) {
                        trans[index].setIsolationLevel(isolationLevel.trim());
                    } else {
                        trans[index].setIsolationLevel("");
                    }
                }
                this.controls.put(beanName, trans);
            } else if (this.transAttribute != -1 || this.isoLevel != -1) {
                ControlDescriptor control = new ControlDescriptor(methodEntry);
                control.setDescription(this.transactionDescrPanel.getText().trim().equals("") ? null : this.transactionDescrPanel.getText().trim());
                control.setTransactionAttribute(this.transAttribute);
                if (this.isoLevel != -1) {
                    control.setIsolationLevel(isolationLevel.trim());
                } else {
                    control.setIsolationLevel("");
                }
                trans = this.addTransctionDescriptor(trans, control);
                this.controls.put(beanName, trans);
            }
            index = this.findMethodIndex(methodEntry, trans, false);
            if (index != -1) {
                if (trans[index].getIsolationLevel() == -1) {
                    lastSelectedNode.setBeanIsoLevel(false);
                } else {
                    lastSelectedNode.setBeanIsoLevel(true);
                    int i = 0;
                    while (i < trans.length) {
                        if (i != index) {
                            trans[i].setIsolationLevel("");
                        }
                        ++i;
                    }
                    this.controls.put(beanName, trans);
                }
            } else {
                lastSelectedNode.setBeanIsoLevel(false);
            }
        } else if (lastSelectedObj.getType() != 4 && lastSelectedObj.getType() != 3 && lastSelectedObj.getType() != 0) {
            beanName = lastSelectedObj.getType() == 16 ? ((SecurityTreeNode)lastSelectedNode.getParent()).getName() : ((SecurityTreeNode)lastSelectedNode.getParent().getParent()).getName();
            trans = (ControlDescriptor[])this.controls.get(beanName);
            if (lastSelectedObj.getType() == 16) {
                int i = 0;
                while (i < trans.length) {
                    if (trans[i].getMethodEntry().isMethodSpecified()) {
                        index = i;
                    }
                    ++i;
                }
            } else {
                index = this.findMethodIndex(methodEntry, trans, true);
            }
            if (this.methodDescrPanel.getText() != null) {
                methodEntry.setMethodDescription(this.methodDescrPanel.getText().trim());
            }
            if (index != -1 && trans != null && index < trans.length) {
                trans[index].setMethodEntry(methodEntry);
                if (this.transAttribute == -1 && this.isoLevel == -1) {
                    if ((trans = this.removeTransactionDescriptor(trans, index)).length > 0) {
                        this.controls.put(beanName, trans);
                    } else {
                        this.controls.remove(beanName);
                    }
                } else {
                    trans[index].setDescription(this.transactionDescrPanel.getText());
                    if (this.transAttribute == -1) {
                        int atr = this.getBeanTransactionAttribute(beanName);
                        if (atr > -1) {
                            this.transactionComboBox.setSelectedItem(this.chooseAttributes(atr, lastSelectedNode));
                            trans[index].setTransactionAttribute(atr);
                        } else {
                            trans[index].setTransactionAttribute(-1);
                        }
                    } else {
                        trans[index].setTransactionAttribute(this.transAttribute);
                    }
                    trans[index].setIsolationLevel(isolationLevel.trim());
                }
                this.controls.put(beanName, trans);
            } else if (this.transAttribute != -1 || this.isoLevel != -1) {
                if (this.methodDescrPanel.getText() != null && !this.methodDescrPanel.getText().trim().equals("")) {
                    methodEntry.setMethodDescription(this.methodDescrPanel.getText().trim());
                }
                ControlDescriptor control = new ControlDescriptor(methodEntry);
                control.setDescription(this.transactionDescrPanel.getText());
                if (this.transAttribute == -1) {
                    int atr = this.getBeanTransactionAttribute(beanName);
                    if (atr > -1) {
                        this.transactionComboBox.setSelectedItem(this.chooseAttributes(atr, lastSelectedNode));
                        control.setTransactionAttribute(atr);
                    } else {
                        control.setTransactionAttribute(-1);
                    }
                } else {
                    control.setTransactionAttribute(this.transAttribute);
                }
                control.setIsolationLevel(isolationLevel.trim());
                trans = this.addTransctionDescriptor(trans, control);
                this.controls.put(beanName, trans);
            }
        }
        this.refreshDescription(this.transAttribute, this.transactionDescrPanel.getText());
    }

    public void commitChange() {
        DeploymentDescriptor[] descriptors = this.jarDescriptor.getDDescriptors();
        String ejbName = null;
        Object[] contr = null;
        if (descriptors != null && descriptors.length != 0) {
            int i = 0;
            while (i < descriptors.length) {
                try {
                    ejbName = descriptors[i].getEjbName();
                    if (descriptors[i] instanceof SessionDescriptor && ((SessionDescriptor)descriptors[i]).getTransactionType() == 0) {
                        descriptors[i].setTransactionDescriptors(new ControlDescriptor[0]);
                    } else if (descriptors[i] instanceof MessageDrivenDescriptor && ((MessageDrivenDescriptor)descriptors[i]).getTransactionType() == 0) {
                        descriptors[i].setTransactionDescriptors(new ControlDescriptor[0]);
                    } else {
                        contr = (ControlDescriptor[])this.controls.get(ejbName);
                        MethodEntry ent = null;
                        int index = -1;
                        if (contr != null && contr.length != 0) {
                            Vector<Object> tempCD = new Vector<Object>();
                            int j = 0;
                            while (j < contr.length) {
                                ent = contr[j].getMethodEntry();
                                if (!ent.isMethodSpecified()) {
                                    index = j;
                                    ent.setMethodName("Entire EJB");
                                    contr[j].setMethodEntry(ent);
                                }
                                ++j;
                            }
                            int trAtr = -1;
                            if (index > -1) {
                                trAtr = contr[index].getTransactionAttribute();
                                tempCD.add(contr[index]);
                            }
                            int k = 0;
                            while (k < contr.length) {
                                if (!(contr[k].getMethodEntry().getMethodInterface() == null && !((ControlDescriptor)contr[k]).getMethodEntry().isMethodSpecified() || ((ControlDescriptor)contr[k]).getTransactionAttribute() == -1 && ((ControlDescriptor)contr[k]).getIsolationLevel() == -1)) {
                                    if (((ControlDescriptor)contr[k]).getTransactionAttribute() != trAtr) {
                                        tempCD.add(contr[k]);
                                    } else if (((ControlDescriptor)contr[k]).getIsolationLevel() != -1) {
                                        tempCD.add(contr[k]);
                                    }
                                }
                                ++k;
                            }
                            contr = new ControlDescriptor[tempCD.size()];
                            tempCD.copyInto(contr);
                            descriptors[i].setTransactionDescriptors((ControlDescriptor[])contr);
                        } else {
                            descriptors[i].setTransactionDescriptors(new ControlDescriptor[0]);
                        }
                    }
                }
                catch (IllegalArgumentException iae) {
                    JOptionPane.showMessageDialog(this, "Wrong value has bean added in descriptors.\n" + iae.toString(), "Illegal Argument Exception", 0);
                }
                ++i;
            }
            this.jarDescriptor.setDescriptors(descriptors);
        }
    }

    public void refreshDescription(int transAttribute, String str) {
        int i;
        String key = null;
        Vector<Object> temp = new Vector<Object>();
        Object[] contr = null;
        Enumeration enumeration = this.controls.keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            contr = (ControlDescriptor[])this.controls.get(key);
            i = 0;
            while (i < contr.length) {
                temp.add(contr[i]);
                ++i;
            }
        }
        contr = new ControlDescriptor[temp.size()];
        temp.copyInto(contr);
        if (contr != null) {
            i = 0;
            while (i < contr.length) {
                if (((ControlDescriptor)contr[i]).getTransactionAttribute() == transAttribute) {
                    ((ControlDescriptor)contr[i]).setDescription(str);
                }
                ++i;
            }
        }
    }

    public SecurityTreeNode addHomeNode(Method method, SecurityTreeNode parent, String intrf) {
        MethodEntry entry = new MethodEntry(parent.getMethodEntry().getEjbName(), intrf, method, null);
        SecurityTreeNode node = null;
        entry.setMethodInterface(intrf);
        try {
            node = new SecurityTreeNode(entry, 1);
            if (parent != null) {
                parent.add(node);
            } else {
                this.root.add(node);
            }
            TreeUtils.expandTree((JTree)this.methodsTree, (int)2);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error occurs while new Home tree node is creating and adding to the tree.\nReason:" + e.toString(), "Home tree node error", 0);
        }
        return node;
    }

    public SecurityTreeNode addRemoteNode(Method method, SecurityTreeNode parent, String intrf) {
        MethodEntry entry = new MethodEntry(parent.getMethodEntry().getEjbName(), intrf, method, null);
        SecurityTreeNode node = null;
        entry.setMethodInterface(intrf);
        try {
            node = new SecurityTreeNode(entry, 2);
            if (parent != null) {
                parent.add(node);
            } else {
                this.root.add(node);
            }
            TreeUtils.expandTree((JTree)this.methodsTree, (int)2);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error occurs while new Remote tree node is creating and adding to the tree.\nReason:" + e.toString(), "Remote tree node error", 0);
        }
        return node;
    }

    public int findMethodIndex(MethodEntry entry, ControlDescriptor[] trans, boolean flag) {
        String intf = entry.getMethodInterface();
        String curr = null;
        int j = -1;
        if (trans != null) {
            int i = 0;
            while (i < trans.length) {
                curr = trans[i].getMethodEntry().getMethodInterface();
                if (curr == null) {
                    if (!trans[i].getMethodEntry().isMethodSpecified() && !flag) {
                        j = i;
                    }
                } else if (curr.equals(intf) && trans[i].getMethodEntry().simpleEquals(entry)) {
                    return i;
                }
                ++i;
            }
        }
        if (j > -1) {
            return j;
        }
        return -1;
    }

    private int getBeanTransactionAttribute(String beanName) {
        ControlDescriptor[] trans = (ControlDescriptor[])this.controls.get(beanName);
        int result = -1;
        int i = 0;
        while (i < trans.length) {
            if (!trans[i].getMethodEntry().isMethodSpecified()) {
                result = trans[i].getTransactionAttribute();
                break;
            }
            ++i;
        }
        return result;
    }

    private ControlDescriptor[] removeTransactionDescriptor(ControlDescriptor[] trans, int index) {
        Vector<ControlDescriptor> temp = new Vector<ControlDescriptor>();
        int i = 0;
        while (i < trans.length) {
            if (i != index) {
                temp.add(trans[i]);
            }
            ++i;
        }
        Object[] newTrans = new ControlDescriptor[temp.size()];
        temp.copyInto(newTrans);
        return newTrans;
    }

    private ControlDescriptor[] addTransctionDescriptor(ControlDescriptor[] trans, ControlDescriptor control) {
        Vector<ControlDescriptor> temp = new Vector<ControlDescriptor>();
        if (trans == null) {
            temp.add(control);
        } else {
            int i = 0;
            while (i < trans.length) {
                if (!trans[i].getMethodEntry().simpleEquals(control.getMethodEntry())) {
                    temp.add(trans[i]);
                }
                ++i;
            }
        }
        temp.add(control);
        Object[] newTrans = new ControlDescriptor[temp.size()];
        temp.copyInto(newTrans);
        return newTrans;
    }

    private Method[] getClassMethods(Class interfaceClass) {
        Method[] interfaceMethods = null;
        interfaceMethods = interfaceClass.getMethods();
        Vector<Method> methodsToReturn = new Vector<Method>();
        Method meth = null;
        Method tempMeth = null;
        int index = -1;
        int i = 0;
        while (i < interfaceMethods.length) {
            meth = interfaceMethods[i];
            if (methodsToReturn == null || methodsToReturn.size() == 0) {
                methodsToReturn.add(meth);
            } else {
                int j = 0;
                while (j < methodsToReturn.size()) {
                    tempMeth = (Method)methodsToReturn.elementAt(j);
                    if (this.identicalMethods(meth, tempMeth)) {
                        index = j;
                        break;
                    }
                    ++j;
                }
                if (index == -1) {
                    methodsToReturn.add(meth);
                }
                index = -1;
            }
            ++i;
        }
        Object[] res = new Method[methodsToReturn.size()];
        methodsToReturn.copyInto(res);
        return res;
    }

    private void setMethodDescription(SecurityTreeNode node, ControlDescriptor[] contrDescr) {
        int i = 0;
        while (i < contrDescr.length) {
            if (contrDescr[i].getMethodEntry().simpleEquals(node.getMethodEntry())) {
                node.getMethodEntry().setMethodDescription(contrDescr[i].getMethodEntry().getMethodDescription());
                return;
            }
            ++i;
        }
    }

    protected String chooseIsolation(int index) {
        if (index == 1) {
            return "Uncommitted";
        }
        if (index == 4) {
            return "Repeatable";
        }
        return "";
    }

    protected String chooseAttributes(int index, SecurityTreeNode currNode) {
        if (index == 0) {
            return "NotSupported";
        }
        if (index == 1) {
            return "Never";
        }
        if (index == 2) {
            return "Required";
        }
        if (index == 3) {
            return "Supports";
        }
        if (index == 4) {
            return "RequiresNew";
        }
        if (index == 5) {
            return "Mandatory";
        }
        return "";
    }

    protected int getIsolation(String isoLevel) {
        if (isoLevel.equals("Uncommitted")) {
            return 1;
        }
        if (isoLevel.equals("Repeatable")) {
            return 4;
        }
        return -1;
    }

    protected int getAttributes(String attrName) {
        if (attrName.equals("NotSupported")) {
            return 0;
        }
        if (attrName.equals("Required")) {
            return 2;
        }
        if (attrName.equals("Never")) {
            return 1;
        }
        if (attrName.equals("Supports")) {
            return 3;
        }
        if (attrName.equals("RequiresNew")) {
            return 4;
        }
        if (attrName.equals("Mandatory")) {
            return 5;
        }
        return -1;
    }

    private String chooseTransactionDescr(int attr) {
        String descr = null;
        String key = null;
        Vector<ControlDescriptor> temp = new Vector<ControlDescriptor>();
        Enumeration enumeration = this.controls.keys();
        ControlDescriptor[] array = null;
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            array = (ControlDescriptor[])this.controls.get(key);
            int i = 0;
            while (i < array.length) {
                temp.add(array[i]);
                ++i;
            }
        }
        Object[] contr = new ControlDescriptor[temp.size()];
        temp.copyInto(contr);
        if (contr != null) {
            int i = 0;
            while (i < contr.length) {
                if (((ControlDescriptor)contr[i]).getTransactionAttribute() == attr && (descr = ((ControlDescriptor)contr[i]).getDescription()) != null && !descr.trim().equals("")) {
                    return descr.trim();
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean identicalMethods(Method m1, Method m2) {
        if (m1 != null) {
            Class<?>[] params2;
            if (m2 == null) return true;
            if (!m1.getName().equals(m2.getName())) {
                return false;
            }
            Class<?>[] params1 = m1.getParameterTypes();
            if (params1.length != (params2 = m2.getParameterTypes()).length) return false;
            int i = 0;
            while (i < params1.length) {
                if (!params1[i].equals(params2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        } else {
            if (m2 == null) return true;
            return false;
        }
    }

    public void updateLook_Feel() {
        SwingUtilities.updateComponentTreeUI(this);
        this.transactionDescrPanel.updateLook_Feel();
        this.methodDescrPanel.updateLook_Feel();
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
    }

    public int isCorrect() {
        return this.isCorrectIndex;
    }

    public void setLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public void clear() {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return this.error;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

